/*  a simple command shell */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>
#include <unistd.h>

#define BS 0x1000

/* */
void die(char *x){ perror(x); exit(EXIT_FAILURE); }
void bye(char *x){ fprintf(stderr, "%s\n", x); exit(EXIT_FAILURE); }

/* */
int resolv(char *host, struct sockaddr_in *sap)
{
    struct hostent  *hp = NULL;

    hp = gethostbyname(host);
    if(hp == NULL){
        herror("gethostbyname");
        exit(EXIT_FAILURE);
    }
    sap->sin_addr = **((struct in_addr **) hp->h_addr_list);

    return 0;
}

/* */
int conn(char *host, char *port)
{
    int sock;
    struct sockaddr_in  sa;

    memset(&sa, 0, sizeof(sa));
    sa.sin_family = AF_INET;
    sa.sin_port = htons(atoi(port));
    resolv(host, &sa);

    sock = socket(AF_INET, SOCK_STREAM, 0);
    if(sock < 0)
        die("socket");
    if(connect(sock, (struct sockaddr *)&sa, sizeof(sa)) < 0)
        die("connect");

    return sock;
}
 
/* */
void rw_sock(int from, int to)
{
    char    buf[BS];
    int l = 0;

    l = read(from, buf, BS);
    if(l < 0)
        die("read");
    else if(l == 0)
        bye("Connection closed");
	        
    if (write(to, buf, l) != l)
        die("write");
}

/* */
void shell(char *host, char *port)
{
    int sock = 0;
    fd_set rfds;

    sock = conn(host, port);

    printf("got a shell\n\n");
    FD_ZERO(&rfds);

    for(;;){
	    FD_SET(STDIN_FILENO, &rfds);
	    FD_SET(sock, &rfds);

	    if (select(sock + 1, &rfds, NULL, NULL, NULL) < 1)
	        die("select");

	    if (FD_ISSET(STDIN_FILENO, &rfds))
            rw_sock(STDIN_FILENO, sock);

	    if (FD_ISSET(sock, &rfds)) 
            rw_sock(sock, STDOUT_FILENO);
    }
}


/*
 */
int main(int argc, char **argv)
{

    if(argc < 3){
        fprintf(stderr, "Usage: %s <host> <port>\n", argv[0]);
        return EXIT_FAILURE;
    }

    shell(argv[1], argv[2]);

	return EXIT_SUCCESS;
}
