// crc
typedef struct {
    u32     table[256];
    u32     poly;
    int     size;
    u32     init;
    u32     final;
    int     type;
    int     rever;
} crc_context;
#define CRC_BITMASK(SIZE)   ((u64)1 << (u64)(SIZE))
static u64 reflect(u64 v, int b) {
    u64     t;
    int     i;

    t = v;
    for(i = 0; i < b; i++) {
        if(t & (u64)1) {
            v |= CRC_BITMASK((b - 1) - (u64)i);
        } else {
            v &= (CRC_BITMASK((b - 1) ^ (u64)0xffffffffffffffffLL) - (u64)i);
        }
        t >>= (u64)1;
    }
    return(v);
}
inline u64 widmask(int size) {
    return((((u64)1 << (u64)(size - 1)) - (u64)1) << (u64)1) | (u64)1;
}
static u64 cm_tab(int inbyte, u64 poly, int size, int rever) {
    u64     r,
            topbit;
    int     i;

    topbit = CRC_BITMASK(size - 1);

    if(rever) inbyte = reflect(inbyte, 8);  // RefIn

    r = (u64)inbyte << (u64)(size - 8);

    for(i = 0; i < 8; i++) {
        if(r & topbit) {
            r = (r << (u64)1) ^ poly;
        } else {
            r <<= (u64)1;
        }
    }

    if(rever) r = reflect(r, size);         // RefOut

    return(r & widmask(size));
}
u32 crc_safe_limit(u32 crc, int size) { // in my tests this was NOT necessary, but I want to be sure
    if(size <= 8)  return(crc & 0xff);
    if(size <= 16) return(crc & 0xffff);
    if(size <= 32) return(crc & 0xffffffff);
    return(crc);    // in case of future u64 implementations
}
void make_crctable(u32 *output, u64 poly, int size, int rever) {
    //u64     num;
    u32     num;
    int     i;

    for(i = 0; i < 256; i++) {
        num = cm_tab(i, poly, size, rever);
        *output++ = crc_safe_limit(num, size);
    }
}
u16 pck_cksum(u32 init, u8 *data, int len) {
    u32     sum;
    int     endian = 1; // big endian
    u16     crc,
            *p,
            *l;

    if(*(char *)&endian) endian = 0;
    sum = init;

    for(p = (u16 *)data, l = p + (len >> 1); p < l; p++) sum += *p;
    if(len & 1) sum += *p & (endian ? 0xff00 : 0xff);
    sum = (sum >> 16) + (sum & 0xffff);
    crc = sum + (sum >> 16);
    if(!endian) crc = (crc >> 8) | (crc << 8);
    return(crc);    // should be xored with 0xffff but this job is done later
}
u32 calc_crc(crc_context *ctx, u8 *data, int datalen) {
#define CALC_CRC_CYCLE(X) \
    for(i = 0; i < datalen; i++) { \
        crc = X; \
        crc = crc_safe_limit(crc, ctx->size); \
    }
    u32     crc;
    int     i;

    crc = ctx->init;    // Init
    if(!ctx->type) {
        CALC_CRC_CYCLE(ctx->table[(data[i] ^ crc) & 0xff] ^ (crc >> 8));
    } else if(ctx->type == 1) {
        CALC_CRC_CYCLE(ctx->table[(data[i] ^ (crc >> 24)) & 0xff] ^ (crc << 8));
    } else if(ctx->type == 2) {
        CALC_CRC_CYCLE(((crc << 8) | data[i]) ^ ctx->table[(crc >> 24) & 0xff]);
    } else if(ctx->type == 3) {
        CALC_CRC_CYCLE(((crc >> 1) + ((crc & 1) << (ctx->size - 1))) + *data);
    } else if(ctx->type == 4) {
        crc = pck_cksum(crc, data, datalen);
    } else {
        printf("\nError: unsupported crc type %d\n", ctx->type);
        return(-1);
    }
    crc ^= ctx->final;  // XorOut
    return(crc_safe_limit(crc, ctx->size));
}

