#define WIN32_LEAN_AND_MEAN
#define UNICODE
#define _UNICODE
#include <windows.h>
#include <tchar.h>

#define DefWinStaDeskW L"WinSta0\\Default"
#define DefWinStaDeskA  "WinSta0\\Default"

DWORD WINAPI CreateProcessAsPIDW(HANDLE hCaller, LPWSTR lpCommandLineW,
             DWORD dwCreationFlags, LPWSTR lpWinStaDeskW, LPWSTR lpCurrentDirectoryW) {
  HANDLE hThread = NULL, hProcess = NULL;
  if(lpWinStaDeskW == NULL)
    lpWinStaDeskW = DefWinStaDeskW;
  WCHAR OldDIR[MAX_PATH]; OldDIR[0] = '\0';
  if(lpCurrentDirectoryW)
    if(GetCurrentDirectoryW(sizeof(OldDIR), OldDIR))
      SetCurrentDirectoryW(lpCurrentDirectoryW);
  STARTUPINFOW si = {sizeof(si)};
  si.lpDesktop = lpWinStaDeskW;
  PROCESS_INFORMATION pi;
  if(CreateProcessW(NULL, lpCommandLineW, NULL, NULL, FALSE, dwCreationFlags, NULL, NULL, &si, &pi)) {
    HANDLE hCP = GetCurrentProcess();
    DuplicateHandle(hCP, pi.hThread,  hCaller, &hThread,  0, FALSE, DUPLICATE_CLOSE_SOURCE | DUPLICATE_SAME_ACCESS);
    DuplicateHandle(hCP, pi.hProcess, hCaller, &hProcess, 0, FALSE, DUPLICATE_CLOSE_SOURCE | DUPLICATE_SAME_ACCESS);
  }
  CloseHandle(hCaller);
  if(OldDIR[0])
    SetCurrentDirectoryW(OldDIR);
  return((LOWORD((DWORD)hProcess) << 16) + LOWORD((DWORD)hThread));
}

DWORD WINAPI CreateProcessAsPIDA(HANDLE hCaller, LPSTR lpCommandLineA,
             DWORD dwCreationFlags, LPSTR lpWinStaDeskA, LPSTR lpCurrentDirectoryA) {
  HANDLE hThread = NULL, hProcess = NULL;
  if(lpWinStaDeskA == NULL)
    lpWinStaDeskA = DefWinStaDeskA;
  CHAR OldDIR[MAX_PATH]; OldDIR[0] = '\0';
  if(lpCurrentDirectoryA)
    if(GetCurrentDirectoryA(sizeof(OldDIR), OldDIR))
      SetCurrentDirectoryA(lpCurrentDirectoryA);
  STARTUPINFOA si = {sizeof(si)};
  si.lpDesktop = lpWinStaDeskA;
  PROCESS_INFORMATION pi;
  if(CreateProcessA(NULL, lpCommandLineA, NULL, NULL, FALSE, dwCreationFlags, NULL, NULL, &si, &pi)) {
    HANDLE hCP = GetCurrentProcess();
    DuplicateHandle(hCP, pi.hThread,  hCaller, &hThread,  0, FALSE, DUPLICATE_CLOSE_SOURCE | DUPLICATE_SAME_ACCESS);
    DuplicateHandle(hCP, pi.hProcess, hCaller, &hProcess, 0, FALSE, DUPLICATE_CLOSE_SOURCE | DUPLICATE_SAME_ACCESS);
  }
  if(OldDIR[0])
    SetCurrentDirectoryA(OldDIR);
  CloseHandle(hCaller);
  return((LOWORD((DWORD)hProcess) << 16) + LOWORD((DWORD)hThread));
}