/*
 * omen - Attack of the Vau[02] CBC-PAD flaw with Imap over SSL/TLS
 *
 * Copyright (c) 2003 Martin Vuagnoux <martin@vuagnoux.com>
 *
 * omen is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later
 * version.
 *
 * omen is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along
 * with wavemon; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include <ncurses.h>
#include <unistd.h>
#include "conf.h"
#include "proxy.h"
#include "cbc_sha_attack.h"

int stdX;
int stdY;

void exit_success(struct cbcPadConf *conf) 
{
  /* print the password in hexa */
  print_passwd_hexa(conf);

  /* if problems, close socket before */
  close_sockets(conf);

  wprintw(conf->debugWin, "Quitting...\n");
  wrefresh(conf->debugWin);

 /* destroy all windows */
  delwin(conf->debugWin);
  delwin(conf->pwWin);
  delwin(conf->tlsWin);
  delwin(conf->stdscr);

  endwin();
  refresh();

  /* free malloc */
  free(conf->passwd);
  free(conf->pkt);
  free(conf->attack_word);
  free(conf->host);

  /* and finally exit ;) */
  exit(EXIT_SUCCESS);
}

/* create lines on the stdscr */
void createUi(int y, int x)
{
  attron(COLOR_PAIR(COLOR_GREEN));
  /* first the border */
  box(stdscr, 0, 0);
  /* then the split window */
  mvwaddch(stdscr, y-1, x/2-1, ACS_BTEE);
  mvwaddch(stdscr, 0, x/2-1, ACS_TTEE);
  mvwvline(stdscr, 1, x/2-1, ACS_VLINE, y-2);
  /* now creating passwd window */
  mvwaddch(stdscr, 5, x/2-1, ACS_LTEE);
  mvwaddch(stdscr, 5, x-1, ACS_RTEE);
  mvwhline(stdscr, 5, x/2, ACS_HLINE, x/2-1);
  /* label windows (safe code) */
  mvwaddch(stdscr, 0, 1, '[');
  attron(COLOR_PAIR(COLOR_WHITE) | A_BOLD);
  mvwaddnstr(stdscr, 0, 2, "debug", 5);
  attroff(A_BOLD);
  attron(COLOR_PAIR(COLOR_GREEN));
  mvwaddch(stdscr, 0, 7, ']');

  mvwaddch(stdscr, 0, x/2-1+1, '[');
  attron(COLOR_PAIR(COLOR_WHITE) | A_BOLD);
  mvwaddnstr(stdscr, 0, x/2-1+2, "passwd", 6);
  attroff(A_BOLD);
  attron(COLOR_PAIR(COLOR_GREEN));
  mvwaddch(stdscr, 0, x/2-1+8, ']');

  mvwaddch(stdscr, 5, x/2-1+1, '[');
  attron(COLOR_PAIR(COLOR_WHITE) | A_BOLD);
  mvwaddnstr(stdscr, 5, x/2-1+2, "TLS", 3);
  attroff(A_BOLD);
  attron(COLOR_PAIR(COLOR_GREEN));
  mvwaddch(stdscr, 5, x/2-1+5, ']');

  /* refresh window */
  wrefresh(stdscr);
}



/* creating main ncurses window */
int init_ui(struct cbcPadConf *conf)
{
  /* create the main window (stdscr) */
  if ( (initscr()) == NULL ) {
    fprintf(stderr, "[E]::Error initialising ncurses.\n");
    exit(EXIT_FAILURE);
  }

  /* fill conf struct */
  conf->stdscr = stdscr;

  keypad(stdscr, TRUE); /* put mainwin listening key map */
  (void) nonl(); /* tell ncurse not to do NL->CR/NL on output */
  (void) cbreak(); /* take inChar one at a time. No wait for \n */
  (void) noecho(); /* don't echo input */
  (void) nodelay(stdscr, TRUE); /* don't wait for a key hit */
  if (has_colors()) {
    start_color();
   
    /* Simple color assignment, often all we need. 
     * param:(<name>, <foreground color>, <background color>)
     */
    init_pair(COLOR_BLACK, COLOR_BLACK, COLOR_BLACK);
    init_pair(COLOR_GREEN, COLOR_GREEN, COLOR_BLACK);
    init_pair(COLOR_RED, COLOR_RED, COLOR_BLACK);
    init_pair(COLOR_CYAN, COLOR_CYAN, COLOR_BLACK);
    init_pair(COLOR_WHITE, COLOR_WHITE, COLOR_BLACK);
    init_pair(COLOR_MAGENTA, COLOR_MAGENTA, COLOR_BLACK);
    init_pair(COLOR_BLUE, COLOR_BLUE, COLOR_BLACK);
    init_pair(COLOR_YELLOW, COLOR_YELLOW, COLOR_BLACK);

  }
  
  /* parse all dimensions */
  getmaxyx(stdscr, stdY, stdX);
  conf->x=stdX;
  conf->y=stdY;
  
  /* create the ui */
  createUi(stdY, stdX);

  /* create debug window */
  conf->debugWin = subwin(stdscr, stdY-2, stdX/2-2, 1, 1);
  wrefresh(conf->debugWin);
  scrollok(conf->debugWin, TRUE); /* active scrolling */
  /* create tls window */
  conf->tlsWin = subwin(stdscr, stdY-7, stdX/2-1, 6, stdX/2);
  wrefresh(conf->tlsWin);
  scrollok(conf->tlsWin, TRUE); /* active scrolling */
  /* create passwd window */
  conf->pwWin = subwin(stdscr, 4, stdX/2-1, 1, stdX/2);
  wrefresh(conf->pwWin);
  scrollok(conf->pwWin, TRUE); /* active scrolling */
  /* intro msg */
  
  wattron(conf->debugWin, COLOR_PAIR(COLOR_WHITE));
  wattron(conf->tlsWin, COLOR_PAIR(COLOR_WHITE));
  wattron(conf->pwWin, COLOR_PAIR(COLOR_WHITE));

    wattron(conf->debugWin, A_BOLD);
    wprintw(conf->debugWin, "\n.::omen::.\n");
    wattroff(conf->debugWin, A_BOLD);
    wprintw(conf->debugWin, "Press \'h\' to print passwd in hex.\n");
    wprintw(conf->debugWin, "Press \'q\' to exit.\n\n");
    wprintw(conf->debugWin, "Port to listen: %d\n", conf->listenPort);
    wprintw(conf->debugWin, "Remote host   : %s\n", conf->host);
    wprintw(conf->debugWin, "remote Port   : %d\n", conf->hostPort);
    wprintw(conf->debugWin, "type          : %d\n\n", conf->type);

    /* OMEN automatic mode */
    if (conf->threshold == -1) {
      wattron(conf->debugWin, A_BOLD);
      wattron(conf->debugWin, A_BLINK);
      wprintw(conf->debugWin, "\nYOU ARE IN OMEN AUTO MODE!        \n");
      wattroff(conf->debugWin, A_BLINK);
      wprintw(conf->debugWin, "OMEN AUTO MODE try to find itself the \n");
      wprintw(conf->debugWin, "value of the THRESHOLD between a \n");
      wprintw(conf->debugWin, "bad_record_mac and a decryp_failed.\n");
      wprintw(conf->debugWin, "No crack here! When you think it's\n"); 
      wprintw(conf->debugWin, "stable run omen with -t <threshold>\n\n");
      wattroff(conf->debugWin, A_BOLD);
    }

    wrefresh(conf->debugWin);

    /* make connections */
    if (init_proxy(conf) < 0) {

      wprintw(conf->debugWin, "\n\nERROR! :(\n");
      wrefresh(conf->debugWin);
    }

    /* exit properly */
    exit_success(conf);
    return 0;
}

