
// export LD_LIBRARY_PATH=$ORACLE_HOME/lib
// ./version 192.168.0.100/orcl

#include <stdio.h>
#include <assert.h>
#include <string.h>

#include "oci.h"

static void checkerr(OCIError *errhp, sword status)
{ 
  unsigned char errbuf[512];
  ub4 buflen;
  sb4 errcode;
  switch (status)
    { case OCI_SUCCESS:
	break;
    case OCI_SUCCESS_WITH_INFO:
      printf("ErrorOCI_SUCCESS_WITH_INFO\n");
      break;
    case OCI_NEED_DATA:
      printf("ErrorOCI_NEED_DATA\n");
      break;
    case OCI_NO_DATA:
      printf("ErrorOCI_NO_DATA\n");
      break;
    case OCI_ERROR:
      OCIErrorGet (errhp, 1, NULL, &errcode,
		   //            errbuf, 512, (ub4) OCI_HTYPE_ENV);
		   errbuf, 
		   512, OCI_HTYPE_ERROR);
      printf("Error: %s\n", errbuf);
      break;
    case OCI_INVALID_HANDLE:
      printf("ErrorOCI_INVALID_HANDLE\n");
      break;
    case OCI_STILL_EXECUTING:
      printf("ErrorOCI_STILL_EXECUTE\n");
      break;
    case OCI_CONTINUE:
      printf("ErrorOCI_CONTINUE\n");
      break;
    default:
      break;
    }
}

int main(int argc, char * argv[])
{

  OCIEnv *myenvhp;       /* the environment handle */
  OCIServer *mysrvhp;    /* the server handle */
  OCIError *myerrhp;     /* the error handle */
  OCISession *myusrhp;   /* user session handle */
  OCISvcCtx *mysvchp;    /* the  service handle */
  OCIStmt *stmt;
  OCIDefine *dfn;
  char	buf[10240];

  sword status;

  assert (argv[1]!=NULL);

  assert (OCIEnvCreate (&myenvhp, OCI_THREADED|OCI_OBJECT, 0, 0, 0, 0, 0, 0)==0);

  assert (OCIHandleAlloc (myenvhp, (dvoid**)&mysrvhp, OCI_HTYPE_SERVER, 0, 0)==0);

  assert (OCIHandleAlloc (myenvhp, (dvoid**)&myerrhp, OCI_HTYPE_ERROR, 0, 0)==0);

  status=OCIServerAttach (mysrvhp, myerrhp, (const OraText *)argv[1], strlen (argv[1]), OCI_DEFAULT);

  if (status!=0)
    {
      checkerr (myerrhp, status);
      return 0;
    };

  assert (OCIHandleAlloc (myenvhp, (dvoid**)&mysvchp, OCI_HTYPE_SVCCTX, 0, 0)==0);

  assert (OCIAttrSet (mysvchp, OCI_HTYPE_SVCCTX, mysrvhp, 0, OCI_ATTR_SERVER, myerrhp)==0);

  assert (OCIHandleAlloc (myenvhp, (dvoid**)&myusrhp, OCI_HTYPE_SESSION, 0, 0)==0);

  assert (OCIHandleAlloc (myenvhp, (dvoid**)&stmt, OCI_HTYPE_STMT, 0, 0)==0);

#define USERNAME "scott"
#define PASSWORD "tiger"

  assert (OCIAttrSet (myusrhp, OCI_HTYPE_SESSION, (void*)USERNAME, strlen(USERNAME), OCI_ATTR_USERNAME, myerrhp)==0);

  assert (OCIAttrSet (myusrhp, OCI_HTYPE_SESSION, (void*)PASSWORD, strlen(PASSWORD), OCI_ATTR_PASSWORD, myerrhp)==0);

  status=OCISessionBegin (mysvchp, myerrhp, myusrhp, OCI_CRED_RDBMS, OCI_DEFAULT);

  if (status!=0)
    {
      checkerr (myerrhp, status);
      return 0;
    };

  assert (OCIAttrSet (mysvchp, OCI_HTYPE_SVCCTX, myusrhp, 0, OCI_ATTR_SESSION, myerrhp)==0);

#define STMT "select * from v$version"

  assert (OCIStmtPrepare (stmt, myerrhp, (const OraText *)STMT, strlen (STMT), OCI_NTV_SYNTAX, OCI_DEFAULT)==0);

  assert (OCIDefineByPos (stmt, &dfn, myerrhp, 1, buf, 10240, SQLT_STR, 0, 0, 0, OCI_DEFAULT)==0);

  status = OCIStmtExecute (mysvchp, stmt, myerrhp, 1,  0, NULL, NULL, OCI_DEFAULT);

  if (status!=0)
    {
      checkerr (myerrhp, status);
      return 0;
    };

//  while (status != OCI_NO_DATA)
    {
      printf ("|%s\n", buf);

      status=OCIStmtFetch(stmt, myerrhp, 1, 0, 0);
    }

  return 0;
};
