#pragma once

#include <windows.h>
#include <d3dkmthk.h>

struct NvEscapeHeader {
  DWORD magic;
  WORD unknown_4;
  WORD unknown_6;
  DWORD size;
  DWORD magic2;
  DWORD code;
  DWORD unknown[7];
};

static_assert(sizeof(NvEscapeHeader) == 0x30, "sizeof(NvEscapeHeader)");

#pragma pack(push, 1)
template <typename T>
struct NvEscape {
  NvEscapeHeader header;
  T data;

  NvEscape(DWORD code, DWORD magic2) {
    memset(&header, 0, sizeof(header));
    memset(&data, 0, sizeof(data));

    header.magic = 0x4e564441;
    header.magic2 = magic2;
    header.unknown_6 = 1;
    header.size = sizeof(header) + sizeof(data);
    header.code = code;
  }
};
#pragma push(pop)

class Gpu {
public:
  Gpu();
  ~Gpu();

  bool Init();
  NTSTATUS Escape(void* data, size_t size);

private:
  D3DKMT_HANDLE adapter_handle_ = 0;
  D3DKMT_HANDLE device_handle_ = 0;
};

