/*

VERSION 0.1.1

Half-Life packets encoding function
by Luigi Auriemma
e-mail: aluigi@pivx.com
web:    http://www.pivx.com/luigi/


How to use:

mybuff = buffer that contains the data that you want to encode
bufflen = size of the data

hlenc(mybuff, bufflen);


Now mybuff contains the encoded buffer 8-)



This software is covered by GNU/GPL
*/



#define HLENCHASH    "\x05\x61\x7A\xED\x1B\xCA\x0D\x9B\x4A\xF1\x64\xC7\xB5\x8E\xDF\xA0"



void hlenc(unsigned char *buff, unsigned long pcksz);
unsigned long hlenc2(unsigned long ecx);




void hlenc(unsigned char *buff, unsigned long pcksz) {
    unsigned char    ebpc[4],
            tmpbyte,
            *ptresi;
    unsigned long    eax,
            ecx,
            edx,
            pcknum,
            invnum,
            cont = 0,
            i;

    if(pcksz < 9) return;
    pcknum = *buff;
    invnum = ~pcknum;
    pcksz = (pcksz - 8) >> 2;
    buff += 8;

    for(i = 0; i < pcksz; i++) {
        eax = *(unsigned long *)buff ^ invnum;
        *(unsigned long *)ebpc = hlenc2(eax);

        ptresi = ebpc;
        for(ecx = 0; ecx < 4; ecx++) {
            tmpbyte = ecx << ecx;
            edx = *(HLENCHASH + ((cont + ecx) & 0xf));
            edx |= tmpbyte;
            edx |= ecx;
            edx |= 0xA5;
            *ptresi ^= edx;
            ptresi++;
        }

        *(unsigned long *)buff = *(unsigned long *)ebpc ^= pcknum;
        buff += 4;
        cont++;
    }
}





unsigned long hlenc2(unsigned long ecx) {
    ecx = ((((ecx) & 0xff000000) >> 24) |
          (((ecx) & 0x00ff0000) >>  8) |
          (((ecx) & 0x0000ff00) <<  8) |
          (((ecx) & 0x000000ff) << 24));
    return(ecx);
}


