#include <stdlib.h>
#include <string.h>
#include "include.h"
#include "blowfish.h"



extern void fatal(char*, ...);

BlowfishContext blowfish_in;
BlowfishContext blowfish_out;


int cipher_set_key(int cipher, unsigned char *key, long keylen)
{

  unsigned char padded[32];

    
    memset(padded, 0, sizeof(padded));
    if (keylen > (long)sizeof(padded)) fatal("cipher keylen");
    memcpy(padded, key, keylen);
    
    switch(cipher)
    {
	case SSH_CIPHER_NONE:
	    break;
	    
	    
	case SSH_CIPHER_BLOWFISH:
	    if (keylen < 8) fatal("blowfish keylen");
	    
	    memset(&blowfish_in, 0, sizeof(blowfish_in));
	    blowfish_set_key(&blowfish_in, key, keylen);
	
	    memset(&blowfish_out, 0, sizeof(blowfish_out));
	    blowfish_set_key(&blowfish_out, key, keylen);
	    break;
    }	    

    return(0);
} 


int cipher_encrypt (int cipher, char *src, long len)
{

  unsigned char *dest;


    dest = malloc(len + 1);
    if (!dest) fatal("cipher_encrypt: malloc");

    if (cipher == SSH_CIPHER_BLOWFISH)
    {
	blowfish_cbc_encrypt(&blowfish_out, dest, src, len);
	memcpy(src, dest, len);
	free(dest);
	return(len);
    }

    return(0);
}



int cipher_decrypt (int cipher, char *src, long len)
{

  unsigned char *dest;

    
    dest = malloc(len + 1);
    if (!dest) fatal("cipher_encrypt: malloc");

    if (cipher == SSH_CIPHER_BLOWFISH)
    {
	blowfish_cbc_decrypt(&blowfish_in, dest, src, len);
	memcpy(src, dest, len);
	return(len);
    }

    return(0);
}
