﻿using Microsoft.Win32.SafeHandles;
using System;
using System.ComponentModel;
using System.Runtime.InteropServices;
using System.Security.Principal;

namespace DataSharingServiceCommon
{
    public enum DS_TOKEN_LIFETIME_TYPE
    {
        Type0 = 0,
        Type1
    }

    public enum DS_TOKEN_USAGE
    {
        Type0 = 0,
        Type1
    }

    public enum DS_SHARE_PERMISSION
    {
        Read,
        Write,
        ReadWrite
    }

    public enum DS_SHARE_MODE
    {
        None = 0,
        Read,
        Write,
        ReadWrite,
        Delete,
        ReadDelete,
        WriteDelete,
        ReadWriteDelete
    }

    public enum DS_SCOPE_TYPE
    {
        UserSid
    }

    [Flags]
    public enum DS_OPEN_FLAGS
    {
        None = 0,
        OpenFlagOverlapped = 1,
        DeleteOnClose = 2,
    };

    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
    public struct DS_SHARE_SCOPE_ENTRY
    {
        public DS_SCOPE_TYPE ScopeType;
        [MarshalAs(UnmanagedType.LPWStr)]
        public string ScopeValue;
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct DS_SHARE_SCOPE
    {
        public int ScopeCount;
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 20)]
        public DS_SHARE_SCOPE_ENTRY[] Scopes;
    };

    [StructLayout(LayoutKind.Sequential)]
    public class DS_SHARE_ACCESS_CONTROL
    {
        public DS_SHARE_PERMISSION SharePermission;
        public DS_SHARE_MODE ShareMode;
        public DS_SHARE_SCOPE Scope;

        public DS_SHARE_ACCESS_CONTROL()
        {
            Scope = new DS_SHARE_SCOPE() { Scopes = new DS_SHARE_SCOPE_ENTRY[20] };
            Scope.ScopeCount = 1;
            Scope.Scopes[0] = new DS_SHARE_SCOPE_ENTRY() { ScopeType = DS_SCOPE_TYPE.UserSid,
                ScopeValue = WindowsIdentity.GetCurrent().User.Value.ToString() };
        }
    };

    public static class Api
    {
        [DllImport("dsclient.dll", CharSet = CharSet.Unicode)]
        public static extern int DSCreateSharedFileToken(
                string filepath,
                DS_SHARE_ACCESS_CONTROL access_control,
                DS_TOKEN_LIFETIME_TYPE token_lifetime,
                DS_TOKEN_USAGE token_usage,
                out string token);

        [DllImport("dsclient.dll", CharSet = CharSet.Unicode)]
        public static extern int DSOpenSharedFile(string token, DS_OPEN_FLAGS flags, out SafeFileHandle handle);

        [DllImport("dsclient.dll", CharSet = CharSet.Unicode)]
        public static extern int DSMoveToSharedFile(string token, string source_file);

        [DllImport("dsclient.dll", CharSet = CharSet.Unicode)]
        public static extern int DSMoveFromSharedFile(string token, string dest_file);

        [DllImport("dsclient.dll", CharSet = CharSet.Unicode)]
        public static extern int DSCopyFromSharedFile(string token, string dest_file);

        [DllImport("dsclient.dll", CharSet = CharSet.Unicode)]
        public static extern int DSGetSharedFileName(string token, out string file_name);

        [DllImport("dsclient.dll", CharSet = CharSet.Unicode)]
        public static extern int DSGetSharingTokenOwner(string token, out string owner);

        [DllImport("dsclient.dll", CharSet = CharSet.Unicode)]
        public static extern int DSRemoveExpiredTokens();

        [DllImport("dsclient.dll", CharSet = CharSet.Unicode)]
        public static extern int DSRemoveSharingToken(string token);

        public static int Check(this int hr)
        {
            if (hr < 0)
            {
                throw new Win32Exception(hr);
            }
            return hr;
        }
    }
}
