/*
    Copyright 2007 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt
*/

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <sys/stat.h>
#include <time.h>
#include "mydownlib.h"

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER     "0.1"
#define UPLOAD0 "Content-Type: multipart/form-data; boundary=---------------------------%u"
#define UPLOAD1 "-----------------------------%u\r\n" \
                "Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"\r\n" \
                "Content-Type: application/octet-stream\r\n" \
                "\r\n"
#define UPLOAD2 "\r\n" \
                "-----------------------------%u\r\n" \
                "Content-Disposition: form-data; name=\"Upload\"\r\n" \
                "\r\n" \
                "Upload\r\n" \
                "-----------------------------%u--\r\n"



void fgetz(char *data, int len);
void std_err(void);



int main(int argc, char *argv[]) {
    mydown_options  opt;
    struct stat xstat;
    FILE    *fd;
    u32     len,
            seed;
    int     ret;
    u8      tmp[100],
            user[64],
            pass[64],
            *content,
            *data,
            *host,
            *lfile,
            *dfile,
            *formname = "";

    setbuf(stdout, NULL);

    fputs("\n"
        "Generic custom HTTP file uploader "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 4) {
        printf("\n"
            "Usage: %s <URL> <local_file> <dest_file> [form-name]\n"
            "\n"
            "Example:\n"
            "  127.0.0.1 file.txt ../../../windows/win.ini\n"
            "  http://127.0.0.1:1234/upload malware.exe ../../dir/file.exe\n"
            "\n", argv[0]);
        exit(1);
    }

    host  = argv[1];
    lfile = argv[2];
    dfile = argv[3];
    if(argc > 4) formname = argv[4];

    do {
        seed = (time(NULL) * 0x343FD) + 0x269EC3;
    } while(seed < 0xffff);         // in reality MIME uses a 64 bit value
    sprintf(tmp, UPLOAD0, seed);    // but this is enough

    printf("- load %s\n", lfile);
    fd = fopen(lfile, "rb");
    if(!fd) std_err();
    fstat(fileno(fd), &xstat);

    content = malloc(sizeof(UPLOAD1) + strlen(dfile) + xstat.st_size + sizeof(UPLOAD2) + 64);
    if(!content) std_err();

    len  = sprintf(content, UPLOAD1, seed, formname, dfile);
    len += fread(content + len, 1, xstat.st_size, fd);
    len += sprintf(content + len, UPLOAD2, seed, seed);

    fclose(fd);

    memset(&opt, 0, sizeof(opt));
    opt.verbose     = -1;
    opt.filedata    = (void *)&data;
    opt.ret_code    = &ret;
    opt.get         = "POST";
    opt.more_http   = tmp;
    opt.content     = content;
    opt.contentsize = len;

redo:
    data = NULL;
    printf("- upload file on %s\n", host);
    len = mydown(host, NULL, &opt);
    if(data) {
        if(len != MYDOWN_ERROR) fwrite(data, 1, len, stdout);
        free(data);
    }

    if(ret == 401) {
        printf("- authorization required:\n");
        printf("  insert the username: ");
        fgetz(user, sizeof(user));
        printf("  insert the password: ");
        fgetz(pass, sizeof(pass));
        opt.user    = user;
        opt.pass    = pass;
        goto redo;
    }
    if((len == MYDOWN_ERROR) && (ret != 200)) {
        printf("\nError: something wrong (return code %d)\n", ret);
    } else {
        printf("- upload finished\n");
    }

    free(content);
    return(0);
}



void fgetz(char *data, int len) {
    char    *p;

    fgets(data, len, stdin);
    for(p = data; *p && (*p != '\n') && (*p != '\r'); p++);
    *p = 0;
}



void std_err(void) {
    perror("\nError");
    exit(1);
}


