;Main include file for Win32 applications built with TASM5.
;Supplied on Companion Disk for book
;"Windows Assembly Language and Systems Programming"
;by Barry Kauler, published by R&D Books / Miller Freeman, USA, 1997.
;
;I have inserted some comments, marked by "*bk*".
;some unicode support, but a bit patchy.  What is missing mainly is
;the prototypes and structures for UNICODE characters.	All API
;functions ending in "....A" are ANSI character, while UNICODE
;functions end in "....W".  Maybe someone will be moved to fix this?
;Also, I have stuck stuff into this file "here and there" and it
;could do with a bit of organising.


;I would like to acknowledge Sven Schreiber:
;				  W32Main.inc
;	                  Win32 Main Header File V1.00
;	        03-14-1996 Sven B. Schreiber sbs@psbs.franken.de
;	                 This is Public Domain Software
;His file W32MAIN.INC is part of his WALK32 Windows 95 assembly language
;development tools, all public domain.	I have incorporated much of
;W32MAIN.INC into this file.

;I would like to acknowledge Wayne Radburn.
;Wayne has a public domain example assembly language program for Windows 95,
;included on the Companion Disk as SKELETON.ZIP.  It is for MASM 6.11.
;I have "borrowed" from his file WINDOWSA.INC, which has the API
;prototypes. I have modified the prototypes to suit TASM 5.0.



;------------------------------------------------------------------------------
				if	UNICODE
;
CHAR				textequ	<WCHAR>		;unicode char type
CHAR_				equ	2		;unicode char size
;
				else
;
CHAR				textequ	<ACHAR>		;ansi char type
CHAR_				equ	1		;ansi char size
;
				endif
;
;------------------------------------------------------------------------------


;
;	BASIC TYPES
;........................................................................
ACHAR				typedef	BYTE		;ansi character
ATOM				typedef DWORD		;string atom
BOOL				typedef DWORD		;boolean variable
COLORREF			typedef	DWORD		;rgb color
DWORDLONG			typedef	QWORD		;long double word
GLOBALHANDLE			typedef	DWORD		;global handle
HACCEL				typedef DWORD		;accelerator handle
HANDLE				typedef DWORD		;unspecified handle
HBITMAP				typedef	DWORD		;bitmap handle
HBRUSH				typedef	DWORD		;brush handle
HCOLORSPACE			typedef	DWORD		;color space handle
HCURSOR				typedef	DWORD		;cursor handle
HDC				typedef	DWORD		;device context handle
HDWP				typedef	DWORD		;defer win pos handle
HENHMETAFILE			typedef	DWORD		;enh. metafile handle
HFILE				typedef	DWORD		;file handle
HFONT				typedef	DWORD		;font handle
HGLOBAL				typedef	DWORD		;global handle
HHOOK				typedef	DWORD		;hook handle
HICON				typedef	DWORD		;icon handle
HINSTANCE			typedef	DWORD		;instance handle
HINTERNET			typedef	DWORD		;internet handle
HLOCAL				typedef	DWORD		;local handle
HMENU				typedef	DWORD		;menu handle
HMETAFILE			typedef	DWORD		;metafile handle
HPALETTE			typedef	DWORD		;palette handle
HPEN				typedef	DWORD		;pen handle
HRGN				typedef	DWORD		;region handle
HRSRC				typedef	DWORD		;resource handle
HSTR				typedef	DWORD		;string handle
HTASK				typedef	DWORD		;task handle
HTREEITEM			typedef	DWORD		;tree view item handle
HWND				typedef	DWORD		;window handle
INTEGER				typedef	DWORD		;standard integer
LOCALHANDLE			typedef	DWORD		;local handle
LONG				typedef	DWORD		;long integer
LONGINT				typedef	DWORD		;long integer
LPARAM				typedef	DWORD		;long parameter
LPBOOL				typedef DWORD		;long ptr to boolean
LPBYTE				typedef DWORD		;long ptr to byte
LPCSTR				typedef DWORD		;long ptr to string
LPCTSTR				typedef DWORD		;long ptr to string
LPCVOID				typedef	DWORD		;long ptr to buffer
LPDWORD				typedef	DWORD		;long ptr to dword
LPFN				typedef DWORD		;long ptr to function
LPINT				typedef DWORD		;long ptr to integer
LPLONG				typedef DWORD		;long ptr to long int
LPSTR				typedef DWORD		;long ptr to string
LPTSTR				typedef DWORD		;long ptr to string
LPVOID				typedef	DWORD		;long ptr to buffer
LPWORD				typedef	DWORD		;long ptr to word
LRESULT				typedef DWORD		;long result
POINTER				typedef DWORD		;pointer to anything
PVOID				typedef DWORD		;pointer to buffer
SHORTINT			typedef	WORD		;short integer
UINT				typedef	DWORD		;unsigned integer
WCHAR				typedef	WORD		;unicode character
WNDPROC				typedef	DWORD		;window procedure
WPARAM				typedef	DWORD		;word parameter
;
;
;

ULONG   EQU <dd>
NULL        equ 0   ;null
FALSE				equ	0		;boolean false
TRUE				equ	1		;boolean true
;
;------------------------------------------------------------------------------
;
BUTTON				equ	0080h		;button class
EDIT				equ	0081h		;edit class
STATIC				equ	0082h		;static class
LISTBOX				equ	0083h		;list box class
SCROLLBAR			equ	0084h		;scroll bar class
COMBOBOX			equ	0085h		;combo box class
;
;------------------------------------------------------------------------------
;
MAX_PATH			equ	260		;maximum path length
OFS_MAXPATHNAME			equ	128		;max OFSTRUCT path len
;
;------------------------------------------------------------------------------
;
INVALID_HANDLE_VALUE		equ	0FFFFFFFFh	;invalid handle
INVALID_FILE_SIZE		equ	0FFFFFFFFh	;invalid file size
INVALID_FILE_POINTER		equ	0FFFFFFFFh	;invalid file pointer
;
;==============================================================================
;
;	WIN32 CONSTANTS
;
;==============================================================================
;
; ========================
; bitmap compression types
; ========================
;
BI_RGB				equ	0
BI_RLE8				equ	1
BI_RLE4				equ	2
BI_BITFIELDS			equ	3
;
;------------------------------------------------------------------------------
;
; =======================
; button control messages
; =======================
;
BM_GETCHECK			equ	00F0h
BM_SETCHECK			equ	00F1h
BM_GETSTATE			equ	00F2h
BM_SETSTATE			equ	00F3h
BM_SETSTYLE			equ	00F4h
BM_CLICK			equ	00F5h
BM_GETIMAGE			equ	00F6h
BM_SETIMAGE			equ	00F7h
;
;------------------------------------------------------------------------------
;
; ============================
; button control notifications
; ============================
;
BN_CLICKED			equ	0000h
BN_PAINT			equ	0001h
BN_HILITE			equ	0002h
BN_UNHILITE			equ	0003h
BN_DISABLE			equ	0004h
BN_DOUBLECLICKED		equ	0005h
BN_SETFOCUS			equ	0006h
BN_KILLFOCUS			equ	0007h
;
BN_PUSHED			equ	BN_HILITE
BN_UNPUSHED			equ	BN_UNHILITE
BN_DBLCLK			equ	BN_DOUBLECLICKED
;
;------------------------------------------------------------------------------
;
; =====================
; button control styles
; =====================
;
BS_PUSHBUTTON			equ	0000h
BS_DEFPUSHBUTTON		equ	0001h
BS_CHECKBOX			equ	0002h
BS_AUTOCHECKBOX			equ	0003h
BS_RADIOBUTTON			equ	0004h
BS_3STATE			equ	0005h
BS_AUTO3STATE			equ	0006h
BS_GROUPBOX			equ	0007h
BS_USERBUTTON			equ	0008h
BS_AUTORADIOBUTTON		equ	0009h
BS_OWNERDRAW			equ	000Bh
BS_LEFTTEXT			equ	0020h
BS_TEXT				equ	0000h
BS_ICON				equ	0040h
BS_BITMAP			equ	0080h
BS_LEFT				equ	0100h
BS_RIGHT			equ	0200h
BS_CENTER			equ	0300h
BS_TOP				equ	0400h
BS_BOTTOM			equ	0800h
BS_VCENTER			equ	0C00h
BS_PUSHLIKE			equ	1000h
BS_MULTILINE			equ	2000h
BS_NOTIFY			equ	4000h
BS_FLAT				equ	8000h
;
BS_RIGHTBUTTON			equ	BS_LEFTTEXT
;
;------------------------------------------------------------------------------
;
; ==================
; combo box messages
; ==================
;
CB_GETEDITSEL			equ	0140h
CB_LIMITTEXT			equ	0141h
CB_SETEDITSEL			equ	0142h
CB_ADDSTRING			equ	0143h
CB_DELETESTRING			equ	0144h
CB_DIR				equ	0145h
CB_GETCOUNT			equ	0146h
CB_GETCURSEL			equ	0147h
CB_GETLBTEXT			equ	0148h
CB_GETLBTEXTLEN			equ	0149h
CB_INSERTSTRING			equ	014Ah
CB_RESETCONTENT			equ	014Bh
CB_FINDSTRING			equ	014Ch
CB_SELECTSTRING			equ	014Dh
CB_SETCURSEL			equ	014Eh
CB_SHOWDROPDOWN			equ	014Fh
CB_GETITEMDATA			equ	0150h
CB_SETITEMDATA			equ	0151h
CB_GETDROPPEDCONTROLRECT	equ	0152h
CB_SETITEMHEIGHT		equ	0153h
CB_GETITEMHEIGHT		equ	0154h
CB_SETEXTENDEDUI		equ	0155h
CB_GETEXTENDEDUI		equ	0156h
CB_GETDROPPEDSTATE		equ	0157h
CB_FINDSTRINGEXACT		equ	0158h
CB_SETLOCALE			equ	0159h
CB_GETLOCALE			equ	015Ah
CB_GETTOPINDEX			equ	015Bh
CB_SETTOPINDEX			equ	015Ch
CB_GETHORIZONTALEXTENT		equ	015Dh
CB_SETHORIZONTALEXTENT		equ	015Eh
CB_GETDROPPEDWIDTH		equ	015Fh
CB_SETDROPPEDWIDTH		equ	0160h
CB_INITSTORAGE			equ	0161h
CB_MSGMAX			equ	0162h
;
;------------------------------------------------------------------------------
;
; =======================
; combo box return values
; =======================
;
CB_OKAY				equ	 0
CB_ERR				equ	-1
CB_ERRSPACE			equ	-2
;
;------------------------------------------------------------------------------
;
; ======================
; CreateDIBitmap() codes
; ======================
;
CBM_INIT			equ	4
;
;------------------------------------------------------------------------------
;
; ============================
; combo box notification codes
; ============================
;
CBN_ERRSPACE			equ	-1
CBN_SELCHANGE			equ	 1
CBN_DBLCLK			equ	 2
CBN_SETFOCUS			equ	 3
CBN_KILLFOCUS			equ	 4
CBN_EDITCHANGE			equ	 5
CBN_EDITUPDATE			equ	 6
CBN_DROPDOWN			equ	 7
CBN_CLOSEUP			equ	 8
CBN_SELENDOK			equ	 9
CBN_SELENDCANCEL		equ	10
;
;------------------------------------------------------------------------------
;
; ================
; combo box styles
; ================
;
CBS_SIMPLE			equ	0001h
CBS_DROPDOWN			equ	0002h
CBS_DROPDOWNLIST		equ	0003h
CBS_OWNERDRAWFIXED		equ	0010h
CBS_OWNERDRAWVARIABLE		equ	0020h
CBS_AUTOHSCROLL			equ	0040h
CBS_OEMCONVERT			equ	0080h
CBS_SORT			equ	0100h
CBS_HASSTRINGS			equ	0200h
CBS_NOINTEGRALHEIGHT		equ	0400h
CBS_DISABLENOSCROLL		equ	0800h
CBS_UPPERCASE			equ	2000h
CBS_LOWERCASE			equ	4000h
;
;------------------------------------------------------------------------------
;
; =================
; clipboard formats
; =================
;
CF_TEXT				equ	0001h
CF_BITMAP			equ	0002h
CF_METAFILEPICT			equ	0003h
CF_SYLK				equ	0004h
CF_DIF				equ	0005h
CF_TIFF				equ	0006h
CF_OEMTEXT			equ	0007h
CF_DIB				equ	0008h
CF_PALETTE			equ	0009h
CF_PENDATA			equ	000Ah
CF_RIFF				equ	000Bh
CF_WAVE				equ	000Ch
CF_UNICODETEXT			equ	000Dh
CF_ENHMETAFILE			equ	000Eh
CF_HDROP			equ	000Fh
CF_LOCALE			equ	0010h
CF_MAX				equ	0011h
;
CF_OWNERDISPLAY			equ	0080h
CF_DSPTEXT			equ	0081h
CF_DSPBITMAP			equ	0082h
CF_DSPMETAFILEPICT		equ	0083h
CF_DSPENHMETAFILE		equ	008Eh
;
CF_PRIVATEFIRST			equ	0200h
CF_PRIVATELAST			equ	02FFh
;
CF_GDIOBJFIRST			equ	0300h
CF_GDIOBJLAST			equ	03FFh
;
;------------------------------------------------------------------------------
;
; ===========
; color types
; ===========
;
COLOR_SCROLLBAR			equ	 0
COLOR_BACKGROUND		equ	 1
COLOR_ACTIVECAPTION		equ	 2
COLOR_INACTIVECAPTION		equ	 3
COLOR_MENU			equ	 4
COLOR_WINDOW			equ	 5
COLOR_WINDOWFRAME		equ	 6
COLOR_MENUTEXT			equ	 7
COLOR_WINDOWTEXT		equ	 8
COLOR_CAPTIONTEXT		equ	 9
COLOR_ACTIVEBORDER		equ	10
COLOR_INACTIVEBORDER		equ	11
COLOR_APPWORKSPACE		equ	12
COLOR_HIGHLIGHT			equ	13
COLOR_HIGHLIGHTTEXT		equ	14
COLOR_BTNFACE			equ	15
COLOR_BTNSHADOW			equ	16
COLOR_GRAYTEXT			equ	17
COLOR_BTNTEXT			equ	18
COLOR_INACTIVECAPTIONTEXT	equ	19
COLOR_BTNHIGHLIGHT		equ	20
COLOR_3DDKSHADOW		equ	21
COLOR_3DLIGHT			equ	22
COLOR_INFOTEXT			equ	23
COLOR_INFOBK			equ	24
;
COLOR_DESKTOP			equ	COLOR_BACKGROUND
COLOR_3DFACE			equ	COLOR_BTNFACE
COLOR_3DSHADOW			equ	COLOR_BTNSHADOW
COLOR_3DHIGHLIGHT		equ	COLOR_BTNHIGHLIGHT
COLOR_3DHILIGHT			equ	COLOR_BTNHIGHLIGHT
COLOR_BTNHILIGHT		equ	COLOR_BTNHIGHLIGHT
;
;------------------------------------------------------------------------------
;
; ===================
; network connections
; ===================
;
CONNECT_UPDATE_PROFILE		equ	00000001h
CONNECT_UPDATE_RECENT		equ	00000002h
CONNECT_TEMPORARY		equ	00000004h
CONNECT_INTERACTIVE		equ	00000008h
CONNECT_PROMPT			equ	00000010h
CONNECT_NEED_DRIVE		equ	00000020h
CONNECT_REFCOUNT		equ	00000040h
CONNECT_REDIRECT		equ	00000080h
CONNECT_LOCALDRIVE		equ	00000100h
CONNECT_CURRENT_MEDIA		equ	00000200h
;
NETPROPERTY_PERSISTENT		equ	1
;
;------------------------------------------------------------------------------
;
; ====================
; thread context flags
; ====================
;
CONTEXT_i386			equ	00010000h
CONTEXT_i486			equ	00010000h
;
CONTEXT_CONTROL			equ	CONTEXT_i386+00000001h
CONTEXT_INTEGER			equ	CONTEXT_i386+00000002h
CONTEXT_SEGMENTS		equ	CONTEXT_i386+00000004h
CONTEXT_FLOATING_POINT		equ	CONTEXT_i386+00000008h
CONTEXT_DEBUG_REGISTERS		equ	CONTEXT_i386+00000010h
;
CONTEXT_FULL			equ	CONTEXT_CONTROL+\
					CONTEXT_INTEGER+\
					CONTEXT_SEGMENTS
;
SIZE_OF_80387_REGISTERS		equ	80
;
;------------------------------------------------------------------------------
;
; ==========
; code pages
; ==========
;
CP_ACP				equ	0
CP_OEMCP			equ	1
CP_MACCP			equ	2
;
;------------------------------------------------------------------------------
;
; ============
; class styles
; ============
;
CS_VREDRAW			equ	00000001h
CS_HREDRAW			equ	00000002h
CS_KEYCVTWINDOW			equ	00000004h
CS_DBLCLKS			equ	00000008h
CS_OWNDC			equ	00000020h
CS_CLASSDC			equ	00000040h
CS_PARENTDC			equ	00000080h
CS_NOKEYCVT			equ	00000100h
CS_NOCLOSE			equ	00000200h
CS_SAVEBITS			equ	00000800h
CS_BYTEALIGNCLIENT		equ	00001000h
CS_BYTEALIGNWINDOW		equ	00002000h
CS_GLOBALCLASS			equ	00004000h
CS_IME				equ	00010000h
;
;------------------------------------------------------------------------------
;
; ===================
; control color types
; ===================
;
CTLCOLOR_MSGBOX			equ	0
CTLCOLOR_EDIT			equ	1
CTLCOLOR_LISTBOX		equ	2
CTLCOLOR_BTN			equ	3
CTLCOLOR_DLG			equ	4
CTLCOLOR_SCROLLBAR		equ	5
CTLCOLOR_STATIC			equ	6
CTLCOLOR_MAX			equ	7
;
;------------------------------------------------------------------------------
;
; =======================
; CreateWindow() commands
; =======================
;
CW_USEDEFAULT			equ	80000000h
;
;------------------------------------------------------------------------------
;
; ===================
; device capabilities
; ===================
;
DC_FIELDS			equ	 1
DC_PAPERS			equ	 2
DC_PAPERSIZE			equ	 3
DC_MINEXTENT			equ	 4
DC_MAXEXTENT			equ	 5
DC_BINS				equ	 6
DC_DUPLEX			equ	 7
DC_SIZE				equ	 8
DC_EXTRA			equ	 9
DC_VERSION			equ	10
DC_DRIVER			equ	11
DC_BINNAMES			equ	12
DC_ENUMRESOLUTIONS		equ	13
DC_FILEDEPENDENCIES		equ	14
DC_TRUETYPE			equ	15
DC_PAPERNAMES			equ	16
DC_ORIENTATION			equ	17
DC_COPIES			equ	18
;
;------------------------------------------------------------------------------
;
; ====================
; dib color table id's
; ====================
;
DIB_RGB_COLORS			equ	0
DIB_PAL_COLORS			equ	1
;
;------------------------------------------------------------------------------
;
; ====================
; DLL LibMain() events
; ====================
;
DLL_PROCESS_DETACH		equ	0
DLL_PROCESS_ATTACH		equ	1
DLL_THREAD_ATTACH		equ	2
DLL_THREAD_DETACH		equ	3
;
;------------------------------------------------------------------------------
;
; ======================
; device mode selections
; ======================
;
DM_UPDATE			equ	1
DM_COPY				equ	2
DM_PROMPT			equ	4
DM_MODIFY			equ	8
;
DM_IN_BUFFER			equ	DM_MODIFY
DM_IN_PROMPT			equ	DM_PROMPT
DM_OUT_BUFFER			equ	DM_COPY
DM_OUT_DEFAULT			equ	DM_UPDATE
;
;------------------------------------------------------------------------------
;
; =============
; dialog styles
; =============
;
DS_ABSALIGN			equ	0001h
DS_SYSMODAL			equ	0002h
DS_3DLOOK			equ	0004h
DS_FIXEDSYS			equ	0008h
DS_NOFAILCREATE			equ	0010h
DS_LOCALEDIT			equ	0020h	;edit items get local storage
DS_SETFONT			equ	0040h	;user specified font
DS_MODALFRAME			equ	0080h	;combinable with WS_CAPTION
DS_NOIDLEMSG			equ	0100h	;don't send WM_ENTERIDLE
DS_SETFOREGROUND		equ	0200h
DS_CONTROL			equ	0400h
DS_CENTER			equ	0800h
DS_CENTERMOUSE			equ	1000h
DS_CONTEXTHELP			equ	2000h
;
DS_MODAL			equ	DS_ABSALIGN+DS_MODALFRAME
DS_MODELESS			equ	DS_ABSALIGN
;
;------------------------------------------------------------------------------
;
; =======================
; DrawText() format flags
; =======================
;
DT_TOP				equ	00000000h
DT_LEFT				equ	00000000h
DT_CENTER			equ	00000001h
DT_RIGHT			equ	00000002h
DT_VCENTER			equ	00000004h
DT_BOTTOM			equ	00000008h
DT_WORDBREAK			equ	00000010h
DT_SINGLELINE			equ	00000020h
DT_EXPANDTABS			equ	00000040h
DT_TABSTOP			equ	00000080h
DT_NOCLIP			equ	00000100h
DT_EXTERNALLEADING		equ	00000200h
DT_CALCRECT			equ	00000400h
DT_NOPREFIX			equ	00000800h
DT_INTERNAL			equ	00001000h
DT_EDITCONTROL			equ	00002000h
DT_PATH_ELLIPSIS		equ	00004000h
DT_END_ELLIPSIS			equ	00008000h
DT_MODIFYSTRING			equ	00010000h
DT_RTLREADING			equ	00020000h
DT_WORD_ELLIPSIS		equ	00040000h
;
;------------------------------------------------------------------------------
;
; =====================
; edit control messages
; =====================
;
EM_GETSEL			equ	00B0h
EM_SETSEL			equ	00B1h
EM_GETRECT			equ	00B2h
EM_SETRECT			equ	00B3h
EM_SETRECTNP			equ	00B4h
EM_SCROLL			equ	00B5h
EM_LINESCROLL			equ	00B6h
EM_SCROLLCARET			equ	00B7h
EM_GETMODIFY			equ	00B8h
EM_SETMODIFY			equ	00B9h
EM_GETLINECOUNT			equ	00BAh
EM_LINEINDEX			equ	00BBh
EM_SETHANDLE			equ	00BCh
EM_GETHANDLE			equ	00BDh
EM_GETTHUMB			equ	00BEh
EM_LINELENGTH			equ	00C1h
EM_REPLACESEL			equ	00C2h
EM_GETLINE			equ	00C4h
EM_LIMITTEXT			equ	00C5h
EM_CANUNDO			equ	00C6h
EM_UNDO				equ	00C7h
EM_FMTLINES			equ	00C8h
EM_LINEFROMCHAR			equ	00C9h
EM_SETTABSTOPS			equ	00CBh
EM_SETPASSWORDCHAR		equ	00CCh
EM_EMPTYUNDOBUFFER		equ	00CDh
EM_GETFIRSTVISIBLELINE		equ	00CEh
EM_SETREADONLY			equ	00CFh
EM_SETWORDBREAKPROC		equ	00D0h
EM_GETWORDBREAKPROC		equ	00D1h
EM_GETPASSWORDCHAR		equ	00D2h
EM_SETMARGINS			equ	00D3h
EM_GETMARGINS			equ	00D4h
EM_GETLIMITTEXT			equ	00D5h
EM_POSFROMCHAR			equ	00D6h
EM_CHARFROMPOS			equ	00D7h
;
EM_SETLIMITTEXT			equ	EM_LIMITTEXT
;
;------------------------------------------------------------------------------
;
; ==========================
; edit control notifications
; ==========================
;
EN_SETFOCUS			equ	0100h
EN_KILLFOCUS			equ	0200h
EN_CHANGE			equ	0300h
EN_UPDATE			equ	0400h
EN_ERRSPACE			equ	0500h
EN_MAXTEXT			equ	0501h
EN_HSCROLL			equ	0601h
EN_VSCROLL			equ	0602h
;
;------------------------------------------------------------------------------
;
; ===========
; error codes
; ===========
;
ERROR_SUCCESS				equ	   0
NO_ERROR				equ	   0
;
ERROR_INVALID_FUNCTION			equ	   1
ERROR_FILE_NOT_FOUND			equ	   2
ERROR_PATH_NOT_FOUND			equ	   3
ERROR_TOO_MANY_OPEN_FILES		equ	   4
ERROR_ACCESS_DENIED			equ	   5
ERROR_INVALID_HANDLE			equ	   6
ERROR_ARENA_TRASHED			equ	   7
ERROR_NOT_ENOUGH_MEMORY			equ	   8
ERROR_INVALID_BLOCK			equ	   9
ERROR_BAD_ENVIRONMENT			equ	  10
ERROR_BAD_FORMAT			equ	  11
ERROR_INVALID_ACCESS			equ	  12
ERROR_INVALID_DATA			equ	  13
ERROR_OUTOFMEMORY			equ	  14
ERROR_INVALID_DRIVE			equ	  15
ERROR_CURRENT_DIRECTORY			equ	  16
ERROR_NOT_SAME_DEVICE			equ	  17
ERROR_NO_MORE_FILES			equ	  18
ERROR_WRITE_PROTECT			equ	  19
ERROR_BAD_UNIT				equ	  20
ERROR_NOT_READY				equ	  21
ERROR_BAD_COMMAND			equ	  22
ERROR_CRC				equ	  23
ERROR_BAD_LENGTH			equ	  24
ERROR_SEEK				equ	  25
ERROR_NOT_DOS_DISK			equ	  26
ERROR_SECTOR_NOT_FOUND			equ	  27
ERROR_OUT_OF_PAPER			equ	  28
ERROR_WRITE_FAULT			equ	  29
ERROR_READ_FAULT			equ	  30
ERROR_GEN_FAILURE			equ	  31
ERROR_SHARING_VIOLATION			equ	  32
ERROR_LOCK_VIOLATION			equ	  33
ERROR_WRONG_DISK			equ	  34
ERROR_SHARING_BUFFER_EXCEEDED		equ	  36
ERROR_HANDLE_EOF			equ	  38
ERROR_HANDLE_DISK_FULL			equ	  39
ERROR_NOT_SUPPORTED			equ	  50
ERROR_REM_NOT_LIST			equ	  51
ERROR_DUP_NAME				equ	  52
ERROR_BAD_NETPATH			equ	  53
ERROR_NETWORK_BUSY			equ	  54
ERROR_DEV_NOT_EXIST			equ	  55
ERROR_TOO_MANY_CMDS			equ	  56
ERROR_ADAP_HDW_ERR			equ	  57
ERROR_BAD_NET_RESP			equ	  58
ERROR_UNEXP_NET_ERR			equ	  59
ERROR_BAD_REM_ADAP			equ	  60
ERROR_PRINTQ_FULL			equ	  61
ERROR_NO_SPOOL_SPACE			equ	  62
ERROR_PRINT_CANCELLED			equ	  63
ERROR_NETNAME_DELETED			equ	  64
ERROR_NETWORK_ACCESS_DENIED		equ	  65
ERROR_BAD_DEV_TYPE			equ	  66
ERROR_BAD_NET_NAME			equ	  67
ERROR_TOO_MANY_NAMES			equ	  68
ERROR_TOO_MANY_SESS			equ	  69
ERROR_SHARING_PAUSED			equ	  70
ERROR_REQ_NOT_ACCEP			equ	  71
ERROR_REDIR_PAUSED			equ	  72
ERROR_FILE_EXISTS			equ	  80
ERROR_CANNOT_MAKE			equ	  82
ERROR_FAIL_I24				equ	  83
ERROR_OUT_OF_STRUCTURES			equ	  84
ERROR_ALREADY_ASSIGNED			equ	  85
ERROR_INVALID_PASSWORD			equ	  86
ERROR_INVALID_PARAMETER			equ	  87
ERROR_NET_WRITE_FAULT			equ	  88
ERROR_NO_PROC_SLOTS			equ	  89
ERROR_TOO_MANY_SEMAPHORES		equ	 100
ERROR_EXCL_SEM_ALREADY_OWNED		equ	 101
ERROR_SEM_IS_SET			equ	 102
ERROR_TOO_MANY_SEM_REQUESTS		equ	 103
ERROR_INVALID_AT_INTERRUPT_TIME		equ	 104
ERROR_SEM_OWNER_DIED			equ	 105
ERROR_SEM_USER_LIMIT			equ	 106
ERROR_DISK_CHANGE			equ	 107
ERROR_DRIVE_LOCKED			equ	 108
ERROR_BROKEN_PIPE			equ	 109
ERROR_OPEN_FAILED			equ	 110
ERROR_BUFFER_OVERFLOW			equ	 111
ERROR_DISK_FULL				equ	 112
ERROR_NO_MORE_SEARCH_HANDLES		equ	 113
ERROR_INVALID_TARGET_HANDLE		equ	 114
ERROR_INVALID_CATEGORY			equ	 117
ERROR_INVALID_VERIFY_SWITCH		equ	 118
ERROR_BAD_DRIVER_LEVEL			equ	 119
ERROR_CALL_NOT_IMPLEMENTED		equ	 120
ERROR_SEM_TIMEOUT			equ	 121
ERROR_INSUFFICIENT_BUFFER		equ	 122
ERROR_INVALID_NAME			equ	 123
ERROR_INVALID_LEVEL			equ	 124
ERROR_NO_VOLUME_LABEL			equ	 125
ERROR_MOD_NOT_FOUND			equ	 126
ERROR_PROC_NOT_FOUND			equ	 127
ERROR_WAIT_NO_CHILDREN			equ	 128
ERROR_CHILD_NOT_COMPLETE		equ	 129
ERROR_DIRECT_ACCESS_HANDLE		equ	 130
ERROR_NEGATIVE_SEEK			equ	 131
ERROR_SEEK_ON_DEVICE			equ	 132
ERROR_IS_JOIN_TARGET			equ	 133
ERROR_IS_JOINED				equ	 134
ERROR_IS_SUBSTED			equ	 135
ERROR_NOT_JOINED			equ	 136
ERROR_NOT_SUBSTED			equ	 137
ERROR_JOIN_TO_JOIN			equ	 138
ERROR_SUBST_TO_SUBST			equ	 139
ERROR_JOIN_TO_SUBST			equ	 140
ERROR_SUBST_TO_JOIN			equ	 141
ERROR_BUSY_DRIVE			equ	 142
ERROR_SAME_DRIVE			equ	 143
ERROR_DIR_NOT_ROOT			equ	 144
ERROR_DIR_NOT_EMPTY			equ	 145
ERROR_IS_SUBST_PATH			equ	 146
ERROR_IS_JOIN_PATH			equ	 147
ERROR_PATH_BUSY				equ	 148
ERROR_IS_SUBST_TARGET			equ	 149
ERROR_SYSTEM_TRACE			equ	 150
ERROR_INVALID_EVENT_COUNT		equ	 151
ERROR_TOO_MANY_MUXWAITERS		equ	 152
ERROR_INVALID_LIST_FORMAT		equ	 153
ERROR_LABEL_TOO_LONG			equ	 154
ERROR_TOO_MANY_TCBS			equ	 155
ERROR_SIGNAL_REFUSED			equ	 156
ERROR_DISCARDED				equ	 157
ERROR_NOT_LOCKED			equ	 158
ERROR_BAD_THREADID_ADDR			equ	 159
ERROR_BAD_ARGUMENTS			equ	 160
ERROR_BAD_PATHNAME			equ	 161
ERROR_SIGNAL_PENDING			equ	 162
ERROR_MAX_THRDS_REACHED			equ	 164
ERROR_LOCK_FAILED			equ	 167
ERROR_BUSY				equ	 170
ERROR_CANCEL_VIOLATION			equ	 173
ERROR_ATOMIC_LOCKS_NOT_SUPPORTED	equ	 174
ERROR_INVALID_SEGMENT_NUMBER		equ	 180
ERROR_INVALID_ORDINAL			equ	 182
ERROR_ALREADY_EXISTS			equ	 183
ERROR_INVALID_FLAG_NUMBER		equ	 186
ERROR_SEM_NOT_FOUND			equ	 187
ERROR_INVALID_STARTING_CODESEG		equ	 188
ERROR_INVALID_STACKSEG			equ	 189
ERROR_INVALID_MODULETYPE		equ	 190
ERROR_INVALID_EXE_SIGNATURE		equ	 191
ERROR_EXE_MARKED_INVALID		equ	 192
ERROR_BAD_EXE_FORMAT			equ	 193
ERROR_ITERATED_DATA_EXCEEDS_64k		equ	 194
ERROR_INVALID_MINALLOCSIZE		equ	 195
ERROR_DYNLINK_FROM_INVALID_RING		equ	 196
ERROR_IOPL_NOT_ENABLED			equ	 197
ERROR_INVALID_SEGDPL			equ	 198
ERROR_AUTODATASEG_EXCEEDS_64k		equ	 199
ERROR_RING2SEG_MUST_BE_MOVABLE		equ	 200
ERROR_RELOC_CHAIN_XEEDS_SEGLIM		equ	 201
ERROR_INFLOOP_IN_RELOC_CHAIN		equ	 202
ERROR_ENVVAR_NOT_FOUND			equ	 203
ERROR_NO_SIGNAL_SENT			equ	 205
ERROR_FILENAME_EXCED_RANGE		equ	 206
ERROR_RING2_STACK_IN_USE		equ	 207
ERROR_META_EXPANSION_TOO_LONG		equ	 208
ERROR_INVALID_SIGNAL_NUMBER		equ	 209
ERROR_THREAD_1_INACTIVE			equ	 210
ERROR_LOCKED				equ	 212
ERROR_TOO_MANY_MODULES			equ	 214
ERROR_NESTING_NOT_ALLOWED		equ	 215
ERROR_BAD_PIPE				equ	 230
ERROR_PIPE_BUSY				equ	 231
ERROR_NO_DATA				equ	 232
ERROR_PIPE_NOT_CONNECTED		equ	 233
ERROR_MORE_DATA				equ	 234
ERROR_VC_DISCONNECTED			equ	 240
ERROR_INVALID_EA_NAME			equ	 254
ERROR_EA_LIST_INCONSISTENT		equ	 255
ERROR_NO_MORE_ITEMS			equ	 259
ERROR_CANNOT_COPY			equ	 266
ERROR_DIRECTORY				equ	 267
ERROR_EAS_DIDNT_FIT			equ	 275
ERROR_EA_FILE_CORRUPT			equ	 276
ERROR_EA_TABLE_FULL			equ	 277
ERROR_INVALID_EA_HANDLE			equ	 278
ERROR_EAS_NOT_SUPPORTED			equ	 282
ERROR_NOT_OWNER				equ	 288
ERROR_TOO_MANY_POSTS			equ	 298
ERROR_PARTIAL_COPY			equ	 299
ERROR_MR_MID_NOT_FOUND			equ	 317
ERROR_INVALID_ADDRESS			equ	 487
ERROR_ARITHMETIC_OVERFLOW		equ	 534
ERROR_PIPE_CONNECTED			equ	 535
ERROR_PIPE_LISTENING			equ	 536
ERROR_EA_ACCESS_DENIED			equ	 994
ERROR_OPERATION_ABORTED			equ	 995
ERROR_IO_INCOMPLETE			equ	 996
ERROR_IO_PENDING			equ	 997
ERROR_NOACCESS				equ	 998
ERROR_SWAPERROR				equ	 999
ERROR_STACK_OVERFLOW			equ	1001
ERROR_INVALID_MESSAGE			equ	1002
ERROR_CAN_NOT_COMPLETE			equ	1003
ERROR_INVALID_FLAGS			equ	1004
ERROR_UNRECOGNIZED_VOLUME		equ	1005
ERROR_FILE_INVALID			equ	1006
ERROR_FULLSCREEN_MODE			equ	1007
ERROR_NO_TOKEN				equ	1008
ERROR_BADDB				equ	1009
ERROR_BADKEY				equ	1010
ERROR_CANTOPEN				equ	1011
ERROR_CANTREAD				equ	1012
ERROR_CANTWRITE				equ	1013
ERROR_REGISTRY_RECOVERED		equ	1014
ERROR_REGISTRY_CORRUPT			equ	1015
ERROR_REGISTRY_IO_FAILED		equ	1016
ERROR_NOT_REGISTRY_FILE			equ	1017
ERROR_KEY_DELETED			equ	1018
ERROR_NO_LOG_SPACE			equ	1019
ERROR_KEY_HAS_CHILDREN			equ	1020
ERROR_CHILD_MUST_BE_VOLATILE		equ	1021
ERROR_NOTIFY_ENUM_DIR			equ	1022
ERROR_DEPENDENT_SERVICES_RUNNING	equ	1051
ERROR_INVALID_SERVICE_CONTROL		equ	1052
ERROR_SERVICE_REQUEST_TIMEOUT		equ	1053
ERROR_SERVICE_NO_THREAD			equ	1054
ERROR_SERVICE_DATABASE_LOCKED		equ	1055
ERROR_SERVICE_ALREADY_RUNNING		equ	1056
ERROR_INVALID_SERVICE_ACCOUNT		equ	1057
ERROR_SERVICE_DISABLED			equ	1058
ERROR_CIRCULAR_DEPENDENCY		equ	1059
ERROR_SERVICE_DOES_NOT_EXIST		equ	1060
ERROR_SERVICE_CANNOT_ACCEPT_CTRL	equ	1061
ERROR_SERVICE_NOT_ACTIVE		equ	1062
ERROR_FAILED_SERVICE_CONTROLLER_CONNECT	equ	1063
ERROR_EXCEPTION_IN_SERVICE		equ	1064
ERROR_DATABASE_DOES_NOT_EXIST		equ	1065
ERROR_SERVICE_SPECIFIC_ERROR		equ	1066
ERROR_PROCESS_ABORTED			equ	1067
ERROR_SERVICE_DEPENDENCY_FAIL		equ	1068
ERROR_SERVICE_LOGON_FAILED		equ	1069
ERROR_SERVICE_START_HANG		equ	1070
ERROR_INVALID_SERVICE_LOCK		equ	1071
ERROR_SERVICE_MARKED_FOR_DELETE		equ	1072
ERROR_SERVICE_EXISTS			equ	1073
ERROR_ALREADY_RUNNING_LKG		equ	1074
ERROR_SERVICE_DEPENDENCY_DELETED	equ	1075
ERROR_BOOT_ALREADY_ACCEPTED		equ	1076
ERROR_SERVICE_NEVER_STARTED		equ	1077
ERROR_DUPLICATE_SERVICE_NAME		equ	1078
ERROR_END_OF_MEDIA			equ	1100
ERROR_FILEMARK_DETECTED			equ	1101
ERROR_BEGINNING_OF_MEDIA		equ	1102
ERROR_SETMARK_DETECTED			equ	1103
ERROR_NO_DATA_DETECTED			equ	1104
ERROR_PARTITION_FAILURE			equ	1105
ERROR_INVALID_BLOCK_LENGTH		equ	1106
ERROR_DEVICE_NOT_PARTITIONED		equ	1107
ERROR_UNABLE_TO_LOCK_MEDIA		equ	1108
ERROR_UNABLE_TO_UNLOAD_MEDIA		equ	1109
ERROR_MEDIA_CHANGED			equ	1110
ERROR_BUS_RESET				equ	1111
ERROR_NO_MEDIA_IN_DRIVE			equ	1112
ERROR_NO_UNICODE_TRANSLATION		equ	1113
ERROR_DLL_INIT_FAILED			equ	1114
ERROR_SHUTDOWN_IN_PROGRESS		equ	1115
ERROR_NO_SHUTDOWN_IN_PROGRESS		equ	1116
ERROR_IO_DEVICE				equ	1117
ERROR_SERIAL_NO_DEVICE			equ	1118
ERROR_IRQ_BUSY				equ	1119
ERROR_MORE_WRITES			equ	1120
ERROR_COUNTER_TIMEOUT			equ	1121
ERROR_FLOPPY_ID_MARK_NOT_FOUND		equ	1122
ERROR_FLOPPY_WRONG_CYLINDER		equ	1123
ERROR_FLOPPY_UNKNOWN_ERROR		equ	1124
ERROR_FLOPPY_BAD_REGISTERS		equ	1125
ERROR_DISK_RECALIBRATE_FAILED		equ	1126
ERROR_DISK_OPERATION_FAILED		equ	1127
ERROR_DISK_RESET_FAILED			equ	1128
ERROR_EOM_OVERFLOW			equ	1129
ERROR_NOT_ENOUGH_SERVER_MEMORY		equ	1130
ERROR_POSSIBLE_DEADLOCK			equ	1131
ERROR_MAPPED_ALIGNMENT			equ	1132
ERROR_SET_POWER_STATE_VETOED		equ	1140
ERROR_SET_POWER_STATE_FAILED		equ	1141
ERROR_OLD_WIN_VERSION			equ	1150
ERROR_APP_WRONG_OS			equ	1151
ERROR_SINGLE_INSTANCE_APP		equ	1152
ERROR_RMODE_APP				equ	1153
ERROR_INVALID_DLL			equ	1154
ERROR_NO_ASSOCIATION			equ	1155
ERROR_DDE_FAIL				equ	1156
ERROR_DLL_NOT_FOUND			equ	1157
ERROR_BAD_USERNAME			equ	2202
ERROR_NOT_CONNECTED			equ	2250
ERROR_OPEN_FILES			equ	2401
ERROR_ACTIVE_CONNECTIONS		equ	2402
ERROR_DEVICE_IN_USE			equ	2404
ERROR_BAD_DEVICE			equ	1200
ERROR_CONNECTION_UNAVAIL		equ	1201
ERROR_DEVICE_ALREADY_REMEMBERED		equ	1202
ERROR_NO_NET_OR_BAD_PATH		equ	1203
ERROR_BAD_PROVIDER			equ	1204
ERROR_CANNOT_OPEN_PROFILE		equ	1205
ERROR_BAD_PROFILE			equ	1206
ERROR_NOT_CONTAINER			equ	1207
ERROR_EXTENDED_ERROR			equ	1208
ERROR_INVALID_GROUPNAME			equ	1209
ERROR_INVALID_COMPUTERNAME		equ	1210
ERROR_INVALID_EVENTNAME			equ	1211
ERROR_INVALID_DOMAINNAME		equ	1212
ERROR_INVALID_SERVICENAME		equ	1213
ERROR_INVALID_NETNAME			equ	1214
ERROR_INVALID_SHARENAME			equ	1215
ERROR_INVALID_PASSWORDNAME		equ	1216
ERROR_INVALID_MESSAGENAME		equ	1217
ERROR_INVALID_MESSAGEDEST		equ	1218
ERROR_SESSION_CREDENTIAL_CONFLICT	equ	1219
ERROR_REMOTE_SESSION_LIMIT_EXCEEDED	equ	1220
ERROR_DUP_DOMAINNAME			equ	1221
ERROR_NO_NETWORK			equ	1222
ERROR_CANCELLED				equ	1223
ERROR_USER_MAPPED_FILE			equ	1224
ERROR_CONNECTION_REFUSED		equ	1225
ERROR_GRACEFUL_DISCONNECT		equ	1226
ERROR_ADDRESS_ALREADY_ASSOCIATED	equ	1227
ERROR_ADDRESS_NOT_ASSOCIATED		equ	1228
ERROR_CONNECTION_INVALID		equ	1229
ERROR_CONNECTION_ACTIVE			equ	1230
ERROR_NETWORK_UNREACHABLE		equ	1231
ERROR_HOST_UNREACHABLE			equ	1232
ERROR_PROTOCOL_UNREACHABLE		equ	1233
ERROR_PORT_UNREACHABLE			equ	1234
ERROR_REQUEST_ABORTED			equ	1235
ERROR_CONNECTION_ABORTED		equ	1236
ERROR_RETRY				equ	1237
ERROR_CONNECTION_COUNT_LIMIT		equ	1238
ERROR_LOGIN_TIME_RESTRICTION		equ	1239
ERROR_LOGIN_WKSTA_RESTRICTION		equ	1240
ERROR_INCORRECT_ADDRESS			equ	1241
ERROR_ALREADY_REGISTERED		equ	1242
ERROR_SERVICE_NOT_FOUND			equ	1243
ERROR_NOT_AUTHENTICATED			equ	1244
ERROR_NOT_LOGGED_ON			equ	1245
ERROR_CONTINUE				equ	1246
ERROR_ALREADY_INITIALIZED		equ	1247
ERROR_NO_MORE_DEVICES			equ	1248
ERROR_NOT_ALL_ASSIGNED			equ	1300
ERROR_SOME_NOT_MAPPED			equ	1301
ERROR_NO_QUOTAS_FOR_ACCOUNT		equ	1302
ERROR_LOCAL_USER_SESSION_KEY		equ	1303
ERROR_NULL_LM_PASSWORD			equ	1304
ERROR_UNKNOWN_REVISION			equ	1305
ERROR_REVISION_MISMATCH			equ	1306
ERROR_INVALID_OWNER			equ	1307
ERROR_INVALID_PRIMARY_GROUP		equ	1308
ERROR_NO_IMPERSONATION_TOKEN		equ	1309
ERROR_CANT_DISABLE_MANDATORY		equ	1310
ERROR_NO_LOGON_SERVERS			equ	1311
ERROR_NO_SUCH_LOGON_SESSION		equ	1312
ERROR_NO_SUCH_PRIVILEGE			equ	1313
ERROR_PRIVILEGE_NOT_HELD		equ	1314
ERROR_INVALID_ACCOUNT_NAME		equ	1315
ERROR_USER_EXISTS			equ	1316
ERROR_NO_SUCH_USER			equ	1317
ERROR_GROUP_EXISTS			equ	1318
ERROR_NO_SUCH_GROUP			equ	1319
ERROR_MEMBER_IN_GROUP			equ	1320
ERROR_MEMBER_NOT_IN_GROUP		equ	1321
ERROR_LAST_ADMIN			equ	1322
ERROR_WRONG_PASSWORD			equ	1323
ERROR_ILL_FORMED_PASSWORD		equ	1324
ERROR_PASSWORD_RESTRICTION		equ	1325
ERROR_LOGON_FAILURE			equ	1326
ERROR_ACCOUNT_RESTRICTION		equ	1327
ERROR_INVALID_LOGON_HOURS		equ	1328
ERROR_INVALID_WORKSTATION		equ	1329
ERROR_PASSWORD_EXPIRED			equ	1330
ERROR_ACCOUNT_DISABLED			equ	1331
ERROR_NONE_MAPPED			equ	1332
ERROR_TOO_MANY_LUIDS_REQUESTED		equ	1333
ERROR_LUIDS_EXHAUSTED			equ	1334
ERROR_INVALID_SUB_AUTHORITY		equ	1335
ERROR_INVALID_ACL			equ	1336
ERROR_INVALID_SID			equ	1337
ERROR_INVALID_SECURITY_DESCR		equ	1338
ERROR_BAD_INHERITANCE_ACL		equ	1340
ERROR_SERVER_DISABLED			equ	1341
ERROR_SERVER_NOT_DISABLED		equ	1342
ERROR_INVALID_ID_AUTHORITY		equ	1343
ERROR_ALLOTTED_SPACE_EXCEEDED		equ	1344
ERROR_INVALID_GROUP_ATTRIBUTES		equ	1345
ERROR_BAD_IMPERSONATION_LEVEL		equ	1346
ERROR_CANT_OPEN_ANONYMOUS		equ	1347
ERROR_BAD_VALIDATION_CLASS		equ	1348
ERROR_BAD_TOKEN_TYPE			equ	1349
ERROR_NO_SECURITY_ON_OBJECT		equ	1350
ERROR_CANT_ACCESS_DOMAIN_INFO		equ	1351
ERROR_INVALID_SERVER_STATE		equ	1352
ERROR_INVALID_DOMAIN_STATE		equ	1353
ERROR_INVALID_DOMAIN_ROLE		equ	1354
ERROR_NO_SUCH_DOMAIN			equ	1355
ERROR_DOMAIN_EXISTS			equ	1356
ERROR_DOMAIN_LIMIT_EXCEEDED		equ	1357
ERROR_INTERNAL_DB_CORRUPTION		equ	1358
ERROR_INTERNAL_ERROR			equ	1359
ERROR_GENERIC_NOT_MAPPED		equ	1360
ERROR_BAD_DESCRIPTOR_FORMAT		equ	1361
ERROR_NOT_LOGON_PROCESS			equ	1362
ERROR_LOGON_SESSION_EXISTS		equ	1363
ERROR_NO_SUCH_PACKAGE			equ	1364
ERROR_BAD_LOGON_SESSION_STATE		equ	1365
ERROR_LOGON_SESSION_COLLISION		equ	1366
ERROR_INVALID_LOGON_TYPE		equ	1367
ERROR_CANNOT_IMPERSONATE		equ	1368
ERROR_RXACT_INVALID_STATE		equ	1369
ERROR_RXACT_COMMIT_FAILURE		equ	1370
ERROR_SPECIAL_ACCOUNT			equ	1371
ERROR_SPECIAL_GROUP			equ	1372
ERROR_SPECIAL_USER			equ	1373
ERROR_MEMBERS_PRIMARY_GROUP		equ	1374
ERROR_TOKEN_ALREADY_IN_USE		equ	1375
ERROR_NO_SUCH_ALIAS			equ	1376
ERROR_MEMBER_NOT_IN_ALIAS		equ	1377
ERROR_MEMBER_IN_ALIAS			equ	1378
ERROR_ALIAS_EXISTS			equ	1379
ERROR_LOGON_NOT_GRANTED			equ	1380
ERROR_TOO_MANY_SECRETS			equ	1381
ERROR_SECRET_TOO_LONG			equ	1382
ERROR_INTERNAL_DB_ERROR			equ	1383
ERROR_TOO_MANY_CONTEXT_IDS		equ	1384
ERROR_LOGON_TYPE_NOT_GRANTED		equ	1385
ERROR_NT_CROSS_ENCRYPTION_REQUIRED	equ	1386
ERROR_NO_SUCH_MEMBER			equ	1387
ERROR_INVALID_MEMBER			equ	1388
ERROR_TOO_MANY_SIDS			equ	1389
ERROR_LM_CROSS_ENCRYPTION_REQUIRED	equ	1390
ERROR_NO_INHERITANCE			equ	1391
ERROR_FILE_CORRUPT			equ	1392
ERROR_DISK_CORRUPT			equ	1393
ERROR_NO_USER_SESSION_KEY		equ	1394
ERROR_LICENSE_QUOTA_EXCEEDED		equ	1395
ERROR_INVALID_WINDOW_HANDLE		equ	1400
ERROR_INVALID_MENU_HANDLE		equ	1401
ERROR_INVALID_CURSOR_HANDLE		equ	1402
ERROR_INVALID_ACCEL_HANDLE		equ	1403
ERROR_INVALID_HOOK_HANDLE		equ	1404
ERROR_INVALID_DWP_HANDLE		equ	1405
ERROR_TLW_WITH_WSCHILD			equ	1406
ERROR_CANNOT_FIND_WND_CLASS		equ	1407
ERROR_WINDOW_OF_OTHER_THREAD		equ	1408
ERROR_HOTKEY_ALREADY_REGISTERED		equ	1409
ERROR_CLASS_ALREADY_EXISTS		equ	1410
ERROR_CLASS_DOES_NOT_EXIST		equ	1411
ERROR_CLASS_HAS_WINDOWS			equ	1412
ERROR_INVALID_INDEX			equ	1413
ERROR_INVALID_ICON_HANDLE		equ	1414
ERROR_PRIVATE_DIALOG_INDEX		equ	1415
ERROR_LISTBOX_ID_NOT_FOUND		equ	1416
ERROR_NO_WILDCARD_CHARACTERS		equ	1417
ERROR_CLIPBOARD_NOT_OPEN		equ	1418
ERROR_HOTKEY_NOT_REGISTERED		equ	1419
ERROR_WINDOW_NOT_DIALOG			equ	1420
ERROR_CONTROL_ID_NOT_FOUND		equ	1421
ERROR_INVALID_COMBOBOX_MESSAGE		equ	1422
ERROR_WINDOW_NOT_COMBOBOX		equ	1423
ERROR_INVALID_EDIT_HEIGHT		equ	1424
ERROR_DC_NOT_FOUND			equ	1425
ERROR_INVALID_HOOK_FILTER		equ	1426
ERROR_INVALID_FILTER_PROC		equ	1427
ERROR_HOOK_NEEDS_HMOD			equ	1428
ERROR_GLOBAL_ONLY_HOOK			equ	1429
ERROR_JOURNAL_HOOK_SET			equ	1430
ERROR_HOOK_NOT_INSTALLED		equ	1431
ERROR_INVALID_LB_MESSAGE		equ	1432
ERROR_SETCOUNT_ON_BAD_LB		equ	1433
ERROR_LB_WITHOUT_TABSTOPS		equ	1434
ERROR_DESTROY_OBJECT_OF_OTHER_THREAD	equ	1435
ERROR_CHILD_WINDOW_MENU			equ	1436
ERROR_NO_SYSTEM_MENU			equ	1437
ERROR_INVALID_MSGBOX_STYLE		equ	1438
ERROR_INVALID_SPI_VALUE			equ	1439
ERROR_SCREEN_ALREADY_LOCKED		equ	1440
ERROR_HWNDS_HAVE_DIFF_PARENT		equ	1441
ERROR_NOT_CHILD_WINDOW			equ	1442
ERROR_INVALID_GW_COMMAND		equ	1443
ERROR_INVALID_THREAD_ID			equ	1444
ERROR_NON_MDICHILD_WINDOW		equ	1445
ERROR_POPUP_ALREADY_ACTIVE		equ	1446
ERROR_NO_SCROLLBARS			equ	1447
ERROR_INVALID_SCROLLBAR_RANGE		equ	1448
ERROR_INVALID_SHOWWIN_COMMAND		equ	1449
ERROR_NO_SYSTEM_RESOURCES		equ	1450
ERROR_NONPAGED_SYSTEM_RESOURCES		equ	1451
ERROR_PAGED_SYSTEM_RESOURCES		equ	1452
ERROR_WORKING_SET_QUOTA			equ	1453
ERROR_PAGEFILE_QUOTA			equ	1454
ERROR_COMMITMENT_LIMIT			equ	1455
ERROR_MENU_ITEM_NOT_FOUND		equ	1456
ERROR_EVENTLOG_FILE_CORRUPT		equ	1500
ERROR_EVENTLOG_CANT_START		equ	1501
ERROR_LOG_FILE_FULL			equ	1502
ERROR_EVENTLOG_FILE_CHANGED		equ	1503
ERROR_INVALID_USER_BUFFER		equ	1784
ERROR_UNRECOGNIZED_MEDIA		equ	1785
ERROR_NO_TRUST_LSA_SECRET		equ	1786
ERROR_NO_TRUST_SAM_ACCOUNT		equ	1787
ERROR_TRUSTED_DOMAIN_FAILURE		equ	1788
ERROR_TRUSTED_RELATIONSHIP_FAILURE	equ	1789
ERROR_TRUST_FAILURE			equ	1790
ERROR_NETLOGON_NOT_STARTED		equ	1792
ERROR_ACCOUNT_EXPIRED			equ	1793
ERROR_REDIRECTOR_HAS_OPEN_HANDLES	equ	1794
ERROR_PRINTER_DRIVER_ALREADY_INSTALLED	equ	1795
ERROR_UNKNOWN_PORT			equ	1796
ERROR_UNKNOWN_PRINTER_DRIVER		equ	1797
ERROR_UNKNOWN_PRINTPROCESSOR		equ	1798
ERROR_INVALID_SEPARATOR_FILE		equ	1799
ERROR_INVALID_PRIORITY			equ	1800
ERROR_INVALID_PRINTER_NAME		equ	1801
ERROR_PRINTER_ALREADY_EXISTS		equ	1802
ERROR_INVALID_PRINTER_COMMAND		equ	1803
ERROR_INVALID_DATATYPE			equ	1804
ERROR_INVALID_ENVIRONMENT		equ	1805
ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT	equ	1807
ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT	equ	1808
ERROR_NOLOGON_SERVER_TRUST_ACCOUNT	equ	1809
ERROR_DOMAIN_TRUST_INCONSISTENT		equ	1810
ERROR_SERVER_HAS_OPEN_HANDLES		equ	1811
ERROR_RESOURCE_DATA_NOT_FOUND		equ	1812
ERROR_RESOURCE_TYPE_NOT_FOUND		equ	1813
ERROR_RESOURCE_NAME_NOT_FOUND		equ	1814
ERROR_RESOURCE_LANG_NOT_FOUND		equ	1815
ERROR_NOT_ENOUGH_QUOTA			equ	1816
ERROR_INVALID_TIME			equ	1901
ERROR_INVALID_FORM_NAME			equ	1902
ERROR_INVALID_FORM_SIZE			equ	1903
ERROR_ALREADY_WAITING			equ	1904
ERROR_PRINTER_DELETED			equ	1905
ERROR_INVALID_PRINTER_STATE		equ	1906
ERROR_PASSWORD_MUST_CHANGE		equ	1907
ERROR_DOMAIN_CONTROLLER_NOT_FOUND	equ	1908
ERROR_ACCOUNT_LOCKED_OUT		equ	1909
ERROR_INVALID_PIXEL_FORMAT		equ	2000
ERROR_BAD_DRIVER			equ	2001
ERROR_INVALID_WINDOW_STYLE		equ	2002
ERROR_METAFILE_NOT_SUPPORTED		equ	2003
ERROR_TRANSFORM_NOT_SUPPORTED		equ	2004
ERROR_CLIPPING_NOT_SUPPORTED		equ	2005
ERROR_UNKNOWN_PRINT_MONITOR		equ	3000
ERROR_PRINTER_DRIVER_IN_USE		equ	3001
ERROR_SPOOL_FILE_NOT_FOUND		equ	3002
ERROR_SPL_NO_STARTDOC			equ	3003
ERROR_SPL_NO_ADDJOB			equ	3004
ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED	equ	3005
ERROR_PRINT_MONITOR_ALREADY_INSTALLED	equ	3006
ERROR_WINS_INTERNAL			equ	4000
ERROR_CAN_NOT_DEL_LOCAL_WINS		equ	4001
ERROR_STATIC_INIT			equ	4002
ERROR_INC_BACKUP			equ	4003
ERROR_FULL_BACKUP			equ	4004
ERROR_REC_NON_EXISTENT			equ	4005
ERROR_RPL_NOT_ALLOWED			equ	4006
ERROR_NO_BROWSER_SERVERS_FOUND		equ	6118
;
;------------------------------------------------------------------------------
;
; ===================
; edit control styles
; ===================
;
ES_LEFT				equ	0000h
ES_CENTER			equ	0001h
ES_RIGHT			equ	0002h
ES_MULTILINE			equ	0004h
ES_UPPERCASE			equ	0008h
ES_LOWERCASE			equ	0010h
ES_PASSWORD			equ	0020h
ES_AUTOVSCROLL			equ	0040h
ES_AUTOHSCROLL			equ	0080h
ES_NOHIDESEL			equ	0100h
ES_OEMCONVERT			equ	0400h
ES_READONLY			equ	0800h
ES_WANTRETURN			equ	1000h
ES_NUMBER			equ	2000h
;
ES_DEFAULT			equ	ES_MULTILINE+ES_AUTOHSCROLL
;
;------------------------------------------------------------------------------
;
; =============
; font families
; =============
;
FF_DONTCARE			equ	0000h
FF_ROMAN			equ	0010h
FF_SWISS			equ	0020h
FF_MODERN			equ	0030h
FF_SCRIPT			equ	0040h
FF_DECORATIVE			equ	0050h
;
;------------------------------------------------------------------------------
;
; ===============
; file attributes
; ===============
;
FILE_ATTRIBUTE_READONLY		equ	00000001h
FILE_ATTRIBUTE_HIDDEN		equ	00000002h
FILE_ATTRIBUTE_SYSTEM		equ	00000004h
FILE_ATTRIBUTE_DIRECTORY	equ	00000010h
FILE_ATTRIBUTE_ARCHIVE		equ	00000020h
FILE_ATTRIBUTE_NORMAL		equ	00000080h
FILE_ATTRIBUTE_TEMPORARY	equ	00000100h
FILE_ATTRIBUTE_COMPRESSED	equ	00000800h
;
;------------------------------------------------------------------------------
;
; ===================
; file creation flags
; ===================
;
FILE_FLAG_WRITE_THROUGH		equ	80000000h
FILE_FLAG_OVERLAPPED		equ	40000000h
FILE_FLAG_NO_BUFFERING		equ	20000000h
FILE_FLAG_RANDOM_ACCESS		equ	10000000h
FILE_FLAG_SEQUENTIAL_SCAN	equ	08000000h
FILE_FLAG_DELETE_ON_CLOSE	equ	04000000h
FILE_FLAG_BACKUP_SEMANTICS	equ	02000000h
FILE_FLAG_POSIX_SEMANTICS	equ	01000000h
;
;------------------------------------------------------------------------------
;
; ==================
; file notifications
; ==================
;
FILE_NOTIFY_CHANGE_FILE_NAME	equ	0001h
FILE_NOTIFY_CHANGE_DIR_NAME	equ	0002h
FILE_NOTIFY_CHANGE_ATTRIBUTES	equ	0004h
FILE_NOTIFY_CHANGE_SIZE		equ	0008h
FILE_NOTIFY_CHANGE_LAST_WRITE	equ	0010h
FILE_NOTIFY_CHANGE_SECURITY	equ	0100h
;
;------------------------------------------------------------------------------
;
; ================
; file share modes
; ================
;
FILE_SHARE_NONE			equ	0000h
FILE_SHARE_READ			equ	0001h
FILE_SHARE_WRITE		equ	0002h
;
FILE_SHARE_READWRITE		equ	FILE_SHARE_READ+FILE_SHARE_WRITE
;
;------------------------------------------------------------------------------
;
; ========================
; SetFilePointer() methods
; ========================
;
FILE_BEGIN			equ	0
FILE_CURRENT			equ	1
FILE_END			equ	2
;
;------------------------------------------------------------------------------
;
; =================
; file system flags
; =================
;
FILE_CASE_SENSITIVE_SEARCH	equ	00000001h
FILE_CASE_PRESERVED_NAMES	equ	00000002h
FILE_UNICODE_ON_DISK		equ	00000004h
FILE_PERSISTENT_ACLS		equ	00000008h
FILE_FILE_COMPRESSION		equ	00000010h
FILE_VOLUME_IS_COMPRESSED	equ	00008000h
;
FS_CASE_SENSITIVE		equ	FILE_CASE_SENSITIVE_SEARCH
FS_CASE_IS_PRESERVED		equ	FILE_CASE_PRESERVED_NAMES
FS_UNICODE_STORED_ON_DISK	equ	FILE_UNICODE_ON_DISK
FS_PERSISTENT_ACLS		equ	FILE_PERSISTENT_ACLS
FS_FILE_COMPRESSION		equ	FILE_FILE_COMPRESSION
FS_VOL_IS_COMPRESSED		equ	FILE_VOLUME_IS_COMPRESSED
;
;------------------------------------------------------------------------------
;
; ============
; font weights
; ============
;
FW_DONTCARE			equ	000
FW_THIN				equ	100
FW_EXTRALIGHT			equ	200
FW_LIGHT			equ	300
FW_NORMAL			equ	400
FW_MEDIUM			equ	500
FW_SEMIBOLD			equ	600
FW_BOLD				equ	700
FW_EXTRABOLD			equ	800
FW_HEAVY			equ	900
;
FW_ULTRALIGHT			equ	FW_EXTRALIGHT
FW_REGULAR			equ	FW_NORMAL
FW_DEMIBOLD			equ	FW_SEMIBOLD
FW_ULTRABOLD			equ	FW_EXTRABOLD
FW_BLACK			equ	FW_HEAVY
;
;------------------------------------------------------------------------------
;
; ======================
; GetClassLong() offsets
; ======================
;
GCL_MENUNAME			equ	-08
GCL_HBRBACKGROUND		equ	-10
GCL_HCURSOR			equ	-12
GCL_HICON			equ	-14
GCL_HMODULE			equ	-16
GCL_CBWNDEXTRA			equ	-18
GCL_CBCLSEXTRA			equ	-20
GCL_WNDPROC			equ	-24
GCL_STYLE			equ	-26
GCW_ATOM			equ	-32
GCL_HICONSM			equ	-34
;
;------------------------------------------------------------------------------
;
; =================
; file access types
; =================
;
GENERIC_ALL			equ	10000000h
GENERIC_EXECUTE			equ	20000000h
GENERIC_WRITE			equ	40000000h
GENERIC_READ			equ	80000000h
;
GENERIC_READWRITE		equ	GENERIC_READ+GENERIC_WRITE
;
;------------------------------------------------------------------------------
;
; ===================
; global memory flags
; ===================
;
GMEM_FIXED			equ	0000h
GMEM_MOVEABLE			equ	0002h
GMEM_NOCOMPACT			equ	0010h
GMEM_NODISCARD			equ	0020h
GMEM_ZEROINIT			equ	0040h
GMEM_MODIFY			equ	0080h
GMEM_DISCARDABLE		equ	0100h
GMEM_NOT_BANKED			equ	1000h
GMEM_SHARE			equ	2000h
GMEM_DDESHARE			equ	2000h
GMEM_NOTIFY			equ	4000h
GMEM_INVALID_HANDLE		equ	8000h
;
GMEM_VALID_FLAGS		equ	7F72h
GMEM_LOWER			equ	GMEM_NOT_BANKED
;
;------------------------------------------------------------------------------
;
; ================
; GetWindow() id's
; ================
;
GW_HWNDFIRST			equ	0
GW_HWNDLAST			equ	1
GW_HWNDNEXT			equ	2
GW_HWNDPREV			equ	3
GW_OWNER			equ	4
GW_CHILD			equ	5
;
GW_MAX				equ	5
;
;------------------------------------------------------------------------------
;
; =======================
; GetWindowLong() offsets
; =======================
;
GWL_WNDPROC			equ	-04
GWL_HINSTANCE			equ	-06
GWL_HWNDPARENT			equ	-08
GWL_STYLE			equ	-16
GWL_EXSTYLE			equ	-20
GWL_USERDATA			equ	-21
GWL_ID				equ	-12
;
;------------------------------------------------------------------------------
;
; ==================
; WinHelp() commands
; ==================
;
HELP_CONTEXT			equ	0001h
HELP_QUIT			equ	0002h
HELP_INDEX			equ	0003h
HELP_CONTENTS			equ	0003h
HELP_HELPONHELP			equ	0004h
HELP_SETINDEX			equ	0005h
HELP_SETCONTENTS		equ	0005h
HELP_CONTEXTPOPUP		equ	0008h
HELP_FORCEFILE			equ	0009h
HELP_CONTEXTMENU		equ	000Ah
HELP_FINDER			equ	000Bh
HELP_WM_HELP			equ	000Ch
HELP_SETPOPUP_POS		equ	000Dh
HELP_TCARD_DATA			equ	0010h
HELP_TCARD_OTHER_CALLER		equ	0011h
HELP_KEY			equ	0101h
HELP_COMMAND			equ	0102h
HELP_PARTIALKEY			equ	0105h
HELP_MULTIKEY			equ	0201h
HELP_SETWINPOS			equ	0203h
HELP_TCARD			equ	8000h
;
;------------------------------------------------------------------------------
;
; =======================
; hit test position codes
; =======================
;
HTERROR				equ	-2
HTTRANSPARENT			equ	-1
HTNOWHERE			equ	 0
HTCLIENT			equ	 1
HTCAPTION			equ	 2
HTSYSMENU			equ	 3
HTGROWBOX			equ	 4
HTMENU				equ	 5
HTHSCROLL			equ	 6
HTVSCROLL			equ	 7
HTMINBUTTON			equ	 8
HTMAXBUTTON			equ	 9
;
HTSIZEFIRST			equ	HTLEFT
HTLEFT				equ	10
HTRIGHT				equ	11
HTTOP				equ	12
HTTOPLEFT			equ	13
HTTOPRIGHT			equ	14
HTBOTTOM			equ	15
HTBOTTOMLEFT			equ	16
HTBOTTOMRIGHT			equ	17
HTSIZELAST			equ	HTBOTTOMRIGHT
;
HTBORDER			equ	18
HTOBJECT			equ	19
HTCLOSE				equ	20
HTHELP				equ	21
;
HTSIZE				equ	HTGROWBOX
HTREDUCE			equ	HTMINBUTTON
HTZOOM				equ	HTMAXBUTTON
;
;------------------------------------------------------------------------------
;
; ===================
; toolbar bitmap id's
; ===================
;
IDB_STD_SMALL_COLOR		equ	 0
IDB_STD_LARGE_COLOR		equ	 1
IDB_VIEW_SMALL_COLOR		equ	 4
IDB_VIEW_LARGE_COLOR		equ	 5
;
HINST_COMMCTRL			equ	-1
;
;------------------------------------------------------------------------------
;
; ====================
; standard cursor id's
; ====================
;
IDC_ARROW			equ	32512
IDC_IBEAM			equ	32513
IDC_WAIT			equ	32514
IDC_CROSS			equ	32515
IDC_UPARROW			equ	32516
IDC_SIZE			equ	32640	;obsolete, use IDC_SIZEALL
IDC_ICON			equ	32641	;obsolete, use IDC_ARROW
IDC_SIZENWSE			equ	32642
IDC_SIZENESW			equ	32643
IDC_SIZEWE			equ	32644
IDC_SIZENS			equ	32645
IDC_SIZEALL			equ	32646
IDC_NO				equ	32648
IDC_APPSTARTING			equ	32650
IDC_HELP			equ	32651
;
;------------------------------------------------------------------------------
;
; ==================
; standard icon id's
; ==================
;
IDI_APPLICATION			equ	32512
IDI_HAND			equ	32513
IDI_QUESTION			equ	32514
IDI_EXCLAMATION			equ	32515
IDI_ASTERISK			equ	32516
IDI_WINLOGO			equ	32517
;
;------------------------------------------------------------------------------
;
; ===================
; dialog command id's
; ===================
;
IDOK				equ	1
IDCANCEL			equ	2
IDABORT				equ	3
IDRETRY				equ	4
IDIGNORE			equ	5
IDYES				equ	6
IDNO				equ	7
IDCLOSE				equ	8
IDHELP				equ	9
;
;------------------------------------------------------------------------------
;
; =============================
; keyboard message lParam flags
; =============================
;
KF_EXTENDED			equ	0100h
KF_DLGMODE			equ	0800h
KF_MENUMODE			equ	1000h
KF_ALTDOWN			equ	2000h
KF_REPEAT			equ	4000h
KF_UP				equ	8000h
;
;------------------------------------------------------------------------------
;
; ================
; listbox messages
; ================
;
LB_ADDSTRING			equ	0180h
LB_INSERTSTRING			equ	0181h
LB_DELETESTRING			equ	0182h
LB_SELITEMRANGEEX		equ	0183h
LB_RESETCONTENT			equ	0184h
LB_SETSEL			equ	0185h
LB_SETCURSEL			equ	0186h
LB_GETSEL			equ	0187h
LB_GETCURSEL			equ	0188h
LB_GETTEXT			equ	0189h
LB_GETTEXTLEN			equ	018Ah
LB_GETCOUNT			equ	018Bh
LB_SELECTSTRING			equ	018Ch
LB_DIR				equ	018Dh
LB_GETTOPINDEX			equ	018Eh
LB_FINDSTRING			equ	018Fh
LB_GETSELCOUNT			equ	0190h
LB_GETSELITEMS			equ	0191h
LB_SETTABSTOPS			equ	0192h
LB_GETHORIZONTALEXTENT		equ	0193h
LB_SETHORIZONTALEXTENT		equ	0194h
LB_SETCOLUMNWIDTH		equ	0195h
LB_ADDFILE			equ	0196h
LB_SETTOPINDEX			equ	0197h
LB_GETITEMRECT			equ	0198h
LB_GETITEMDATA			equ	0199h
LB_SETITEMDATA			equ	019Ah
LB_SELITEMRANGE			equ	019Bh
LB_SETANCHORINDEX		equ	019Ch
LB_GETANCHORINDEX		equ	019Dh
LB_SETCARETINDEX		equ	019Eh
LB_GETCARETINDEX		equ	019Fh
LB_SETITEMHEIGHT		equ	01A0h
LB_GETITEMHEIGHT		equ	01A1h
LB_FINDSTRINGEXACT		equ	01A2h
LB_SETLOCALE			equ	01A5h
LB_GETLOCALE			equ	01A6h
LB_SETCOUNT			equ	01A7h
LB_INITSTORAGE			equ	01A8h
LB_ITEMFROMPOINT		equ	01A9h
LB_MSGMAX			equ	01B0h
;
;------------------------------------------------------------------------------
;
; =====================
; listbox return values
; =====================
;
LB_OKAY				equ	 0
LB_ERR				equ	-1
LB_ERRSPACE			equ	-2
;
;------------------------------------------------------------------------------
;
; ==========================
; listbox notification codes
; ==========================
;
LBN_ERRSPACE			equ	-2
LBN_SELCHANGE			equ	 1
LBN_DBLCLK			equ	 2
LBN_SELCANCEL			equ	 3
LBN_SETFOCUS			equ	 4
LBN_KILLFOCUS			equ	 5
;
;------------------------------------------------------------------------------
;
; ==============
; listbox styles
; ==============
;
LBS_NOTIFY			equ	00000001h
LBS_SORT			equ	00000002h
LBS_NOREDRAW			equ	00000004h
LBS_MULTIPLESEL			equ	00000008h
LBS_OWNERDRAWFIXED		equ	00000010h
LBS_OWNERDRAWVARIABLE		equ	00000020h
LBS_HASSTRINGS			equ	00000040h
LBS_USETABSTOPS			equ	00000080h
LBS_NOINTEGRALHEIGHT		equ	00000100h
LBS_MULTICOLUMN			equ	00000200h
LBS_WANTKEYBOARDINPUT		equ	00000400h
LBS_EXTENDEDSEL			equ	00000800h
LBS_DISABLENOSCROLL		equ	00001000h
LBS_NODATA			equ	00002000h
LBS_NOSEL			equ	00004000h
LBS_STANDARD			equ	00A00003h
;
;------------------------------------------------------------------------------
;
; ==================
; local memory flags
; ==================
;
LMEM_FIXED			equ	0000h
LMEM_MOVEABLE			equ	0002h
LMEM_NOCOMPACT			equ	0010h
LMEM_NODISCARD			equ	0020h
LMEM_ZEROINIT			equ	0040h
LMEM_MODIFY			equ	0080h
LMEM_LOCKCOUNT			equ	00FFh
LMEM_DISCARDABLE		equ	0F00h
LMEM_DISCARDED			equ	4000h
LMEM_INVALID_HANDLE		equ	8000h
;
LMEM_VALID_FLAGS		equ	0F72h
;
NONZEROLHND			equ	LMEM_MOVEABLE
NONZEROLPTR			equ	LMEM_FIXED
;
LHND				equ	LMEM_ZEROINIT+LMEM_MOVEABLE
LPTR				equ	LMEM_ZEROINIT+LMEM_FIXED
;
;------------------------------------------------------------------------------
;
; ==================
; list view messages
; ==================
;
LVM_FIRST			equ	1000h
;
LVM_GETBKCOLOR			equ	LVM_FIRST+000
LVM_SETBKCOLOR			equ	LVM_FIRST+001
LVM_GETIMAGELIST		equ	LVM_FIRST+002
LVM_SETIMAGELIST		equ	LVM_FIRST+003
LVM_GETITEMCOUNT		equ	LVM_FIRST+004
LVM_GETITEMA			equ	LVM_FIRST+005
LVM_SETITEMA			equ	LVM_FIRST+006
LVM_INSERTITEMA			equ	LVM_FIRST+007
LVM_DELETEITEM			equ	LVM_FIRST+008
LVM_DELETEALLITEMS		equ	LVM_FIRST+009
LVM_GETCALLBACKMASK		equ	LVM_FIRST+010
LVM_SETCALLBACKMASK		equ	LVM_FIRST+011
LVM_GETNEXTITEM			equ	LVM_FIRST+012
LVM_FINDITEMA			equ	LVM_FIRST+013
LVM_GETITEMRECT			equ	LVM_FIRST+014
LVM_SETITEMPOSITION		equ	LVM_FIRST+015
LVM_GETITEMPOSITION		equ	LVM_FIRST+016
LVM_GETSTRINGWIDTHA		equ	LVM_FIRST+017
LVM_HITTEST			equ	LVM_FIRST+018
LVM_ENSUREVISIBLE		equ	LVM_FIRST+019
LVM_SCROLL			equ	LVM_FIRST+020
LVM_REDRAWITEMS			equ	LVM_FIRST+021
LVM_ARRANGE			equ	LVM_FIRST+022
LVM_EDITLABELA			equ	LVM_FIRST+023
LVM_GETEDITCONTROL		equ	LVM_FIRST+024
LVM_GETCOLUMNA			equ	LVM_FIRST+025
LVM_SETCOLUMNA			equ	LVM_FIRST+026
LVM_INSERTCOLUMNA		equ	LVM_FIRST+027
LVM_DELETECOLUMN		equ	LVM_FIRST+028
LVM_GETCOLUMNWIDTH		equ	LVM_FIRST+029
LVM_SETCOLUMNWIDTH		equ	LVM_FIRST+030
LVM_CREATEDRAGIMAGE		equ	LVM_FIRST+033
LVM_GETVIEWRECT			equ	LVM_FIRST+034
LVM_GETTEXTCOLOR		equ	LVM_FIRST+035
LVM_SETTEXTCOLOR		equ	LVM_FIRST+036
LVM_GETTEXTBKCOLOR		equ	LVM_FIRST+037
LVM_SETTEXTBKCOLOR		equ	LVM_FIRST+038
LVM_GETTOPINDEX			equ	LVM_FIRST+039
LVM_GETCOUNTPERPAGE		equ	LVM_FIRST+040
LVM_GETORIGIN			equ	LVM_FIRST+041
LVM_UPDATE			equ	LVM_FIRST+042
LVM_SETITEMSTATE		equ	LVM_FIRST+043
LVM_GETITEMSTATE		equ	LVM_FIRST+044
LVM_GETITEMTEXTA		equ	LVM_FIRST+045
LVM_SETITEMTEXTA		equ	LVM_FIRST+046
LVM_SETITEMCOUNT		equ	LVM_FIRST+047
LVM_SORTITEMS			equ	LVM_FIRST+048
LVM_SETITEMPOSITION32		equ	LVM_FIRST+049
LVM_GETSELECTEDCOUNT		equ	LVM_FIRST+050
LVM_GETITEMSPACING		equ	LVM_FIRST+051
LVM_GETISEARCHSTRINGA		equ	LVM_FIRST+052
;
LVM_GETITEMW			equ	LVM_FIRST+075
LVM_SETITEMW			equ	LVM_FIRST+076
LVM_INSERTITEMW			equ	LVM_FIRST+077
LVM_FINDITEMW			equ	LVM_FIRST+083
LVM_GETSTRINGWIDTHW		equ	LVM_FIRST+087
LVM_GETCOLUMNW			equ	LVM_FIRST+095
LVM_SETCOLUMNW			equ	LVM_FIRST+096
LVM_INSERTCOLUMNW		equ	LVM_FIRST+097
LVM_GETITEMTEXTW		equ	LVM_FIRST+115
LVM_SETITEMTEXTW		equ	LVM_FIRST+116
LVM_GETISEARCHSTRINGW		equ	LVM_FIRST+117
LVM_EDITLABELW			equ	LVM_FIRST+118
;
				if	UNICODE
LVM_GETITEM			equ	LVM_GETITEMW
LVM_SETITEM			equ	LVM_SETITEMW
LVM_INSERTITEM			equ	LVM_INSERTITEMW
LVM_FINDITEM			equ	LVM_FINDITEMW
LVM_GETSTRINGWIDTH		equ	LVM_GETSTRINGWIDTHW
LVM_GETCOLUMN			equ	LVM_GETCOLUMNW
LVM_SETCOLUMN			equ	LVM_SETCOLUMNW
LVM_INSERTCOLUMN		equ	LVM_INSERTCOLUMNW
LVM_GETITEMTEXT	 		equ	LVM_GETITEMTEXTW
LVM_SETITEMTEXT 		equ	LVM_SETITEMTEXTW
LVM_GETISEARCHSTRING		equ	LVM_GETISEARCHSTRINGW
LVM_EDITLABEL			equ	LVM_EDITLABELW
				else
LVM_GETITEM			equ	LVM_GETITEMA
LVM_SETITEM			equ	LVM_SETITEMA
LVM_INSERTITEM			equ	LVM_INSERTITEMA
LVM_FINDITEM			equ	LVM_FINDITEMA
LVM_GETSTRINGWIDTH		equ	LVM_GETSTRINGWIDTHA
LVM_GETCOLUMN			equ	LVM_GETCOLUMNA
LVM_SETCOLUMN			equ	LVM_SETCOLUMNA
LVM_INSERTCOLUMN		equ	LVM_INSERTCOLUMNA
LVM_GETITEMTEXT	 		equ	LVM_GETITEMTEXTA
LVM_SETITEMTEXT 		equ	LVM_SETITEMTEXTA
LVM_GETISEARCHSTRING		equ	LVM_GETISEARCHSTRINGA
LVM_EDITLABEL			equ	LVM_EDITLABELA
				endif
;
;------------------------------------------------------------------------------
;
; =======================
; list view notifications
; =======================
;
LVN_FIRST			equ	-100
LVN_LAST			equ	LVN_FIRST-99
;
LVN_ITEMCHANGING		equ	LVN_FIRST-00
LVN_ITEMCHANGED			equ	LVN_FIRST-01
LVN_INSERTITEM			equ	LVN_FIRST-02
LVN_DELETEITEM			equ	LVN_FIRST-03
LVN_DELETEALLITEMS		equ	LVN_FIRST-04
LVN_BEGINLABELEDITA		equ	LVN_FIRST-05
LVN_ENDLABELEDITA		equ	LVN_FIRST-06
LVN_COLUMNCLICK			equ	LVN_FIRST-08
LVN_BEGINDRAG			equ	LVN_FIRST-09
LVN_BEGINRDRAG			equ	LVN_FIRST-11
LVN_GETDISPINFOA		equ	LVN_FIRST-50
LVN_SETDISPINFOA		equ	LVN_FIRST-51
;
LVN_BEGINLABELEDITW		equ	LVN_FIRST-75
LVN_ENDLABELEDITW		equ	LVN_FIRST-76
LVN_GETDISPINFOW		equ	LVN_FIRST-77
LVN_SETDISPINFOW		equ	LVN_FIRST-78
;
				if	UNICODE
LVN_BEGINLABELEDIT		equ	LVN_BEGINLABELEDITW
LVN_ENDLABELEDIT		equ	LVN_ENDLABELEDITW
LVN_GETDISPINFO			equ	LVN_GETDISPINFOW
LVN_SETDISPINFO			equ	LVN_SETDISPINFOW
				else
LVN_BEGINLABELEDIT		equ	LVN_BEGINLABELEDITA
LVN_ENDLABELEDIT		equ	LVN_ENDLABELEDITA
LVN_GETDISPINFO			equ	LVN_GETDISPINFOA
LVN_SETDISPINFO			equ	LVN_SETDISPINFOA
				endif
;
;------------------------------------------------------------------------------
;
; ================
; list view styles
; ================
;
LVS_TYPEMASK			equ	00000003h
LVS_ICON			equ	00000000h
LVS_REPORT			equ	00000001h
LVS_SMALLICON			equ	00000002h
LVS_LIST			equ	00000003h
;
LVS_SINGLESEL			equ	00000004h
LVS_SHOWSELALWAYS		equ	00000008h
LVS_SORTASCENDING		equ	00000010h
LVS_SORTDESCENDING		equ	00000020h
LVS_SHAREIMAGELISTS		equ	00000040h
LVS_NOLABELWRAP			equ	00000080h
LVS_AUTOARRANGE			equ	00000100h
LVS_EDITLABELS			equ	00000200h
;
LVS_TYPESTYLEMASK		equ	0000FC00h
;
LVS_ALIGNMASK			equ	00000C00h
LVS_ALIGNTOP			equ	00000000h
LVS_OWNERDRAWFIXED		equ	00000400h
LVS_ALIGNLEFT			equ	00000800h
;
LVS_NOSCROLL			equ	00002000h
LVS_NOCOLUMNHEADER		equ	00004000h
LVS_NOSORTHEADER		equ	00008000h
;
;------------------------------------------------------------------------------
;
; ==================
; MessageBox() flags
; ==================
;
MB_OK				equ	00000000h
MB_OKCANCEL			equ	00000001h
MB_ABORTRETRYIGNORE		equ	00000002h
MB_YESNOCANCEL			equ	00000003h
MB_YESNO			equ	00000004h
MB_RETRYCANCEL			equ	00000005h
;
MB_ICONHAND			equ	00000010h
MB_ICONQUESTION			equ	00000020h
MB_ICONEXCLAMATION		equ	00000030h
MB_ICONASTERISK			equ	00000040h
;
MB_ICONWARNING			equ	MB_ICONEXCLAMATION
MB_ICONERROR			equ	MB_ICONHAND
MB_ICONINFORMATION		equ	MB_ICONASTERISK
MB_ICONSTOP			equ	MB_ICONHAND
;
MB_DEFBUTTON1			equ	00000000h
MB_DEFBUTTON2			equ	00000100h
MB_DEFBUTTON3			equ	00000200h
MB_DEFBUTTON4			equ	00000300h
;
MB_APPLMODAL			equ	00000000h
MB_SYSTEMMODAL			equ	00001000h
MB_TASKMODAL			equ	00002000h
MB_HELP				equ	00004000h
MB_RIGHT			equ	00080000h
MB_RTLREADING			equ	00100000h
;
MB_NOFOCUS			equ	00008000h
MB_SETFOREGROUND		equ	00010000h
MB_DEFAULT_DESKTOP_ONLY		equ	00020000h
MB_SERVICE_NOTIFICATION		equ	00040000h
;
MB_TYPEMASK			equ	0000000Fh
MB_USERICON			equ	00000080h
MB_ICONMASK			equ	000000F0h
MB_DEFMASK			equ	00000F00h
MB_MODEMASK			equ	00003000h
MB_MISCMASK			equ	0000C000h
;
;------------------------------------------------------------------------------
;
; ==========
; menu flags
; ==========
;
MF_INSERT			equ	00000000h
MF_CHANGE			equ	00000080h
MF_APPEND			equ	00000100h
MF_DELETE			equ	00000200h
MF_REMOVE			equ	00001000h
;
MF_BYCOMMAND			equ	00000000h
MF_BYPOSITION			equ	00000400h
;
MF_SEPARATOR			equ	00000800h
;
MF_ENABLED			equ	00000000h
MF_GRAYED			equ	00000001h
MF_DISABLED			equ	00000002h
;
MF_UNCHECKED			equ	00000000h
MF_CHECKED			equ	00000008h
MF_USECHECKBITMAPS		equ	00000200h
;
MF_STRING			equ	00000000h
MF_BITMAP			equ	00000004h
MF_OWNERDRAW			equ	00000100h
;
MF_POPUP			equ	00000010h
MF_MENUBARBREAK			equ	00000020h
MF_MENUBREAK			equ	00000040h
;
MF_UNHILITE			equ	00000000h
MF_HILITE			equ	00000080h
;
MF_DEFAULT			equ	00001000h
MF_SYSMENU			equ	00002000h
MF_HELP				equ	00004000h
MF_RIGHTJUSTIFY			equ	00004000h
;
MF_MOUSESELECT			equ	00008000h
MF_END				equ	00000080h	;obsolete
;
MFT_STRING			equ	MF_STRING
MFT_BITMAP			equ	MF_BITMAP
MFT_MENUBARBREAK		equ	MF_MENUBARBREAK
MFT_MENUBREAK			equ	MF_MENUBREAK
MFT_OWNERDRAW			equ	MF_OWNERDRAW
MFT_RADIOCHECK			equ	00000200h
MFT_SEPARATOR			equ	MF_SEPARATOR
MFT_RIGHTORDER			equ	00002000h
MFT_RIGHTJUSTIFY		equ	MF_RIGHTJUSTIFY
;
MFS_GRAYED			equ	00000003h
MFS_DISABLED			equ	MFS_GRAYED
MFS_CHECKED			equ	MF_CHECKED
MFS_HILITE			equ	MF_HILITE
MFS_ENABLED			equ	MF_ENABLED
MFS_UNCHECKED			equ	MF_UNCHECKED
MFS_UNHILITE			equ	MF_UNHILITE
MFS_DEFAULT			equ	MF_DEFAULT
;
;------------------------------------------------------------------------------
;
; ========================
; mouse message key states
; ========================
;
MK_LBUTTON			equ	0001h
MK_RBUTTON			equ	0002h
MK_SHIFT			equ	0004h
MK_CONTROL			equ	0008h
MK_MBUTTON			equ	0010h
;
;------------------------------------------------------------------------------
;
; ==================
; owner draw actions
; ==================
;
ODA_DRAWENTIRE			equ	0001h
ODA_SELECT			equ	0002h
ODA_FOCUS			equ	0004h
;
;------------------------------------------------------------------------------
;
; =================
; owner draw states
; =================
;
ODS_SELECTED			equ	0001h
ODS_GRAYED			equ	0002h
ODS_DISABLED			equ	0004h
ODS_CHECKED			equ	0008h
ODS_FOCUS			equ	0010h
ODS_DEFAULT			equ	0020h
ODS_COMBOBOXEDIT		equ	1000h
;
;------------------------------------------------------------------------------
;
; ================
; owner draw types
; ================
;
ODT_MENU			equ	1
ODT_LISTBOX			equ	2
ODT_COMBOBOX			equ	3
ODT_BUTTON			equ	4
ODT_STATIC			equ	5
;
;------------------------------------------------------------------------------
;
; ==================
; OPENFILENAME flags
; ==================
;
OFN_READONLY			equ	00000001h
OFN_OVERWRITEPROMPT		equ	00000002h
OFN_HIDEREADONLY		equ	00000004h
OFN_NOCHANGEDIR			equ	00000008h
OFN_SHOWHELP			equ	00000010h
OFN_ENABLEHOOK			equ	00000020h
OFN_ENABLETEMPLATE		equ	00000040h
OFN_ENABLETEMPLATEHANDLE	equ	00000080h
OFN_NOVALIDATE			equ	00000100h
OFN_ALLOWMULTISELECT		equ	00000200h
OFN_EXTENSIONDIFFERENT		equ	00000400h
OFN_PATHMUSTEXIST		equ	00000800h
OFN_FILEMUSTEXIST		equ	00001000h
OFN_CREATEPROMPT		equ	00002000h
OFN_SHAREAWARE			equ	00004000h
OFN_NOREADONLYRETURN		equ	00008000h
OFN_NOTESTFILECREATE		equ	00010000h
OFN_NONETWORKBUTTON		equ	00020000h
OFN_NOLONGNAMES			equ	00040000h
OFN_EXPLORER			equ	00080000h
OFN_NODEREFERENCELINKS		equ	00100000h
OFN_LONGNAMES			equ	00200000h
;
;------------------------------------------------------------------------------
;
; ==============================
; OPENFILENAME hook return codes
; ==============================
;
OFN_SHAREWARN			equ	0
OFN_SHARENOWARN			equ	1
OFN_SHAREFALLTHROUGH		equ	2
;
;------------------------------------------------------------------------------
;
; ================
; pipe definitions
; ================
;
PIPE_ACCESS_INBOUND		equ	00000001h
PIPE_ACCESS_OUTBOUND		equ	00000002h
PIPE_ACCESS_DUPLEX		equ	00000003h
;
PIPE_CLIENT_END			equ	00000000h
PIPE_SERVER_END			equ	00000001h
;
PIPE_WAIT			equ	00000000h
PIPE_NOWAIT			equ	00000001h
;
PIPE_READMODE_BYTE		equ	00000000h
PIPE_READMODE_MESSAGE		equ	00000002h
;
PIPE_TYPE_BYTE			equ	00000000h
PIPE_TYPE_MESSAGE		equ	00000004h
;
PIPE_UNLIMITED_INSTANCES	equ	255
;
;------------------------------------------------------------------------------
;
; ====================
; process access flags
; ====================
;
PROCESS_TERMINATE		equ	0001h
PROCESS_CREATE_THREAD		equ	0002h
PROCESS_VM_OPERATION		equ	0008h
PROCESS_VM_READ			equ	0010h
PROCESS_VM_WRITE		equ	0020h
PROCESS_DUP_HANDLE		equ	0040h
PROCESS_CREATE_PROCESS		equ	0080h
PROCESS_SET_QUOTA		equ	0100h
PROCESS_SET_INFORMATION		equ	0200h
PROCESS_QUERY_INFORMATION	equ	0400h
;
PROCESS_ALL_ACCESS		equ	STANDARD_RIGHTS_REQUIRED+\
					SYNCHRONIZE+\
					0FFFh
;
;------------------------------------------------------------------------------
;
; ========================
; binary raster operations
; ========================
;
R2_BLACK			equ	 1		;0
R2_NOTMERGEPEN			equ	 2		;DPon
R2_MASKNOTPEN			equ	 3		;DPna
R2_NOTCOPYPEN			equ	 4		;PN
R2_MASKPENNOT			equ	 5		;PDna
R2_NOT				equ	 6		;Dn
R2_XORPEN			equ	 7		;DPx
R2_NOTMASKPEN			equ	 8		;DPan
R2_MASKPEN			equ	 9		;DPa
R2_NOTXORPEN			equ	10		;DPxn
R2_NOP				equ	11		;D
R2_MERGENOTPEN			equ	12		;DPno
R2_COPYPEN			equ	13		;P
R2_MERGEPENNOT			equ	14		;PDno
R2_MERGEPEN			equ	15		;DPo
R2_WHITE			equ	16		;1
R2_LAST				equ	16
;
;------------------------------------------------------------------------------
;
; =================
; network resources
; =================
;
RESOURCE_CONNECTED		equ	00000001h
RESOURCE_GLOBALNET		equ	00000002h
RESOURCE_REMEMBERED		equ	00000003h
RESOURCE_RECENT			equ	00000004h
RESOURCE_CONTEXT		equ	00000005h
;
RESOURCETYPE_ANY		equ	00000000h
RESOURCETYPE_DISK		equ	00000001h
RESOURCETYPE_PRINT		equ	00000002h
RESOURCETYPE_RESERVED		equ	00000008h
RESOURCETYPE_UNKNOWN		equ	-1
;
RESOURCEUSAGE_CONNECTABLE	equ	00000001h
RESOURCEUSAGE_CONTAINER		equ	00000002h
RESOURCEUSAGE_NOLOCALDEVICE	equ	00000004h
RESOURCEUSAGE_SIBLING		equ	00000008h
RESOURCEUSAGE_RESERVED		equ	80000000h
;
RESOURCEUSAGE_ALL		equ	RESOURCEUSAGE_CONNECTABLE+\
					RESOURCEUSAGE_CONTAINER
;
RESOURCEDISPLAYTYPE_GENERIC	equ	00000000h
RESOURCEDISPLAYTYPE_DOMAIN	equ	00000001h
RESOURCEDISPLAYTYPE_SERVER	equ	00000002h
RESOURCEDISPLAYTYPE_SHARE	equ	00000003h
RESOURCEDISPLAYTYPE_FILE	equ	00000004h
RESOURCEDISPLAYTYPE_GROUP	equ	00000005h
RESOURCEDISPLAYTYPE_NETWORK	equ	00000006h
RESOURCEDISPLAYTYPE_ROOT	equ	00000007h
RESOURCEDISPLAYTYPE_SHAREADMIN	equ	00000008h
RESOURCEDISPLAYTYPE_DIRECTORY	equ	00000009h
RESOURCEDISPLAYTYPE_TREE	equ	0000000Ah
;
;------------------------------------------------------------------------------
;
; ==========
; rgb colors
; ==========
;
RGB_BLACK			equ	00000000h
RGB_VDKGRAY32			equ	00202020h
RGB_DKGRAY			equ	00404040h
RGB_SOLIDGRAY			equ	00808080h
RGB_SOLIDLTGRAY			equ	00C0C0C0h
RGB_EBONY			equ	00E0E0E0h
RGB_BLUE			equ	00FF0000h
RGB_GREEN			equ	0000FF00h
RGB_RED				equ	000000FFh
;
RGB_CYAN			equ	RGB_BLUE + RGB_GREEN
RGB_MAGENTA			equ	RGB_BLUE             + RGB_RED
RGB_YELLOW			equ	           RGB_GREEN + RGB_RED
RGB_WHITE			equ	RGB_BLUE + RGB_GREEN + RGB_RED
;
RGB_DKBLUE			equ	00800000h
RGB_DKGREEN			equ	00008000h
RGB_DKRED			equ	00000080h
;
RGB_DKCYAN			equ	RGB_DKBLUE + RGB_DKGREEN
RGB_DKMAGENTA			equ	RGB_DKBLUE               + RGB_DKRED
RGB_DKYELLOW			equ	             RGB_DKGREEN + RGB_DKRED
;
;------------------------------------------------------------------------------
;
; ===================
; CombineRgn() styles
; ===================
;
RGN_AND				equ	1
RGN_OR				equ	2
RGN_XOR				equ	3
RGN_DIFF			equ	4
RGN_COPY			equ	5
RGN_MIN				equ	RGN_AND
RGN_MAX				equ	RGN_COPY
;
;------------------------------------------------------------------------------
;
; ====================
; scroll bar constants
; ====================
;
SB_HORZ				equ	0
SB_VERT				equ	1
SB_CTL				equ	2
SB_BOTH				equ	3
;
;------------------------------------------------------------------------------
;
; ===================
; scroll bar commands
; ===================
;
SB_LINEUP			equ	0
SB_LINELEFT			equ	0
SB_LINEDOWN			equ	1
SB_LINERIGHT			equ	1
SB_PAGEUP			equ	2
SB_PAGELEFT			equ	2
SB_PAGEDOWN			equ	3
SB_PAGERIGHT			equ	3
SB_THUMBPOSITION		equ	4
SB_THUMBTRACK			equ	5
SB_TOP				equ	6
SB_LEFT				equ	6
SB_BOTTOM			equ	7
SB_RIGHT			equ	7
SB_ENDSCROLL			equ	8
;
;------------------------------------------------------------------------------
;
; ===================
; status bar messages
; ===================
;
SB_SETTEXTA			equ	WM_USER+01
SB_GETTEXTA			equ	WM_USER+02
SB_GETTEXTLENGTHA		equ	WM_USER+03
SB_SETPARTS			equ	WM_USER+04
SB_GETPARTS			equ	WM_USER+06
SB_GETBORDERS			equ	WM_USER+07
SB_SETMINHEIGHT			equ	WM_USER+08
SB_SIMPLE			equ	WM_USER+09
SB_GETRECT			equ	WM_USER+10
SB_SETTEXTW			equ	WM_USER+11
SB_GETTEXTLENGTHW		equ	WM_USER+12
SB_GETTEXTW			equ	WM_USER+13
;
				if	UNICODE
SB_GETTEXT			equ	SB_GETTEXTW
SB_SETTEXT			equ	SB_SETTEXTW
SB_GETTEXTLENGTH		equ	SB_GETTEXTLENGTHW
				else
SB_GETTEXT			equ	SB_GETTEXTA
SB_SETTEXT			equ	SB_SETTEXTA
SB_GETTEXTLENGTH		equ	SB_GETTEXTLENGTHA
				endif
;
;------------------------------------------------------------------------------
;
; ===================
; scroll bar messages
; ===================
;
SBM_SETPOS			equ	00E0h
SBM_GETPOS			equ	00E1h
SBM_SETRANGE			equ	00E2h
SBM_GETRANGE			equ	00E3h
SBM_ENABLE_ARROWS		equ	00E4h
SBM_SETRANGEREDRAW		equ	00E6h
SBM_SETSCROLLINFO		equ	00E9h
SBM_GETSCROLLINFO		equ	00EAh
;
;------------------------------------------------------------------------------
;
; =================
; scroll bar styles
; =================
;
SBS_HORZ			equ	0000h
SBS_VERT			equ	0001h
SBS_TOPALIGN			equ	0002h
SBS_LEFTALIGN			equ	0002h
SBS_BOTTOMALIGN			equ	0004h
SBS_RIGHTALIGN			equ	0004h
SBS_SIZEBOXTOPLEFTALIGN		equ	0002h
SBS_SIZEBOXBOTTOMRIGHTALIGN	equ	0004h
SBS_SIZEBOX			equ	0008h
SBS_SIZEGRIP			equ	0010h
;
;------------------------------------------------------------------------------
;
; ================
; status bar types
; ================
;
SBT_DEFAULT			equ	0000h
SBT_NOBORDERS			equ	0100h
SBT_POPOUT			equ	0200h
SBT_RTLREADING			equ	0400h
SBT_OWNERDRAW			equ	1000h
;
;------------------------------------------------------------------------------
;
; ===================
; security attributes
; ===================
;
SECURITY_ANONYMOUS		equ	00000000h
SECURITY_IDENTIFICATION		equ	00010000h
SECURITY_IMPERSONATION		equ	00020000h
SECURITY_DELEGATION		equ	00030000h
;
SECURITY_CONTEXT_TRACKING	equ	00040000h
SECURITY_EFFECTIVE_ONLY		equ	00080000h
;
SECURITY_SQOS_PRESENT		equ	00100000h
SECURITY_VALID_SQOS_FLAGS	equ	001F0000h
;
;------------------------------------------------------------------------------
;
; =====================
; WM_SIZE wParam values
; =====================
;
SIZE_RESTORED			equ	0
SIZE_MINIMIZED			equ	1
SIZE_MAXIMIZED			equ	2
SIZE_MAXSHOW			equ	3
SIZE_MAXHIDE			equ	4
;
SIZENORMAL			equ	SIZE_RESTORED
SIZEICONIC			equ	SIZE_MINIMIZED
SIZEFULLSCREEN			equ	SIZE_MAXIMIZED
SIZEZOOMSHOW			equ	SIZE_MAXSHOW
SIZEZOOMHIDE			equ	SIZE_MAXHIDE
;
;------------------------------------------------------------------------------
;
; ========================
; GetSystemMetrics() codes
; ========================
;
SM_CXSCREEN			equ	 0
SM_CYSCREEN			equ	 1
SM_CXVSCROLL			equ	 2
SM_CYHSCROLL			equ	 3
SM_CYCAPTION			equ	 4
SM_CXBORDER			equ	 5
SM_CYBORDER			equ	 6
SM_CXDLGFRAME			equ	 7
SM_CYDLGFRAME			equ	 8
SM_CYVTHUMB			equ	 9
SM_CXHTHUMB			equ	10
SM_CXICON			equ	11
SM_CYICON			equ	12
SM_CXCURSOR			equ	13
SM_CYCURSOR			equ	14
SM_CYMENU			equ	15
SM_CXFULLSCREEN			equ	16
SM_CYFULLSCREEN			equ	17
SM_CYKANJIWINDOW		equ	18
SM_MOUSEPRESENT			equ	19
SM_CYVSCROLL			equ	20
SM_CXHSCROLL			equ	21
SM_DEBUG			equ	22
SM_SWAPBUTTON			equ	23
SM_RESERVED1			equ	24
SM_RESERVED2			equ	25
SM_RESERVED3			equ	26
SM_RESERVED4			equ	27
SM_CXMIN			equ	28
SM_CYMIN			equ	29
SM_CXSIZE			equ	30
SM_CYSIZE			equ	31
SM_CXFRAME			equ	32
SM_CYFRAME			equ	33
SM_CXMINTRACK			equ	34
SM_CYMINTRACK			equ	35
SM_CXDOUBLECLK			equ	36
SM_CYDOUBLECLK			equ	37
SM_CXICONSPACING		equ	38
SM_CYICONSPACING		equ	39
SM_MENUDROPALIGNMENT		equ	40
SM_PENWINDOWS			equ	41
SM_DBCSENABLED			equ	42
SM_CMOUSEBUTTONS		equ	43
SM_SECURE			equ	44
SM_CXEDGE			equ	45
SM_CYEDGE			equ	46
SM_CXMINSPACING			equ	47
SM_CYMINSPACING			equ	48
SM_CXSMICON			equ	49
SM_CYSMICON			equ	50
SM_CYSMCAPTION			equ	51
SM_CXSMSIZE			equ	52
SM_CYSMSIZE			equ	53
SM_CXMENUSIZE			equ	54
SM_CYMENUSIZE			equ	55
SM_ARRANGE			equ	56
SM_CXMINIMIZED			equ	57
SM_CYMINIMIZED			equ	58
SM_CXMAXTRACK			equ	59
SM_CYMAXTRACK			equ	60
SM_CXMAXIMIZED			equ	61
SM_CYMAXIMIZED			equ	62
SM_NETWORK			equ	63
SM_CLEANBOOT			equ	67
SM_CXDRAG			equ	68
SM_CYDRAG			equ	69
SM_SHOWSOUNDS			equ	70
SM_CXMENUCHECK			equ	71
SM_CYMENUCHECK			equ	72
SM_SLOWMACHINE			equ	73
SM_MIDEASTENABLED		equ	74
;
SM_CXFIXEDFRAME			equ	SM_CXDLGFRAME
SM_CYFIXEDFRAME			equ	SM_CYDLGFRAME
SM_CXSIZEFRAME			equ	SM_CXFRAME
SM_CYSIZEFRAME			equ	SM_CYFRAME
;
;------------------------------------------------------------------------------
;
; =====================
; static control styles
; =====================
;
SS_LEFT				equ	0000h
SS_CENTER			equ	0001h
SS_RIGHT			equ	0002h
SS_ICON				equ	0003h
SS_BLACKRECT			equ	0004h
SS_GRAYRECT			equ	0005h
SS_WHITERECT			equ	0006h
SS_BLACKFRAME			equ	0007h
SS_GRAYFRAME			equ	0008h
SS_WHITEFRAME			equ	0009h
SS_USERITEM			equ	000Ah
SS_SIMPLE			equ	000Bh
SS_LEFTNOWORDWRAP		equ	000Ch
SS_BITMAP			equ	000Eh
SS_OWNERDRAW			equ	000Dh
SS_ENHMETAFILE			equ	000Fh
SS_ETCHEDHORZ			equ	0010h
SS_ETCHEDVERT			equ	0011h
SS_ETCHEDFRAME			equ	0012h
SS_TYPEMASK			equ	001Fh
SS_NOPREFIX			equ	0080h
SS_NOTIFY			equ	0100h
SS_CENTERIMAGE			equ	0200h
SS_RIGHTJUST			equ	0400h
SS_REALSIZEIMAGE		equ	0800h
SS_SUNKEN			equ	1000h
;
;------------------------------------------------------------------------------
;
; ================
; startup commands
; ================
;
STARTF_USESHOWWINDOW		equ	00000001h
STARTF_USESIZE			equ	00000002h
STARTF_USEPOSITION		equ	00000004h
STARTF_USECOUNTCHARS		equ	00000008h
STARTF_USEFILLATTRIBUTE		equ	00000010h
STARTF_RUNFULLSCREEN		equ	00000020h	;ignored for non-x86
STARTF_FORCEONFEEDBACK		equ	00000040h
STARTF_FORCEOFFFEEDBACK		equ	00000080h
STARTF_USESTDHANDLES		equ	00000100h
STARTF_USEHOTKEY		equ	00000200h
;
;------------------------------------------------------------------------------
;
; ============
; status codes
; ============
;
STATUS_WAIT_0			equ	000000000h
STATUS_ABANDONED_WAIT_0		equ	000000080h
STATUS_USER_APC			equ	0000000C0h
STATUS_TIMEOUT			equ	000000102h
STATUS_PENDING			equ	000000103h
STATUS_SEGMENT_NOTIFICATION	equ	040000005h
STATUS_GUARD_PAGE_VIOLATION	equ	080000001h
STATUS_DATATYPE_MISALIGNMENT	equ	080000002h
STATUS_BREAKPOINT		equ	080000003h
STATUS_SINGLE_STEP		equ	080000004h
STATUS_ACCESS_VIOLATION		equ	0C0000005h
STATUS_IN_PAGE_ERROR		equ	0C0000006h
STATUS_NO_MEMORY		equ	0C0000017h
STATUS_ILLEGAL_INSTRUCTION	equ	0C000001Dh
STATUS_NONCONTINUABLE_EXCEPTION	equ	0C0000025h
STATUS_INVALID_DISPOSITION	equ	0C0000026h
STATUS_ARRAY_BOUNDS_EXCEEDED	equ	0C000008Ch
STATUS_FLOAT_DENORMAL_OPERAND	equ	0C000008Dh
STATUS_FLOAT_DIVIDE_BY_ZERO	equ	0C000008Eh
STATUS_FLOAT_INEXACT_RESULT	equ	0C000008Fh
STATUS_FLOAT_INVALID_OPERATION	equ	0C0000090h
STATUS_FLOAT_OVERFLOW		equ	0C0000091h
STATUS_FLOAT_STACK_CHECK	equ	0C0000092h
STATUS_FLOAT_UNDERFLOW		equ	0C0000093h
STATUS_INTEGER_DIVIDE_BY_ZERO	equ	0C0000094h
STATUS_INTEGER_OVERFLOW		equ	0C0000095h
STATUS_PRIVILEGED_INSTRUCTION	equ	0C0000096h
STATUS_STACK_OVERFLOW		equ	0C00000FDh
STATUS_CONTROL_C_EXIT		equ	0C000013Ah
;
;------------------------------------------------------------------------------
;
; ========================
; toolbar standard bitmaps
; ========================
;
STD_CUT				equ	 0
STD_COPY			equ	 1
STD_PASTE			equ	 2
STD_UNDO			equ	 3
STD_REDOW			equ	 4
STD_DELETE			equ	 5
STD_FILENEW			equ	 6
STD_FILEOPEN			equ	 7
STD_FILESAVE			equ	 8
STD_PRINTPRE			equ	 9
STD_PROPERTIES			equ	10
STD_HELP			equ	11
STD_FIND			equ	12
STD_REPLACE			equ	13
STD_PRINT			equ	14
;
;------------------------------------------------------------------------------
;
; =====================
; standard file handles
; =====================
;
STD_INPUT_HANDLE		equ	-10
STD_OUTPUT_HANDLE		equ	-11
STD_ERROR_HANDLE		equ	-12
;
;------------------------------------------------------------------------------
;
; =====================
; ShowWindow() commands
; =====================
;
SW_HIDE				equ	 0
SW_SHOWNORMAL			equ	 1
SW_NORMAL			equ	 1
SW_SHOWMINIMIZED		equ	 2
SW_SHOWMAXIMIZED		equ	 3
SW_MAXIMIZE			equ	 3
SW_SHOWNOACTIVATE		equ	 4
SW_SHOW				equ	 5
SW_MINIMIZE			equ	 6
SW_SHOWMINNOACTIVE		equ	 7
SW_SHOWNA			equ	 8
SW_RESTORE			equ	 9
SW_SHOWDEFAULT			equ	10
SW_MAX				equ	10
;
;------------------------------------------------------------------------------
;
; ====================
; SetWindowPos() flags
; ====================
;
SWP_NOSIZE			equ	0001h
SWP_NOMOVE			equ	0002h
SWP_NOZORDER			equ	0004h
SWP_NOREDRAW			equ	0008h
SWP_NOACTIVATE			equ	0010h
SWP_FRAMECHANGED		equ	0020h
SWP_SHOWWINDOW			equ	0040h
SWP_HIDEWINDOW			equ	0080h
SWP_NOCOPYBITS			equ	0100h
SWP_NOOWNERZORDER		equ	0200h
SWP_NOSENDCHANGING		equ	0400h
SWP_DEFERERASE			equ	2000h
SWP_ASYNCWINDOWPOS		equ	4000h
;
SWP_DRAWFRAME			equ	SWP_FRAMECHANGED
SWP_NOREPOSITION		equ	SWP_NOOWNERZORDER
;
;------------------------------------------------------------------------------
;
; ======================
; text alignment options
; ======================
;
TA_NOUPDATECP			equ	0000h
TA_UPDATECP			equ	0001h
;
TA_LEFT				equ	0000h
TA_RIGHT			equ	0002h
TA_CENTER			equ	0006h
;
TA_TOP				equ	0000h
TA_BOTTOM			equ	0008h
TA_BASELINE			equ	0018h
TA_RTLREADING			equ	0100h
TA_MASK				equ	TA_BASELINE+TA_CENTER+TA_UPDATECP+\
					TA_RTLREADING
;
;------------------------------------------------------------------------------
;
; ================
; toolbar messages
; ================
;
TB_ENABLEBUTTON			equ	WM_USER+01
TB_CHECKBUTTON			equ	WM_USER+02
TB_PRESSBUTTON			equ	WM_USER+03
TB_HIDEBUTTON			equ	WM_USER+04
TB_INDETERMINATE		equ	WM_USER+05
TB_ISBUTTONENABLED		equ	WM_USER+09
TB_ISBUTTONCHECKED		equ	WM_USER+10
TB_ISBUTTONPRESSED		equ	WM_USER+11
TB_ISBUTTONHIDDEN		equ	WM_USER+12
TB_ISBUTTONINDETERMINATE	equ	WM_USER+13
TB_SETSTATE			equ	WM_USER+17
TB_GETSTATE			equ	WM_USER+18
TB_ADDBITMAP			equ	WM_USER+19
TB_ADDBUTTONS			equ	WM_USER+20
TB_INSERTBUTTON			equ	WM_USER+21
TB_DELETEBUTTON			equ	WM_USER+22
TB_GETBUTTON			equ	WM_USER+23
TB_BUTTONCOUNT			equ	WM_USER+24
TB_COMMANDTOINDEX		equ	WM_USER+25
TB_SAVERESTOREA			equ	WM_USER+26
TB_CUSTOMIZE			equ	WM_USER+27
TB_ADDSTRINGA			equ	WM_USER+28
TB_GETITEMRECT			equ	WM_USER+29
TB_BUTTONSTRUCTSIZE		equ	WM_USER+30
TB_SETBUTTONSIZE		equ	WM_USER+31
TB_SETBITMAPSIZE		equ	WM_USER+32
TB_AUTOSIZE			equ	WM_USER+33
TB_GETTOOLTIPS			equ	WM_USER+35
TB_SETTOOLTIPS			equ	WM_USER+36
TB_SETPARENT			equ	WM_USER+37
TB_SETROWS			equ	WM_USER+39
TB_GETROWS			equ	WM_USER+40
TB_GETBITMAPFLAGS		equ	WM_USER+41
TB_SETCMDID			equ	WM_USER+42
TB_CHANGEBITMAP			equ	WM_USER+43
TB_GETBITMAP			equ	WM_USER+44
TB_GETBUTTONTEXTA		equ	WM_USER+45
TB_REPLACEBITMAP		equ	WM_USER+46
;
TB_GETBUTTONTEXTW		equ	WM_USER+75
TB_SAVERESTOREW			equ	WM_USER+76
TB_ADDSTRINGW			equ	WM_USER+77
;
				if	UNICODE
TB_GETBUTTONTEXT		equ	TB_GETBUTTONTEXTW
TB_SAVERESTORE			equ	TB_SAVERESTOREW
TB_ADDSTRING			equ	TB_ADDSTRINGW
				else
TB_GETBUTTONTEXT		equ	TB_GETBUTTONTEXTA
TB_SAVERESTORE			equ	TB_SAVERESTOREA
TB_ADDSTRING			equ	TB_ADDSTRINGA
				endif
;
;------------------------------------------------------------------------------
;
; =====================
; toolbar notifications
; =====================
;
TBN_FIRST			equ	-700
TBN_LAST			equ	TBN_FIRST-20
;
TBN_GETBUTTONINFOA		equ	TBN_FIRST-00
TBN_BEGINDRAG			equ	TBN_FIRST-01
TBN_ENDDRAG			equ	TBN_FIRST-02
TBN_BEGINADJUST			equ	TBN_FIRST-03
TBN_ENDADJUST			equ	TBN_FIRST-04
TBN_RESET			equ	TBN_FIRST-05
TBN_QUERYINSERT			equ	TBN_FIRST-06
TBN_QUERYDELETE			equ	TBN_FIRST-07
TBN_TOOLBARCHANGE		equ	TBN_FIRST-08
TBN_CUSTHELP			equ	TBN_FIRST-09
TBN_GETBUTTONINFOW		equ	TBN_FIRST-20
;
;------------------------------------------------------------------------------
;
; ==============
; toolbar states
; ==============
;
TBSTATE_CHECKED			equ	0001h
TBSTATE_PRESSED			equ	0002h
TBSTATE_ENABLED			equ	0004h
TBSTATE_HIDDEN			equ	0008h
TBSTATE_INDETERMINATE		equ	0010h
TBSTATE_WRAP			equ	0020h
;
;------------------------------------------------------------------------------
;
; ==============
; toolbar styles
; ==============
;
TBSTYLE_BUTTON			equ	0000h
TBSTYLE_SEP			equ	0001h
TBSTYLE_CHECK			equ	0002h
TBSTYLE_GROUP			equ	0004h
TBSTYLE_TOOLTIPS		equ	0100h
TBSTYLE_WRAPABLE		equ	0200h
TBSTYLE_ALTDRAG			equ	0400h
;
TBSTYLE_CHECKGROUP		equ	TBSTYLE_GROUP+TBSTYLE_CHECK
;
;------------------------------------------------------------------------------
;
; ===================
; thread access flags
; ===================
;
THREAD_TERMINATE		equ	0001h
THREAD_SUSPEND_RESUME		equ	0002h
THREAD_GET_CONTEXT		equ	0008h
THREAD_SET_CONTEXT		equ	0010h
THREAD_SET_INFORMATION		equ	0020h
THREAD_QUERY_INFORMATION	equ	0040h
THREAD_SET_THREAD_TOKEN		equ	0080h
THREAD_IMPERSONATE		equ	0100h
THREAD_DIRECT_IMPERSONATION	equ	0200h
;
THREAD_ALL_ACCESS		equ	STANDARD_RIGHTS_REQUIRED+\
					SYNCHRONIZE+\
					03FFh
;
;------------------------------------------------------------------------------
;
; =================
; thread priorities
; =================
;
THREAD_BASE_PRIORITY_IDLE	equ	-15
THREAD_BASE_PRIORITY_MIN	equ	 -2
THREAD_BASE_PRIORITY_MAX	equ	  2
THREAD_BASE_PRIORITY_LOWRT	equ	 15
;
THREAD_PRIORITY_LOWEST		equ	THREAD_BASE_PRIORITY_MIN
THREAD_PRIORITY_BELOW_NORMAL	equ	THREAD_PRIORITY_LOWEST+1
THREAD_PRIORITY_NORMAL		equ	  0
THREAD_PRIORITY_ABOVE_NORMAL	equ	THREAD_PRIORITY_HIGHEST-1
THREAD_PRIORITY_HIGHEST		equ	THREAD_BASE_PRIORITY_MAX
;
THREAD_PRIORITY_TIME_CRITICAL	equ	THREAD_BASE_PRIORITY_LOWRT
THREAD_PRIORITY_IDLE		equ	THREAD_BASE_PRIORITY_IDLE
;
THREAD_PRIORITY_ERROR_RETURN	equ	 -1
;
;------------------------------------------------------------------------------
;
; ==================
; tree view messages
; ==================
;
TVM_FIRST			equ	1100h
TV_FIRST			equ	TVM_FIRST
;
TVM_INSERTITEMA			equ	TVM_FIRST+00
TVM_DELETEITEM			equ	TVM_FIRST+01
TVM_EXPAND			equ	TVM_FIRST+02
TVM_GETITEMRECT			equ	TVM_FIRST+04
TVM_GETCOUNT			equ	TVM_FIRST+05
TVM_GETINDENT			equ	TVM_FIRST+06
TVM_SETINDENT			equ	TVM_FIRST+07
TVM_GETIMAGELIST		equ	TVM_FIRST+08
TVM_SETIMAGELIST		equ	TVM_FIRST+09
TVM_GETNEXTITEM			equ	TVM_FIRST+10
TVM_SELECTITEM			equ	TVM_FIRST+11
TVM_GETITEMA			equ	TVM_FIRST+12
TVM_SETITEMA			equ	TVM_FIRST+13
TVM_EDITLABELA			equ	TVM_FIRST+14
TVM_GETEDITCONTROL		equ	TVM_FIRST+15
TVM_GETVISIBLECOUNT		equ	TVM_FIRST+16
TVM_HITTEST			equ	TVM_FIRST+17
TVM_CREATEDRAGIMAGE		equ	TVM_FIRST+18
TVM_SORTCHILDREN		equ	TVM_FIRST+19
TVM_ENSUREVISIBLE		equ	TVM_FIRST+20
TVM_SORTCHILDRENCB		equ	TVM_FIRST+21
TVM_ENDEDITLABELNOW		equ	TVM_FIRST+22
TVM_GETISEARCHSTRINGA		equ	TVM_FIRST+23
;
TVM_INSERTITEMW			equ	TVM_FIRST+50
TVM_GETITEMW			equ	TVM_FIRST+62
TVM_SETITEMW			equ	TVM_FIRST+63
TVM_GETISEARCHSTRINGW		equ	TVM_FIRST+64
TVM_EDITLABELW			equ	TVM_FIRST+65
;
				if	UNICODE
TVM_INSERTITEM			equ	TVM_INSERTITEMW
TVM_GETITEM			equ	TVM_GETITEMW
TVM_SETITEM			equ	TVM_SETITEMW
TVM_GETISEARCHSTRING		equ	TVM_GETISEARCHSTRINGW
TVM_EDITLABEL			equ	TVM_EDITLABELW
				else
TVM_INSERTITEM			equ	TVM_INSERTITEMA
TVM_GETITEM			equ	TVM_GETITEMA
TVM_SETITEM			equ	TVM_SETITEMA
TVM_GETISEARCHSTRING		equ	TVM_GETISEARCHSTRINGA
TVM_EDITLABEL			equ	TVM_EDITLABELA
				endif
;
;------------------------------------------------------------------------------
;
; =======================
; tree view notifications
; =======================
;
TVN_FIRST			equ	-400
TVN_LAST			equ	TVN_FIRST-99
;
TVN_SELCHANGINGA		equ	TVN_FIRST-01
TVN_SELCHANGEDA			equ	TVN_FIRST-02
TVN_GETDISPINFOA		equ	TVN_FIRST-03
TVN_SETDISPINFOA		equ	TVN_FIRST-04
TVN_ITEMEXPANDINGA		equ	TVN_FIRST-05
TVN_ITEMEXPANDEDA		equ	TVN_FIRST-06
TVN_BEGINDRAGA			equ	TVN_FIRST-07
TVN_BEGINRDRAGA			equ	TVN_FIRST-08
TVN_DELETEITEMA			equ	TVN_FIRST-09
TVN_ENDLABELEDITA		equ	TVN_FIRST-11
TVN_KEYDOWN			equ	TVN_FIRST-12
;
TVN_SELCHANGINGW		equ	TVN_FIRST-50
TVN_SELCHANGEDW			equ	TVN_FIRST-51
TVN_GETDISPINFOW		equ	TVN_FIRST-52
TVN_SETDISPINFOW		equ	TVN_FIRST-53
TVN_ITEMEXPANDINGW		equ	TVN_FIRST-54
TVN_ITEMEXPANDEDW		equ	TVN_FIRST-55
TVN_BEGINDRAGW			equ	TVN_FIRST-56
TVN_BEGINRDRAGW			equ	TVN_FIRST-57
TVN_DELETEITEMW			equ	TVN_FIRST-58
TVN_BEGINLABELEDITA		equ	TVN_FIRST-10
TVN_BEGINLABELEDITW		equ	TVN_FIRST-59
TVN_ENDLABELEDITW		equ	TVN_FIRST-60
;
				if	UNICODE
TVN_SELCHANGING			equ	TVN_SELCHANGINGW
TVN_SELCHANGED			equ	TVN_SELCHANGEDW
TVN_GETDISPINFO			equ	TVN_GETDISPINFOW
TVN_SETDISPINFO			equ	TVN_SETDISPINFOW
TVN_ITEMEXPANDING		equ	TVN_ITEMEXPANDINGW
TVN_ITEMEXPANDED		equ	TVN_ITEMEXPANDEDW
TVN_BEGINDRAG			equ	TVN_BEGINDRAGW
TVN_BEGINRDRAG			equ	TVN_BEGINRDRAGW
TVN_DELETEITEM			equ	TVN_DELETEITEMW
TVN_BEGINLABELEDIT		equ	TVN_BEGINLABELEDITW
TVN_ENDLABELEDIT		equ	TVN_ENDLABELEDITW
				else
TVN_SELCHANGING			equ	TVN_SELCHANGINGA
TVN_SELCHANGED			equ	TVN_SELCHANGEDA
TVN_GETDISPINFO			equ	TVN_GETDISPINFOA
TVN_SETDISPINFO			equ	TVN_SETDISPINFOA
TVN_ITEMEXPANDING		equ	TVN_ITEMEXPANDINGA
TVN_ITEMEXPANDED		equ	TVN_ITEMEXPANDEDA
TVN_BEGINDRAG			equ	TVN_BEGINDRAGA
TVN_BEGINRDRAG			equ	TVN_BEGINRDRAGA
TVN_DELETEITEM			equ	TVN_DELETEITEMA
TVN_BEGINLABELEDIT		equ	TVN_BEGINLABELEDITA
TVN_ENDLABELEDIT		equ	TVN_ENDLABELEDITA
				endif
;
;------------------------------------------------------------------------------
;
; ================
; tree view styles
; ================
;
TVS_HASBUTTONS			equ	00000001h
TVS_HASLINES			equ	00000002h
TVS_LINESATROOT			equ	00000004h
TVS_EDITLABELS			equ	00000008h
TVS_DISABLEDRAGDROP		equ	00000010h
TVS_SHOWSELALWAYS		equ	00000020h
;
;------------------------------------------------------------------------------
;
; ================
; os platform id's
; ================
;
VER_PLATFORM_WIN32s		equ	0
VER_PLATFORM_WIN32_WINDOWS	equ	1
VER_PLATFORM_WIN32_NT		equ	2
;
;------------------------------------------------------------------------------
;
; ====================
; toolbar view bitmaps
; ====================
;
VIEW_LARGEICONS			equ	 0
VIEW_SMALLICONS			equ	 1
VIEW_LIST			equ	 2
VIEW_DETAILS			equ	 3
VIEW_SORTNAME			equ	 4
VIEW_SORTSIZE			equ	 5
VIEW_SORTDATE			equ	 6
VIEW_SORTTYPE			equ	 7
VIEW_PARENTFOLDER		equ	 8
VIEW_NETCONNECT			equ	 9
VIEW_NETDISCONNECT		equ	10
VIEW_NEWFOLDER			equ	11
;
;------------------------------------------------------------------------------
;
; =====================
; standard virtual keys
; =====================
;
VK_LBUTTON			equ	01h
VK_RBUTTON			equ	02h
VK_CANCEL			equ	03h
VK_MBUTTON			equ	04h
;
VK_BACK				equ	08h
VK_TAB				equ	09h
VK_CLEAR			equ	0Ch
VK_RETURN			equ	0Dh
VK_SHIFT			equ	10h
VK_CONTROL			equ	11h
VK_MENU				equ	12h
VK_PAUSE			equ	13h
VK_CAPITAL			equ	14h
VK_ESCAPE			equ	1Bh
;
VK_SPACE			equ	20h
VK_PRIOR			equ	21h
VK_NEXT				equ	22h
VK_END				equ	23h
VK_HOME				equ	24h
VK_LEFT				equ	25h
VK_UP				equ	26h
VK_RIGHT			equ	27h
VK_DOWN				equ	28h
VK_SELECT			equ	29h
VK_PRINT			equ	2Ah
VK_EXECUTE			equ	2Bh
VK_SNAPSHOT			equ	2Ch
VK_INSERT			equ	2Dh
VK_DELETE			equ	2Eh
VK_HELP				equ	2Fh
;
VK_LWIN				equ	5Bh
VK_RWIN				equ	5Ch
VK_APPS				equ	5Dh
;
VK_NUMPAD0			equ	60h
VK_NUMPAD1			equ	61h
VK_NUMPAD2			equ	62h
VK_NUMPAD3			equ	63h
VK_NUMPAD4			equ	64h
VK_NUMPAD5			equ	65h
VK_NUMPAD6			equ	66h
VK_NUMPAD7			equ	67h
VK_NUMPAD8			equ	68h
VK_NUMPAD9			equ	69h
VK_MULTIPLY			equ	6Ah
VK_ADD				equ	6Bh
VK_SEPARATOR			equ	6Ch
VK_SUBTRACT			equ	6Dh
VK_DECIMAL			equ	6Eh
VK_DIVIDE			equ	6Fh
VK_F1				equ	70h
VK_F2				equ	71h
VK_F3				equ	72h
VK_F4				equ	73h
VK_F5				equ	74h
VK_F6				equ	75h
VK_F7				equ	76h
VK_F8				equ	77h
VK_F9				equ	78h
VK_F10				equ	79h
VK_F11				equ	7Ah
VK_F12				equ	7Bh
VK_F13				equ	7Ch
VK_F14				equ	7Dh
VK_F15				equ	7Eh
VK_F16				equ	7Fh
VK_F17				equ	80h
VK_F18				equ	81h
VK_F19				equ	82h
VK_F20				equ	83h
VK_F21				equ	84h
VK_F22				equ	85h
VK_F23				equ	86h
VK_F24				equ	87h
;
VK_NUMLOCK			equ	90h
VK_SCROLL			equ	91h
;
;------------------------------------------------------------------------------
;
; ====================
; special virtual keys
; ====================
;
VK_LSHIFT			equ	0A0h
VK_RSHIFT			equ	0A1h
VK_LCONTROL			equ	0A2h
VK_RCONTROL			equ	0A3h
VK_LMENU			equ	0A4h
VK_RMENU			equ	0A5h
;
VK_PROCESSKEY			equ	0E5h
;
VK_ATTN				equ	0F6h
VK_CRSEL			equ	0F7h
VK_EXSEL			equ	0F8h
VK_EREOF			equ	0F9h
VK_PLAY				equ	0FAh
VK_ZOOM				equ	0FBh
VK_NONAME			equ	0FCh
VK_PA1				equ	0FDh
VK_OEM_CLEAR			equ	0FEh
;
;------------------------------------------------------------------------------
;
; =================
; wait status codes
; =================
;
WAIT_FAILED			equ	-1
WAIT_OBJECT_0			equ	STATUS_WAIT_0
;
WAIT_ABANDONED			equ	STATUS_ABANDONED_WAIT_0
WAIT_ABANDONED_0		equ	STATUS_ABANDONED_WAIT_0
;
WAIT_TIMEOUT			equ	STATUS_TIMEOUT
WAIT_IO_COMPLETION		equ	STATUS_USER_APC
STILL_ACTIVE			equ	STATUS_PENDING
;
MAXIMUM_WAIT_OBJECTS		equ	 64
MAXIMUM_SUSPEND_COUNT		equ	127
INFINITE			equ	 -1
;
;------------------------------------------------------------------------------
;
; ===============
; window messages
; ===============
;
WM_NULL				equ	0000h
WM_CREATE			equ	0001h
WM_DESTROY			equ	0002h
WM_MOVE				equ	0003h
WM_SIZE				equ	0005h
WM_ACTIVATE			equ	0006h
WM_SETFOCUS			equ	0007h
WM_KILLFOCUS			equ	0008h
WM_ENABLE			equ	000Ah
WM_SETREDRAW			equ	000Bh
WM_SETTEXT			equ	000Ch
WM_GETTEXT			equ	000Dh
WM_GETTEXTLENGTH		equ	000Eh
WM_PAINT			equ	000Fh
WM_CLOSE			equ	0010h
WM_QUERYENDSESSION		equ	0011h
WM_QUIT				equ	0012h
WM_QUERYOPEN			equ	0013h
WM_ERASEBKGND			equ	0014h
WM_SYSCOLORCHANGE		equ	0015h
WM_ENDSESSION			equ	0016h
WM_SHOWWINDOW			equ	0018h
WM_WININICHANGE			equ	001Ah
WM_SETTINGCHANGE		equ	WM_WININICHANGE
WM_DEVMODECHANGE		equ	001Bh
WM_ACTIVATEAPP			equ	001Ch
WM_FONTCHANGE			equ	001Dh
WM_TIMECHANGE			equ	001Eh
WM_CANCELMODE			equ	001Fh
WM_SETCURSOR			equ	0020h
WM_MOUSEACTIVATE		equ	0021h
WM_CHILDACTIVATE		equ	0022h
WM_QUEUESYNC			equ	0023h
WM_GETMINMAXINFO		equ	0024h
WM_PAINTICON			equ	0026h
WM_ICONERASEBKGND		equ	0027h
WM_NEXTDLGCTL			equ	0028h
WM_SPOOLERSTATUS		equ	002Ah
WM_DRAWITEM			equ	002Bh
WM_MEASUREITEM			equ	002Ch
WM_DELETEITEM			equ	002Dh
WM_VKEYTOITEM			equ	002Eh
WM_CHARTOITEM			equ	002Fh
WM_SETFONT			equ	0030h
WM_GETFONT			equ	0031h
WM_SETHOTKEY			equ	0032h
WM_GETHOTKEY			equ	0033h
WM_QUERYDRAGICON		equ	0037h
WM_COMPAREITEM			equ	0039h
WM_COMPACTING			equ	0041h
WM_COMMNOTIFY			equ	0044h		;no longer suported
WM_WINDOWPOSCHANGING		equ	0046h
WM_WINDOWPOSCHANGED		equ	0047h
WM_POWER			equ	0048h
WM_COPYDATA			equ	004Ah
WM_CANCELJOURNAL		equ	004Bh
WM_NOTIFY			equ	004Eh
WM_INPUTLANGCHANGEREQUEST	equ	0050h
WM_INPUTLANGCHANGE		equ	0051h
WM_TCARD			equ	0052h
WM_HELP				equ	0053h
WM_USERCHANGED			equ	0054h
WM_NOTIFYFORMAT			equ	0055h
WM_CONTEXTMENU			equ	007Bh
WM_STYLECHANGING		equ	007Ch
WM_STYLECHANGED			equ	007Dh
WM_DISPLAYCHANGE		equ	007Eh
WM_GETICON			equ	007Fh
WM_SETICON			equ	0080h
WM_NCCREATE			equ	0081h
WM_NCDESTROY			equ	0082h
WM_NCCALCSIZE			equ	0083h
WM_NCHITTEST			equ	0084h
WM_NCPAINT			equ	0085h
WM_NCACTIVATE			equ	0086h
WM_GETDLGCODE			equ	0087h
;
WM_NCMOUSEMOVE			equ	00A0h
WM_NCLBUTTONDOWN		equ	00A1h
WM_NCLBUTTONUP			equ	00A2h
WM_NCLBUTTONDBLCLK		equ	00A3h
WM_NCRBUTTONDOWN		equ	00A4h
WM_NCRBUTTONUP			equ	00A5h
WM_NCRBUTTONDBLCLK		equ	00A6h
WM_NCMBUTTONDOWN		equ	00A7h
WM_NCMBUTTONUP			equ	00A8h
WM_NCMBUTTONDBLCLK		equ	00A9h
;
WM_KEYFIRST			equ	0100h
WM_KEYDOWN			equ	0100h
WM_KEYUP			equ	0101h
WM_CHAR				equ	0102h
WM_DEADCHAR			equ	0103h
WM_SYSKEYDOWN			equ	0104h
WM_SYSKEYUP			equ	0105h
WM_SYSCHAR			equ	0106h
WM_SYSDEADCHAR			equ	0107h
WM_KEYLAST			equ	0108h
;
WM_IME_STARTCOMPOSITION		equ	010Dh
WM_IME_ENDCOMPOSITION		equ	010Eh
WM_IME_COMPOSITION		equ	010Fh
WM_IME_KEYLAST			equ	010Fh
WM_INITDIALOG			equ	0110h
WM_COMMAND			equ	0111h
WM_SYSCOMMAND			equ	0112h
WM_TIMER			equ	0113h
WM_HSCROLL			equ	0114h
WM_VSCROLL			equ	0115h
WM_INITMENU			equ	0116h
WM_INITMENUPOPUP		equ	0117h
WM_MENUSELECT			equ	011Fh
WM_MENUCHAR			equ	0120h
WM_ENTERIDLE			equ	0121h
WM_CTLCOLORMSGBOX		equ	0132h
WM_CTLCOLOREDIT			equ	0133h
WM_CTLCOLORLISTBOX		equ	0134h
WM_CTLCOLORBTN			equ	0135h
WM_CTLCOLORDLG			equ	0136h
WM_CTLCOLORSCROLLBAR		equ	0137h
WM_CTLCOLORSTATIC		equ	0138h
;
WM_MOUSEFIRST			equ	0200h
WM_MOUSEMOVE			equ	0200h
WM_LBUTTONDOWN			equ	0201h
WM_LBUTTONUP			equ	0202h
WM_LBUTTONDBLCLK		equ	0203h
WM_RBUTTONDOWN			equ	0204h
WM_RBUTTONUP			equ	0205h
WM_RBUTTONDBLCLK		equ	0206h
WM_MBUTTONDOWN			equ	0207h
WM_MBUTTONUP			equ	0208h
WM_MBUTTONDBLCLK		equ	0209h
WM_MOUSELAST			equ	0209h
;
WM_PARENTNOTIFY			equ	0210h
WM_ENTERMENULOOP		equ	0211h
WM_EXITMENULOOP			equ	0212h
WM_NEXTMENU			equ	0213h
WM_SIZING			equ	0214h
WM_CAPTURECHANGED		equ	0215h
WM_MOVING			equ	0216h
WM_POWERBROADCAST		equ	0218h
WM_DEVICECHANGE			equ	0219h
WM_MDICREATE			equ	0220h
WM_MDIDESTROY			equ	0221h
WM_MDIACTIVATE			equ	0222h
WM_MDIRESTORE			equ	0223h
WM_MDINEXT			equ	0224h
WM_MDIMAXIMIZE			equ	0225h
WM_MDITILE			equ	0226h
WM_MDICASCADE			equ	0227h
WM_MDIICONARRANGE		equ	0228h
WM_MDIGETACTIVE			equ	0229h
WM_MDISETMENU			equ	0230h
WM_ENTERSIZEMOVE		equ	0231h
WM_EXITSIZEMOVE			equ	0232h
WM_DROPFILES			equ	0233h
WM_MDIREFRESHMENU		equ	0234h
;
WM_IME_SETCONTEXT		equ	0281h
WM_IME_NOTIFY			equ	0282h
WM_IME_CONTROL			equ	0283h
WM_IME_COMPOSITIONFULL		equ	0284h
WM_IME_SELECT			equ	0285h
WM_IME_CHAR			equ	0286h
WM_IME_KEYDOWN			equ	0290h
WM_IME_KEYUP			equ	0291h
;
WM_CUT				equ	0300h
WM_COPY				equ	0301h
WM_PASTE			equ	0302h
WM_CLEAR			equ	0303h
WM_UNDO				equ	0304h
WM_RENDERFORMAT			equ	0305h
WM_RENDERALLFORMATS		equ	0306h
WM_DESTROYCLIPBOARD		equ	0307h
WM_DRAWCLIPBOARD		equ	0308h
WM_PAINTCLIPBOARD		equ	0309h
WM_VSCROLLCLIPBOARD		equ	030Ah
WM_SIZECLIPBOARD		equ	030Bh
WM_ASKCBFORMATNAME		equ	030Ch
WM_CHANGECBCHAIN		equ	030Dh
WM_HSCROLLCLIPBOARD		equ	030Eh
WM_QUERYNEWPALETTE		equ	030Fh
WM_PALETTEISCHANGING		equ	0310h
WM_PALETTECHANGED		equ	0311h
WM_HOTKEY			equ	0312h
WM_PRINT			equ	0317h
WM_PRINTCLIENT			equ	0318h
;
WM_HANDHELDFIRST		equ	0358h
WM_HANDHELDLAST			equ	035Fh
;
WM_AFXFIRST			equ	0360h
WM_AFXLAST			equ	037Fh
;
WM_PENWINFIRST			equ	0380h
WM_PENWINLAST			equ	038Fh
;
WM_DDE_FIRST			equ	03E0h
WM_DDE_INITIATE			equ	WM_DDE_FIRST
WM_DDE_TERMINATE		equ	WM_DDE_FIRST+1
WM_DDE_ADVISE			equ	WM_DDE_FIRST+2
WM_DDE_UNADVISE			equ	WM_DDE_FIRST+3
WM_DDE_ACK			equ	WM_DDE_FIRST+4
WM_DDE_DATA			equ	WM_DDE_FIRST+5
WM_DDE_REQUEST			equ	WM_DDE_FIRST+6
WM_DDE_POKE			equ	WM_DDE_FIRST+7
WM_DDE_EXECUTE			equ	WM_DDE_FIRST+8
WM_DDE_LAST			equ	03E8h
;
WM_USER				equ	0400h
WM_APP				equ	8000h
;
;------------------------------------------------------------------------------
;
; ====================
; WNet*() status codes
; ====================
;
WN_SUCCESS			equ	NO_ERROR
WN_NO_ERROR			equ	NO_ERROR
;
WN_NOT_SUPPORTED		equ	ERROR_NOT_SUPPORTED
WN_CANCEL			equ	ERROR_CANCELLED
WN_RETRY			equ	ERROR_RETRY
WN_NET_ERROR			equ	ERROR_UNEXP_NET_ERR
WN_MORE_DATA			equ	ERROR_MORE_DATA
WN_BAD_POINTER			equ	ERROR_INVALID_ADDRESS
WN_BAD_VALUE			equ	ERROR_INVALID_PARAMETER
WN_BAD_USER			equ	ERROR_BAD_USERNAME
WN_BAD_PASSWORD			equ	ERROR_INVALID_PASSWORD
WN_ACCESS_DENIED		equ	ERROR_ACCESS_DENIED
WN_FUNCTION_BUSY		equ	ERROR_BUSY
WN_WINDOWS_ERROR		equ	ERROR_UNEXP_NET_ERR
WN_OUT_OF_MEMORY		equ	ERROR_NOT_ENOUGH_MEMORY
WN_NO_NETWORK			equ	ERROR_NO_NETWORK
WN_EXTENDED_ERROR		equ	ERROR_EXTENDED_ERROR
WN_BAD_LEVEL			equ	ERROR_INVALID_LEVEL
WN_BAD_HANDLE			equ	ERROR_INVALID_HANDLE
WN_NOT_INITIALIZING		equ	ERROR_ALREADY_INITIALIZED
WN_NO_MORE_DEVICES		equ	ERROR_NO_MORE_DEVICES
;
WN_NOT_CONNECTED		equ	ERROR_NOT_CONNECTED
WN_OPEN_FILES			equ	ERROR_OPEN_FILES
WN_DEVICE_IN_USE		equ	ERROR_DEVICE_IN_USE
WN_BAD_NETNAME			equ	ERROR_BAD_NET_NAME
WN_BAD_LOCALNAME		equ	ERROR_BAD_DEVICE
WN_ALREADY_CONNECTED		equ	ERROR_ALREADY_ASSIGNED
WN_DEVICE_ERROR			equ	ERROR_GEN_FAILURE
WN_CONNECTION_CLOSED		equ	ERROR_CONNECTION_UNAVAIL
WN_NO_NET_OR_BAD_PATH		equ	ERROR_NO_NET_OR_BAD_PATH
WN_BAD_PROVIDER			equ	ERROR_BAD_PROVIDER
WN_CANNOT_OPEN_PROFILE		equ	ERROR_CANNOT_OPEN_PROFILE
WN_BAD_PROFILE			equ	ERROR_BAD_PROFILE
WN_BAD_DEV_TYPE			equ	ERROR_BAD_DEV_TYPE
WN_DEVICE_ALREADY_REMEMBERED	equ	ERROR_DEVICE_ALREADY_REMEMBERED
;
WN_NO_MORE_ENTRIES		equ	ERROR_NO_MORE_ITEMS
WN_NOT_CONTAINER		equ	ERROR_NOT_CONTAINER
;
WN_NOT_AUTHENTICATED		equ	ERROR_NOT_AUTHENTICATED
WN_NOT_LOGGED_ON		equ	ERROR_NOT_LOGGED_ON
WN_NOT_VALIDATED		equ	ERROR_NO_LOGON_SERVERS
;
;------------------------------------------------------------------------------
;
; =============
; network types
; =============
;
WNNC_NET_MSNET			equ	00010000h
WNNC_NET_LANMAN			equ	00020000h
WNNC_NET_NETWARE		equ	00030000h
WNNC_NET_VINES			equ	00040000h
WNNC_NET_10NET			equ	00050000h
WNNC_NET_LOCUS			equ	00060000h
WNNC_NET_SUN_PC_NFS		equ	00070000h
WNNC_NET_LANSTEP		equ	00080000h
WNNC_NET_9TILES			equ	00090000h
WNNC_NET_LANTASTIC		equ	000A0000h
WNNC_NET_AS400			equ	000B0000h
WNNC_NET_FTP_NFS		equ	000C0000h
WNNC_NET_PATHWORKS		equ	000D0000h
WNNC_NET_LIFENET		equ	000E0000h
WNNC_NET_POWERLAN		equ	000F0000h
WNNC_NET_BWNFS			equ	00100000h
WNNC_NET_COGENT			equ	00110000h
WNNC_NET_FARALLON		equ	00120000h
WNNC_NET_APPLETALK		equ	00130000h
;
;------------------------------------------------------------------------------
;
; =============
; window styles
; =============
;
WS_OVERLAPPED			equ	00000000h
WS_TABSTOP			equ	00010000h
WS_GROUP			equ	00020000h
WS_MAXIMIZEBOX			equ	00010000h
WS_MINIMIZEBOX			equ	00020000h
WS_THICKFRAME			equ	00040000h
WS_SYSMENU			equ	00080000h
WS_HSCROLL			equ	00100000h
WS_VSCROLL			equ	00200000h
WS_DLGFRAME			equ	00400000h
WS_BORDER			equ	00800000h
WS_MAXIMIZE			equ	01000000h
WS_CLIPCHILDREN			equ	02000000h
WS_CLIPSIBLINGS			equ	04000000h
WS_DISABLED			equ	08000000h
WS_VISIBLE			equ	10000000h
WS_MINIMIZE			equ	20000000h
WS_CHILD			equ	40000000h
WS_POPUP			equ	80000000h
;
WS_CAPTION			equ	WS_BORDER+WS_DLGFRAME
WS_POPUPWINDOW			equ	WS_POPUP+WS_BORDER+WS_SYSMENU
WS_MODAL			equ	WS_CAPTION+WS_SYSMENU+WS_VISIBLE
WS_MODELESS			equ	WS_CAPTION+WS_SYSMENU+WS_VISIBLE
WS_CONTROL			equ	WS_CHILD+WS_VISIBLE
WS_OVERLAPPEDWINDOW		equ	WS_OVERLAPPED+WS_CAPTION+WS_SYSMENU+\
					WS_THICKFRAME+WS_MINIMIZEBOX+\
					WS_MAXIMIZEBOX
;
WS_TILED			equ	WS_OVERLAPPED
WS_CHILDWINDOW			equ	WS_CHILD
WS_ICONIC			equ	WS_MINIMIZE
WS_SIZEBOX			equ	WS_THICKFRAME
WS_TILEDWINDOW			equ	WS_OVERLAPPEDWINDOW
;
;------------------------------------------------------------------------------
;
; ======================
; extended window styles
; ======================
;
WS_EX_NONE			equ	00000000h
WS_EX_DLGMODALFRAME		equ	00000001h
WS_EX_NOPARENTNOTIFY		equ	00000004h
WS_EX_TOPMOST			equ	00000008h
WS_EX_ACCEPTFILES		equ	00000010h
WS_EX_TRANSPARENT		equ	00000020h
WS_EX_MDICHILD			equ	00000040h
WS_EX_TOOLWINDOW		equ	00000080h
WS_EX_WINDOWEDGE		equ	00000100h
WS_EX_CLIENTEDGE		equ	00000200h
WS_EX_CONTEXTHELP		equ	00000400h
WS_EX_RIGHT			equ	00001000h
WS_EX_LEFT			equ	00000000h
WS_EX_RTLREADING		equ	00002000h
WS_EX_LTRREADING		equ	00000000h
WS_EX_LEFTSCROLLBAR		equ	00004000h
WS_EX_RIGHTSCROLLBAR		equ	00000000h
WS_EX_CONTROLPARENT		equ	00010000h
WS_EX_STATICEDGE		equ	00020000h
WS_EX_APPWINDOW			equ	00040000h
;
WS_EX_OVERLAPPEDWINDOW		equ	00000300h
WS_EX_PALETTEWINDOW		equ	00000188h
;
;------------------------------------------------------------------------------
;
; ================
; background modes
; ================
;
TRANSPARENT			equ	1
OPAQUE				equ	2
BKMODE_LAST			equ	2
;
;------------------------------------------------------------------------------
;
; ====================
; CreateFile() actions
; ====================
;
CREATE_NEW			equ	1
CREATE_ALWAYS			equ	2
OPEN_EXISTING			equ	3
OPEN_ALWAYS			equ	4
TRUNCATE_EXISTING		equ	5
;
;------------------------------------------------------------------------------
;
; =====================
; CreateProcess() flags
; =====================
;
DEBUG_PROCESS			equ	00000001h
DEBUG_ONLY_THIS_PROCESS		equ	00000002h
CREATE_SUSPENDED		equ	00000004h
DETACHED_PROCESS		equ	00000008h
CREATE_NEW_CONSOLE		equ	00000010h
NORMAL_PRIORITY_CLASS		equ	00000020h
IDLE_PRIORITY_CLASS		equ	00000040h
HIGH_PRIORITY_CLASS		equ	00000080h
REALTIME_PRIORITY_CLASS		equ	00000100h
;
CREATE_NEW_PROCESS_GROUP	equ	00000200h
CREATE_UNICODE_ENVIRONMENT	equ	00000400h
CREATE_SEPARATE_WOW_VDM		equ	00000800h
CREATE_SHARED_WOW_VDM		equ	00001000h
CREATE_DEFAULT_ERROR_MODE	equ	04000000h
CREATE_NO_WINDOW		equ	08000000h
;
PROFILE_USER			equ	10000000h
PROFILE_KERNEL			equ	20000000h
PROFILE_SERVER			equ	40000000h
;
;------------------------------------------------------------------------------
;
; ===============
; gdi error codes
; ===============
;
GDI_ERROR			equ	-1
HGDI_ERROR			equ	-1
;
;------------------------------------------------------------------------------
;
; =================
; memory attributes
; =================
;
PAGE_NOACCESS			equ	00000001h
PAGE_READONLY			equ	00000002h
PAGE_READWRITE			equ	00000004h
PAGE_WRITECOPY			equ	00000008h
PAGE_EXECUTE			equ	00000010h
PAGE_EXECUTE_READ		equ	00000020h
PAGE_EXECUTE_READWRITE		equ	00000040h
PAGE_EXECUTE_WRITECOPY		equ	00000080h
PAGE_GUARD			equ	00000100h
PAGE_NOCACHE			equ	00000200h
;
MEM_COMMIT			equ	00001000h
MEM_RESERVE			equ	00002000h
MEM_DECOMMIT			equ	00004000h
MEM_RELEASE			equ	00008000h
MEM_FREE			equ	00010000h
MEM_PRIVATE			equ	00020000h
MEM_MAPPED			equ	00040000h
MEM_TOP_DOWN			equ	00100000h
;
SEC_FILE			equ	00800000h
SEC_IMAGE			equ	01000000h
SEC_RESERVE			equ	04000000h
SEC_COMMIT			equ	08000000h
SEC_NOCACHE			equ	10000000h
;
MEM_IMAGE			equ	SEC_IMAGE
;
SECTION_QUERY			equ	00000001h
SECTION_MAP_WRITE		equ	00000002h
SECTION_MAP_READ		equ	00000004h
SECTION_MAP_EXECUTE		equ	00000008h
SECTION_EXTEND_SIZE		equ	00000010h
;
SECTION_ALL_ACCESS		equ	STANDARD_RIGHTS_REQUIRED+\
					SECTION_QUERY+\
					SECTION_MAP_WRITE+\
					SECTION_MAP_READ+\
					SECTION_MAP_EXECUTE+\
					SECTION_EXTEND_SIZE
;
FILE_MAP_COPY			equ	SECTION_QUERY
FILE_MAP_WRITE			equ	SECTION_MAP_WRITE
FILE_MAP_READ			equ	SECTION_MAP_READ
FILE_MAP_ALL_ACCESS		equ	SECTION_ALL_ACCESS
;
;------------------------------------------------------------------------------
;
; ================
; PolyFill() modes
; ================
;
ALTERNATE			equ	1
WINDING				equ	2
POLYFILL_LAST			equ	2
;
;------------------------------------------------------------------------------
;
; ============
; region flags
; ============
;
ERROR				equ	0
NULLREGION			equ	1
SIMPLEREGION			equ	2
COMPLEXREGION			equ	3
RGN_ERROR			equ	ERROR
;
;------------------------------------------------------------------------------
;
; =====================
; standard access types
; =====================
;
DELETE				equ	00010000h
READ_CONTROL			equ	00020000h
WRITE_DAC			equ	00040000h
WRITE_OWNER			equ	00080000h
SYNCHRONIZE			equ	00100000h
;
SPECIFIC_RIGHTS_ALL		equ	0000FFFFh
STANDARD_RIGHTS_REQUIRED	equ	000F0000h
STANDARD_RIGHTS_ALL		equ	001F0000h
;
STANDARD_RIGHTS_READ		equ	READ_CONTROL
STANDARD_RIGHTS_WRITE		equ	READ_CONTROL
STANDARD_RIGHTS_EXECUTE		equ	READ_CONTROL
;
;------------------------------------------------------------------------------
;
; =====================
; stock logical objects
; =====================
;
WHITE_BRUSH			equ	 0
LTGRAY_BRUSH			equ	 1
GRAY_BRUSH			equ	 2
DKGRAY_BRUSH			equ	 3
BLACK_BRUSH			equ	 4
NULL_BRUSH			equ	 5
WHITE_PEN			equ	 6
BLACK_PEN			equ	 7
NULL_PEN			equ	 8
OEM_FIXED_FONT			equ	10
ANSI_FIXED_FONT			equ	11
ANSI_VAR_FONT			equ	12
SYSTEM_FONT			equ	13
DEVICE_DEFAULT_FONT		equ	14
DEFAULT_PALETTE			equ	15
SYSTEM_FIXED_FONT		equ	16
DEFAULT_GUI_FONT		equ	17
;
HOLLOW_BRUSH			equ	NULL_BRUSH
;
;------------------------------------------------------------------------------
;
; ==================
; StretchBlt() modes
; ==================
;
BLACKONWHITE			equ	1
WHITEONBLACK			equ	2
COLORONCOLOR			equ	3
HALFTONE			equ	4
MAXSTRETCHBLTMODE		equ	4
;
STRETCH_ANDSCANS		equ	BLACKONWHITE
STRETCH_ORSCANS			equ	WHITEONBLACK
STRETCH_DELETESCANS		equ	COLORONCOLOR
STRETCH_HALFTONE		equ	HALFTONE
;
;------------------------------------------------------------------------------
;
; =========================
; ternary raster operations
; =========================
;
SRCCOPY				equ	00CC0020h	;dest = src
SRCPAINT			equ	00EE0086h	;dest = src or dest
SRCAND				equ	008800C6h	;dest = src and dest
SRCINVERT			equ	00660046h	;dest = src xor dest
SRCERASE			equ	00440328h	;dest = src and -dest
NOTSRCCOPY			equ	00330008h	;dest = -src
NOTSRCERASE			equ	001100A6h	;dest = -src and -dest
MERGECOPY			equ	00C000CAh	;dest = src and pat
MERGEPAINT			equ	00BB0226h	;dest = -src or dest
PATCOPY				equ	00F00021h	;dest = pat
PATPAINT			equ	00FB0A09h	;dest = DPSnoo
PATINVERT			equ	005A0049h	;dest = pat xor dest
DSTINVERT			equ	00550009h	;dest = -dest
BLACKNESS			equ	00000042h	;dest = black
WHITENESS			equ	00FF0062h	;dest = white
;
;;==============================================================================
;
;	STRUCTURES
;
;==============================================================================
;
STARTUPINFOA		STRUCT
	cb		DWORD		?
	lpReserved	LPSTR		?
	lpDesktop	LPSTR		?
	lpTitle		LPSTR		?
	dwX		DWORD		?
	dwY		DWORD		?
	dwXSize		DWORD		?
	dwYSize		DWORD		?
	dwXCountChars	DWORD		?
	dwYCountChars	DWORD		?
	dwFillAttribute	DWORD		?
	dwFlags		DWORD		?
	wShowWindow	WORD		?
	cbReserved2	WORD		?
	lpReserved2	LPBYTE		?
	hStdInput	HANDLE		?
	hStdOutput	HANDLE		?
	hStdError	HANDLE		?
STARTUPINFOA		ENDS




;
BITMAPFILEHEADER	struct
bf_bfType		WORD	  0		;file type
bf_bfSize		DWORD	  0		;file size
bf_bfReserved1		WORD	  0		;(reserved)
bf_bfReserved2		WORD	  0		;(reserved)
bf_bfOffBits		DWORD	  0		;data offset
BITMAPFILEHEADER	ends
BITMAPFILEHEADER_	equ	  2+4+2+2+4
;
;------------------------------------------------------------------------------
;
BITMAPINFOHEADER	struct
bi_biSize		DWORD	  0		;structure size
bi_biWidth		LONG	  0		;bitmap width
bi_biHeight		LONG	  0		;bitmap height
bi_biPlanes		WORD	  0		;number of color planes
bi_biBitCount		WORD	  0		;number of bits per pixel
bi_biCompression	DWORD	  0		;compression type
bi_biSizeImage		DWORD	  0		;number of data bytes
bi_biXPelsPerMeter	LONG	  0		;horizontal resolution
bi_biYPelsPerMeter	LONG	  0		;vertical resolution
bi_biClrUsed		DWORD	  0		;number of used colors
bi_biClrImportant	DWORD	  0		;number of important colors
BITMAPINFOHEADER	ends
BITMAPINFOHEADER_	equ	  4+4+4+2+2+4+4+4+4+4+4
;
;------------------------------------------------------------------------------
;
BITMAP			struct
bm_bmType		LONG	  0		;bitmap type
bm_bmWidth		LONG	  0		;bitmap width
bm_bmHeight		LONG	  0		;bitmap height
bm_bmWidthBytes		LONG	  0		;bytes per scan line
bm_bmPlanes		WORD	  0		;number of color planes
bm_bmBitsPixel		WORD	  0		;number of bits per pixel
bm_bmBits		LPVOID	  0		;data pointer
BITMAP			ends
BITMAP_			equ	  4+4+4+4+2+2+4
;
;------------------------------------------------------------------------------
;
COPYDATASTRUCT		struct
cd_dwData		DWORD	  0		;32-bit data
cd_cbData		DWORD	  0		;number of data bytes
cd_lpData		PVOID	  0		;data bytes
COPYDATASTRUCT		ends
COPYDATASTRUCT_		equ	  4+4+4
;
;------------------------------------------------------------------------------
;
CONTEXT			struct
;
cx_ContextFlags		DWORD	  0		;context flags
;
; CONTEXT_DEBUG_REGISTERS
;
cx_Dr0			DWORD	  0		;debug register #0
cx_Dr1			DWORD	  0		;debug register #1
cx_Dr2			DWORD	  0		;debug register #2
cx_Dr3			DWORD	  0		;debug register #3
cx_Dr6			DWORD	  0		;debug register #6
cx_Dr7			DWORD	  0		;debug register #7
;
; CONTEXT_FLOATING_POINT
;
cx_ControlWord		DWORD	  0		;fpu context
cx_StatusWord		DWORD	  0
cx_TagWord		DWORD	  0
cx_ErrorOffset		DWORD	  0
cx_ErrorSelector	DWORD	  0
cx_DataOffset		DWORD	  0
cx_DataSelector		DWORD	  0
cx_RegisterArea		BYTE	  SIZE_OF_80387_REGISTERS dup (0)
cx_Cr0NpxState		DWORD	  0
;
; CONTEXT_SEGMENTS
;
cx_SegGs		DWORD	  0		;gs register
cx_SegFs		DWORD	  0		;fs register
cx_SegEs		DWORD	  0		;es register
cx_SegDs		DWORD	  0		;ds register
;
; CONTEXT_INTEGER
;
cx_Edi			DWORD	  0		;edi register
cx_Esi			DWORD	  0		;esi register
cx_Ebx			DWORD	  0		;ebx register
cx_Edx			DWORD	  0		;edx register
cx_Ecx			DWORD	  0		;ecx register
cx_Eax			DWORD	  0		;eax register
;
; CONTEXT_CONTROL
;
cx_Ebp			DWORD	  0		;ebp register
cx_Eip			DWORD	  0		;eip register
cx_SegCs		DWORD	  0		;cs register
cx_EFlags		DWORD	  0		;eflags register
cx_Esp			DWORD	  0		;esp register
cx_SegSs		DWORD	  0		;ss register
;
CONTEXT			ends
;
CONTEXT_FLAGS_			equ	4
CONTEXT_DEBUG_REGISTERS_	equ	4+4+4+4+4+4
CONTEXT_FLOATING_POINT_		equ	4+4+4+4+4+4+4+SIZE_OF_80387_REGISTERS+4
CONTEXT_SEGMENTS_		equ	4+4+4+4
CONTEXT_INTEGER_		equ	4+4+4+4+4+4
CONTEXT_CONTROL_		equ	4+4+4+4+4+4
;
CONTEXT_FULL_			equ	CONTEXT_FLAGS_+\
					CONTEXT_SEGMENTS_+\
					CONTEXT_INTEGER_+\
					CONTEXT_CONTROL_
;
;------------------------------------------------------------------------------
;
DIALOGATTRIBUTES	struct
da_Palette		DWORD	  0		;palette pointer
da_TextBox		DWORD	  0		;text box list pointer
DIALOGATTRIBUTES	ends
DIALOGATTRIBUTES_	equ	  4+4
;
;------------------------------------------------------------------------------
;
DIALOGPALETTE		struct
dp_DlgText		COLORREF  0		;dialog text color
dp_DlgBk		COLORREF  0		;dialog background color
dp_StaticText		COLORREF  0		;static text color
dp_StaticBk		COLORREF  0		;static background color
dp_TextBoxText		COLORREF  0		;text box text color
dp_TextBoxBk		COLORREF  0		;text box background color
dp_EditText		COLORREF  0		;edit text color
dp_EditBk		COLORREF  0		;edit background color
dp_ListBoxText		COLORREF  0		;list box text color
dp_ListBoxBk		COLORREF  0		;list box background color
DIALOGPALETTE		ends
DIALOGPALETTE_		equ	  4+4+4+4+4+4+4+4+4+4
;
;------------------------------------------------------------------------------
;
DIALOGRECORD		struct
dr_hWnd			HWND	  0		;dialog window handle
dr_fModeless		BOOL	  FALSE		;mode flag
dr_Attributes		DWORD	  0		;dialog window attributes list
dr_Data			DWORD	  0		;dialog data
dr_hDlgBrush		HBRUSH	  0		;dialog brush handle
dr_hStaticBrush		HBRUSH	  0		;static brush handle
dr_hTextBoxBrush	HBRUSH	  0		;text box brush handle
dr_hEditBrush		HBRUSH	  0		;edit brush handle
dr_hListBoxBrush	HBRUSH	  0		;list box brush handle
DIALOGRECORD		ends
DIALOGRECORD_		equ	  4+4+4+4+4+4+4+4+4
;
;------------------------------------------------------------------------------
;
WIN32_FIND_DATA_	equ	  4+8+8+8+4+4+4+4+(MAX_PATH*CHAR_)+(14*CHAR_)
WIN32_FIND_DATA		struct
fd_dwFileAttributes	DWORD	  0		;file attributes
fd_ftCreationTime	DWORD	  0, 0		;time of file creation
fd_ftLastAccessTime	DWORD	  0, 0		;time of last file access
fd_ftLastWriteTime	DWORD	  0, 0		;time of last write access
fd_nFileSizeHigh	DWORD	  0		;high-order word of file size
fd_nFileSizeLow		DWORD	  0		;low-order word of file size
fd_dwReserved0		DWORD	  0		;(reserved)
fd_dwReserved1		DWORD	  0		;(reserved)
fd_cFileName		CHAR	  MAX_PATH dup(0) ;matching file name
fd_cAlternateFileName	CHAR	  14 dup(0)	;8.3 alias name
WIN32_FIND_DATA		ends
;
;------------------------------------------------------------------------------
;
BY_HANDLE_FILE_INFORMATION struct
fi_dwFileAttributes	DWORD	  0		;file attributes
fi_ftCreationTime	DWORD	  0, 0		;time of file creation
fi_ftLastAccessTime	DWORD	  0, 0		;time of last file access
fi_ftLastWriteTime	DWORD	  0, 0		;time of last write access
fi_dwVolumeSerialNumber	DWORD	  0		;volume serial number
fi_nFileSizeHigh	DWORD	  0		;high-order word of file size
fi_nFileSizeLow		DWORD	  0		;low-order word of file size
fi_nNumberOfLinks	DWORD	  0		;number of links to the file
fi_nFileIndexHigh	DWORD	  0		;high-order word of identifier
fi_nFileIndexLow	DWORD	  0		;low-order word of identifier
BY_HANDLE_FILE_INFORMATION  ends
BY_HANDLE_FILE_INFORMATION_ equ	  4+8+8+8+4+4+4+4+4+4
;
;------------------------------------------------------------------------------
;
FILETIME		struct
ft_dwLowDateTime	DWORD	  0		;low-order 32 bits
ft_dwHighDateTime	DWORD	  0		;high-order 32 bits
FILETIME		ends
FILETIME_		equ	  4+4
;
;------------------------------------------------------------------------------
;
MSG			struct
ms_hwnd			HWND	  0		;window handle
ms_message		UINT	  0		;message id
ms_wParam		WPARAM	  0		;additional parameter
ms_lParam		LPARAM	  0		;additional parameter
ms_time			DWORD	  0		;time stamp
ms_x			LONGINT	  0		;x coordinate
ms_y			LONGINT	  0		;y coordinate
MSG			ends
MSG_			equ	  4+4+4+4+4+4+4
;
;------------------------------------------------------------------------------
;
NETRESOURCE		struct
nr_dwScope		DWORD	  0		;resource scope
nr_dwType		DWORD	  0		;resource type
nr_dwDisplayType	DWORD	  0		;display type
nr_dwUsage		DWORD	  0		;resource usage
nr_lpLocalName		LPSTR	  0		;redirected local device
nr_lpRemoteName		LPSTR	  0		;remote name
nr_lpComment		LPSTR	  0		;provider supplied comment
nr_lpProvider		LPSTR	  0		;name of provider
NETRESOURCE		ends
NETRESOURCE_		equ	  4+4+4+4+4+4+4+4
;
;------------------------------------------------------------------------------
;
OFSTRUCT_		equ	  1+1+2+2+2+OFS_MAXPATHNAME
OFSTRUCT		struct
of_cBytes		BYTE	  0		;structure size
of_fFixedDisk		BYTE	  0		;fixed-disk flag
of_nErrCode		WORD	  0		;error code
of_Reserved1		WORD	  0		;(reserved)
of_Reserved2		WORD	  0		;(reserved)
of_szPathName		BYTE	  OFS_MAXPATHNAME dup (0) ;path name
OFSTRUCT		ends
;
;------------------------------------------------------------------------------
;
OPENFILENAME_		equ	  4+4+4+4+4+4+4+4+4+4+4+4+4+4+2+2+4+4+4+4
OPENFILENAME		struct
on_lStructSize		DWORD	  OPENFILENAME_	;number of bytes
on_hwndOwner		HWND	  0		;dialog box owner
on_hInstance		HINSTANCE 0		;dialog box template id
on_lpstrFilter		LPCSTR	  0		;filter strings
on_lpstrCustomFilter	LPSTR	  0		;user-defined filter stings
on_nMaxCustFilter	DWORD	  0		;size of custom filter buffer
on_nFilterIndex		DWORD	  0		;index into the filter buffer
on_lpstrFile		LPSTR	  0		;default file name buffer
on_nMaxFile		DWORD	  0		;size of the file name buffer
on_lpstrFileTitle	LPSTR	  0		;file title buffer
on_nMaxFileTitle	DWORD	  0		;size of the file title buffer
on_lpstrInitialDir	LPCSTR	  0		;initial directory
on_lpstrTitle		LPCSTR	  0		;dialog box title
on_Flags		DWORD	  0		;dialog box creation flags
on_nFileOffset		WORD	  0		;file name offset in lpstrFile
on_nFileExtension	WORD	  0		;file ext offset in lpstrFile
on_lpstrDefExt		LPCSTR	  0		;default extension
on_lCustData		LPARAM	  0		;application-defined hook data
on_lpfnHook		LPFN	  0		;hook function
on_lpTemplateName	LPCSTR	  0		;dialog box template name
OPENFILENAME		ends
;
;------------------------------------------------------------------------------
;
OSVERSIONINFO_		equ	4+4+4+4+4+(128*CHAR_)
OSVERSIONINFO		struct
ov_dwOSVersionInfoSize	DWORD	OSVERSIONINFO_	;structure size
ov_dwMajorVersion	DWORD	0		;major version number
ov_dwMinorVersion	DWORD	0		;minor version number
ov_dwBuildNumber	DWORD	0		;build number
ov_dwPlatformId		DWORD	0		;platform id
ov_szCSDVersion		CHAR	128 dup (0)	;info string
OSVERSIONINFO		ends
;
;------------------------------------------------------------------------------
;
PAINTSTRUCT		struct
ps_hdc			HDC	  0		;device context handle
ps_fErase		BOOL	  FALSE		;background erase flag
ps_leftPaint		LONGINT	  0		;left margin of clipping rect
ps_topPaint		LONGINT	  0		;top margin of clipping rect
ps_rightPaint		LONGINT	  0		;right margin of clipping rect
ps_bottomPaint		LONGINT	  0		;bottom margin of clipping rect
ps_fRestore		BOOL	  FALSE		;(reserved)
ps_fIncUpdate		BOOL	  FALSE		;(reserved)
ps_rgbReserved		BYTE	  32 dup (0)	;(reserved)
PAINTSTRUCT		ends
PAINTSTRUCT_		equ	  4+4+4+4+4+4+4+4+32
;
;------------------------------------------------------------------------------
;
PROCESS_INFORMATION	struct
pi_hProcess		HANDLE	  0		;process handle
pi_hThread		HANDLE	  0		;thread handle
pi_dwProcessId		DWORD	  0		;process id
pi_dwThreadId		DWORD	  0		;thread id
PROCESS_INFORMATION	ends
PROCESS_INFORMATION_	equ	  4+4+4+4
;
;------------------------------------------------------------------------------
;
POINT			struct
pt_x			LONGINT	  0		;x coordinate
pt_y			LONGINT	  0		;y coordinate
POINT			ends
POINT_			equ	  4+4
;
;------------------------------------------------------------------------------
;
RECT			struct
rc_left			LONGINT	  0		;left margin
rc_top			LONGINT	  0		;top margin
rc_right		LONGINT	  0		;right margin
rc_bottom		LONGINT	  0		;bottom margin
RECT			ends
RECT_			equ	  4+4+4+4
;
;------------------------------------------------------------------------------
;
RGBQUAD			struct
rq_rgbBlue		BYTE	  0		;intensity of blue component
rq_rgbGreen		BYTE	  0		;intensity of green component
rq_rgbRed		BYTE	  0		;intensity of red component
rq_rgbReserved		BYTE	  0		;(reserved)
RGBQUAD			ends
RGBQUAD_		equ	  1+1+1+1
;
;------------------------------------------------------------------------------
;
SECURITY_ATTRIBUTES_	equ	  4+4+4
SECURITY_ATTRIBUTES	struct
sa_nLength		DWORD	  SECURITY_ATTRIBUTES_ ;structure size
sa_lpSecurityDescriptor	LPVOID	  0		;security descriptor
sa_bInheritHandle	BOOL	  FALSE		;handle inheritance flag
SECURITY_ATTRIBUTES	ends
;
;------------------------------------------------------------------------------
;
STARTUPINFO		struct
si_cb			DWORD	  0		;structure size
si_lpReserved		LPSTR	  0		;(reserved)
si_lpDesktop		LPSTR	  0		;desktop name
sl_lpTitle		LPSTR	  0		;console window title
si_dwX			DWORD	  0		;window origin (column)
si_dwY			DWORD	  0		;window origin (row)
si_dwXSize		DWORD	  0		;window width
si_dwYSize		DWORD	  0		;window height
si_dwXCountChars	DWORD	  0		;screen buffer width
si_dwYCountChars	DWORD	  0		;screen buffer height
si_dwFillAttribute	DWORD	  0		;console window initialization
si_dwFlags		DWORD	  0		;structure member flags
si_wShowWindow		WORD	  0		;ShowWindow() parameter
si_cbReserved2		WORD	  0		;(reserved)
si_lpReserved2		LPBYTE	  0		;(reserved)
si_hStdInput		HANDLE	  0		;standard input handle
si_hStdOutput		HANDLE	  0		;standard output handle
si_hStdError		HANDLE	  0		;standard error handle
STARTUPINFO		ends
STARTUPINFO_		equ	  4+4+4+4+4+4+4+4+4+4+4+4+2+2+4+4+4+4
;
;------------------------------------------------------------------------------
;
SYSTEMTIME		struct
st_wYear		WORD	  0		;current year
st_wMonth		WORD	  0		;current month (1..12)
st_wDayOfWeek		WORD	  0		;day of week (0 = sunday)
st_wDay			WORD	  0		;current day of the month
st_wHour		WORD	  0		;current hour
st_wMinute		WORD	  0		;current minute
st_wSecond		WORD	  0		;current second
st_wMilliseconds	WORD	  0		;current millisecond
SYSTEMTIME		ends
SYSTEMTIME_		equ	  2+2+2+2+2+2+2+2
;
;------------------------------------------------------------------------------
;
TBADDBITMAP		struct
ta_hInst		HINSTANCE 0		;resource module instance
ta_nID			UINT	  0		;resource id
TBADDBITMAP		ends
TBADDBITMAP_		equ	  4+4
;
;------------------------------------------------------------------------------
;
TBBUTTON 		struct
tb_iBitmap		INTEGER	  0		;zero-based button image index
tb_idCommand		INTEGER	  0		;button command id
tb_fsState		BYTE	  0		;button state flags
tb_fsStyle		BYTE	  0		;button style
tb_bReserved		BYTE	  0, 0		;(reserved)
tb_dwData		DWORD	  0		;application defined value
tb_iString		INTEGER	  0		;zero-based button string index
TBBUTTON		ends
TBBUTTON_		equ	  4+4+1+1+(1+1)+4+4
;
;------------------------------------------------------------------------------
;
TEXTMETRIC		struct
tm_tmHeight		LONGINT	  0		;char height (ascent+descent)
tm_tmAscent		LONGINT	  0		;units above baseline
tm_tmDescent		LONGINT	  0		;units below baseline
tm_tmInternalLeading	LONGINT	  0		;space included in tmHeight
tm_tmExternalLeading	LONGINT	  0		;extra space between rows
tm_tmAveCharWidth	LONGINT	  0		;average character width ('x')
tm_tmMaxCharWidth	LONGINT	  0		;maximum character width
tm_tmWeight		LONGINT	  0		;font weight
tm_tmOverhang		LONGINT	  0		;italic flag
tm_tmDigitizedAspectX	LONGINT	  0		;horizontal device aspect
tm_tmDigitizedAspectY	LONGINT	  0		;vertical device aspect
tm_tmFirstChar		CHAR	  0		;first font character value
tm_tmLastChar		CHAR	  0		;last font character value
tm_tmDefaultChar	CHAR	  0		;default substitution character
tm_tmBreakChar		CHAR	  0		;word break character
tm_tmItalic		BYTE	  0		;italic font
tm_tmUnderlined		BYTE	  0		;underline font
tm_tmStruckOut		BYTE	  0		;strikeout font
tm_tmPitchAndFamily	BYTE	  0		;font pitch/family
tm_tmCharSet		BYTE	  0		;font character set
TEXTMETRIC		ends
TEXTMETRIC_		equ	  4+4+4+4+4+4+4+4+4+4+4+\
				  CHAR_+CHAR_+CHAR_+CHAR_+\
				  1+1+1+1+1
;
;------------------------------------------------------------------------------
;
WNDCLASS		struct
w_style			UINT	  0		;class style
w_lpfnWndProc		WNDPROC	  0		;window procedure
w_cbClsExtra		INTEGER	  0		;class extra data
w_cbWndExtra		INTEGER	  0		;window extra data
w_hInstance		HINSTANCE 0		;class owner
w_hIcon			HICON	  0		;icon handle
w_hCursor		HCURSOR	  0		;cursor handle
w_hbrBackground		HBRUSH	  0		;background color
w_lpszMenuName		LPCSTR	  0		;menu name
w_lpszClassName		LPCSTR	  0		;class name
WNDCLASS		ends
WNDCLASS_		equ	  4+4+4+4+4+4+4+4+4+4
;
;------------------------------------------------------------------------------
;
WNDPARAMETERS		struct
wp_hWnd			HWND	  0		;window handle
wp_FontId		DWORD	  0		;font id
wp_TextColor		COLORREF  0		;text color
wp_BkColor		COLORREF  0		;background color
wp_BkMode		DWORD	  0		;background mode
WNDPARAMETERS		ends
WNDPARAMETERS_		equ	  4+4+4+4+4
;
;==============================================================================
;
;	DDE STRUCTURES
;
;==============================================================================
;
DDEACK			struct
ddeack_Status		WORD	  0		;status
DDEACK			ends
DDEACK_			equ	  2
;
;------------------------------------------------------------------------------
;
DDEADVISE		struct
ddeadvise_Status	WORD	  0		;status
ddeadvise_cfFormat	WORD	  0		;clipboard data format
DDEADVISE		ends
DDEADVISE_		equ	  2+2
;
;------------------------------------------------------------------------------
;
DDEDATA			struct
ddedata_Status		WORD	  0		;status
ddedata_cfFormat	WORD	  0		;clipboard data format
ddedata_Value		BYTE	  0		;data item
DDEDATA			ends
DDEDATA_		equ	  2+2+1
;
;------------------------------------------------------------------------------
;
DDEPOKE			struct
ddepoke_Status		WORD	  0		;status
ddepoke_cfFormat	WORD	  0		;clipboard data format
ddepoke_Value		BYTE	  0		;data item
DDEPOKE			ends
DDEPOKE_		equ	  2+2+1
;
;==============================================================================

;*bk*
;be careful from here on. This stuff assumes ansi, not unicode.
;for example, StartDoc is equated to StartDocA, the ansi API
;function. The unicode equivalent is StartDocB.



LPSECURITY_ATTRIBUTES	TYPEDEF	PTR SECURITY_ATTRIBUTES
LPRECT		TYPEDEF	PTR RECT
LPPOINT		TYPEDEF	PTR POINT
LPPAINTSTRUCT		TYPEDEF PTR PAINTSTRUCT
HGDIOBJ		TYPEDEF	DWORD
LPPROCESS_INFORMATION	TYPEDEF	PTR PROCESS_INFORMATION
LPSTARTUPINFO		TYPEDEF	PTR STARTUPINFOA
LPCTBBUTTON		TYPEDEF	PTR TBBUTTON

;*******************************************************************************
;*			WINDEF.H	****************************************
;*******************************************************************************

MAX_PATH	EQU	0104h

NULL		EQU	0h
FALSE		EQU	0h
TRUE		EQU	1h

;CALLBACK	TYPEDEF	PROTO STDCALL
CALLBACK TEXTEQU	<STDCALL>
;WINAPI		TYPEDEF	PROTO STDCALL
WINAPI TEXTEQU	<STDCALL>




;*******************************************************************************
;*			WINNT.H		****************************************
;*******************************************************************************

LPSTR		TYPEDEF	DWORD
LPCSTR		TYPEDEF	DWORD

FILE_ATTRIBUTE_READONLY	EQU	0001h
FILE_ATTRIBUTE_HIDDEN	EQU	0002h
FILE_ATTRIBUTE_SYSTEM	EQU	0004h
FILE_ATTRIBUTE_DIRECTORY EQU	0010h
FILE_ATTRIBUTE_ARCHIVE	EQU	0020h
FILE_ATTRIBUTE_NORMAL	EQU	0080h
FILE_ATTRIBUTE_TEMPORARY EQU	0100h
FILE_ATTRIBUTE_COMPRESSED EQU	0800h

GENERIC_READ		EQU	080000000h
GENERIC_WRITE		EQU	040000000h
GENERIC_EXECUTE		EQU	020000000h
GENERIC_ALL		EQU	010000000h

DLL_PROCESS_ATTACH	EQU	01h
DLL_THREAD_ATTACH	EQU	02h
DLL_THREAD_DETACH	EQU	03h
DLL_PROCESS_DETACH	EQU	00h

RtlMoveMemory		PROCDESC	STDCALL :DWORD, :DWORD, :DWORD
MoveMemory		TEXTEQU	<RtlMoveMemory>
RtlFillMemory		PROCDESC	STDCALL :DWORD, :DWORD, :BYTE
FillMemory		TEXTEQU	<RtlFillMemory>

;*******************************************************************************
;*			WINERROR.H	****************************************
;*******************************************************************************

ERROR_SUCCESS		EQU	000h
ERROR_INVALID_HANDLE	EQU	006h
ERROR_ALREADY_EXISTS	EQU	0B7h


;*******************************************************************************
;*	KERNEL32.LIB	WINBASE.H	****************************************
;*******************************************************************************

;INVALID_HANDLE_VALUE	EQU	-1

CREATE_NEW		EQU	01h
CREATE_ALWAYS		EQU	02h
OPEN_EXISTING		EQU	03h
OPEN_ALWAYS		EQU	04h
TRUNCATE_EXISTING	EQU	05h

OVERLAPPED		STRUCT
	Internal	DWORD	?
	InternalHigh	DWORD	?
	_Offset		DWORD	?
	OffsetHigh	DWORD	?
	hEvent		HANDLE	?
OVERLAPPED		ENDS
LPOVERLAPPED		TYPEDEF	PTR OVERLAPPED


GMEM_FIXED		EQU	00000h
GMEM_MOVEABLE		EQU	00002h
GMEM_ZEROINIT		EQU	00040h
GMEM_SHARE		EQU	02000h

DEBUG_PROCESS		EQU	001h
DEBUG_ONLY_THIS_PROCESS	EQU	002h
CREATE_SUSPENDED	EQU	004h
DETACHED_PROCESS	EQU	008h
CREATE_NEWE_CONSOLE	EQU	010h
NORMAL_PRIORITY_CLASS	EQU	020h

WinMain			PROCDESC	WINAPI	:HINSTANCE, :HINSTANCE, :LPSTR, :SDWORD
GlobalAlloc		PROCDESC	WINAPI	:UINT, :DWORD
GlobalLock		PROCDESC	WINAPI	:HGLOBAL
GlobalUnlock		PROCDESC	WINAPI	:HGLOBAL
GlobalFree		PROCDESC	WINAPI	:HGLOBAL
ExitProcess		PROCDESC	WINAPI	:DWORD
GetLastError		PROCDESC	WINAPI
DebugBreak		PROCDESC	WINAPI
Sleep			PROCDESC	WINAPI	:DWORD
LoadResource		PROCDESC	WINAPI	:HINSTANCE, :HRSRC
GetFileSize		PROCDESC	WINAPI	:HANDLE, :LPDWORD
WriteFile		PROCDESC	WINAPI	:HANDLE, :LPCVOID, :DWORD, :LPDWORD, :LPOVERLAPPED
ReadFile		PROCDESC	WINAPI	:HANDLE, :LPVOID, :DWORD, :LPDWORD, :LPOVERLAPPED
CloseHandle		PROCDESC	WINAPI	:HANDLE
SetFilePointer	PROCDESC	WINAPI	:HANDLE, :DWORD, :LPDWORD, :DWORD
SetEndOfFile	PROCDESC	WINAPI	:HANDLE


Beep			PROCDESC	WINAPI	:DWORD, :DWORD
lstrlenA		PROCDESC	WINAPI	:LPCSTR
lstrlen			TEXTEQU	<lstrlenA>

STARTF_USESHOWWINDOW	EQU	0001h
STARTF_USESIZE		EQU	0002h
STARTF_USEPOSITION	EQU	0004h
STARTF_USECOUNTCHARS	EQU	0008h
STARTF_USEFILLATTRIBUTE	EQU	0010h
STARTF_RUNFULLSCREEN	EQU	0020h
STARTF_FORCEONFEEDBACK	EQU	0040h
STARTF_FORCEOFFFEEDBACK	EQU	0080h
STARTF_USESTDHANDLES	EQU	0100h
STARTF_USEHOTKEY	EQU	0200h


CreateSemaphoreA	PROCDESC	WINAPI	:LPSECURITY_ATTRIBUTES, :LONG, :LONG, :LPCSTR
CreateSemaphore		TEXTEQU	<CreateSemaphoreA>

GetModuleHandleA	PROCDESC	WINAPI	:DWORD
GetModuleHandle		TEXTEQU	<GetModuleHandleA>
CreateProcessA		PROCDESC	STDCALL	:LPCSTR, :LPSTR,\
					:LPSECURITY_ATTRIBUTES,\
					:LPSECURITY_ATTRIBUTES,\
					:BOOL, :DWORD, :LPVOID, :LPCSTR,\
					:LPSTARTUPINFO,\
					:LPPROCESS_INFORMATION
CreateProcess		TEXTEQU	<CreateProcessA>
GetStartupInfoA		PROCDESC	WINAPI	:LPSTARTUPINFO
GetStartupInfo		TEXTEQU	<GetStartupInfoA>
GetCommandLineA		PROCDESC	WINAPI
GetCommandLine		TEXTEQU	<GetCommandLineA>
OutputDebugStringA	PROCDESC	WINAPI	:LPCSTR
OutputDebugString	TEXTEQU	<OutputDebugStringA>
FindResourceA		PROCDESC	WINAPI	:HINSTANCE, :LPCSTR, :LPCSTR
FindResource		TEXTEQU	<FindResourceA>
CreateFileA		PROCDESC	WINAPI	:LPCSTR, :DWORD, :DWORD,\
					:LPSECURITY_ATTRIBUTES,\
					:DWORD, :DWORD, :HANDLE
CreateFile		TEXTEQU	<CreateFileA>
QueryPerformanceCounter	PROCDESC	WINAPI	:DWORD
QueryPerformanceFrequency PROCDESC	WINAPI	:DWORD

CreateFileMappingA 	PROCDESC	:HANDLE,  :LPSECURITY_ATTRIBUTES, :DWORD, :DWORD, :DWORD, :LPCTSTR	
CreateFileMapping		TEXTEQU	<CreateFileMappingA>
MapViewOfFile		PROCDESC 	:HANDLE, :DWORD, :DWORD, :DWORD
UnmapViewOfFile		PROCDESC 	:LPVOID
FlushViewOfFile		PROCDESC	:LPCVOID, :DWORD
CopyFileA			PROCDESC	:LPTSTR, :LPTSTR, :BOOL
CopyFile			TEXTEQU	<CopyFileA>
;*******************************************************************************
;*	GDI32.LIB	WINGDI.H	****************************************
;*******************************************************************************

SRCCOPY			EQU	00CC0020h	;dest = source
SRCPAINT		EQU	00EE0086h	;dest = source OR dest
SRCAND			EQU	008800C6h	;dest = source AND dest
SRCINVERT		EQU	00660046h	;dest = source XOR dest
SRCERASE		EQU	00440328h	;dest = source AND (NOT dest)

TA_LEFT			EQU	000h
TA_RIGHT		EQU	002h
TA_CENTER		EQU	006h
TA_TOP			EQU	000h
TA_BOTTOM		EQU	008h
TA_BASELINE		EQU	018h

SP_ERROR		EQU	-1


DRAFT_QUALITY		EQU	002h
PROOF_QUALITY		EQU	003h
FIXED_PITCH		EQU	001h
VARIABLE_PITCH		EQU	002h
FW_NORMAL		EQU	400
FW_BOLD			EQU	700
FF_ROMAN		EQU	010h
FF_MODERN		EQU	030h

TRANSPARENT		EQU	01h
OPAQUE			EQU	02h

WHITE_BRUSH		EQU	00h
LTGRAY_BRUSH		EQU	01h
GRAY_BRUSH		EQU	02h
DKGRAY_BRUSH		EQU	03h
BLACK_BRUSH		EQU	04h

BitBlt			PROCDESC	WINAPI	:HDC, :DWORD, :DWORD, :DWORD, :DWORD,\
					:HDC, :DWORD, :DWORD, :DWORD
CreateCompatibleDC	PROCDESC	WINAPI	:HDC
CreateFontA		PROCDESC	WINAPI	:SDWORD, :SDWORD, :SDWORD, :SDWORD, :SDWORD, :DWORD, :DWORD,\
					:DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :LPCSTR
CreateFont		TEXTEQU	<CreateFontA>
CreateSolidBrush	PROCDESC	WINAPI	:COLORREF
DeleteDC		PROCDESC	WINAPI	:HDC
DeleteObject		PROCDESC	WINAPI	:HGDIOBJ
GetStockObject		PROCDESC	WINAPI	:SDWORD
LineTo			PROCDESC	WINAPI	:HDC, :UINT, :UINT
RectVisible		PROCDESC	WINAPI	:HDC, :LPRECT
SelectObject		PROCDESC	WINAPI	:HDC, :HGDIOBJ
SetBkColor		PROCDESC	WINAPI	:HDC, :COLORREF
SetBkMode		PROCDESC	WINAPI	:HDC, :SDWORD

CLR_INVALID     EQU	0FFFFFFFFh


StretchBlt		PROCDESC	WINAPI	:HDC, :SDWORD, :SDWORD, :SDWORD, :SDWORD,\
					:HDC, :SDWORD, :SDWORD, :SDWORD, :SDWORD, :DWORD
SetTextColor		PROCDESC	WINAPI	:HDC, :COLORREF
SetTextAlign		PROCDESC	WINAPI	:HDC, :UINT

;ABORTPROC		TYPEDEF	PROCDESC STDCALL
ABORTPROC TEXTEQU <STDCALL>

DOCINFOA		STRUCT
	cbSize		SDWORD	?
	lpszDocName	LPCSTR	?
	lpszOutput	LPCSTR	?
	lpszDataType	LPCSTR	?
	fwType		DWORD	?
DOCINFOA		ENDS
LPDOCINFO		TYPEDEF	PTR DOCINFOA
DOCINFO			TEXTEQU	<DOCINFOA>

StartDocA		PROCDESC	WINAPI	:HDC, :LPDOCINFO
StartDoc		TEXTEQU	<StartDocA>
EndDoc			PROCDESC	WINAPI	:HDC
StartPage		PROCDESC	WINAPI	:HDC
EndPage			PROCDESC	WINAPI	:HDC
AbortDoc		PROCDESC	WINAPI	:HDC
;SetAbortProc		PROCDESC	WINAPI	:HDC, :ABORTPROC
SetAbortProc		PROCDESC	WINAPI	:HDC, :DWORD

MoveToEx		PROCDESC	WINAPI	:HDC, :UINT, :UINT, :LPPOINT
TextOutA		PROCDESC	WINAPI	:HDC, :DWORD, :DWORD, :LPCSTR, :DWORD
TextOut			TEXTEQU	<TextOutA>


;*******************************************************************************
;*	USER32.LIB	WINUSER.H	****************************************
;*******************************************************************************

;DLGPROC		TYPEDEF	PROCDESC STDCALL
DLGPROC TEXTEQU <STDCALL>

SB_HORZ			EQU	0
SB_VERT			EQU	1
SB_CTL			EQU	2
SB_BOTH			EQU	3
SB_THUMBPOSITION	EQU	4
SB_ENDSCROLL		EQU	8

SW_HIDE			EQU	00h
SW_SHOWNORMAL		EQU	01h
SW_SHOWMINIMIZED	EQU	02h
SW_SHOWMAXIMIZED	EQU	03h
SW_SHOW			EQU	05h
SW_RESTORE		EQU	09h
SW_SHOWDEFAULT		EQU	0Ah

WNDCLASSEX_ EQU 4*12
WNDCLASSEXA		STRUCT
	wc_cbSize		UINT		?
	wc_style		UINT		?
	wc_lpfnWndProc		DWORD		?
	wc_cbClsExtra		SDWORD		?
	wc_cbWndExtra		SDWORD		?
	wc_hInstance		HINSTANCE	?
	wc_hIcon		HICON		?
	wc_hCursor		HCURSOR		?
	wc_hbrBackground	HBRUSH		?
	wc_lpszMenuName		LPCSTR		?
	wc_lpszClassName	LPCSTR		?
	wc_hIconSm		HICON		?
WNDCLASSEXA		ENDS
WNDCLASSEX		TEXTEQU	<WNDCLASSEXA>

LPMSG			TYPEDEF	DWORD

;GWL_ID			EQU	0FFFFFFF4h

WM_CREATE		EQU	0001h
WM_DESTROY		EQU	0002h
WM_SIZE			EQU	0005h
WM_SETTEXT		EQU	000Ch
WM_PAINT		EQU	000Fh
WM_CLOSE		EQU	0010h
WM_ERASEBKGND		EQU	0014h
WM_NOTIFY		EQU	004Eh
WM_HELP			EQU	0053h
WM_CHAR			EQU	0102h
WM_INITDIALOG		EQU	0110h
WM_COMMAND		EQU	0111h
WM_TIMER		EQU	0113h
WM_HSCROLL		EQU	0114h
WM_VSCROLL		EQU	0115h
WM_MENUSELECT		EQU	011Fh
WM_CTLCOLORDLG		EQU	0136h
WM_MOUSEMOVE		EQU	0200h
WM_LBUTTONDOWN		EQU	0201h
WM_LBUTTONUP		EQU	0202h
WM_LBUTTONDBLCLK	EQU	0203h
WM_RBUTTONDOWN		EQU	0204h
WM_RBUTTONUP		EQU	0205h
WM_RBUTTONDBLCLK	EQU	0206h
WM_CUT			EQU	0300h
WM_COPY			EQU	0301h
WM_PASTE		EQU	0302h
WM_CLEAR		EQU	0303h
WM_UNDO			EQU	0304h
WM_USER			EQU	0400h

WS_POPUP		EQU	080000000h
WS_CHILD		EQU	040000000h
WS_MINIMIZE		EQU	020000000h
WS_VISIBLE		EQU	010000000h
WS_MAXIMIZE		EQU	001000000h
WS_CAPTION		EQU	000C00000h
WS_BORDER		EQU	000800000h
WS_DLGFRAME		EQU	000400000h
WS_VSCROLL		EQU	000200000h
WS_HSCROLL		EQU	000100000h
WS_SYSMENU		EQU	000080000h
;WS_SIZEBOX		EQU	000040000h
WS_MINIMIZEBOX		EQU	000020000h
WS_MAXIMIZEBOX		EQU	000010000h
WS_OVERLAPPEDWINDOW	EQU	000CF0000h
WS_EX_NOPARENTNOTIFY	EQU	000000004h
WS_EX_WINDOWEDGE	EQU	000000100h
WS_EX_CLIENTEDGE	EQU	000000200h
WS_EX_OVERLAPPEDWINDOW	EQU	WS_EX_WINDOWEDGE + WS_EX_CLIENTEDGE

CS_VREDRAW		EQU	00001h
CS_HREDRAW		EQU	00002h
CS_PARENTDC		EQU	00080h
CS_BYTEALIGNWINDOW	EQU	02000h

BDR_RAISEDOUTER		EQU	01h
BDR_SUNKENOUTER		EQU	02h
BDR_RAISEDINNER		EQU	04h
BDR_SUNKENINNER		EQU	08h
EDGE_RAISED		EQU	BDR_RAISEDOUTER + BDR_RAISEDINNER
EDGE_SUNKEN		EQU	BDR_SUNKENOUTER + BDR_SUNKENINNER
EDGE_ETCHED		EQU	BDR_SUNKENOUTER + BDR_RAISEDINNER
EDGE_BUMP		EQU	BDR_RAISEDOUTER + BDR_SUNKENINNER
BF_LEFT			EQU	01h
BF_TOP			EQU	02h
BF_RIGHT		EQU	04h
BF_BOTTOM		EQU	08h
BF_RECT			EQU	BF_LEFT + BF_TOP + BF_RIGHT + BF_BOTTOM
DrawEdge		PROCDESC	WINAPI	:HDC, :LPRECT, :UINT, :UINT


NMHDR			STRUCT
	hwndFrom	HWND	?
	idFrom		UINT	?
	code		UINT	?
NMHDR			ENDS

GetMessageA		PROCDESC	WINAPI	:LPMSG, :HWND, :UINT, :UINT
GetMessage		TEXTEQU	<GetMessageA>
TranslateMessage	PROCDESC	WINAPI	:LPMSG
DispatchMessageA	PROCDESC	WINAPI	:LPMSG
DispatchMessage		TEXTEQU	<DispatchMessageA>

PeekMessageA		PROCDESC	WINAPI	:LPMSG, :HWND, :UINT, :UINT, :UINT
PeekMessage		TEXTEQU	<PeekMessageA>
PM_NOREMOVE		EQU	00h
PM_REMOVE		EQU	01h
PM_NOYIELD		EQU	02h

SendMessageA		PROCDESC	WINAPI	:HWND, :UINT, :WPARAM, :LPARAM
SendMessage		TEXTEQU	<SendMessageA>
PostMessageA		PROCDESC	WINAPI	:HWND, :UINT, :WPARAM, :LPARAM
PostMessage		TEXTEQU	<PostMessageA>
DefWindowProcA		PROCDESC	WINAPI	:HWND, :UINT, :WPARAM, :LPARAM
DefWindowProc		TEXTEQU	<DefWindowProcA>
PostQuitMessage		PROCDESC	WINAPI	:SWORD
RegisterClassA	    PROCDESC WINAPI :DWORD
RegisterClass	    TEXTEQU <RegisterClassA>
RegisterClassExA	PROCDESC	WINAPI	:DWORD
RegisterClassEx		TEXTEQU	<RegisterClassExA>
CreateWindowA	PROCDESC WINAPI :LPCTSTR, :LPCTSTR, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :HWND, :HMENU, :HANDLE, :DWORD
CreateWindow	TEXTEQU <CreateWindowA>
CreateWindowExA		PROCDESC	WINAPI	:DWORD, :LPCSTR, :LPCSTR, :DWORD, :SDWORD, :SDWORD,\
					:SDWORD, :SDWORD, :HWND, :HMENU, :HINSTANCE, :DWORD
CreateWindowEx		TEXTEQU	<CreateWindowExA>
DestroyWindow		PROCDESC	WINAPI	:HWND
ShowWindow		PROCDESC	WINAPI	:HWND, :SDWORD
MoveWindow		PROCDESC	WINAPI	:HWND, :UINT, :UINT, :UINT, :UINT, :BOOL
SetWindowPos		PROCDESC	WINAPI	:HWND, :HWND, :UINT, :UINT, :UINT, :UINT, :UINT
IsIconic		PROCDESC	WINAPI	:HWND

SWP_NOSIZE		EQU	001h
SWP_NOMOVE		EQU	002h
SWP_NOZORDER		EQU	004h
SWP_FRAMECHANGED	EQU	020h
SWP_DRAWFRAME		EQU	SWP_FRAMECHANGED
HWND_TOP		EQU	000h

DLGTEMPLATE		STRUCT
	style		DWORD	?
	dwExtendedStyle	DWORD	?
	cdit		WORD	?
	x		SWORD	?
	y		SWORD	?
	nx		SWORD	?
	ny		SWORD	?
DLGTEMPLATE		ENDS
;LPCDLGTEMPLATE		TYPEDEF	PTR LPDLGTEMPLATE

;CreateDialogParamA	PROCDESC	WINAPI	:HINSTANCE, :LPCSTR, :HWND, :DLGPROC, :LPARAM
CreateDialogParamA	PROCDESC	WINAPI	:HINSTANCE, :LPCSTR, :HWND, :DWORD, :LPARAM
CreateDialogParam	TEXTEQU	<CreateDialogParamA>
;DialogBoxParamA		PROCDESC	WINAPI	:HINSTANCE, :LPCSTR, :HWND, :DLGPROC, :LPARAM
DialogBoxParamA		PROCDESC	WINAPI	:HINSTANCE, :LPCSTR, :HWND, :DWORD, :LPARAM
DialogBoxParam		TEXTEQU	<DialogBoxParamA>
EndDialog		PROCDESC	WINAPI	:HWND, :UINT
GetDlgItem		PROCDESC	WINAPI	:HWND, :UINT
GetDlgItemTextA		PROCDESC	WINAPI	:HWND, :UINT, :LPCSTR, : UINT
GetDlgItemText		TEXTEQU	<GetDlgItemTextA>
SetDlgItemTextA		PROCDESC	WINAPI	:HWND, :SDWORD, :LPCSTR
SetDlgItemText		TEXTEQU	<SetDlgItemTextA>
SendDlgItemMessageA	PROCDESC	WINAPI	:HWND, :UINT, :UINT, :WPARAM, :LPARAM
SendDlgItemMessage	TEXTEQU	<SendDlgItemMessageA>
DefDlgProcA		PROCDESC	WINAPI	:HWND, :UINT, :WPARAM, :LPARAM
DefDlgProc		TEXTEQU	<DefDlgProcA>
DLGWINDOWEXTRA		EQU	00000001Eh

SetFocus		PROCDESC	WINAPI	:HWND
SetTimer		PROCDESC	WINAPI	:HWND, :UINT, :UINT, :PTR DWORD
KillTimer		PROCDESC	WINAPI	:HWND, :UINT
EnableWindow		PROCDESC	WINAPI	:HWND, :BOOL
LoadAcceleratorsA	PROCDESC	WINAPI	:HINSTANCE, :LPCSTR
LoadAccelerators	TEXTEQU	<LoadAcceleratorsA>
TranslateAcceleratorA	PROCDESC	WINAPI	:HWND, :HACCEL, :LPMSG
TranslateAccelerator	TEXTEQU	<TranslateAcceleratorA>

SM_CXSCREEN		EQU	000h
SM_CYSCREEN		EQU	001h
SM_CXFULLSCREEN		EQU	010h
SM_CYFULLSCREEN		EQU	011h
GetSystemMetrics	PROCDESC	WINAPI	:UINT
DrawTextA		PROCDESC	WINAPI	:HDC, :LPCSTR, :UINT, :LPRECT, :UINT
DrawText		TEXTEQU	<DrawTextA>
UpdateWindow		PROCDESC	WINAPI	:HWND
SetForegroundWindow	PROCDESC	WINAPI	:HWND
GetDC			PROCDESC	WINAPI	:HWND
ReleaseDC		PROCDESC	WINAPI	:HWND, :HDC
BeginPaint		PROCDESC	WINAPI	:HWND, :LPPAINTSTRUCT
EndPaint		PROCDESC	WINAPI	:HWND, :LPPAINTSTRUCT
InvalidateRect		PROCDESC	WINAPI	:HWND, :LPRECT, :UINT
InvalidateRgn		PROCDESC	WINAPI	:HWND, :HRGN, :BOOL
GetScrollPos		PROCDESC	WINAPI	:HWND, :UINT
SetWindowTextA		PROCDESC	WINAPI	:HWND, :LPCSTR
SetWindowText		TEXTEQU	<SetWindowTextA>
GetClientRect		PROCDESC	WINAPI	:HWND, :LPRECT
GetWindowRect		PROCDESC	WINAPI	:HWND, :LPRECT

MB_OK			EQU	000h
MB_OKCANCEL		EQU	001h
MB_ABORTRETRYIGNORE	EQU	002h
MB_YESNOCANCEL		EQU	003h
MB_YESNO		EQU	004h
MB_RETRYCANCEL		EQU	005h
;MB_ICONERROR		EQU	010h
;MB_ICONWARNING		EQU	030h
MessageBoxA		PROCDESC	WINAPI	:HWND, :LPCSTR, :LPCSTR, :UINT
MessageBox		TEXTEQU	<MessageBoxA>

COLOR_BACKGROUND	EQU	001h
COLOR_WINDOW		EQU	005h
;COLOR_3DFACE		EQU	00Fh
;COLOR_3DSHADOW		EQU	010h
COLOR_APPWORKSPACE	EQU	00Ch
COLOR_3DLIGHT		EQU	016h
GetSysColor		PROCDESC	WINAPI	:UINT
FillRect		PROCDESC	WINAPI	:HDC, :LPRECT, :HBRUSH
GetWindowLongA		PROCDESC	WINAPI	:HWND, :DWORD
GetWindowLong		TEXTEQU	<GetWindowLongA>
GetDesktopWindow	PROCDESC	WINAPI
FindWindowA		PROCDESC	WINAPI	:LPCSTR, :LPCSTR
FindWindow		TEXTEQU	<FindWindowA>
GetLastActivePopup	PROCDESC	WINAPI	:HWND

MF_POPUP		EQU	00010h
MF_SYSMENU		EQU	02000h
;MFT_SEPARATOR		EQU	00800h

SC_SIZE			EQU	0F000h
SC_MOVE			EQU	0F010h
SC_MINIMIZE		EQU	0F020h
SC_MAXIMIZE		EQU	0F030h
SC_CLOSE		EQU	0F060h
SC_RESTORE		EQU	0F120h

LoadBitmapA		PROCDESC	WINAPI	:HINSTANCE, :LPCSTR
LoadBitmap		TEXTEQU	<LoadBitmapA>
LoadCursorA		PROCDESC	WINAPI	:HINSTANCE, :LPCSTR
LoadCursor		TEXTEQU	<LoadCursorA>
LoadIconA		PROCDESC	WINAPI	:HINSTANCE, :LPCSTR
LoadIcon		TEXTEQU	<LoadIconA>

IMAGE_BITMAP		EQU	00000h
IMAGE_ICON		EQU	00001h
IMAGE_CURSOR		EQU	00002h
LR_LOADTRANSPARENT	EQU	00020h
LR_LOADMAP3DCOLORS	EQU	01000h
LoadImageA		PROCDESC	WINAPI	:HINSTANCE, :LPCSTR, :UINT, :UINT, :UINT, :UINT
LoadImage		TEXTEQU	<LoadImageA>

IDC_ARROW		EQU	07f00h

LoadStringA		PROCDESC	WINAPI	:HINSTANCE, :UINT, :LPCSTR, :UINT
LoadString		TEXTEQU	<LoadStringA>

IDOK			EQU	01h
IDCANCEL		EQU	02h
IDABORT			EQU	03h
IDRETRY			EQU	04h
IDIGNORE		EQU	05h
IDYES			EQU	06h
IDNO			EQU	07h
IDCLOSE			EQU	08h
IDHELP			EQU	09h

ES_LEFT			EQU	000h
ES_MULTILINE		EQU	004h
ES_AUTOVSCROLL		EQU	040h

BM_GETCHECK		EQU	0F0h
BM_SETCHECK		EQU	0F1h
BM_CLICK		EQU	0F5h
BM_SETIMAGE		EQU	0F7h

BST_UNCHECKED		EQU	00h
BST_CHECKED		EQU	01h
BST_INDETERMINATE	EQU	02h

SS_LEFT			EQU	00h
SS_CENTER		EQU	01h
SS_RIGHT		EQU	02h
SS_ICON			EQU	03h
SS_BLACKFRAME		EQU	07h

IsDialogMessageA	PROCDESC	WINAPI	:HWND, :LPMSG
IsDialogMessage		TEXTEQU	<IsDialogMessageA>

DS_MODALFRAME		EQU	0080h
DS_NOIDLEMSG		EQU	0100h
DS_3DLOOK		EQU	0004h

HELP_CONTEXT		EQU	01h
HELP_QUIT		EQU	02h
HELP_INDEX		EQU	03h
HELP_CONTENTS		EQU	03h
HELP_HELPONHELP		EQU	04h
HELP_CONTEXTMENU	EQU	0Ah
HELP_FINDER		EQU	0Bh
HELP_WM_HELP		EQU	0Ch

WinHelpA		PROCDESC	WINAPI	:HWND, :LPCSTR, :UINT, :DWORD
WinHelp			TEXTEQU	<WinHelpA>


;*******************************************************************************
;*	COMDLG32.LIB	COMMDLG.H	****************************************
;*******************************************************************************

OPENFILENAMEA		STRUCT
	op_lStructSize	DWORD		?
	op_hwndOwner	HWND		?
	op_hInstance	HINSTANCE	?
	op_lpstrFilter	LPCSTR		?
	op_lpstrCustomFilter LPSTR		?
	op_nMaxCustFilter	DWORD		?
	op_nFilterIndex	DWORD		?
	op_lpstrFile	LPSTR		?
	op_nMaxFile	DWORD		?
	op_lpstrFileTitle	LPSTR		?
	op_nMaxFileTitle	DWORD		?
	op_lpstrInitialDir	LPCSTR		?
	op_lpstrTitle	LPCSTR		?
	op_Flags		DWORD		?
	op_nFileOffset	WORD		?
	op_nFileExtension	WORD		?
	op_lpstrDefExt	LPCSTR		?
	op_lCustData	LPARAM		?
	op_lpfnHook	DWORD		?
	op_lpTemplateName	LPCSTR		?
OPENFILENAMEA		ENDS
LPOPENFILENAME		TYPEDEF	PTR OPENFILENAMEA

GetOpenFileNameA	PROCDESC	WINAPI	:LPOPENFILENAME
GetOpenFileName		TEXTEQU	<GetOpenFileNameA>
GetSaveFileNameA	PROCDESC	WINAPI	:LPOPENFILENAME
GetSaveFileName		TEXTEQU	<GetSaveFileNameA>

OFN_READONLY		EQU	00000001h
OFN_OVERWRITEPROMPT	EQU	00000002h
OFN_HIDEREADONLY	EQU	00000004h
OFN_NOCHANGEDIR		EQU	00000008h
OFN_SHOWHELP		EQU	00000010h
OFN_ENABLEHOOK		EQU	00000020h
OFN_ENABLETEMPLATE	EQU	00000040h
OFN_ENABLETEMPLATEHANDLE EQU	00000080h
OFN_NOVALIDATE		EQU	00000100h
OFN_ALLOWMULTISELECT	EQU	00000200h
OFN_EXTENSIONDIFFERENT	EQU	00000400h
OFN_PATHMUSTEXIST	EQU	00000800h
OFN_FILEMUSTEXIST	EQU	00001000h
OFN_CREATEPROMPT	EQU	00002000h
OFN_SHAREAWARE		EQU	00004000h
OFN_NOREADONLYRETURN	EQU	00008000h
OFN_NOTESTFILECREATE	EQU	00010000h
OFN_NONETWORKBUTTON	EQU	00020000h
OFN_NOLONGNAMES		EQU	00040000h
OFN_EXPLORER		EQU	00080000h
OFN_NODEREFERENCELINKS	EQU	00100000h
OFN_LONGNAMES		EQU	00200000h

PRINTDLGA		STRUCT
	pr_lStructSize	DWORD	?
	pr_hwndOwner	HWND	?
	pr_hDevMode	HGLOBAL	?
	pr_hDevNames	HGLOBAL	?
	pr_hDC		HDC	?
	pr_Flags		DWORD	?
	pr_nFromPage	WORD	?
	pr_nToPage		WORD	?
	pr_nMinPage	WORD	?
	pr_nMaxPage	WORD	?
	pr_nCopies		WORD	?
	pr_hInstance	HINSTANCE ?
	pr_lCustData	DWORD	?
	pr_lpfnPrintHook	DWORD	?
	pr_lpfnSetupHook	DWORD	?
	pr_lpPrintTemplateName LPCSTR ?
	pr_lpSetupTemplateName LPCSTR ?
	pr_hPrintTemplate	HGLOBAL	?
	pr_hSetupTemplate	HGLOBAL	?
PRINTDLGA		ENDS
LPPRINTDLG		TYPEDEF	PTR PRINTDLGA

PrintDlg		PROCDESC	WINAPI	:LPPRINTDLG

PD_ALLPAGES		EQU	00000h
PD_SELECTION		EQU	00001h
PD_PAGENUMS		EQU	00002h
PD_NOSELECTION		EQU	00004h
PD_NOPAGENUMS		EQU	00008h
PD_COLLATE		EQU	00010h
PD_PRINTTOFILE		EQU	00020h
PD_PRINTSETUP		EQU	00040h
PD_NOWARNING		EQU	00080h
PD_RETURNDC		EQU	00100h
PD_RETURNIC		EQU	00200h
PD_RETURNDEFAULT	EQU	00400h
PD_SHOWHELP		EQU	00800h
PD_ENABLEPRINTHOOK	EQU	01000h
PD_ENABLESETUPHOOK	EQU	02000h
PD_ENABLEPRINTTEMPLATE	EQU	04000h
PD_ENABLESETUPTEMPLATE	EQU	08000h
PD_ENABLEPRINTTEMPLATEHANDLE	EQU	0010000h
PD_ENABLESETUPTEMPLATEHANDLE	EQU	0020000h
PD_USEDEVMODECOPIES		EQU	0040000h
PD_USEDEVMODECOPIESANDCOLLATE	EQU	0040000h
PD_DISABLEPRINTTOFILE		EQU	0080000h
PD_HIDEPRINTTOFILE		EQU	0100000h
PD_NONETWORKBUTTON		EQU	0200000h

CommDlgExtendedError	PROCDESC	WINAPI

PAGESETUPDLGA		STRUCT
	pa_lStructSize	DWORD	?
	pa_hwndOwner	HWND	?
	pa_hDevMode	HGLOBAL	?
	pa_hDevNames	HGLOBAL	?
	pa_Flags		DWORD	?
	pa_ptPaperSize	POINT	<>
	pa_rtMinMargin	RECT	<>
	pa_rtMargin	RECT	<>
	pa_hInstance	HINSTANCE ?
	pa_lCustData	LPARAM	?
	pa_lpfnPageSetupHook	DWORD	?
	pa_lpfnPagePaintHook	DWORD	?
	pa_lpPageSetupTemplateName LPCSTR	?
	pa_hPageSetupTemplate	HGLOBAL	?
PAGESETUPDLGA		ENDS
LPPAGESETUPDLG		TYPEDEF	PTR PAGESETUPDLGA

PageSetupDlg		PROCDESC	WINAPI	:LPPAGESETUPDLG

PSD_DEFAULTMINMARGINS		EQU	0000000h
PSD_MINMARGINS			EQU	0000001h
PSD_MARGINS			EQU	0000002h
PSD_INTHOUSANDTHSOFINCHES	EQU	0000004h
PSD_INHUNDREDTHSOFMILLIMETERS	EQU	0000008h
PSD_DISABLEMARGINS		EQU	0000010h
PSD_DISABLEPRINTER		EQU	0000020h
PSD_NOWARNING			EQU	0000080h
PSD_DISABLEORIENTATION		EQU	0000100h
PSD_DISABLEPAPER		EQU	0000200h
PSD_RETURNDEFAULT		EQU	0000400h
PSD_SHOWHELP			EQU	0000800h
PSD_ENABLEPAGESETUPHOOK		EQU	0002000h
PSD_ENABLEPAGESETUPTEMPLATE	EQU	0008000h
PSD_ENABLEPAGESETUPTEMPLATEHANDLE EQU	0020000h
PSD_ENABLEPAGEPAINTHOOK		EQU	0040000h
PSD_DISABLEPAGEPAINTING		EQU	0080000h
PSD_NONETWORKBUTTON		EQU	0200000h


;*******************************************************************************
;*	COMCTL32.LIB	COMMCTRL.H	****************************************
;*******************************************************************************

InitCommonControls	PROCDESC	WINAPI


CreateToolbarEx		PROCDESC	WINAPI	:HWND, :DWORD, :UINT, :SDWORD,\
					:HINSTANCE, :UINT, :LPCTBBUTTON,\
					:SDWORD, :SDWORD, :SDWORD,\
					:SDWORD, :SDWORD, :UINT
TBSTATE_ENABLED		EQU	4h
TBSTYLE_BUTTON		EQU	0h
TBSTYLE_SEP		EQU	1h
TBSTYLE_TOOLTIPS	EQU	0100h

TB_ADDBITMAP		EQU	WM_USER + 13h


HINST_COMMCTRL		EQU	-1h
IDB_STD_SMALL_COLOR	EQU	00h

STD_CUT			EQU	00h
STD_COPY		EQU	01h
STD_PASTE		EQU	02h
STD_UNDO		EQU	03h
STD_REDOW		EQU	04h
STD_DELETE		EQU	05h
STD_FILENEW		EQU	06h
STD_FILEOPEN		EQU	07h
STD_FILESAVE		EQU	08h
STD_PRINTPRE		EQU	09h
STD_PROPERTIES		EQU	0Ah
STD_HELP		EQU	0Bh
STD_FIND		EQU	0Ch
STD_REPLACE		EQU	0Dh
STD_PRINT		EQU	0Eh

TTN_FIRST		EQU	-520
TTN_NEEDTEXT		EQU	TTN_FIRST - 0

TOOLTIPTEXTA		STRUCT
	hdr		NMHDR	<>
	lpszText	LPSTR	?
	szText		SBYTE	80 DUP (?)
	hinst		HINSTANCE ?
	uFlags		UINT	?
TOOLTIPTEXTA		ENDS
LPTOOLTIPTEXT		TYPEDEF	PTR TOOLTIPTEXTA
TOOLTIPTEXT		TEXTEQU	<TOOLTIPTEXTA>

CreateStatusWindow	PROCDESC	WINAPI	:LONG, :LPCSTR, :HWND, :UINT

SB_SETTEXTA		EQU	(WM_USER+1)
SB_SETTEXT		EQU	SB_SETTEXTA
SB_SIMPLE		EQU	(WM_USER+9)
SBT_NOBORDERS		EQU	0100h
SBT_POPOUT		EQU	0200h

TBM_GETPOS		EQU	(WM_USER)
TBM_SETPOS		EQU	(WM_USER+5)
TBM_SETRANGE		EQU	(WM_USER+6)
TBM_SETTICFREQ		EQU	(WM_USER+20)
TBM_SETPAGESIZE		EQU	(WM_USER+21)
TB_LINEUP		EQU	00h
TB_LINEDOWN		EQU	01h
TB_PAGEUP		EQU	02h
TB_PAGEDOWN		EQU	03h
TB_THUMBPOSITION	EQU	04h
TB_THUMBTRACK		EQU	05h
TB_TOP			EQU	06h
TB_BOTTOM		EQU	07h
TB_ENDTRACK		EQU	08h

UDM_SETRANGE		EQU	(WM_USER+101)
UDM_SETPOS		EQU	(WM_USER+103)
UDM_GETPOS		EQU	(WM_USER+104)



;............................
;Added 21 Feb 97

IDI_APPLICATION EQU	32512
IDI_HAND EQU	   32513
IDI_QUESTION EQU	   32514
IDI_EXCLAMATION	EQU   32515
IDI_ASTERISK EQU	   32516

MB_ICONHAND EQU		    00000010h
MB_ICONQUESTION	EQU	   00000020h
MB_ICONEXCLAMATION EQU	   00000030h
MB_ICONASTERISK	EQU	   00000040h

;taken from WINGDI.H:
OEM_FIXED_FONT	   EQU 10
ANSI_FIXED_FONT	  EQU 11
ANSI_VAR_FONT	  EQU 12
SYSTEM_FONT	  EQU 13
DEVICE_DEFAULT_FONT EQU 14
DEFAULT_PALETTE	  EQU 15
SYSTEM_FIXED_FONT   EQU	 16


MessageBeep PROCDESC WINAPI :DWORD

MINMAXINFO struc
  res_x               dd ?
  res_y               dd ?
  maxsize_x           dd ?
  maxsize_y           dd ?
  maxposition_x       dd ?
  maxposition_y       dd ?
  mintrackposition_x  dd ?
  mintrackposition_y  dd ?
  maxtrackposition_x  dd ?
  maxtrackposition_y  dd ?
MINMAXINFO ends


;*******************************************************************
;
;  Window Class structure
;
;*******************************************************************

WNDCLASS struc
        clsStyle          UINT     ?
        clsLpfnWndProc    ULONG    ?
        clsCbClsExtra     UINT     ?
        clsCbWndExtra     UINT     ?
        clsHInstance      UINT     ?
        clsHIcon          UINT     ?
        clsHCursor        UINT     ?
        clsHbrBackground  UINT     ?
        clsLpszMenuName   ULONG    ?
        clsLpszClassName  ULONG    ?
                hIconSm           UINT     ?
WNDCLASS ends
