#! /usr/bin/python

import cherrypy
import sys

server_port = int(sys.argv[1])

class Server(object):
  i = 0

  def next_url(self):
    self.i += 1
    return 'http://evil{}.com:{}/'.format(self.i % 4, server_port)

  @cherrypy.expose
  def webgl(self):
    cherrypy.response.headers['Cache-Control'] = 'no-store'
    cherrypy.response.headers['Content-Type'] = 'text/html'
    with open('webgl.html', 'r') as tmp:
      return tmp.read()

  @cherrypy.expose
  def index(self):
    cherrypy.response.headers['Cache-Control'] = 'no-store'
    cherrypy.response.headers['Content-Type'] = 'text/html'
    cherrypy.response.headers['Set-Cookie'] = 'NextUrl={}'.format(self.next_url())
    with open('index.html', 'r') as tmp:
      return tmp.read()


if __name__ == '__main__':
  cherrypy.config.update({'server.socket_port':server_port, 'server.socket_host':'0.0.0.0'})
  cherrypy.quickstart(Server())
