


#define UNICODE
#define _UNICODE

#include <tchar.h>
#include <windows.h>
#include <winnt.h>
#include "../misc/ntdll.h"

#include <stdio.h>
#include <stdlib.h>


void
server (const TCHAR *name)
{
    HANDLE hPort;
    OBJECT_ATTRIBUTES obj;
    UNICODE_STRING str;
    NTSTATUS rc;
    unsigned char rep_buff[200];
    unsigned char req_buff[200];
    PLPC_MESSAGE req = (PLPC_MESSAGE) req_buff;
    PLPC_MESSAGE rep = (PLPC_MESSAGE) rep_buff;

    /* create */
    RtlInitUnicodeString (&str, name);
    InitializeObjectAttributes (&obj, &str, 0, 0, 0);
    rc = NtCreatePort (&hPort, &obj, 0, sizeof (rep_buff) - sizeof (*rep), 0);
    if (rc < 0) {
        _ftprintf (stderr, _T ("NtCreatePort failed: 0x%x\n"), rc);
        exit (1);
    }
    /* loop */
    while (1) {
        rc = NtReplyWaitReceivePort (hPort, 0, 0, rep);
        if (rc < 0) {
            _ftprintf (stderr, _T ("NtReplyWaitReceivePort failed: 0x%x\n"),
                       rc);
            continue;
        }

        _ftprintf (stdout, _T ("Received msg:\n"));
        _ftprintf (stdout, _T ("   Type: %d:\n"), rep->MsgType);
        _ftprintf (stdout, _T ("   Pid: %d:\n"), rep->Cid.pid);
        _ftprintf (stdout, _T ("   Tid: %d:\n"), rep->Cid.tid);
        _ftprintf (stdout, _T ("   Mid: %d:\n"), rep->Mid);
        _ftprintf (stdout, _T ("   Cid: %d:\n"), rep->CallbackId);

        if (rep->MsgType == LPC_CONN_REQ) {
            HANDLE hNewPort;

            Sleep (20000);

            rc = NtAcceptConnectPort (&hNewPort, 0, rep, 1, NULL, NULL);
            if (rc >= 0) {
                _ftprintf (stderr, _T ("NtAcceptConnectPort succeeded\n"));
                rc = NtCompleteConnectPort (hNewPort);
                if (rc < 0) {
                    _ftprintf (stderr,
                               _T ("NtCompleteConnectPort failed: 0x%x\n"),
                               rc);
                } else {
                    _ftprintf (stderr, _T ("NtCompleteConnectPort succeeded\n"));
                }
            } else {
                _ftprintf (stderr,
                           _T ("NtAcceptConnectPort failed: 0x%x\n"),
                           rc);
            }
        } else {
            Sleep (20000);

            rc = NtReplyPort (hPort, rep);
            if (rc < 0) {
                _ftprintf (stderr, _T ("NtReplyPort failed: 0x%x\n"),
                           rc);
            } else {
                _ftprintf (stderr, _T ("NtReplyPort succeeded\n"));
            }
        }
    }
}


void
server1 ()
{
    NTSTATUS rc;
    unsigned char rep_buff[200];
    unsigned char req_buff[200];
    PLPC_MESSAGE req = (PLPC_MESSAGE) req_buff;
    PLPC_MESSAGE rep = (PLPC_MESSAGE) rep_buff;
    HANDLE hNewPort;
    int pid, tid, mid;

    _ftprintf (stdout, _T ("Enter pid, tid, mid:\n"));
    _ftscanf (stdin, _T ("%d, %d, %d"),
              &pid, &tid, &mid);

    rep->MsgType = LPC_CONN_REQ;
    rep->Cid.pid = pid;
    rep->Cid.tid = tid;
    rep->Mid = mid;

    rc = NtAcceptConnectPort (&hNewPort, 0, rep, 1, NULL, NULL);
    if (rc >= 0) {
        _ftprintf (stderr, _T ("NtAcceptConnectPort succeeded\n"));
        rc = NtCompleteConnectPort (hNewPort);
        if (rc < 0) {
            _ftprintf (stderr,
                       _T ("NtCompleteConnectPort failed: 0x%x\n"),
                       rc);
        } else {
            _ftprintf (stderr, _T ("NtCompleteConnectPort succeeded\n"));
        }
    } else {
        _ftprintf (stderr,
                   _T ("NtAcceptConnectPort failed: 0x%x\n"),
                   rc);
    }
}


void
server2 (const TCHAR *name)
{
    HANDLE hPort;
    OBJECT_ATTRIBUTES obj;
    UNICODE_STRING str;
    NTSTATUS rc;
    unsigned char rep_buff[200];
    unsigned char req_buff[200];
    PLPC_MESSAGE req = (PLPC_MESSAGE) req_buff;
    PLPC_MESSAGE rep = (PLPC_MESSAGE) rep_buff;

    /* create */
    RtlInitUnicodeString (&str, name);
    InitializeObjectAttributes (&obj, &str, 0, 0, 0);
    rc = NtCreatePort (&hPort, &obj, 0, sizeof (rep_buff) - sizeof (*rep), 0);
    if (rc < 0) {
        _ftprintf (stderr, _T ("NtCreatePort failed: 0x%x\n"), rc);
        exit (1);
    }
    /* loop */
    while (1) {
        rc = NtReplyWaitReceivePort (hPort, 0, 0, rep);
        if (rc < 0) {
            _ftprintf (stderr, _T ("NtReplyWaitReceivePort failed: 0x%x\n"),
                       rc);
            continue;
        }

        _ftprintf (stdout, _T ("Received msg:\n"));
        _ftprintf (stdout, _T ("   Type: %d:\n"), rep->MsgType);
        _ftprintf (stdout, _T ("   Pid: %d:\n"), rep->Cid.pid);
        _ftprintf (stdout, _T ("   Tid: %d:\n"), rep->Cid.tid);
        _ftprintf (stdout, _T ("   Mid: %d:\n"), rep->Mid);

        Sleep (20000);

        rc = NtReplyPort (hPort, rep);
        if (rc < 0) {
            _ftprintf (stderr, _T ("NtReplyPort failed: 0x%x\n"),
                       rc);
        } else {
            _ftprintf (stderr, _T ("NtReplyPort succeeded\n"));
        }
    }
}


void
server3 (const TCHAR *name)
{
    HANDLE hPort;
    OBJECT_ATTRIBUTES obj;
    UNICODE_STRING str;
    NTSTATUS rc;
    unsigned char rep_buff[200];
    unsigned char req_buff[200];
    PLPC_MESSAGE req = (PLPC_MESSAGE) req_buff;
    PLPC_MESSAGE rep = (PLPC_MESSAGE) rep_buff;
    int pid, tid, mid;

    /* create */
    RtlInitUnicodeString (&str, name);
    InitializeObjectAttributes (&obj, &str, 0, 0, 0);
    rc = NtCreatePort (&hPort, &obj, 0, sizeof (rep_buff) - sizeof (*rep), 0);
    if (rc < 0) {
        _ftprintf (stderr, _T ("NtCreatePort failed: 0x%x\n"), rc);
        exit (1);
    }

    _ftprintf (stdout, _T ("Enter pid, tid, mid:\n"));
    _ftscanf (stdin, _T ("%d, %d, %d"),
              &pid, &tid, &mid);

    rep->DataSize = 0;
    rep->MsgSize = sizeof (*rep);
    rep->MsgType = LPC_REQUEST;
    rep->Cid.pid = pid;
    rep->Cid.tid = tid;
    rep->Mid = mid;

    rc = NtReplyPort (hPort, rep);
    if (rc < 0) {
        _ftprintf (stderr, _T ("NtReplyPort failed: 0x%x\n"),
                   rc);
    } else {
        _ftprintf (stderr, _T ("NtReplyPort succeeded\n"));
    }
}


void
server4 (const TCHAR *name)
{
    HANDLE hPort;
    HANDLE hNewPort;
    OBJECT_ATTRIBUTES obj;
    UNICODE_STRING str;
    NTSTATUS rc;
    unsigned char rep_buff[200];
    unsigned char req_buff[200];
    PLPC_MESSAGE req = (PLPC_MESSAGE) req_buff;
    PLPC_MESSAGE rep = (PLPC_MESSAGE) rep_buff;
    int count = 0;

    /* create */
    RtlInitUnicodeString (&str, name);
    InitializeObjectAttributes (&obj, &str, 0, 0, 0);
    rc = NtCreatePort (&hPort, &obj, 0, sizeof (rep_buff) - sizeof (*rep), 0);
    if (rc < 0) {
        _ftprintf (stderr, _T ("NtCreatePort failed: 0x%x\n"), rc);
        exit (1);
    }
    /* loop */
    while (1) {
        rc = NtReplyWaitReceivePort (hPort, 0, 0, rep);
        if (rc < 0) {
            _ftprintf (stderr, _T ("NtReplyWaitReceivePort failed: 0x%x\n"),
                       rc);
            continue;
        }
        _ftprintf (stdout, _T ("Received msg:\n"));
        _ftprintf (stdout, _T ("   Type: %d:\n"), rep->MsgType);
        _ftprintf (stdout, _T ("   Pid: %d:\n"), rep->Cid.pid);
        _ftprintf (stdout, _T ("   Tid: %d:\n"), rep->Cid.tid);
        _ftprintf (stdout, _T ("   Mid: %d:\n"), rep->Mid);
        _ftprintf (stdout, _T ("   Callbackid: %d:\n"), rep->CallbackId);

        if (rep->MsgType == LPC_CONN_REQ) {

            rc = NtAcceptConnectPort (&hNewPort, 0, rep, 1, NULL, NULL);
            if (rc >= 0) {
                _ftprintf (stderr, _T ("NtAcceptConnectPort succeeded\n"));
                rc = NtCompleteConnectPort (hNewPort);
                if (rc < 0) {
                    _ftprintf (stderr,
                               _T ("NtCompleteConnectPort failed: 0x%x\n"),
                               rc);
                } else {
                    _ftprintf (stderr, _T ("NtCompleteConnectPort succeeded\n"));
                }
            } else {
                _ftprintf (stderr,
                           _T ("NtAcceptConnectPort failed: 0x%x\n"),
                           rc);
            }
        } else {
            unsigned long pid, tid, mid, callback_id;
            unsigned long save_pid, save_tid, save_mid, save_callback_id;

            _ftprintf (stdout, _T ("Enter pid, tid, mid, callback_id:\n"));
            _ftscanf (stdin, _T ("%d, %d, %d, %d"),
                      &pid, &tid, &mid, &callback_id);

            save_pid = rep->Cid.pid;
            save_tid = rep->Cid.tid;
            save_mid = rep->Mid;
            save_callback_id = rep->CallbackId;

            rep->Cid.pid = pid;
            rep->Cid.tid = tid;
            rep->Mid = mid;
            rep->CallbackId = callback_id;
            
            rc = NtImpersonateClientOfPort (hNewPort, rep);
            if (rc < 0) {
                _ftprintf (stderr,
                           _T ("NtImpersonateClientOfPort failed: 0x%x\n"),
                           rc);
            } else {
                _ftprintf (stderr, _T ("NtImpersonateClientOfPort succeeded\n"));
            }

            rep->Cid.pid = save_pid;
            rep->Cid.tid = save_tid;
            rep->Mid = save_mid;
            rep->CallbackId = save_callback_id;
            
            rc = NtReplyPort (hPort, rep);
            if (rc < 0) {
                _ftprintf (stderr, _T ("NtReplyPort failed: 0x%x\n"),
                           rc);
            } else {
                _ftprintf (stderr, _T ("NtReplyPort succeeded\n"));
            }
        }
    }
}


void
server4b (const TCHAR *name)
{
    HANDLE hPort;
    OBJECT_ATTRIBUTES obj;
    UNICODE_STRING str;
    NTSTATUS rc;
    unsigned char rep_buff[200];
    unsigned char req_buff[200];
    PLPC_MESSAGE req = (PLPC_MESSAGE) req_buff;
    PLPC_MESSAGE rep = (PLPC_MESSAGE) rep_buff;

    /* create */
    RtlInitUnicodeString (&str, name);
    InitializeObjectAttributes (&obj, &str, 0, 0, 0);
    rc = NtCreatePort (&hPort, &obj, 0, sizeof (rep_buff) - sizeof (*rep), 0);
    if (rc < 0) {
        _ftprintf (stderr, _T ("NtCreatePort failed: 0x%x\n"), rc);
        exit (1);
    }
    /* loop */
    while (1) {
        rc = NtReplyWaitReceivePort (hPort, 0, 0, rep);
        if (rc < 0) {
            _ftprintf (stderr, _T ("NtReplyWaitReceivePort failed: 0x%x\n"),
                       rc);
            continue;
        }

        _ftprintf (stdout, _T ("Received msg:\n"));
        _ftprintf (stdout, _T ("   Type: %d:\n"), rep->MsgType);
        _ftprintf (stdout, _T ("   Pid: %d:\n"), rep->Cid.pid);
        _ftprintf (stdout, _T ("   Tid: %d:\n"), rep->Cid.tid);
        _ftprintf (stdout, _T ("   Mid: %d:\n"), rep->Mid);
        _ftprintf (stdout, _T ("   Cid: %d:\n"), rep->CallbackId);

        if (rep->MsgType == LPC_CONN_REQ) {
            HANDLE hNewPort;

            rc = NtAcceptConnectPort (&hNewPort, 0, rep, 1, NULL, NULL);
            if (rc >= 0) {
                _ftprintf (stderr, _T ("NtAcceptConnectPort succeeded\n"));
                rc = NtCompleteConnectPort (hNewPort);
                if (rc < 0) {
                    _ftprintf (stderr,
                               _T ("NtCompleteConnectPort failed: 0x%x\n"),
                               rc);
                } else {
                    _ftprintf (stderr, _T ("NtCompleteConnectPort succeeded\n"));
                }
            } else {
                _ftprintf (stderr,
                           _T ("NtAcceptConnectPort failed: 0x%x\n"),
                           rc);
            }
        } else {
            rc = NtReplyWaitReplyPort (hPort, rep);
            if (rc < 0) {
                _ftprintf (stderr, _T ("NtReplyWaitReplyPort failed: 0x%x\n"),
                           rc);
            } else {
                _ftprintf (stderr, _T ("NtReplyWaitReplyPort succeeded\n"));
            }
        }
    }
}


void
server5a (const TCHAR *name)
{
    HANDLE hPort;
    HANDLE hNewPort;
    OBJECT_ATTRIBUTES obj;
    UNICODE_STRING str;
    NTSTATUS rc;
    unsigned char rep_buff[200];
    unsigned char req_buff[200];
    PLPC_MESSAGE req = (PLPC_MESSAGE) req_buff;
    PLPC_MESSAGE rep = (PLPC_MESSAGE) rep_buff;
    int count = 0;

    /* create */
    RtlInitUnicodeString (&str, name);
    InitializeObjectAttributes (&obj, &str, 0, 0, 0);
    rc = NtCreatePort (&hPort, &obj, 0, sizeof (rep_buff) - sizeof (*rep), 0);
    if (rc < 0) {
        _ftprintf (stderr, _T ("NtCreatePort failed: 0x%x\n"), rc);
        exit (1);
    }
    /* loop */
    while (1) {
        rc = NtReplyWaitReceivePort (hPort, 0, 0, rep);
        if (rc < 0) {
            _ftprintf (stderr, _T ("NtReplyWaitReceivePort failed: 0x%x\n"),
                       rc);
            continue;
        }
        _ftprintf (stdout, _T ("Received msg:\n"));
        _ftprintf (stdout, _T ("   Type: %d:\n"), rep->MsgType);
        _ftprintf (stdout, _T ("   Pid: %d:\n"), rep->Cid.pid);
        _ftprintf (stdout, _T ("   Tid: %d:\n"), rep->Cid.tid);
        _ftprintf (stdout, _T ("   Mid: %d:\n"), rep->Mid);
        _ftprintf (stdout, _T ("   Cid: %d:\n"), rep->CallbackId);

        if (rep->MsgType == LPC_CONN_REQ) {

            rc = NtAcceptConnectPort (&hNewPort, 0, rep, 1, NULL, NULL);
            if (rc >= 0) {
                _ftprintf (stderr, _T ("NtAcceptConnectPort succeeded\n"));
                rc = NtCompleteConnectPort (hNewPort);
                if (rc < 0) {
                    _ftprintf (stderr,
                               _T ("NtCompleteConnectPort failed: 0x%x\n"),
                               rc);
                } else {
                    _ftprintf (stderr, _T ("NtCompleteConnectPort succeeded\n"));
                }
            } else {
                _ftprintf (stderr,
                           _T ("NtAcceptConnectPort failed: 0x%x\n"),
                           rc);
            }
        } else {
            unsigned long data[3];

            Sleep (20000);
            
            rc = NtReadRequestData (hPort, rep, 0, data, sizeof (data), NULL);
            if (rc < 0) {
                _ftprintf (stderr, _T ("NtReadRequestData failed: 0x%x\n"),
                           rc);
            } else {
                _ftprintf (stderr, _T ("NtReadRequestData succeeded\n"));
                _ftprintf (stderr, _T ("data[0] = 0x%x\n"), data[0]);
                _ftprintf (stderr, _T ("data[1] = 0x%x\n"), data[1]);
                _ftprintf (stderr, _T ("data[2] = 0x%x\n"), data[2]);
            }

            data[0] = 0xdeadbabe;
            data[1] = 0xcafebeef;
            data[2] = 0xdeafface;
            rc = NtWriteRequestData (hPort, rep, 0, data, sizeof (data), NULL);
            if (rc < 0) {
                _ftprintf (stderr, _T ("NtWriteRequestData failed: 0x%x\n"),
                           rc);
            } else {
                _ftprintf (stderr, _T ("NtWriteRequestData succeeded\n"));
            }

            rc = NtReplyPort (hPort, rep);
            if (rc < 0) {
                _ftprintf (stderr, _T ("NtReplyPort failed: 0x%x\n"),
                           rc);
            } else {
                _ftprintf (stderr, _T ("NtReplyPort succeeded\n"));
            }
        }
    }
}


unsigned long saved_mids[10000];
unsigned int num_saved;

void
server5b (const TCHAR *name)
{
    HANDLE hPort;
    OBJECT_ATTRIBUTES obj;
    UNICODE_STRING str;
    NTSTATUS rc;
    unsigned char rep_buff[200];
    PLPC_MESSAGE rep = (PLPC_MESSAGE) rep_buff;

    /* create */
    RtlInitUnicodeString (&str, name);
    InitializeObjectAttributes (&obj, &str, 0, 0, 0);
    rc = NtCreatePort (&hPort, &obj, 0, sizeof (rep_buff) - sizeof (*rep), 0);
    if (rc < 0) {
        _ftprintf (stderr, _T ("NtCreatePort failed: 0x%x\n"), rc);
        exit (1);
    }
    /* loop */
    while (1) {
        rc = NtReplyWaitReceivePort (hPort, 0, 0, rep);
        if (rc < 0) {
            _ftprintf (stderr, _T ("NtReplyWaitReceivePort failed: 0x%x\n"),
                       rc);
            continue;
        }

        if (rep->MsgType == LPC_CONN_REQ) {
            HANDLE hNewPort;

            rc = NtAcceptConnectPort (&hNewPort, 0, rep, 1, NULL, NULL);
            if (rc >= 0) {
                _ftprintf (stderr, _T ("NtAcceptConnectPort succeeded\n"));
                rc = NtCompleteConnectPort (hNewPort);
                if (rc < 0) {
                    _ftprintf (stderr,
                               _T ("NtCompleteConnectPort failed: 0x%x\n"),
                               rc);
                } else {
                    _ftprintf (stderr, _T ("NtCompleteConnectPort succeeded\n"));
                }
            } else {
                _ftprintf (stderr,
                           _T ("NtAcceptConnectPort failed: 0x%x\n"),
                           rc);
            }
        } else {
            if (rep->DataSize != 0xc) {
                break;
            }
            if (num_saved < sizeof (saved_mids) / sizeof (saved_mids[0])) {
                saved_mids[num_saved++] = rep->Mid;
                rep->CallbackId++;
            }
            rc = NtReplyPort (hPort, rep);
            if (rc < 0) {
                _ftprintf (stderr, _T ("NtReplyPort failed: 0x%x\n"),
                           rc);
            }
        }
    }

    while (1) {
        unsigned long data[100];
        unsigned long pid, tid, mid, callback_id;
        unsigned char req_buff[200];
        PLPC_MESSAGE req = (PLPC_MESSAGE) req_buff;
        unsigned char *pMsgData = (unsigned char *)req + sizeof (*req);

        memset (req, 0, sizeof (*req));
        memset (data, 0, sizeof (data));

        _ftprintf (stdout, _T ("Enter pid, tid, mid, callback_id:\n"));
        _ftscanf (stdin, _T ("%d, %d, %d, %d"),
                  &pid, &tid, &mid, &callback_id);

        req->DataSize = 0xc;
        req->MsgSize = req->DataSize + sizeof (*req);
        req->MsgType = LPC_REQUEST;
        req->VirtRangOff = sizeof (*req);
        req->Cid.pid = pid;
        req->Cid.tid = tid;
        req->Mid = mid;
        req->CallbackId = callback_id;

        *(unsigned long *)pMsgData = 1;
        *((unsigned long *)pMsgData+1) = 0x7ffdf000;
        *((unsigned long *)pMsgData+2) = sizeof (data);

        rc = NtReadRequestData (hPort, req, 0, data, sizeof (data), NULL);
        if (rc < 0) {
            _ftprintf (stderr, _T ("NtReadRequestData failed: 0x%x\n"),
                       rc);
        } else {
            _ftprintf (stderr, _T ("NtReadRequestData succeeded\n"));
            _ftprintf (stderr, _T ("data[0] = 0x%x\n"), data[0]);
            _ftprintf (stderr, _T ("data[1] = 0x%x\n"), data[1]);
            _ftprintf (stderr, _T ("data[2] = 0x%x\n"), data[2]);
        }

        data[0] = 0xdeadbabe;
        data[1] = 0xcafebeef;
        data[2] = 0xdeafface;
        rc = NtWriteRequestData (hPort, req, 0, data, sizeof (data), NULL);
        if (rc < 0) {
            _ftprintf (stderr, _T ("NtWriteRequestData failed: 0x%x\n"),
                       rc);
        } else {
            _ftprintf (stderr, _T ("NtWriteRequestData succeeded\n"));
        }
    }
}


void
server5b_2 (const TCHAR *name)
{
    HANDLE hPort;
    OBJECT_ATTRIBUTES obj;
    UNICODE_STRING str;
    NTSTATUS rc;
    unsigned char rep_buff[200];
    unsigned char req_buff[200];
    PLPC_MESSAGE req = (PLPC_MESSAGE) req_buff;
    PLPC_MESSAGE rep = (PLPC_MESSAGE) rep_buff;
    int count = 0;

    /* create */
    RtlInitUnicodeString (&str, name);
    InitializeObjectAttributes (&obj, &str, 0, 0, 0);
    rc = NtCreatePort (&hPort, &obj, 0, sizeof (rep_buff) - sizeof (*rep), 0);
    if (rc < 0) {
        _ftprintf (stderr, _T ("NtCreatePort failed: 0x%x\n"), rc);
        exit (1);
    }
    /* loop */
    while (1) {
        rc = NtReplyWaitReceivePort (hPort, 0, 0, rep);
        if (rc < 0) {
            _ftprintf (stderr, _T ("NtReplyWaitReceivePort failed: 0x%x\n"),
                       rc);
            continue;
        }
        count++;
        if (count % 1000000 == 0) {
            _ftprintf (stdout, _T ("Received msg:\n"));
            _ftprintf (stdout, _T ("   Type: %d:\n"), rep->MsgType);
            _ftprintf (stdout, _T ("   Pid: %d:\n"), rep->Cid.pid);
            _ftprintf (stdout, _T ("   Tid: %d:\n"), rep->Cid.tid);
            _ftprintf (stdout, _T ("   Mid: %d:\n"), rep->Mid);
        }

        if (rep->MsgType == LPC_CONN_REQ) {
            HANDLE hNewPort;

            rc = NtAcceptConnectPort (&hNewPort, 0, rep, 1, NULL, NULL);
            if (rc >= 0) {
                _ftprintf (stderr, _T ("NtAcceptConnectPort succeeded\n"));
                rc = NtCompleteConnectPort (hNewPort);
                if (rc < 0) {
                    _ftprintf (stderr,
                               _T ("NtCompleteConnectPort failed: 0x%x\n"),
                               rc);
                } else {
                    _ftprintf (stderr, _T ("NtCompleteConnectPort succeeded\n"));
                }
            } else {
                _ftprintf (stderr,
                           _T ("NtAcceptConnectPort failed: 0x%x\n"),
                           rc);
            }
        } else {
            rc = NtReplyPort (hPort, rep);
            if (rc < 0) {
                _ftprintf (stderr, _T ("NtReplyPort failed: 0x%x\n"),
                           rc);
            } else {
                if (count % 1000000 == 0) {
                    _ftprintf (stderr, _T ("NtReplyPort succeeded\n"));
                }
            }
        }
    }
}


void
server6 (const TCHAR *name)
{
    HANDLE hPort;
    OBJECT_ATTRIBUTES obj;
    UNICODE_STRING str;
    NTSTATUS rc;
    unsigned char rep_buff[200];
    unsigned char req_buff[200];
    PLPC_MESSAGE req = (PLPC_MESSAGE) req_buff;
    PLPC_MESSAGE rep = (PLPC_MESSAGE) rep_buff;

    /* create */
    RtlInitUnicodeString (&str, name);
    InitializeObjectAttributes (&obj, &str, 0, 0, 0);
    rc = NtCreatePort (&hPort, &obj, 0, sizeof (rep_buff) - sizeof (*rep), 0);
    if (rc < 0) {
        _ftprintf (stderr, _T ("NtCreatePort failed: 0x%x\n"), rc);
        exit (1);
    }
    /* loop */
    while (1) {
        rc = NtReplyWaitReceivePort (hPort, 0, 0, rep);
        if (rc < 0) {
            _ftprintf (stderr, _T ("NtReplyWaitReceivePort failed: 0x%x\n"),
                       rc);
            continue;
        }

        _ftprintf (stdout, _T ("Received msg:\n"));
        _ftprintf (stdout, _T ("   Type: %d:\n"), rep->MsgType);
        _ftprintf (stdout, _T ("   Pid: %d:\n"), rep->Cid.pid);
        _ftprintf (stdout, _T ("   Tid: %d:\n"), rep->Cid.tid);
        _ftprintf (stdout, _T ("   Mid: %d:\n"), rep->Mid);

        if (rep->MsgType == LPC_CONN_REQ) {
            HANDLE hNewPort;

            rc = NtAcceptConnectPort (&hNewPort, 0, rep, 1, NULL, NULL);
            if (rc >= 0) {
                _ftprintf (stderr, _T ("NtAcceptConnectPort succeeded\n"));
                rc = NtCompleteConnectPort (hNewPort);
                if (rc < 0) {
                    _ftprintf (stderr,
                               _T ("NtCompleteConnectPort failed: 0x%x\n"),
                               rc);
                } else {
                    _ftprintf (stderr, _T ("NtCompleteConnectPort succeeded\n"));
                }
            } else {
                _ftprintf (stderr,
                           _T ("NtAcceptConnectPort failed: 0x%x\n"),
                           rc);
            }
        } else {
            rep->CallbackId++;
            rc = NtReplyPort (hPort, rep);
            if (rc < 0) {
                _ftprintf (stderr, _T ("NtReplyPort failed: 0x%x\n"),
                           rc);
            } else {
                _ftprintf (stderr, _T ("NtReplyPort succeeded\n"));
            }
        }
    }
}


void
client (const TCHAR *name)
{
    HANDLE hPort;
    UNICODE_STRING str;
    NTSTATUS rc;
    SECURITY_QUALITY_OF_SERVICE QoS = { sizeof (QoS), 2, 1, 1 };
    unsigned char msg_buf[500];
    unsigned int max_msg_size;
    PLPC_MESSAGE pMsg = (PLPC_MESSAGE) msg_buf;

    RtlInitUnicodeString (&str, name);
    rc = NtConnectPort (&hPort, &str, &QoS, NULL, NULL, &max_msg_size, NULL, NULL);
    if (rc < 0) {
        _ftprintf (stderr, _T ("NtConnectPort failed: 0x%x\n"), rc);
    } else {
        _ftprintf (stderr, _T ("NtConnectPort succeeded\n"));

        memset (pMsg, 0, sizeof (*pMsg));
        pMsg->DataSize = 10;
        pMsg->MsgSize = pMsg->DataSize + sizeof (*pMsg);
        pMsg->MsgType = LPC_NEW_MSG;
        rc = NtRequestWaitReplyPort (hPort, pMsg, pMsg);
        if (rc < 0) {
            _ftprintf (stderr, _T ("NtRequestWaitReplyPort failed: 0x%x\n"), rc);
            exit (1);
        }
        _ftprintf (stderr, _T ("NtRequestWaitReplyPort succeeded\n"));
        _ftprintf (stdout, _T ("Received msg:\n"));
        _ftprintf (stdout, _T ("   Type: %d:\n"), pMsg->MsgType);
        _ftprintf (stdout, _T ("   Pid: %d:\n"), pMsg->Cid.pid);
        _ftprintf (stdout, _T ("   Tid: %d:\n"), pMsg->Cid.tid);
        _ftprintf (stdout, _T ("   Mid: %d:\n"), pMsg->Mid);
        _ftprintf (stdout, _T ("   Cid: %d:\n"), pMsg->CallbackId);
    }
}


void
client2 (const TCHAR *name)
{
    HANDLE hPort;
    UNICODE_STRING str;
    NTSTATUS rc;
    SECURITY_QUALITY_OF_SERVICE QoS = { sizeof (QoS), 2, 1, 1 };
    unsigned char msg_buf[500];
    unsigned int max_msg_size;
    PLPC_MESSAGE pMsg = (PLPC_MESSAGE) msg_buf;
    unsigned char *pMsgData = &msg_buf[sizeof (*pMsg)];

    RtlInitUnicodeString (&str, name);
    rc = NtConnectPort (&hPort, &str, &QoS, NULL, NULL, &max_msg_size, NULL, NULL);
    if (rc < 0) {
        _ftprintf (stderr, _T ("NtConnectPort failed: 0x%x\n"), rc);
    } else {
        _ftprintf (stderr, _T ("NtConnectPort succeeded\n"));

        max_msg_size = min (max_msg_size, sizeof (msg_buf));

        while (1) {
            int i;
            memset (pMsg, 0, sizeof (*pMsg));

            pMsg->DataSize = rand () % (max_msg_size - sizeof (*pMsg));
            pMsg->MsgSize = pMsg->DataSize + sizeof (*pMsg);
            pMsg->MsgType = LPC_NEW_MSG;

            for (i=0; i<pMsg->DataSize; i++) {
                pMsgData[i] = rand () % 256;
            }
            *(unsigned long *)pMsgData = 0;
            rc = NtRequestWaitReplyPort (hPort, pMsg, pMsg);
            if (rc < 0) {
                _ftprintf (stderr, _T ("NtRequestWaitReplyPort failed: 0x%x\n"), rc);
            }
            _ftprintf (stderr, _T ("NtRequestWaitReplyPort succeeded\n"));
            _ftprintf (stdout, _T ("Received msg:\n"));
            _ftprintf (stdout, _T ("   Type: %d:\n"), pMsg->MsgType);
            _ftprintf (stdout, _T ("   Pid: %d:\n"), pMsg->Cid.pid);
            _ftprintf (stdout, _T ("   Tid: %d:\n"), pMsg->Cid.tid);
            _ftprintf (stdout, _T ("   Mid: %d:\n"), pMsg->Mid);
        }
    }
}


void
client5a_1 (const TCHAR *name)
{
    HANDLE hPort;
    UNICODE_STRING str;
    NTSTATUS rc;
    SECURITY_QUALITY_OF_SERVICE QoS = { sizeof (QoS), 2, 1, 1 };
    unsigned char msg_buf[500];
    unsigned int max_msg_size;
    PLPC_MESSAGE pMsg = (PLPC_MESSAGE) msg_buf;
    unsigned char *pMsgData = &msg_buf[sizeof (*pMsg)];
    int count = 0;

    RtlInitUnicodeString (&str, name);
    rc = NtConnectPort (&hPort, &str, &QoS, NULL, NULL, &max_msg_size, NULL, NULL);
    if (rc < 0) {
        _ftprintf (stderr, _T ("NtConnectPort failed: 0x%x\n"), rc);
    } else {
        _ftprintf (stderr, _T ("NtConnectPort succeeded\n"));

        max_msg_size = min (max_msg_size, sizeof (msg_buf));
        
        while (1)
        {
            memset (pMsg, 0, sizeof (*pMsg));

            pMsg->DataSize = 0xc;
            pMsg->MsgSize = pMsg->DataSize + sizeof (*pMsg);
            pMsg->MsgType = LPC_NEW_MSG;
            pMsg->VirtRangOff = sizeof (*pMsg);

            *(unsigned long *)pMsgData = 1;
            *((unsigned long *)pMsgData+1) = (unsigned long)&QoS;
            *((unsigned long *)pMsgData+2) = sizeof (QoS);

            rc = NtRequestWaitReplyPort (hPort, pMsg, pMsg);
            if (rc < 0) {
                _ftprintf (stderr, _T ("NtRequestWaitReplyPort failed: 0x%x\n"), rc);
            } else {
                _ftprintf (stderr, _T ("NtRequestWaitReplyPort succeeded\n"));
                _ftprintf (stdout, _T ("Received msg:\n"));
                _ftprintf (stdout, _T ("   Type: %d\n"), pMsg->MsgType);
                _ftprintf (stdout, _T ("   Pid: %d\n"), pMsg->Cid.pid);
                _ftprintf (stdout, _T ("   Tid: %d\n"), pMsg->Cid.tid);
                _ftprintf (stdout, _T ("   Mid: %d\n"), pMsg->Mid);
                _ftprintf (stdout, _T ("   Callback: %d\n"), pMsg->CallbackId);
                _ftprintf (stdout, _T ("   QoS now: 0x%x\n"), QoS.Length);
            }
        }
    }
}


void
client5a_2 (const TCHAR *name)
{
    HANDLE hPort;
    UNICODE_STRING str;
    NTSTATUS rc;
    SECURITY_QUALITY_OF_SERVICE QoS = { sizeof (QoS), 2, 1, 1 };
    unsigned char msg_buf[500];
    unsigned int max_msg_size;
    PLPC_MESSAGE pMsg = (PLPC_MESSAGE) msg_buf;
    unsigned char *pMsgData = &msg_buf[sizeof (*pMsg)];
    int count = 0;
    unsigned long pid, tid, mid, callback_id;

    RtlInitUnicodeString (&str, name);
    rc = NtConnectPort (&hPort, &str, &QoS, NULL, NULL, &max_msg_size, NULL, NULL);
    if (rc < 0) {
        _ftprintf (stderr, _T ("NtConnectPort failed: 0x%x\n"), rc);
    } else {
        _ftprintf (stderr, _T ("NtConnectPort succeeded\n"));

        {
            unsigned long data[3];
            memset (pMsg, 0, sizeof (*pMsg));
            memset (data, 0, sizeof (data));

            _ftprintf (stdout, _T ("Enter pid, tid, mid, callback_id:\n"));
            _ftscanf (stdin, _T ("%d, %d, %d, %d"),
                      &pid, &tid, &mid, &callback_id);

            pMsg->DataSize = 0xc;
            pMsg->MsgSize = pMsg->DataSize + sizeof (*pMsg);
            pMsg->MsgType = LPC_NEW_MSG;
            pMsg->VirtRangOff = sizeof (*pMsg);
            pMsg->Cid.pid = pid;
            pMsg->Cid.tid = tid;
            pMsg->Mid = mid;
            pMsg->CallbackId = callback_id;

            *(unsigned long *)pMsgData = 1;
            *((unsigned long *)pMsgData+1) = (unsigned long)&QoS;
            *((unsigned long *)pMsgData+2) = sizeof (QoS);

            
            rc = NtReadRequestData (hPort, pMsg, 0, data, sizeof (data), NULL);
            if (rc < 0) {
                _ftprintf (stderr, _T ("NtReadRequestData failed: 0x%x\n"),
                           rc);
            } else {
                _ftprintf (stderr, _T ("NtReadRequestData succeeded\n"));
                _ftprintf (stderr, _T ("data[0] = 0x%x\n"), data[0]);
                _ftprintf (stderr, _T ("data[1] = 0x%x\n"), data[1]);
                _ftprintf (stderr, _T ("data[2] = 0x%x\n"), data[2]);
            }

            data[0] = 0xdeadbabe;
            data[1] = 0xcafebeef;
            data[2] = 0xdeafface;
            rc = NtWriteRequestData (hPort, pMsg, 0, data, sizeof (data), NULL);
            if (rc < 0) {
                _ftprintf (stderr, _T ("NtWriteRequestData failed: 0x%x\n"),
                           rc);
            } else {
                _ftprintf (stderr, _T ("NtWriteRequestData succeeded\n"));
            }
        }
    }
}



void
client5b (const TCHAR *name, const TCHAR *name2)
{
    HANDLE hPort;
    UNICODE_STRING str;
    NTSTATUS rc;
    SECURITY_QUALITY_OF_SERVICE QoS = { sizeof (QoS), 2, 1, 1 };
    unsigned char msg_buf[500];
    unsigned int max_msg_size;
    PLPC_MESSAGE pMsg = (PLPC_MESSAGE) msg_buf;
    unsigned char *pMsgData = &msg_buf[sizeof (*pMsg)];
    int count = 0;
    unsigned long first_mid=0;

    RtlInitUnicodeString (&str, name);
    rc = NtConnectPort (&hPort, &str, &QoS, NULL, NULL, &max_msg_size, NULL, NULL);
    if (rc < 0) {
        _ftprintf (stderr, _T ("NtConnectPort failed: 0x%x\n"), rc);
    } else {
        _ftprintf (stderr, _T ("NtConnectPort succeeded\n"));

        for (count = 0; count < 10000; count++) {
            memset (pMsg, 0, sizeof (*pMsg));

            pMsg->DataSize = 0xc;
            pMsg->MsgSize = pMsg->DataSize + sizeof (*pMsg);
            pMsg->MsgType = LPC_NEW_MSG;
            pMsg->VirtRangOff = sizeof (*pMsg);

            *(unsigned long *)pMsgData = 1;
            *((unsigned long *)pMsgData+1) = 0x7ffdf000;
            *((unsigned long *)pMsgData+2) = 400;
            
            rc = NtRequestWaitReplyPort (hPort, pMsg, pMsg);
            if (rc < 0) {
                _ftprintf (stderr, _T ("NtRequestWaitReplyPort failed: 0x%x\n"), rc);
            } else {
                if (first_mid==0)
                    first_mid = pMsg->Mid;
            }
        }
        //
        // tell the server we're done sending
        //
        memset (pMsg, 0, sizeof (*pMsg));

        pMsg->DataSize = 0;
        pMsg->MsgSize = pMsg->DataSize + sizeof (*pMsg);
        pMsg->MsgType = LPC_NEW_MSG;

        rc = NtRequestPort (hPort, pMsg);
        if (rc < 0) {
            _ftprintf (stderr, _T ("NtRequestPort failed: 0x%x\n"), rc);
        } else {
            _ftprintf (stderr, _T ("Server should be waiting now\n"));
        }       
    }

    count = 0;
    RtlInitUnicodeString (&str, name2);
    rc = NtConnectPort (&hPort, &str, &QoS, NULL, NULL, &max_msg_size, NULL, NULL);
    if (rc < 0) {
        _ftprintf (stderr, _T ("NtConnectPort failed: 0x%x\n"), rc);
    } else {
        _ftprintf (stderr, _T ("NtConnectPort succeeded\n"));

        max_msg_size = min (max_msg_size, sizeof (msg_buf));

        while (1) {
            memset (pMsg, 0, sizeof (*pMsg));

            pMsg->DataSize = 0;
            pMsg->MsgSize = pMsg->DataSize + sizeof (*pMsg);
            pMsg->MsgType = LPC_NEW_MSG;

            rc = NtRequestWaitReplyPort (hPort, pMsg, pMsg);
            if (rc < 0) {
                _ftprintf (stderr, _T ("NtRequestWaitReplyPort failed: 0x%x\n"), rc);
            } else {
                if ((pMsg->Mid < first_mid)
                    && (pMsg->Mid+10000 > first_mid)) {
                    break;
                }
                count++;
                if (count % 1000000 == 0) {
                    _ftprintf (stderr, _T ("NtRequestWaitReplyPort succeeded\n"));
                    _ftprintf (stdout, _T ("Received msg:\n"));
                    _ftprintf (stdout, _T ("   Type: %d:\n"), pMsg->MsgType);
                    _ftprintf (stdout, _T ("   Pid: %d:\n"), pMsg->Cid.pid);
                    _ftprintf (stdout, _T ("   Tid: %d:\n"), pMsg->Cid.tid);
                    _ftprintf (stdout, _T ("   Mid: %d:\n"), pMsg->Mid);
                }
            }
        }
    }

    _ftprintf (stdout, _T ("Wrapped close to first_mid == %d\n"),
               first_mid);
    Sleep (1000000);
}


void
client6 (const TCHAR *name)
{
    HANDLE hPort;
    UNICODE_STRING str;
    NTSTATUS rc;
    SECURITY_QUALITY_OF_SERVICE QoS = { sizeof (QoS), 2, 1, 1 };
    unsigned char msg_buf[500];
    unsigned int max_msg_size;
    PLPC_MESSAGE pMsg = (PLPC_MESSAGE) msg_buf;
    unsigned char *pMsgData = &msg_buf[sizeof (*pMsg)];
    int count = 0;

    RtlInitUnicodeString (&str, name);
    rc = NtConnectPort (&hPort, &str, &QoS, NULL, NULL, &max_msg_size, NULL, NULL);
    if (rc < 0) {
        _ftprintf (stderr, _T ("NtConnectPort failed: 0x%x\n"), rc);
    } else {
        _ftprintf (stderr, _T ("NtConnectPort succeeded\n"));

        max_msg_size = min (max_msg_size, sizeof (msg_buf));

        while (1) {
            memset (pMsg, 0, sizeof (*pMsg));

            pMsg->DataSize = 0xc;
            pMsg->MsgSize = pMsg->DataSize + sizeof (*pMsg);
            pMsg->MsgType = LPC_NEW_MSG;
            pMsg->VirtRangOff = sizeof (*pMsg);

            *(unsigned long *)pMsgData = 1;
            *((unsigned long *)pMsgData+1) = (unsigned long)&QoS;
            *((unsigned long *)pMsgData+2) = sizeof (QoS);

            rc = NtRequestWaitReplyPort (hPort, pMsg, pMsg);
            if (rc < 0) {
                _ftprintf (stderr, _T ("NtRequestWaitReplyPort failed: 0x%x\n"), rc);
            } else {
                count++;
                if (count % 1000000 == 0) {
                    _ftprintf (stderr, _T ("NtRequestWaitReplyPort succeeded\n"));
                    _ftprintf (stdout, _T ("Received msg:\n"));
                    _ftprintf (stdout, _T ("   Type: %d:\n"), pMsg->MsgType);
                    _ftprintf (stdout, _T ("   Pid: %d:\n"), pMsg->Cid.pid);
                    _ftprintf (stdout, _T ("   Tid: %d:\n"), pMsg->Cid.tid);
                    _ftprintf (stdout, _T ("   Mid: %d:\n"), pMsg->Mid);
                }
            }
        }
    }
}

_tmain (int argc, TCHAR *argv[])
{
    _ftprintf (stdout, _T ("Pid: %d  Tid: %d\n"),
               GetCurrentProcessId (), GetCurrentThreadId ());
    if (_tcscmp (_T ("-c"), argv[1]) == 0) {
        client (argv[2]);
    } else if (_tcscmp (_T ("-c2"), argv[1]) == 0) {
        client2 (argv[2]);
    } else if (_tcscmp (_T ("-c5a-1"), argv[1]) == 0) {
        client5a_1 (argv[2]);
    } else if (_tcscmp (_T ("-c5a-2"), argv[1]) == 0) {
        client5a_2 (argv[2]);
    } else if (_tcscmp (_T ("-c5b"), argv[1]) == 0) {
        client5b (argv[2], argv[3]);
    } else if (_tcscmp (_T ("-c6"), argv[1]) == 0) {
        client6 (argv[2]);
    } else if (_tcscmp (_T ("-s"), argv[1]) == 0) {
        server (argv[2]);
    } else if (_tcscmp (_T ("-s1"), argv[1]) == 0) {
        server1 ();
    } else if (_tcscmp (_T ("-s2"), argv[1]) == 0) {
        server2 (argv[2]);
    } else if (_tcscmp (_T ("-s3"), argv[1]) == 0) {
        server3 (argv[2]);
    } else if (_tcscmp (_T ("-s4"), argv[1]) == 0) {
        server4 (argv[2]);
    } else if (_tcscmp (_T ("-s4b"), argv[1]) == 0) {
        server4b (argv[2]);
    } else if (_tcscmp (_T ("-s5a"), argv[1]) == 0) {
        server5a (argv[2]);
    } else if (_tcscmp (_T ("-s5b"), argv[1]) == 0) {
        server5b (argv[2]);
    } else if (_tcscmp (_T ("-s5b-2"), argv[1]) == 0) {
        server5b_2 (argv[2]);
    } else if (_tcscmp (_T ("-s6"), argv[1]) == 0) {
        server6 (argv[2]);
    }
}

