
#ifndef NTDLL_H
#define NTDLL_H

#ifdef __cplusplus
extern "C" {
#endif

typedef long NTSTATUS;

typedef struct _UNICODE_STRING {
    USHORT Length;
    USHORT MaximumLength;
    PWSTR  Buffer;
} UNICODE_STRING, *PUNICODE_STRING;

#define OBJ_INHERIT             0x00000002L
#define OBJ_PERMANENT           0x00000010L
#define OBJ_EXCLUSIVE           0x00000020L
#define OBJ_CASE_INSENSITIVE    0x00000040L
#define OBJ_OPENIF              0x00000080L
#define OBJ_OPENLINK            0x00000100L
#define OBJ_VALID_ATTRIBUTES    0x000001F2L

typedef struct _OBJECT_ATTRIBUTES {
    ULONG Length;
    HANDLE RootDirectory;
    PUNICODE_STRING ObjectName;
    ULONG Attributes;
    PVOID SecurityDescriptor;        // Points to type SECURITY_DESCRIPTOR
    PVOID SecurityQualityOfService;  // Points to type SECURITY_QUALITY_OF_SERVICE
} OBJECT_ATTRIBUTES, *POBJECT_ATTRIBUTES;

#define InitializeObjectAttributes( p, n, a, r, s ) { \
    (p)->Length = sizeof( OBJECT_ATTRIBUTES );          \
    (p)->RootDirectory = r;                             \
    (p)->Attributes = a;                                \
    (p)->ObjectName = n;                                \
    (p)->SecurityDescriptor = s;                        \
    (p)->SecurityQualityOfService = NULL;               \
    }

typedef enum _SECTION_INHERIT {
    ViewShare = 1,
    ViewUnmap = 2
} SECTION_INHERIT;

typedef struct _IO_STATUS_BLOCK {
    NTSTATUS Status;
    ULONG Information;
} IO_STATUS_BLOCK, *PIO_STATUS_BLOCK;

typedef struct _client_id {
    ULONG pid;
    ULONG tid;
} CLIENT_ID;


typedef struct _VM_COUNTERS {
    ULONG PeakVirtualSize;
    ULONG VirtualSize;
    ULONG PageFaultCount;
    ULONG PeakWorkingSetSize;
    ULONG WorkingSetSize;
    ULONG QuotaPeakPagedPoolUsage;
    ULONG QuotaPagedPoolUsage;
    ULONG QuotaPeakNonPagedPoolUsage;
    ULONG QuotaNonPagedPoolUsage;
    ULONG PagefileUsage;
    ULONG PeakPagefileUsage;
} VM_COUNTERS;

typedef enum {
    StateInitialized,
    StateReady,
    StateRunning,
    StateStandby,
    StateTerminated,
    StateWait,
    StateTransition,
    StateUnknown
} THREAD_STATE;

typedef enum _KWAIT_REASON {
    Executive,
    FreePage,
    PageIn,
    PoolAllocation,
    DelayExecution,
    Suspended,
    UserRequest,
    WrExecutive,
    WrFreePage,
    WrPageIn,
    WrPoolAllocation,
    WrDelayExecution,
    WrSuspended,
    WrUserRequest,
    WrEventPair,
    WrQueue,
    WrLpcReceive,
    WrLpcReply,
    WrVirtualMemory,
    WrPageOut,
    WrRendezvous,
    Spare2,
    Spare3,
    Spare4,
    Spare5,
    Spare6,
    WrKernel,
    MaximumWaitReason
} KWAIT_REASON;

typedef LONG KPRIORITY;

typedef struct _SYSTEM_THREADS {
    LARGE_INTEGER KernelTime;
    LARGE_INTEGER UserTime;
    LARGE_INTEGER CreateTime;
    ULONG WaitTime;
    PVOID StartAddress;
    CLIENT_ID ClientId;
    KPRIORITY Priority;
    KPRIORITY BasePriority;
    ULONG ContextSwitchCount;
    THREAD_STATE State;
    KWAIT_REASON WaitReason;
} SYSTEM_THREADS, *PSYSTEM_THREADS;

typedef struct _SYSTEM_PROCESSES {
    ULONG NextEntryDelta;
    ULONG ThreadCount;
    ULONG Reserved1[6];
    LARGE_INTEGER CreateTime;
    LARGE_INTEGER UserTime;
    LARGE_INTEGER KernelTime;
    UNICODE_STRING ProcessName;
    ULONG BasePriority;
    ULONG ProcessId;
    ULONG InheritedFromProcessId;
    ULONG HandleCount;
    ULONG Reserved[2];
    VM_COUNTERS VmCounters;
    SYSTEM_THREADS ThreadInfo[1]; // many
} SYSTEM_PROCESSES;


typedef struct _PROCESS_ACCESS_TOKEN {
    HANDLE Token;
    HANDLE Thread;
} PROCESS_ACCESS_TOKEN, *PPROCESS_ACCESS_TOKEN;



NTSTATUS _stdcall NtUnmapViewOfSection(
		IN HANDLE  ProcessHandle,
		IN PVOID  BaseAddress
		);

NTSTATUS _stdcall NtOpenSection(
		OUT PHANDLE  SectionHandle,
		IN ACCESS_MASK  DesiredAccess,
		IN POBJECT_ATTRIBUTES  ObjectAttributes
		);

NTSTATUS (__stdcall NtOpenDirectoryObject)(
		OUT PHANDLE  DirectoryHandle,
		IN ACCESS_MASK  DesiredAccess,
		IN POBJECT_ATTRIBUTES  ObjectAttributes
		);

NTSTATUS (__stdcall NtOpenSymbolicLinkObject)(
		OUT PHANDLE  Handle,
		IN ACCESS_MASK  DesiredAccess,
		IN POBJECT_ATTRIBUTES  ObjectAttributes
		);

NTSTATUS (__stdcall NtQuerySymbolicLinkObject)(
		IN HANDLE  Handle,
                OUT PUNICODE_STRING DirEntryBuffer,
                OUT PULONG BytesReturned
		);

NTSTATUS (__stdcall NtQuerySecurityObject)(
		IN HANDLE Handle,
                IN SECURITY_INFORMATION info,
                OUT PSECURITY_DESCRIPTOR pSD,
                IN ULONG bufsiz,
                OUT PULONG size_needed
		);

#define STATUS_NO_MORE_ENTRIES 0x8000001A
typedef struct _dir_entry {
    UNICODE_STRING Name;
    UNICODE_STRING Type;
} DIRECTORY_ENTRY;
NTSTATUS (__stdcall NtQueryDirectoryObject)(
		IN HANDLE  DirectoryHandle,
                OUT PVOID DirEntryBuffer,
                IN ULONG DirEntryBufferSize,
                IN BOOLEAN bOneAtaTime,
                IN BOOLEAN bStartAgain,
                OUT PULONG EntryIndex,
                OUT PULONG BytesReturned
		);

NTSTATUS (__stdcall NtMapViewOfSection)(
		IN HANDLE  SectionHandle,
		IN HANDLE  ProcessHandle,
		IN OUT PVOID  *BaseAddress,
		IN ULONG  ZeroBits,
		IN ULONG  CommitSize,
		IN OUT PLARGE_INTEGER  SectionOffset,	// optional
		IN OUT PULONG  ViewSize,
		IN SECTION_INHERIT  InheritDisposition,
		IN ULONG  AllocationType,
		IN ULONG  Protect
		);

VOID  (__stdcall NtClose)(
		IN HANDLE  Object
		);

#define FILE_SUPERSEDE                  0x00000000
#define FILE_OPEN                       0x00000001
#define FILE_CREATE                     0x00000002
#define FILE_OPEN_IF                    0x00000003
#define FILE_OVERWRITE                  0x00000004
#define FILE_OVERWRITE_IF               0x00000005
#define FILE_MAXIMUM_DISPOSITION        0x00000005

#define FILE_DIRECTORY_FILE                     0x00000001
#define FILE_WRITE_THROUGH                      0x00000002
#define FILE_SEQUENTIAL_ONLY                    0x00000004
#define FILE_NO_INTERMEDIATE_BUFFERING          0x00000008
#define FILE_SYNCHRONOUS_IO_ALERT               0x00000010
#define FILE_SYNCHRONOUS_IO_NONALERT            0x00000020
#define FILE_NON_DIRECTORY_FILE                 0x00000040
#define FILE_CREATE_TREE_CONNECTION             0x00000080
#define FILE_COMPLETE_IF_OPLOCKED               0x00000100
#define FILE_NO_EA_KNOWLEDGE                    0x00000200
//UNUSED                                        0x00000400
#define FILE_RANDOM_ACCESS                      0x00000800
#define FILE_DELETE_ON_CLOSE                    0x00001000
#define FILE_OPEN_BY_FILE_ID                    0x00002000
#define FILE_OPEN_FOR_BACKUP_INTENT             0x00004000
#define FILE_NO_COMPRESSION                     0x00008000
#define FILE_RESERVE_OPFILTER                   0x00100000
#define FILE_TRANSACTED_MODE                    0x00200000
#define FILE_OPEN_OFFLINE_FILE                  0x00400000
#define FILE_VALID_OPTION_FLAGS                 0x007fffff
#define FILE_VALID_PIPE_OPTION_FLAGS            0x00000032
#define FILE_VALID_MAILSLOT_OPTION_FLAGS        0x00000032
#define FILE_VALID_SET_FLAGS                    0x00000036

NTSTATUS (__stdcall NtCreateFile)(
    OUT PHANDLE FileHandle,
    IN ACCESS_MASK DesiredAccess,
    IN POBJECT_ATTRIBUTES ObjectAttributes,
    OUT PIO_STATUS_BLOCK IoStatusBlock,
    IN PLARGE_INTEGER AllocationSize OPTIONAL,
    IN ULONG FileAttributes,
    IN ULONG ShareAccess,
    IN ULONG CreateDisposition,
    IN ULONG CreateOptions,
    IN PVOID EaBuffer OPTIONAL,
    IN ULONG EaLength
    );

NTSTATUS (__stdcall NtOpenFile)(
	OUT PHANDLE FileHandle,
	IN ACCESS_MASK DesiredAccess,
	IN POBJECT_ATTRIBUTES ObjectAttributes,
	OUT PIO_STATUS_BLOCK IoStatusBlock,
	IN ULONG ShareAccess,
	IN ULONG OpenOptions
	);

NTSTATUS (__stdcall NtCreateSection)(
	    OUT PHANDLE SectionHandle, 
		IN ACCESS_MASK DesiredAccess,
		IN POBJECT_ATTRIBUTES ObjectAttributes,  // Optional
		IN PLARGE_INTEGER MaximumSize,           // Optional
		IN ULONG SectionPageProtection,
		IN ULONG AllocationAttributes,
		IN HANDLE FileHandle                     // Optional
		);

NTSTATUS (__stdcall NtMakeTemporaryObject)(
		IN HANDLE  Handle
		);

NTSTATUS (__stdcall NtCreateDirectoryObject)(
		OUT PHANDLE  DirectoryHandle,
		IN ACCESS_MASK  DesiredAccess,
		IN POBJECT_ATTRIBUTES  ObjectAttributes
                );

typedef struct _port_message {
    USHORT DataSize;
    USHORT MsgSize;
    USHORT MsgType;
    USHORT VirtRangOff;
    CLIENT_ID Cid;
    ULONG  Mid;
    ULONG  CallbackId;
} LPC_MESSAGE, *PLPC_MESSAGE;

typedef struct _section_write {
    ULONG Len;
    HANDLE hSection;
    ULONG SectOffset;
    ULONG ViewSize;
    PVOID ViewBase;
    PVOID TargetViewBase;
} PORT_SECTION_WRITE, *PPORT_SECTION_WRITE;

typedef struct _section_read {
    ULONG Length;
    ULONG ViewSize;
    ULONG ViewBase;
} PORT_SECTION_READ, *PPORT_SECTION_READ;

typedef enum _lpc_msg_type {
    LPC_NEW_MSG,
    LPC_REQUEST,
    LPC_REPLY,
    LPC_DATAGRAM,
    LPC_LOST_REPLY,
    LPC_PORT_CLOSED,
    LPC_CLIENT_DIED,
    LPC_EXCEPTION,
    LPC_DEBUG_EVENT,
    LPC_ERROR_EVENT,
    LPC_CONN_REQ,
} LPC_MSG_TYPE;

NTSTATUS (__stdcall NtCreatePort)(
		OUT PHANDLE PortHandle,
		IN POBJECT_ATTRIBUTES ObjectAttributes,
                IN ULONG MaxDataSize,
                IN ULONG MaxMsgSize,
                IN ULONG Reserved
                );

NTSTATUS (__stdcall NtCreateWaitablePort)(
		OUT PHANDLE PortHandle,
		IN POBJECT_ATTRIBUTES ObjectAttributes,
                IN ULONG MaxDataSize,
                IN ULONG MaxMsgSize,
                IN ULONG Reserved
                );

NTSTATUS (__stdcall NtConnectPort)(
		OUT PHANDLE PortHandle,
                IN PUNICODE_STRING PortName,
                IN PSECURITY_QUALITY_OF_SERVICE QoS,
                IN OUT PPORT_SECTION_WRITE WriteSection,
                IN OUT PPORT_SECTION_READ ReadSection,
                OUT PULONG MaxMsgSize,
                IN OUT PVOID ConnectData,
                IN OUT PULONG ConnectDataLength
                );

NTSTATUS (__stdcall NtSecureConnectPort)(
		OUT PHANDLE PortHandle,
                IN PUNICODE_STRING PortName,
                IN PSECURITY_QUALITY_OF_SERVICE QoS,
                IN OUT PPORT_SECTION_WRITE WriteSection,
                IN PSID ServerSid,
                IN OUT PPORT_SECTION_READ ReadSection,
                OUT PULONG MaxMsgSize,
                IN OUT PVOID ConnectData,
                IN OUT PULONG ConnectDataLength
                );

NTSTATUS (__stdcall NtListenPort)(
		IN HANDLE PortHandle,
                OUT PLPC_MESSAGE Message
                );

NTSTATUS (__stdcall NtAcceptConnectPort)(
		OUT PHANDLE PortHandle,
                IN ULONG PortIdentifier,
                IN PLPC_MESSAGE Message,
                IN BOOLEAN Accept,
                IN OUT PPORT_SECTION_WRITE WriteSection,
                IN OUT PPORT_SECTION_READ  ReadSection
                );

NTSTATUS (__stdcall NtCompleteConnectPort)(
		IN HANDLE PortHandle
                );

NTSTATUS (__stdcall NtRequestPort)(
		IN HANDLE PortHandle,
                IN PLPC_MESSAGE Message
                );

NTSTATUS (__stdcall NtRequestWaitReplyPort)(
		IN HANDLE PortHandle,
                IN PLPC_MESSAGE MessageIn,
                OUT PLPC_MESSAGE MessageOut
                );

NTSTATUS (__stdcall NtReplyPort)(
		IN HANDLE PortHandle,
                IN PLPC_MESSAGE Message
                );

NTSTATUS (__stdcall NtReplyWaitReplyPort)(
		IN HANDLE PortHandle,
                IN OUT PLPC_MESSAGE Message
                );

NTSTATUS (__stdcall NtReplyWaitReceivePort)(
		IN HANDLE PortHandle,
                OUT PULONG PortIdentifier,
                IN PLPC_MESSAGE MessageIn,
                OUT PLPC_MESSAGE MessageOut
                );

NTSTATUS (__stdcall NtReplyWaitReceivePortEx)(
		IN HANDLE PortHandle,
                OUT PULONG PortIdentifier,
                IN PLPC_MESSAGE MessageIn,
                OUT PLPC_MESSAGE MessageOut,
                IN PLARGE_INTEGER Timeout
                );

NTSTATUS (__stdcall NtReadRequestData)(
		IN HANDLE PortHandle,
                IN PLPC_MESSAGE Message,
                IN ULONG Index,
                OUT PVOID Buffer,
                IN ULONG BufferLen,
                OUT PULONG RetLen
                );

NTSTATUS (__stdcall NtWriteRequestData)(
		IN HANDLE PortHandle,
                IN PLPC_MESSAGE Message,
                IN ULONG Index,
                OUT PVOID Buffer,
                IN ULONG BufferLen,
                OUT PULONG RetLen
                );

NTSTATUS (__stdcall NtImpersonateClientOfPort)(
		IN HANDLE PortHandle,
                IN PLPC_MESSAGE Message
                );

typedef int SYSTEM_INFORMATION_CLASS;

NTSTATUS (__stdcall NtQuerySystemInformation)(
		IN SYSTEM_INFORMATION_CLASS SysInfoClass,
                IN OUT PVOID SystemInformation,
                IN ULONG SystemInformationLength,
                OUT PULONG RetLen
                );

NTSTATUS (__stdcall NtCreateKey)(
    OUT PHANDLE KeyHandle,
    IN ACCESS_MASK DesiredAccess,
    IN POBJECT_ATTRIBUTES ObjectAttributes,
    IN ULONG TitleIndex,
    IN PUNICODE_STRING Class OPTIONAL,
    IN ULONG CreateOptions,
    OUT PULONG Disposition OPTIONAL
    );


NTSTATUS (__stdcall NtOpenKey) (
    OUT PHANDLE KeyHandle,
    IN ACCESS_MASK DesiredAccess,
    IN POBJECT_ATTRIBUTES ObjectAttributes
    );


NTSTATUS (__stdcall NtOpenThreadToken) (
    IN HANDLE ThreadHandle,
    IN ACCESS_MASK DesiredAccess,
    IN BOOLEAN OpenAsSelf,
    OUT PHANDLE TokenHandle
    );

NTSTATUS (__stdcall NtCreateToken) (
    OUT PHANDLE TokenHandle,
    IN ACCESS_MASK DesiredAccess,
    IN POBJECT_ATTRIBUTES ObjectAttributes,
    IN TOKEN_TYPE Type,
    IN PLUID AuthenticationId,
    IN PLARGE_INTEGER ExpirationTime,
    IN PTOKEN_USER User,
    IN PTOKEN_GROUPS Groups,
    IN PTOKEN_PRIVILEGES Privileges,
    IN PTOKEN_OWNER Owner,
    IN PTOKEN_PRIMARY_GROUP PrimaryGroup,
    IN PTOKEN_DEFAULT_DACL DefaultDacl,
    IN PTOKEN_SOURCE Source
    );

typedef enum _PROCESSINFOCLASS {
    ProcessBasicInformation,
    ProcessQuotaLimits,
    ProcessIoCounters,
    ProcessVmCounters,
    ProcessTimes,
    ProcessBasePriority,
    ProcessRaisePriority,
    ProcessDebugPort,
    ProcessExceptionPort,
    ProcessAccessToken,
    ProcessLdtInformation,
    ProcessLdtSize,
    ProcessDefaultHardErrorMode,
    ProcessIoPortHandlers,          // Note: this is kernel mode only
    ProcessPooledUsageAndLimits,
    ProcessWorkingSetWatch,
    ProcessUserModeIOPL,
    ProcessEnableAlignmentFaultFixup,
    ProcessPriorityClass,
    ProcessWx86Information,
    ProcessHandleCount,
    ProcessAffinityMask,
    ProcessPriorityBoost,
    ProcessDeviceMap,
    ProcessSessionInformation,
    ProcessForegroundInformation,
    ProcessWow64Information,
    MaxProcessInfoClass
} PROCESSINFOCLASS;


NTSTATUS (__stdcall NtSetInformationProcess) (
    IN HANDLE ProcessHandle,
    IN PROCESSINFOCLASS ProcessInformationClass,
    IN PVOID ProcessInformation,
    IN ULONG ProcessInformationLength
    );






/*
 * Utility functions
 */
VOID (__stdcall RtlInitUnicodeString)(
		IN OUT PUNICODE_STRING  DestinationString,
		IN PCWSTR  SourceString
		);

LONG (__stdcall RtlCompareUnicodeString)(
		IN PUNICODE_STRING  One,
		IN PUNICODE_STRING  Two,
		IN BOOLEAN  CaseSensitive
		);

ULONG (__stdcall RtlNtStatusToDosError) (
		IN NTSTATUS Status
		);


#ifdef __cplusplus
}
#endif
#endif
