/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package smbtest;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map.Entry;
import java.util.concurrent.SynchronousQueue;
import javax.xml.bind.DatatypeConverter;

/**
 *
 * @author dev
 */
public class WebDavNtlmHandler implements HttpHandler {

    int state = 0;
    
    static byte[] readStream(InputStream stm) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int len;
        byte[] buf = new byte[8192];

        try {
            while((len = stm.read(buf)) > 0) {
                bos.write(buf, 0, len);
            }

            stm.close();
        } catch(IOException e) {
            System.out.println(e.getMessage());
        }        
        
        return bos.toByteArray();
    }
    
    static void dumpHeaders(Headers headers) {
        for(Entry<String, List<String>> entry : headers.entrySet()) {
            System.out.print(entry.getKey() + ": ");
            for(String value : entry.getValue()) {
                System.out.print(value + " : ");
            }
            System.out.println();
        }
    }
    
    static byte[] getNtlmBlock(Headers headers) {
        String authValue = headers.getFirst("Authorization");
        if(authValue.startsWith("NTLM ")) {        
            return DatatypeConverter.parseBase64Binary(authValue.substring(5));
        }
        
        return null;
    }            
    
    SynchronousQueue<byte[]> _queue;
    
    public void handleNormalRequest(HttpExchange he) throws IOException {
        Headers reqHeaders = he.getRequestHeaders();        
        
        dumpHeaders(reqHeaders);
        
        byte[] reqData = readStream(he.getRequestBody());
        
        Headers respHeaders = he.getResponseHeaders();            
        
        he.sendResponseHeaders(404, 0);
        he.getResponseBody().close();
    }
    
    public void handleOptionsRequest(HttpExchange he) throws IOException {
        Headers reqHeaders = he.getRequestHeaders();        
        
        dumpHeaders(reqHeaders);
        
        byte[] reqData = readStream(he.getRequestBody());
        
        if(reqData.length > 0) {
            System.out.println("Request Data:");
            System.out.println(new String(reqData));
        }
        
        Headers respHeaders = he.getResponseHeaders();
        int respCode = 401;
                
        if(!reqHeaders.containsKey("Authorization")) {            
            respHeaders.add("WWW-Authenticate", "NTLM");
            state = 0;            
        } else {
            byte[] block = getNtlmBlock(reqHeaders);            
            if(block != null) {
                 try {        
                    if(state == 0) {

                        _queue = new SynchronousQueue<>();

                        new SmbRequestThread(_queue).start();

                        // Start SMB client
                        // Set initial type 1, get back challenge                        
                        _queue.put(block);
                        byte[] challenge = _queue.take();

                        respHeaders.add("WWW-Authenticate", "NTLM " 
                                + DatatypeConverter.printBase64Binary(challenge));
                        state++;
                    } else if(state == 1) {
                        _queue.put(block);
                        respCode = 200;
                        state++;
                    }
                } catch(InterruptedException e) {
                    e.printStackTrace(System.out);
                }
            } else {
                respCode = 500;
            }
        }
        
        he.sendResponseHeaders(respCode, 0);
        he.getResponseBody().close();     
    }
    
    @Override
    public void handle(HttpExchange he) throws IOException {
        System.out.println("Reqeust Method: " + he.getRequestMethod());
        System.out.println("Request Path: " + he.getRequestURI());
        
        if(he.getRequestMethod().equalsIgnoreCase("OPTIONS")) {
            handleOptionsRequest(he);
        } else {
            handleNormalRequest(he);
        }             
    }    
}
