// Code generated by ifacemaker; DO NOT EDIT.

package awsapi

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/service/autoscaling"
	. "github.com/aws/aws-sdk-go-v2/service/autoscaling"
)

// ASG provides an interface to the AWS ASG service.
type ASG interface {
	// Options returns a copy of the client configuration.
	//
	// Callers SHOULD NOT perform mutations on any inner structures within client
	// config. Config overrides should instead be made on a per-operation basis through
	// functional options.
	Options() autoscaling.Options
	// Attaches one or more EC2 instances to the specified Auto Scaling group.
	//
	// When you attach instances, Amazon EC2 Auto Scaling increases the desired
	// capacity of the group by the number of instances being attached. If the number
	// of instances being attached plus the desired capacity of the group exceeds the
	// maximum size of the group, the operation fails.
	//
	// If there is a Classic Load Balancer attached to your Auto Scaling group, the
	// instances are also registered with the load balancer. If there are target groups
	// attached to your Auto Scaling group, the instances are also registered with the
	// target groups.
	//
	// For more information, see [Detach or attach instances] in the Amazon EC2 Auto Scaling User Guide.
	//
	// [Detach or attach instances]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-detach-attach-instances.html
	AttachInstances(ctx context.Context, params *autoscaling.AttachInstancesInput, optFns ...func(*Options)) (*autoscaling.AttachInstancesOutput, error)
	// This API operation is superseded by [AttachTrafficSources], which can attach multiple traffic sources
	// types. We recommend using AttachTrafficSources to simplify how you manage
	// traffic sources. However, we continue to support AttachLoadBalancerTargetGroups
	// . You can use both the original AttachLoadBalancerTargetGroups API operation
	// and AttachTrafficSources on the same Auto Scaling group.
	//
	// Attaches one or more target groups to the specified Auto Scaling group.
	//
	// This operation is used with the following load balancer types:
	//
	//   - Application Load Balancer - Operates at the application layer (layer 7) and
	//     supports HTTP and HTTPS.
	//
	//   - Network Load Balancer - Operates at the transport layer (layer 4) and
	//     supports TCP, TLS, and UDP.
	//
	//   - Gateway Load Balancer - Operates at the network layer (layer 3).
	//
	// To describe the target groups for an Auto Scaling group, call the [DescribeLoadBalancerTargetGroups] API. To
	// detach the target group from the Auto Scaling group, call the [DetachLoadBalancerTargetGroups]API.
	//
	// This operation is additive and does not detach existing target groups or
	// Classic Load Balancers from the Auto Scaling group.
	//
	// For more information, see [Use Elastic Load Balancing to distribute traffic across the instances in your Auto Scaling group] in the Amazon EC2 Auto Scaling User Guide.
	//
	// [DescribeLoadBalancerTargetGroups]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeLoadBalancerTargetGroups.html
	// [DetachLoadBalancerTargetGroups]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DetachLoadBalancerTargetGroups.html
	// [AttachTrafficSources]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_AttachTrafficSources.html
	// [Use Elastic Load Balancing to distribute traffic across the instances in your Auto Scaling group]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html
	AttachLoadBalancerTargetGroups(ctx context.Context, params *autoscaling.AttachLoadBalancerTargetGroupsInput, optFns ...func(*Options)) (*autoscaling.AttachLoadBalancerTargetGroupsOutput, error)
	// This API operation is superseded by [https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_AttachTrafficSources.html], which can attach multiple traffic sources
	// types. We recommend using AttachTrafficSources to simplify how you manage
	// traffic sources. However, we continue to support AttachLoadBalancers . You can
	// use both the original AttachLoadBalancers API operation and AttachTrafficSources
	// on the same Auto Scaling group.
	//
	// Attaches one or more Classic Load Balancers to the specified Auto Scaling
	// group. Amazon EC2 Auto Scaling registers the running instances with these
	// Classic Load Balancers.
	//
	// To describe the load balancers for an Auto Scaling group, call the [DescribeLoadBalancers] API. To
	// detach a load balancer from the Auto Scaling group, call the [DetachLoadBalancers]API.
	//
	// This operation is additive and does not detach existing Classic Load Balancers
	// or target groups from the Auto Scaling group.
	//
	// For more information, see [Use Elastic Load Balancing to distribute traffic across the instances in your Auto Scaling group] in the Amazon EC2 Auto Scaling User Guide.
	//
	// [DetachLoadBalancers]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DetachLoadBalancers.html
	// [DescribeLoadBalancers]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeLoadBalancers.html
	// [https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_AttachTrafficSources.html]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_AttachTrafficSources.html
	// [Use Elastic Load Balancing to distribute traffic across the instances in your Auto Scaling group]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html
	AttachLoadBalancers(ctx context.Context, params *autoscaling.AttachLoadBalancersInput, optFns ...func(*Options)) (*autoscaling.AttachLoadBalancersOutput, error)
	// Attaches one or more traffic sources to the specified Auto Scaling group.
	//
	// You can use any of the following as traffic sources for an Auto Scaling group:
	//
	//   - Application Load Balancer
	//
	//   - Classic Load Balancer
	//
	//   - Gateway Load Balancer
	//
	//   - Network Load Balancer
	//
	//   - VPC Lattice
	//
	// This operation is additive and does not detach existing traffic sources from
	// the Auto Scaling group.
	//
	// After the operation completes, use the [DescribeTrafficSources] API to return details about the state
	// of the attachments between traffic sources and your Auto Scaling group. To
	// detach a traffic source from the Auto Scaling group, call the [DetachTrafficSources]API.
	//
	// [DescribeTrafficSources]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeTrafficSources.html
	// [DetachTrafficSources]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DetachTrafficSources.html
	AttachTrafficSources(ctx context.Context, params *autoscaling.AttachTrafficSourcesInput, optFns ...func(*Options)) (*autoscaling.AttachTrafficSourcesOutput, error)
	// Deletes one or more scheduled actions for the specified Auto Scaling group.
	BatchDeleteScheduledAction(ctx context.Context, params *autoscaling.BatchDeleteScheduledActionInput, optFns ...func(*Options)) (*autoscaling.BatchDeleteScheduledActionOutput, error)
	// Creates or updates one or more scheduled scaling actions for an Auto Scaling
	// group.
	BatchPutScheduledUpdateGroupAction(ctx context.Context, params *autoscaling.BatchPutScheduledUpdateGroupActionInput, optFns ...func(*Options)) (*autoscaling.BatchPutScheduledUpdateGroupActionOutput, error)
	// Cancels an instance refresh or rollback that is in progress. If an instance
	// refresh or rollback is not in progress, an ActiveInstanceRefreshNotFound error
	// occurs.
	//
	// This operation is part of the [instance refresh feature] in Amazon EC2 Auto Scaling, which helps you
	// update instances in your Auto Scaling group after you make configuration
	// changes.
	//
	// When you cancel an instance refresh, this does not roll back any changes that
	// it made. Use the [RollbackInstanceRefresh]API to roll back instead.
	//
	// [instance refresh feature]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html
	// [RollbackInstanceRefresh]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_RollbackInstanceRefresh.html
	CancelInstanceRefresh(ctx context.Context, params *autoscaling.CancelInstanceRefreshInput, optFns ...func(*Options)) (*autoscaling.CancelInstanceRefreshOutput, error)
	// Completes the lifecycle action for the specified token or instance with the
	// specified result.
	//
	// This step is a part of the procedure for adding a lifecycle hook to an Auto
	// Scaling group:
	//
	//   - (Optional) Create a launch template or launch configuration with a user
	//     data script that runs while an instance is in a wait state due to a lifecycle
	//     hook.
	//
	//   - (Optional) Create a Lambda function and a rule that allows Amazon
	//     EventBridge to invoke your Lambda function when an instance is put into a wait
	//     state due to a lifecycle hook.
	//
	//   - (Optional) Create a notification target and an IAM role. The target can be
	//     either an Amazon SQS queue or an Amazon SNS topic. The role allows Amazon EC2
	//     Auto Scaling to publish lifecycle notifications to the target.
	//
	//   - Create the lifecycle hook. Specify whether the hook is used when the
	//     instances launch or terminate.
	//
	//   - If you need more time, record the lifecycle action heartbeat to keep the
	//     instance in a wait state.
	//
	//   - If you finish before the timeout period ends, send a callback by using the [CompleteLifecycleAction]
	//     API call.
	//
	// For more information, see [Complete a lifecycle action] in the Amazon EC2 Auto Scaling User Guide.
	//
	// [CompleteLifecycleAction]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_CompleteLifecycleAction.html
	// [Complete a lifecycle action]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/completing-lifecycle-hooks.html
	CompleteLifecycleAction(ctx context.Context, params *autoscaling.CompleteLifecycleActionInput, optFns ...func(*Options)) (*autoscaling.CompleteLifecycleActionOutput, error)
	//	We strongly recommend using a launch template when calling this operation to
	//
	// ensure full functionality for Amazon EC2 Auto Scaling and Amazon EC2.
	//
	// Creates an Auto Scaling group with the specified name and attributes.
	//
	// If you exceed your maximum limit of Auto Scaling groups, the call fails. To
	// query this limit, call the [DescribeAccountLimits]API. For information about updating this limit, see [Quotas for Amazon EC2 Auto Scaling]
	// in the Amazon EC2 Auto Scaling User Guide.
	//
	// If you're new to Amazon EC2 Auto Scaling, see the introductory tutorials in [Get started with Amazon EC2 Auto Scaling] in
	// the Amazon EC2 Auto Scaling User Guide.
	//
	// Every Auto Scaling group has three size properties ( DesiredCapacity , MaxSize ,
	// and MinSize ). Usually, you set these sizes based on a specific number of
	// instances. However, if you configure a mixed instances policy that defines
	// weights for the instance types, you must specify these sizes with the same units
	// that you use for weighting instances.
	//
	// [DescribeAccountLimits]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html
	// [Get started with Amazon EC2 Auto Scaling]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/get-started-with-ec2-auto-scaling.html
	// [Quotas for Amazon EC2 Auto Scaling]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-quotas.html
	CreateAutoScalingGroup(ctx context.Context, params *autoscaling.CreateAutoScalingGroupInput, optFns ...func(*Options)) (*autoscaling.CreateAutoScalingGroupOutput, error)
	// Creates a launch configuration.
	//
	// If you exceed your maximum limit of launch configurations, the call fails. To
	// query this limit, call the [DescribeAccountLimits]API. For information about updating this limit, see [Quotas for Amazon EC2 Auto Scaling]
	// in the Amazon EC2 Auto Scaling User Guide.
	//
	// For more information, see [Launch configurations] in the Amazon EC2 Auto Scaling User Guide.
	//
	// Amazon EC2 Auto Scaling configures instances launched as part of an Auto
	// Scaling group using either a launch template or a launch configuration. We
	// strongly recommend that you do not use launch configurations. They do not
	// provide full functionality for Amazon EC2 Auto Scaling or Amazon EC2. For
	// information about using launch templates, see [Launch templates]in the Amazon EC2 Auto Scaling
	// User Guide.
	//
	// [DescribeAccountLimits]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html
	// [Quotas for Amazon EC2 Auto Scaling]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-quotas.html
	// [Launch configurations]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-configurations.html
	// [Launch templates]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-templates.html
	CreateLaunchConfiguration(ctx context.Context, params *autoscaling.CreateLaunchConfigurationInput, optFns ...func(*Options)) (*autoscaling.CreateLaunchConfigurationOutput, error)
	// Creates or updates tags for the specified Auto Scaling group.
	//
	// When you specify a tag with a key that already exists, the operation overwrites
	// the previous tag definition, and you do not get an error message.
	//
	// For more information, see [Tag Auto Scaling groups and instances] in the Amazon EC2 Auto Scaling User Guide.
	//
	// [Tag Auto Scaling groups and instances]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html
	CreateOrUpdateTags(ctx context.Context, params *autoscaling.CreateOrUpdateTagsInput, optFns ...func(*Options)) (*autoscaling.CreateOrUpdateTagsOutput, error)
	// Deletes the specified Auto Scaling group.
	//
	// If the group has instances or scaling activities in progress, you must specify
	// the option to force the deletion in order for it to succeed. The force delete
	// operation will also terminate the EC2 instances. If the group has a warm pool,
	// the force delete option also deletes the warm pool.
	//
	// To remove instances from the Auto Scaling group before deleting it, call the [DetachInstances]
	// API with the list of instances and the option to decrement the desired capacity.
	// This ensures that Amazon EC2 Auto Scaling does not launch replacement instances.
	//
	// To terminate all instances before deleting the Auto Scaling group, call the [UpdateAutoScalingGroup]
	// API and set the minimum size and desired capacity of the Auto Scaling group to
	// zero.
	//
	// If the group has scaling policies, deleting the group deletes the policies, the
	// underlying alarm actions, and any alarm that no longer has an associated action.
	//
	// For more information, see [Delete your Auto Scaling infrastructure] in the Amazon EC2 Auto Scaling User Guide.
	//
	// [Delete your Auto Scaling infrastructure]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-process-shutdown.html
	// [DetachInstances]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DetachInstances.html
	// [UpdateAutoScalingGroup]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_UpdateAutoScalingGroup.html
	DeleteAutoScalingGroup(ctx context.Context, params *autoscaling.DeleteAutoScalingGroupInput, optFns ...func(*Options)) (*autoscaling.DeleteAutoScalingGroupOutput, error)
	// Deletes the specified launch configuration.
	//
	// The launch configuration must not be attached to an Auto Scaling group. When
	// this call completes, the launch configuration is no longer available for use.
	DeleteLaunchConfiguration(ctx context.Context, params *autoscaling.DeleteLaunchConfigurationInput, optFns ...func(*Options)) (*autoscaling.DeleteLaunchConfigurationOutput, error)
	// Deletes the specified lifecycle hook.
	//
	// If there are any outstanding lifecycle actions, they are completed first (
	// ABANDON for launching instances, CONTINUE for terminating instances).
	DeleteLifecycleHook(ctx context.Context, params *autoscaling.DeleteLifecycleHookInput, optFns ...func(*Options)) (*autoscaling.DeleteLifecycleHookOutput, error)
	// Deletes the specified notification.
	DeleteNotificationConfiguration(ctx context.Context, params *autoscaling.DeleteNotificationConfigurationInput, optFns ...func(*Options)) (*autoscaling.DeleteNotificationConfigurationOutput, error)
	// Deletes the specified scaling policy.
	//
	// Deleting either a step scaling policy or a simple scaling policy deletes the
	// underlying alarm action, but does not delete the alarm, even if it no longer has
	// an associated action.
	//
	// For more information, see [Delete a scaling policy] in the Amazon EC2 Auto Scaling User Guide.
	//
	// [Delete a scaling policy]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/deleting-scaling-policy.html
	DeletePolicy(ctx context.Context, params *autoscaling.DeletePolicyInput, optFns ...func(*Options)) (*autoscaling.DeletePolicyOutput, error)
	// Deletes the specified scheduled action.
	DeleteScheduledAction(ctx context.Context, params *autoscaling.DeleteScheduledActionInput, optFns ...func(*Options)) (*autoscaling.DeleteScheduledActionOutput, error)
	// Deletes the specified tags.
	DeleteTags(ctx context.Context, params *autoscaling.DeleteTagsInput, optFns ...func(*Options)) (*autoscaling.DeleteTagsOutput, error)
	// Deletes the warm pool for the specified Auto Scaling group.
	//
	// For more information, see [Warm pools for Amazon EC2 Auto Scaling] in the Amazon EC2 Auto Scaling User Guide.
	//
	// [Warm pools for Amazon EC2 Auto Scaling]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html
	DeleteWarmPool(ctx context.Context, params *autoscaling.DeleteWarmPoolInput, optFns ...func(*Options)) (*autoscaling.DeleteWarmPoolOutput, error)
	// Describes the current Amazon EC2 Auto Scaling resource quotas for your account.
	//
	// When you establish an Amazon Web Services account, the account has initial
	// quotas on the maximum number of Auto Scaling groups and launch configurations
	// that you can create in a given Region. For more information, see [Quotas for Amazon EC2 Auto Scaling]in the Amazon
	// EC2 Auto Scaling User Guide.
	//
	// [Quotas for Amazon EC2 Auto Scaling]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-quotas.html
	DescribeAccountLimits(ctx context.Context, params *autoscaling.DescribeAccountLimitsInput, optFns ...func(*Options)) (*autoscaling.DescribeAccountLimitsOutput, error)
	// Describes the available adjustment types for step scaling and simple scaling
	// policies.
	//
	// The following adjustment types are supported:
	//
	//   - ChangeInCapacity
	//
	//   - ExactCapacity
	//
	//   - PercentChangeInCapacity
	DescribeAdjustmentTypes(ctx context.Context, params *autoscaling.DescribeAdjustmentTypesInput, optFns ...func(*Options)) (*autoscaling.DescribeAdjustmentTypesOutput, error)
	// Gets information about the Auto Scaling groups in the account and Region.
	//
	// If you specify Auto Scaling group names, the output includes information for
	// only the specified Auto Scaling groups. If you specify filters, the output
	// includes information for only those Auto Scaling groups that meet the filter
	// criteria. If you do not specify group names or filters, the output includes
	// information for all Auto Scaling groups.
	//
	// This operation also returns information about instances in Auto Scaling groups.
	// To retrieve information about the instances in a warm pool, you must call the [DescribeWarmPool]
	// API.
	//
	// [DescribeWarmPool]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeWarmPool.html
	DescribeAutoScalingGroups(ctx context.Context, params *autoscaling.DescribeAutoScalingGroupsInput, optFns ...func(*Options)) (*autoscaling.DescribeAutoScalingGroupsOutput, error)
	// Gets information about the Auto Scaling instances in the account and Region.
	DescribeAutoScalingInstances(ctx context.Context, params *autoscaling.DescribeAutoScalingInstancesInput, optFns ...func(*Options)) (*autoscaling.DescribeAutoScalingInstancesOutput, error)
	// Describes the notification types that are supported by Amazon EC2 Auto Scaling.
	DescribeAutoScalingNotificationTypes(ctx context.Context, params *autoscaling.DescribeAutoScalingNotificationTypesInput, optFns ...func(*Options)) (*autoscaling.DescribeAutoScalingNotificationTypesOutput, error)
	// Gets information about the instance refreshes for the specified Auto Scaling
	// group from the previous six weeks.
	//
	// This operation is part of the [instance refresh feature] in Amazon EC2 Auto Scaling, which helps you
	// update instances in your Auto Scaling group after you make configuration
	// changes.
	//
	// To help you determine the status of an instance refresh, Amazon EC2 Auto
	// Scaling returns information about the instance refreshes you previously
	// initiated, including their status, start time, end time, the percentage of the
	// instance refresh that is complete, and the number of instances remaining to
	// update before the instance refresh is complete. If a rollback is initiated while
	// an instance refresh is in progress, Amazon EC2 Auto Scaling also returns
	// information about the rollback of the instance refresh.
	//
	// [instance refresh feature]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html
	DescribeInstanceRefreshes(ctx context.Context, params *autoscaling.DescribeInstanceRefreshesInput, optFns ...func(*Options)) (*autoscaling.DescribeInstanceRefreshesOutput, error)
	// Gets information about the launch configurations in the account and Region.
	DescribeLaunchConfigurations(ctx context.Context, params *autoscaling.DescribeLaunchConfigurationsInput, optFns ...func(*Options)) (*autoscaling.DescribeLaunchConfigurationsOutput, error)
	// Describes the available types of lifecycle hooks.
	//
	// The following hook types are supported:
	//
	//   - autoscaling:EC2_INSTANCE_LAUNCHING
	//
	//   - autoscaling:EC2_INSTANCE_TERMINATING
	DescribeLifecycleHookTypes(ctx context.Context, params *autoscaling.DescribeLifecycleHookTypesInput, optFns ...func(*Options)) (*autoscaling.DescribeLifecycleHookTypesOutput, error)
	// Gets information about the lifecycle hooks for the specified Auto Scaling group.
	DescribeLifecycleHooks(ctx context.Context, params *autoscaling.DescribeLifecycleHooksInput, optFns ...func(*Options)) (*autoscaling.DescribeLifecycleHooksOutput, error)
	// This API operation is superseded by [DescribeTrafficSources], which can describe multiple traffic
	// sources types. We recommend using DetachTrafficSources to simplify how you
	// manage traffic sources. However, we continue to support
	// DescribeLoadBalancerTargetGroups . You can use both the original
	// DescribeLoadBalancerTargetGroups API operation and DescribeTrafficSources on
	// the same Auto Scaling group.
	//
	// Gets information about the Elastic Load Balancing target groups for the
	// specified Auto Scaling group.
	//
	// To determine the attachment status of the target group, use the State element
	// in the response. When you attach a target group to an Auto Scaling group, the
	// initial State value is Adding . The state transitions to Added after all Auto
	// Scaling instances are registered with the target group. If Elastic Load
	// Balancing health checks are enabled for the Auto Scaling group, the state
	// transitions to InService after at least one Auto Scaling instance passes the
	// health check. When the target group is in the InService state, Amazon EC2 Auto
	// Scaling can terminate and replace any instances that are reported as unhealthy.
	// If no registered instances pass the health checks, the target group doesn't
	// enter the InService state.
	//
	// Target groups also have an InService state if you attach them in the [CreateAutoScalingGroup] API call.
	// If your target group state is InService , but it is not working properly, check
	// the scaling activities by calling [DescribeScalingActivities]and take any corrective actions necessary.
	//
	// For help with failed health checks, see [Troubleshooting Amazon EC2 Auto Scaling: Health checks] in the Amazon EC2 Auto Scaling User
	// Guide. For more information, see [Use Elastic Load Balancing to distribute traffic across the instances in your Auto Scaling group]in the Amazon EC2 Auto Scaling User Guide.
	//
	// You can use this operation to describe target groups that were attached by
	// using [AttachLoadBalancerTargetGroups], but not for target groups that were attached by using [AttachTrafficSources].
	//
	// [Troubleshooting Amazon EC2 Auto Scaling: Health checks]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ts-as-healthchecks.html
	// [AttachLoadBalancerTargetGroups]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_AttachLoadBalancerTargetGroups.html
	// [DescribeScalingActivities]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeScalingActivities.html
	// [CreateAutoScalingGroup]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_CreateAutoScalingGroup.html
	// [DescribeTrafficSources]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeTrafficSources.html
	// [AttachTrafficSources]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_AttachTrafficSources.html
	// [Use Elastic Load Balancing to distribute traffic across the instances in your Auto Scaling group]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html
	DescribeLoadBalancerTargetGroups(ctx context.Context, params *autoscaling.DescribeLoadBalancerTargetGroupsInput, optFns ...func(*Options)) (*autoscaling.DescribeLoadBalancerTargetGroupsOutput, error)
	// This API operation is superseded by [DescribeTrafficSources], which can describe multiple traffic
	// sources types. We recommend using DescribeTrafficSources to simplify how you
	// manage traffic sources. However, we continue to support DescribeLoadBalancers .
	// You can use both the original DescribeLoadBalancers API operation and
	// DescribeTrafficSources on the same Auto Scaling group.
	//
	// Gets information about the load balancers for the specified Auto Scaling group.
	//
	// This operation describes only Classic Load Balancers. If you have Application
	// Load Balancers, Network Load Balancers, or Gateway Load Balancers, use the [DescribeLoadBalancerTargetGroups]API
	// instead.
	//
	// To determine the attachment status of the load balancer, use the State element
	// in the response. When you attach a load balancer to an Auto Scaling group, the
	// initial State value is Adding . The state transitions to Added after all Auto
	// Scaling instances are registered with the load balancer. If Elastic Load
	// Balancing health checks are enabled for the Auto Scaling group, the state
	// transitions to InService after at least one Auto Scaling instance passes the
	// health check. When the load balancer is in the InService state, Amazon EC2 Auto
	// Scaling can terminate and replace any instances that are reported as unhealthy.
	// If no registered instances pass the health checks, the load balancer doesn't
	// enter the InService state.
	//
	// Load balancers also have an InService state if you attach them in the [CreateAutoScalingGroup] API
	// call. If your load balancer state is InService , but it is not working properly,
	// check the scaling activities by calling [DescribeScalingActivities]and take any corrective actions
	// necessary.
	//
	// For help with failed health checks, see [Troubleshooting Amazon EC2 Auto Scaling: Health checks] in the Amazon EC2 Auto Scaling User
	// Guide. For more information, see [Use Elastic Load Balancing to distribute traffic across the instances in your Auto Scaling group]in the Amazon EC2 Auto Scaling User Guide.
	//
	// [Troubleshooting Amazon EC2 Auto Scaling: Health checks]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ts-as-healthchecks.html
	// [DescribeScalingActivities]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeScalingActivities.html
	// [DescribeLoadBalancerTargetGroups]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeLoadBalancerTargetGroups.html
	// [CreateAutoScalingGroup]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_CreateAutoScalingGroup.html
	// [DescribeTrafficSources]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeTrafficSources.html
	// [Use Elastic Load Balancing to distribute traffic across the instances in your Auto Scaling group]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html
	DescribeLoadBalancers(ctx context.Context, params *autoscaling.DescribeLoadBalancersInput, optFns ...func(*Options)) (*autoscaling.DescribeLoadBalancersOutput, error)
	// Describes the available CloudWatch metrics for Amazon EC2 Auto Scaling.
	DescribeMetricCollectionTypes(ctx context.Context, params *autoscaling.DescribeMetricCollectionTypesInput, optFns ...func(*Options)) (*autoscaling.DescribeMetricCollectionTypesOutput, error)
	// Gets information about the Amazon SNS notifications that are configured for one
	// or more Auto Scaling groups.
	DescribeNotificationConfigurations(ctx context.Context, params *autoscaling.DescribeNotificationConfigurationsInput, optFns ...func(*Options)) (*autoscaling.DescribeNotificationConfigurationsOutput, error)
	// Gets information about the scaling policies in the account and Region.
	DescribePolicies(ctx context.Context, params *autoscaling.DescribePoliciesInput, optFns ...func(*Options)) (*autoscaling.DescribePoliciesOutput, error)
	// Gets information about the scaling activities in the account and Region.
	//
	// When scaling events occur, you see a record of the scaling activity in the
	// scaling activities. For more information, see [Verify a scaling activity for an Auto Scaling group]in the Amazon EC2 Auto Scaling
	// User Guide.
	//
	// If the scaling event succeeds, the value of the StatusCode element in the
	// response is Successful . If an attempt to launch instances failed, the
	// StatusCode value is Failed or Cancelled and the StatusMessage element in the
	// response indicates the cause of the failure. For help interpreting the
	// StatusMessage , see [Troubleshooting Amazon EC2 Auto Scaling] in the Amazon EC2 Auto Scaling User Guide.
	//
	// [Troubleshooting Amazon EC2 Auto Scaling]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/CHAP_Troubleshooting.html
	// [Verify a scaling activity for an Auto Scaling group]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-verify-scaling-activity.html
	DescribeScalingActivities(ctx context.Context, params *autoscaling.DescribeScalingActivitiesInput, optFns ...func(*Options)) (*autoscaling.DescribeScalingActivitiesOutput, error)
	// Describes the scaling process types for use with the [ResumeProcesses] and [SuspendProcesses] APIs.
	//
	// [ResumeProcesses]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_ResumeProcesses.html
	// [SuspendProcesses]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_SuspendProcesses.html
	DescribeScalingProcessTypes(ctx context.Context, params *autoscaling.DescribeScalingProcessTypesInput, optFns ...func(*Options)) (*autoscaling.DescribeScalingProcessTypesOutput, error)
	// Gets information about the scheduled actions that haven't run or that have not
	// reached their end time.
	//
	// To describe the scaling activities for scheduled actions that have already run,
	// call the [DescribeScalingActivities]API.
	//
	// [DescribeScalingActivities]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeScalingActivities.html
	DescribeScheduledActions(ctx context.Context, params *autoscaling.DescribeScheduledActionsInput, optFns ...func(*Options)) (*autoscaling.DescribeScheduledActionsOutput, error)
	// Describes the specified tags.
	//
	// You can use filters to limit the results. For example, you can query for the
	// tags for a specific Auto Scaling group. You can specify multiple values for a
	// filter. A tag must match at least one of the specified values for it to be
	// included in the results.
	//
	// You can also specify multiple filters. The result includes information for a
	// particular tag only if it matches all the filters. If there's no match, no
	// special message is returned.
	//
	// For more information, see [Tag Auto Scaling groups and instances] in the Amazon EC2 Auto Scaling User Guide.
	//
	// [Tag Auto Scaling groups and instances]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html
	DescribeTags(ctx context.Context, params *autoscaling.DescribeTagsInput, optFns ...func(*Options)) (*autoscaling.DescribeTagsOutput, error)
	// Describes the termination policies supported by Amazon EC2 Auto Scaling.
	//
	// For more information, see [Configure termination policies for Amazon EC2 Auto Scaling] in the Amazon EC2 Auto Scaling User Guide.
	//
	// [Configure termination policies for Amazon EC2 Auto Scaling]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html
	DescribeTerminationPolicyTypes(ctx context.Context, params *autoscaling.DescribeTerminationPolicyTypesInput, optFns ...func(*Options)) (*autoscaling.DescribeTerminationPolicyTypesOutput, error)
	// Gets information about the traffic sources for the specified Auto Scaling group.
	//
	// You can optionally provide a traffic source type. If you provide a traffic
	// source type, then the results only include that traffic source type.
	//
	// If you do not provide a traffic source type, then the results include all the
	// traffic sources for the specified Auto Scaling group.
	DescribeTrafficSources(ctx context.Context, params *autoscaling.DescribeTrafficSourcesInput, optFns ...func(*Options)) (*autoscaling.DescribeTrafficSourcesOutput, error)
	// Gets information about a warm pool and its instances.
	//
	// For more information, see [Warm pools for Amazon EC2 Auto Scaling] in the Amazon EC2 Auto Scaling User Guide.
	//
	// [Warm pools for Amazon EC2 Auto Scaling]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html
	DescribeWarmPool(ctx context.Context, params *autoscaling.DescribeWarmPoolInput, optFns ...func(*Options)) (*autoscaling.DescribeWarmPoolOutput, error)
	// Removes one or more instances from the specified Auto Scaling group.
	//
	// After the instances are detached, you can manage them independent of the Auto
	// Scaling group.
	//
	// If you do not specify the option to decrement the desired capacity, Amazon EC2
	// Auto Scaling launches instances to replace the ones that are detached.
	//
	// If there is a Classic Load Balancer attached to the Auto Scaling group, the
	// instances are deregistered from the load balancer. If there are target groups
	// attached to the Auto Scaling group, the instances are deregistered from the
	// target groups.
	//
	// For more information, see [Detach or attach instances] in the Amazon EC2 Auto Scaling User Guide.
	//
	// [Detach or attach instances]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-detach-attach-instances.html
	DetachInstances(ctx context.Context, params *autoscaling.DetachInstancesInput, optFns ...func(*Options)) (*autoscaling.DetachInstancesOutput, error)
	// This API operation is superseded by [DetachTrafficSources], which can detach multiple traffic sources
	// types. We recommend using DetachTrafficSources to simplify how you manage
	// traffic sources. However, we continue to support DetachLoadBalancerTargetGroups
	// . You can use both the original DetachLoadBalancerTargetGroups API operation
	// and DetachTrafficSources on the same Auto Scaling group.
	//
	// Detaches one or more target groups from the specified Auto Scaling group.
	//
	// When you detach a target group, it enters the Removing state while
	// deregistering the instances in the group. When all instances are deregistered,
	// then you can no longer describe the target group using the [DescribeLoadBalancerTargetGroups]API call. The
	// instances remain running.
	//
	// You can use this operation to detach target groups that were attached by using [AttachLoadBalancerTargetGroups]
	// , but not for target groups that were attached by using [AttachTrafficSources].
	//
	// [AttachLoadBalancerTargetGroups]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_AttachLoadBalancerTargetGroups.html
	// [DescribeLoadBalancerTargetGroups]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeLoadBalancerTargetGroups.html
	// [DetachTrafficSources]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeTrafficSources.html
	// [AttachTrafficSources]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_AttachTrafficSources.html
	DetachLoadBalancerTargetGroups(ctx context.Context, params *autoscaling.DetachLoadBalancerTargetGroupsInput, optFns ...func(*Options)) (*autoscaling.DetachLoadBalancerTargetGroupsOutput, error)
	// This API operation is superseded by [DetachTrafficSources], which can detach multiple traffic sources
	// types. We recommend using DetachTrafficSources to simplify how you manage
	// traffic sources. However, we continue to support DetachLoadBalancers . You can
	// use both the original DetachLoadBalancers API operation and DetachTrafficSources
	// on the same Auto Scaling group.
	//
	// Detaches one or more Classic Load Balancers from the specified Auto Scaling
	// group.
	//
	// This operation detaches only Classic Load Balancers. If you have Application
	// Load Balancers, Network Load Balancers, or Gateway Load Balancers, use the [DetachLoadBalancerTargetGroups]API
	// instead.
	//
	// When you detach a load balancer, it enters the Removing state while
	// deregistering the instances in the group. When all instances are deregistered,
	// then you can no longer describe the load balancer using the [DescribeLoadBalancers]API call. The
	// instances remain running.
	//
	// [DetachLoadBalancerTargetGroups]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DetachLoadBalancerTargetGroups.html
	// [DescribeLoadBalancers]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeLoadBalancers.html
	// [DetachTrafficSources]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DetachTrafficSources.html
	DetachLoadBalancers(ctx context.Context, params *autoscaling.DetachLoadBalancersInput, optFns ...func(*Options)) (*autoscaling.DetachLoadBalancersOutput, error)
	// Detaches one or more traffic sources from the specified Auto Scaling group.
	//
	// When you detach a traffic source, it enters the Removing state while
	// deregistering the instances in the group. When all instances are deregistered,
	// then you can no longer describe the traffic source using the [DescribeTrafficSources]API call. The
	// instances continue to run.
	//
	// [DescribeTrafficSources]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeTrafficSources.html
	DetachTrafficSources(ctx context.Context, params *autoscaling.DetachTrafficSourcesInput, optFns ...func(*Options)) (*autoscaling.DetachTrafficSourcesOutput, error)
	// Disables group metrics collection for the specified Auto Scaling group.
	DisableMetricsCollection(ctx context.Context, params *autoscaling.DisableMetricsCollectionInput, optFns ...func(*Options)) (*autoscaling.DisableMetricsCollectionOutput, error)
	// Enables group metrics collection for the specified Auto Scaling group.
	//
	// You can use these metrics to track changes in an Auto Scaling group and to set
	// alarms on threshold values. You can view group metrics using the Amazon EC2 Auto
	// Scaling console or the CloudWatch console. For more information, see [Monitor CloudWatch metrics for your Auto Scaling groups and instances]in the
	// Amazon EC2 Auto Scaling User Guide.
	//
	// [Monitor CloudWatch metrics for your Auto Scaling groups and instances]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-cloudwatch-monitoring.html
	EnableMetricsCollection(ctx context.Context, params *autoscaling.EnableMetricsCollectionInput, optFns ...func(*Options)) (*autoscaling.EnableMetricsCollectionOutput, error)
	// Moves the specified instances into the standby state.
	//
	// If you choose to decrement the desired capacity of the Auto Scaling group, the
	// instances can enter standby as long as the desired capacity of the Auto Scaling
	// group after the instances are placed into standby is equal to or greater than
	// the minimum capacity of the group.
	//
	// If you choose not to decrement the desired capacity of the Auto Scaling group,
	// the Auto Scaling group launches new instances to replace the instances on
	// standby.
	//
	// For more information, see [Temporarily removing instances from your Auto Scaling group] in the Amazon EC2 Auto Scaling User Guide.
	//
	// [Temporarily removing instances from your Auto Scaling group]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enter-exit-standby.html
	EnterStandby(ctx context.Context, params *autoscaling.EnterStandbyInput, optFns ...func(*Options)) (*autoscaling.EnterStandbyOutput, error)
	// Executes the specified policy. This can be useful for testing the design of
	// your scaling policy.
	ExecutePolicy(ctx context.Context, params *autoscaling.ExecutePolicyInput, optFns ...func(*Options)) (*autoscaling.ExecutePolicyOutput, error)
	// Moves the specified instances out of the standby state.
	//
	// After you put the instances back in service, the desired capacity is
	// incremented.
	//
	// For more information, see [Temporarily removing instances from your Auto Scaling group] in the Amazon EC2 Auto Scaling User Guide.
	//
	// [Temporarily removing instances from your Auto Scaling group]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enter-exit-standby.html
	ExitStandby(ctx context.Context, params *autoscaling.ExitStandbyInput, optFns ...func(*Options)) (*autoscaling.ExitStandbyOutput, error)
	// Retrieves the forecast data for a predictive scaling policy.
	//
	// Load forecasts are predictions of the hourly load values using historical load
	// data from CloudWatch and an analysis of historical trends. Capacity forecasts
	// are represented as predicted values for the minimum capacity that is needed on
	// an hourly basis, based on the hourly load forecast.
	//
	// A minimum of 24 hours of data is required to create the initial forecasts.
	// However, having a full 14 days of historical data results in more accurate
	// forecasts.
	//
	// For more information, see [Predictive scaling for Amazon EC2 Auto Scaling] in the Amazon EC2 Auto Scaling User Guide.
	//
	// [Predictive scaling for Amazon EC2 Auto Scaling]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-predictive-scaling.html
	GetPredictiveScalingForecast(ctx context.Context, params *autoscaling.GetPredictiveScalingForecastInput, optFns ...func(*Options)) (*autoscaling.GetPredictiveScalingForecastOutput, error)
	//	Launches a specified number of instances in an Auto Scaling group. Returns
	//
	// instance IDs and other details if launch is successful or error details if
	// launch is unsuccessful.
	LaunchInstances(ctx context.Context, params *autoscaling.LaunchInstancesInput, optFns ...func(*Options)) (*autoscaling.LaunchInstancesOutput, error)
	// Creates or updates a lifecycle hook for the specified Auto Scaling group.
	//
	// Lifecycle hooks let you create solutions that are aware of events in the Auto
	// Scaling instance lifecycle, and then perform a custom action on instances when
	// the corresponding lifecycle event occurs.
	//
	// This step is a part of the procedure for adding a lifecycle hook to an Auto
	// Scaling group:
	//
	//   - (Optional) Create a launch template or launch configuration with a user
	//     data script that runs while an instance is in a wait state due to a lifecycle
	//     hook.
	//
	//   - (Optional) Create a Lambda function and a rule that allows Amazon
	//     EventBridge to invoke your Lambda function when an instance is put into a wait
	//     state due to a lifecycle hook.
	//
	//   - (Optional) Create a notification target and an IAM role. The target can be
	//     either an Amazon SQS queue or an Amazon SNS topic. The role allows Amazon EC2
	//     Auto Scaling to publish lifecycle notifications to the target.
	//
	//   - Create the lifecycle hook. Specify whether the hook is used when the
	//     instances launch or terminate.
	//
	//   - If you need more time, record the lifecycle action heartbeat to keep the
	//     instance in a wait state using the [RecordLifecycleActionHeartbeat]API call.
	//
	//   - If you finish before the timeout period ends, send a callback by using the [CompleteLifecycleAction]
	//     API call.
	//
	// For more information, see [Amazon EC2 Auto Scaling lifecycle hooks] in the Amazon EC2 Auto Scaling User Guide.
	//
	// If you exceed your maximum limit of lifecycle hooks, which by default is 50 per
	// Auto Scaling group, the call fails.
	//
	// You can view the lifecycle hooks for an Auto Scaling group using the [DescribeLifecycleHooks] API call.
	// If you are no longer using a lifecycle hook, you can delete it by calling the [DeleteLifecycleHook]
	// API.
	//
	// [RecordLifecycleActionHeartbeat]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_RecordLifecycleActionHeartbeat.html
	// [CompleteLifecycleAction]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_CompleteLifecycleAction.html
	// [Amazon EC2 Auto Scaling lifecycle hooks]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html
	// [DescribeLifecycleHooks]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeLifecycleHooks.html
	// [DeleteLifecycleHook]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DeleteLifecycleHook.html
	PutLifecycleHook(ctx context.Context, params *autoscaling.PutLifecycleHookInput, optFns ...func(*Options)) (*autoscaling.PutLifecycleHookOutput, error)
	// Configures an Auto Scaling group to send notifications when specified events
	// take place. Subscribers to the specified topic can have messages delivered to an
	// endpoint such as a web server or an email address.
	//
	// This configuration overwrites any existing configuration.
	//
	// For more information, see [Amazon SNS notification options for Amazon EC2 Auto Scaling] in the Amazon EC2 Auto Scaling User Guide.
	//
	// If you exceed your maximum limit of SNS topics, which is 10 per Auto Scaling
	// group, the call fails.
	//
	// [Amazon SNS notification options for Amazon EC2 Auto Scaling]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-sns-notifications.html
	PutNotificationConfiguration(ctx context.Context, params *autoscaling.PutNotificationConfigurationInput, optFns ...func(*Options)) (*autoscaling.PutNotificationConfigurationOutput, error)
	// Creates or updates a scaling policy for an Auto Scaling group. Scaling policies
	// are used to scale an Auto Scaling group based on configurable metrics. If no
	// policies are defined, the dynamic scaling and predictive scaling features are
	// not used.
	//
	// For more information about using dynamic scaling, see [Target tracking scaling policies] and [Step and simple scaling policies] in the Amazon EC2
	// Auto Scaling User Guide.
	//
	// For more information about using predictive scaling, see [Predictive scaling for Amazon EC2 Auto Scaling] in the Amazon EC2
	// Auto Scaling User Guide.
	//
	// You can view the scaling policies for an Auto Scaling group using the [DescribePolicies] API
	// call. If you are no longer using a scaling policy, you can delete it by calling
	// the [DeletePolicy]API.
	//
	// [Step and simple scaling policies]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html
	// [DeletePolicy]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DeletePolicy.html
	// [Target tracking scaling policies]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-target-tracking.html
	// [DescribePolicies]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribePolicies.html
	// [Predictive scaling for Amazon EC2 Auto Scaling]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-predictive-scaling.html
	PutScalingPolicy(ctx context.Context, params *autoscaling.PutScalingPolicyInput, optFns ...func(*Options)) (*autoscaling.PutScalingPolicyOutput, error)
	// Creates or updates a scheduled scaling action for an Auto Scaling group.
	//
	// For more information, see [Scheduled scaling] in the Amazon EC2 Auto Scaling User Guide.
	//
	// You can view the scheduled actions for an Auto Scaling group using the [DescribeScheduledActions] API
	// call. If you are no longer using a scheduled action, you can delete it by
	// calling the [DeleteScheduledAction]API.
	//
	// If you try to schedule your action in the past, Amazon EC2 Auto Scaling returns
	// an error message.
	//
	// [DeleteScheduledAction]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DeleteScheduledAction.html
	// [DescribeScheduledActions]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeScheduledActions.html
	// [Scheduled scaling]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scheduled-scaling.html
	PutScheduledUpdateGroupAction(ctx context.Context, params *autoscaling.PutScheduledUpdateGroupActionInput, optFns ...func(*Options)) (*autoscaling.PutScheduledUpdateGroupActionOutput, error)
	// Creates or updates a warm pool for the specified Auto Scaling group. A warm
	// pool is a pool of pre-initialized EC2 instances that sits alongside the Auto
	// Scaling group. Whenever your application needs to scale out, the Auto Scaling
	// group can draw on the warm pool to meet its new desired capacity.
	//
	// This operation must be called from the Region in which the Auto Scaling group
	// was created.
	//
	// You can view the instances in the warm pool using the [DescribeWarmPool] API call. If you are no
	// longer using a warm pool, you can delete it by calling the [DeleteWarmPool]API.
	//
	// For more information, see [Warm pools for Amazon EC2 Auto Scaling] in the Amazon EC2 Auto Scaling User Guide.
	//
	// [DeleteWarmPool]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DeleteWarmPool.html
	// [DescribeWarmPool]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeWarmPool.html
	// [Warm pools for Amazon EC2 Auto Scaling]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html
	PutWarmPool(ctx context.Context, params *autoscaling.PutWarmPoolInput, optFns ...func(*Options)) (*autoscaling.PutWarmPoolOutput, error)
	// Records a heartbeat for the lifecycle action associated with the specified
	// token or instance. This extends the timeout by the length of time defined using
	// the [PutLifecycleHook]API call.
	//
	// This step is a part of the procedure for adding a lifecycle hook to an Auto
	// Scaling group:
	//
	//   - (Optional) Create a launch template or launch configuration with a user
	//     data script that runs while an instance is in a wait state due to a lifecycle
	//     hook.
	//
	//   - (Optional) Create a Lambda function and a rule that allows Amazon
	//     EventBridge to invoke your Lambda function when an instance is put into a wait
	//     state due to a lifecycle hook.
	//
	//   - (Optional) Create a notification target and an IAM role. The target can be
	//     either an Amazon SQS queue or an Amazon SNS topic. The role allows Amazon EC2
	//     Auto Scaling to publish lifecycle notifications to the target.
	//
	//   - Create the lifecycle hook. Specify whether the hook is used when the
	//     instances launch or terminate.
	//
	//   - If you need more time, record the lifecycle action heartbeat to keep the
	//     instance in a wait state.
	//
	//   - If you finish before the timeout period ends, send a callback by using the [CompleteLifecycleAction]
	//     API call.
	//
	// For more information, see [Amazon EC2 Auto Scaling lifecycle hooks] in the Amazon EC2 Auto Scaling User Guide.
	//
	// [CompleteLifecycleAction]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_CompleteLifecycleAction.html
	// [Amazon EC2 Auto Scaling lifecycle hooks]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html
	// [PutLifecycleHook]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_PutLifecycleHook.html
	RecordLifecycleActionHeartbeat(ctx context.Context, params *autoscaling.RecordLifecycleActionHeartbeatInput, optFns ...func(*Options)) (*autoscaling.RecordLifecycleActionHeartbeatOutput, error)
	// Resumes the specified suspended auto scaling processes, or all suspended
	// process, for the specified Auto Scaling group.
	//
	// For more information, see [Suspend and resume Amazon EC2 Auto Scaling processes] in the Amazon EC2 Auto Scaling User Guide.
	//
	// [Suspend and resume Amazon EC2 Auto Scaling processes]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html
	ResumeProcesses(ctx context.Context, params *autoscaling.ResumeProcessesInput, optFns ...func(*Options)) (*autoscaling.ResumeProcessesOutput, error)
	// Cancels an instance refresh that is in progress and rolls back any changes that
	// it made. Amazon EC2 Auto Scaling replaces any instances that were replaced
	// during the instance refresh. This restores your Auto Scaling group to the
	// configuration that it was using before the start of the instance refresh.
	//
	// This operation is part of the [instance refresh feature] in Amazon EC2 Auto Scaling, which helps you
	// update instances in your Auto Scaling group after you make configuration
	// changes.
	//
	// A rollback is not supported in the following situations:
	//
	//   - There is no desired configuration specified for the instance refresh.
	//
	//   - The Auto Scaling group has a launch template that uses an Amazon Web
	//     Services Systems Manager parameter instead of an AMI ID for the ImageId
	//     property.
	//
	//   - The Auto Scaling group uses the launch template's $Latest or $Default
	//     version.
	//
	// When you receive a successful response from this operation, Amazon EC2 Auto
	// Scaling immediately begins replacing instances. You can check the status of this
	// operation through the [DescribeInstanceRefreshes]API operation.
	//
	// [instance refresh feature]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html
	// [DescribeInstanceRefreshes]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeInstanceRefreshes.html
	RollbackInstanceRefresh(ctx context.Context, params *autoscaling.RollbackInstanceRefreshInput, optFns ...func(*Options)) (*autoscaling.RollbackInstanceRefreshOutput, error)
	// Sets the size of the specified Auto Scaling group.
	//
	// If a scale-in activity occurs as a result of a new DesiredCapacity value that
	// is lower than the current size of the group, the Auto Scaling group uses its
	// termination policy to determine which instances to terminate.
	//
	// For more information, see [Manual scaling] in the Amazon EC2 Auto Scaling User Guide.
	//
	// [Manual scaling]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scaling-manually.html
	SetDesiredCapacity(ctx context.Context, params *autoscaling.SetDesiredCapacityInput, optFns ...func(*Options)) (*autoscaling.SetDesiredCapacityOutput, error)
	// Sets the health status of the specified instance.
	//
	// For more information, see [Set up a custom health check for your Auto Scaling group] in the Amazon EC2 Auto Scaling User Guide.
	//
	// [Set up a custom health check for your Auto Scaling group]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/set-up-a-custom-health-check.html
	SetInstanceHealth(ctx context.Context, params *autoscaling.SetInstanceHealthInput, optFns ...func(*Options)) (*autoscaling.SetInstanceHealthOutput, error)
	// Updates the instance protection settings of the specified instances. This
	// operation cannot be called on instances in a warm pool.
	//
	// For more information, see [Use instance scale-in protection] in the Amazon EC2 Auto Scaling User Guide.
	//
	// If you exceed your maximum limit of instance IDs, which is 50 per Auto Scaling
	// group, the call fails.
	//
	// [Use instance scale-in protection]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html
	SetInstanceProtection(ctx context.Context, params *autoscaling.SetInstanceProtectionInput, optFns ...func(*Options)) (*autoscaling.SetInstanceProtectionOutput, error)
	// Starts an instance refresh.
	//
	// This operation is part of the [instance refresh feature] in Amazon EC2 Auto Scaling, which helps you
	// update instances in your Auto Scaling group. This feature is helpful, for
	// example, when you have a new AMI or a new user data script. You just need to
	// create a new launch template that specifies the new AMI or user data script.
	// Then start an instance refresh to immediately begin the process of updating
	// instances in the group.
	//
	// If successful, the request's response contains a unique ID that you can use to
	// track the progress of the instance refresh. To query its status, call the [DescribeInstanceRefreshes]API.
	// To describe the instance refreshes that have already run, call the [DescribeInstanceRefreshes]API. To
	// cancel an instance refresh that is in progress, use the [CancelInstanceRefresh]API.
	//
	// An instance refresh might fail for several reasons, such as EC2 launch
	// failures, misconfigured health checks, or not ignoring or allowing the
	// termination of instances that are in Standby state or protected from scale in.
	// You can monitor for failed EC2 launches using the scaling activities. To find
	// the scaling activities, call the [DescribeScalingActivities]API.
	//
	// If you enable auto rollback, your Auto Scaling group will be rolled back
	// automatically when the instance refresh fails. You can enable this feature
	// before starting an instance refresh by specifying the AutoRollback property in
	// the instance refresh preferences. Otherwise, to roll back an instance refresh
	// before it finishes, use the [RollbackInstanceRefresh]API.
	//
	// [DescribeScalingActivities]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeScalingActivities.html
	// [instance refresh feature]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html
	// [DescribeInstanceRefreshes]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeInstanceRefreshes.html
	// [CancelInstanceRefresh]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_CancelInstanceRefresh.html
	// [RollbackInstanceRefresh]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_RollbackInstanceRefresh.html
	StartInstanceRefresh(ctx context.Context, params *autoscaling.StartInstanceRefreshInput, optFns ...func(*Options)) (*autoscaling.StartInstanceRefreshOutput, error)
	// Suspends the specified auto scaling processes, or all processes, for the
	// specified Auto Scaling group.
	//
	// If you suspend either the Launch or Terminate process types, it can prevent
	// other process types from functioning properly. For more information, see [Suspend and resume Amazon EC2 Auto Scaling processes]in the
	// Amazon EC2 Auto Scaling User Guide.
	//
	// To resume processes that have been suspended, call the [ResumeProcesses] API.
	//
	// [ResumeProcesses]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_ResumeProcesses.html
	// [Suspend and resume Amazon EC2 Auto Scaling processes]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html
	SuspendProcesses(ctx context.Context, params *autoscaling.SuspendProcessesInput, optFns ...func(*Options)) (*autoscaling.SuspendProcessesOutput, error)
	// Terminates the specified instance and optionally adjusts the desired group
	// size. This operation cannot be called on instances in a warm pool.
	//
	// This call simply makes a termination request. The instance is not terminated
	// immediately. When an instance is terminated, the instance status changes to
	// terminated . You can't connect to or start an instance after you've terminated
	// it.
	//
	// If you do not specify the option to decrement the desired capacity, Amazon EC2
	// Auto Scaling launches instances to replace the ones that are terminated.
	//
	// By default, Amazon EC2 Auto Scaling balances instances across all Availability
	// Zones. If you decrement the desired capacity, your Auto Scaling group can become
	// unbalanced between Availability Zones. Amazon EC2 Auto Scaling tries to
	// rebalance the group, and rebalancing might terminate instances in other zones.
	// For more information, see [Manual scaling]in the Amazon EC2 Auto Scaling User Guide.
	//
	// [Manual scaling]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scaling-manually.html
	TerminateInstanceInAutoScalingGroup(ctx context.Context, params *autoscaling.TerminateInstanceInAutoScalingGroupInput, optFns ...func(*Options)) (*autoscaling.TerminateInstanceInAutoScalingGroupOutput, error)
	//	We strongly recommend that all Auto Scaling groups use launch templates to
	//
	// ensure full functionality for Amazon EC2 Auto Scaling and Amazon EC2.
	//
	// Updates the configuration for the specified Auto Scaling group.
	//
	// To update an Auto Scaling group, specify the name of the group and the property
	// that you want to change. Any properties that you don't specify are not changed
	// by this update request. The new settings take effect on any scaling activities
	// after this call returns.
	//
	// If you associate a new launch configuration or template with an Auto Scaling
	// group, all new instances will get the updated configuration. Existing instances
	// continue to run with the configuration that they were originally launched with.
	// When you update a group to specify a mixed instances policy instead of a launch
	// configuration or template, existing instances may be replaced to match the new
	// purchasing options that you specified in the policy. For example, if the group
	// currently has 100% On-Demand capacity and the policy specifies 50% Spot
	// capacity, this means that half of your instances will be gradually terminated
	// and relaunched as Spot Instances. When replacing instances, Amazon EC2 Auto
	// Scaling launches new instances before terminating the old ones, so that updating
	// your group does not compromise the performance or availability of your
	// application.
	//
	// Note the following about changing DesiredCapacity , MaxSize , or MinSize :
	//
	//   - If a scale-in activity occurs as a result of a new DesiredCapacity value
	//     that is lower than the current size of the group, the Auto Scaling group uses
	//     its termination policy to determine which instances to terminate.
	//
	//   - If you specify a new value for MinSize without specifying a value for
	//     DesiredCapacity , and the new MinSize is larger than the current size of the
	//     group, this sets the group's DesiredCapacity to the new MinSize value.
	//
	//   - If you specify a new value for MaxSize without specifying a value for
	//     DesiredCapacity , and the new MaxSize is smaller than the current size of the
	//     group, this sets the group's DesiredCapacity to the new MaxSize value.
	//
	// To see which properties have been set, call the [DescribeAutoScalingGroups] API. To view the scaling
	// policies for an Auto Scaling group, call the [DescribePolicies]API. If the group has scaling
	// policies, you can update them by calling the [PutScalingPolicy]API.
	//
	// [DescribeAutoScalingGroups]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAutoScalingGroups.html
	// [DescribePolicies]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribePolicies.html
	// [PutScalingPolicy]: https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_PutScalingPolicy.html
	UpdateAutoScalingGroup(ctx context.Context, params *autoscaling.UpdateAutoScalingGroupInput, optFns ...func(*Options)) (*autoscaling.UpdateAutoScalingGroupOutput, error)
}

