/*
 * Decompiled with CFR 0.152.
 */
package com.sittinglittleduck.DirBuster.gui.tableModels;

import com.sittinglittleduck.DirBuster.Manager;
import com.sittinglittleduck.DirBuster.Result;
import java.util.List;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;

public class ResultsTableModel
extends DefaultTableModel {
    Vector<Result> data;
    String[] columnNames = new String[]{new String("Type"), new String("Found"), new String("Response"), new String("Size")};
    Manager manager = Manager.getInstance();
    private int numberOfFiles = 0;
    private int numberOfDirs = 0;

    public ResultsTableModel() {
        this.data = this.manager.results;
    }

    public void setColumnName(int index, String name) {
        if (index < this.columnNames.length) {
            this.columnNames[index] = name;
        }
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    public void addRow() {
        this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
    }

    public void updateRow(String dirFinished, String dirStarted) {
    }

    public void removeRow(int index) {
        this.data.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    public int getRowCount() {
        return this.data == null ? 0 : this.data.size();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Object getValueAt(int row, int col) {
        if (row < 0 || row >= this.data.size()) {
            return null;
        }
        if (col == 0) {
            if (this.data.get(row).getType() == 0) {
                return "Dir";
            }
            return "File";
        }
        if (col == 1) {
            return this.data.get(row).getItemFound().getPath();
        }
        if (col == 2) {
            return this.data.get(row).getResponceCode();
        }
        if (col == 3) {
            if (this.data.get(row).getResponseHeader().equals("") && this.data.get(row).getResponseBody().equals("")) {
                return 0;
            }
            return this.data.get(row).getResponseHeader().length() + this.data.get(row).getResponseBody().length();
        }
        return null;
    }

    public void setValueAt(Object value, int row, int col) {
    }

    public List getList() {
        return this.data;
    }

    public void clearData() {
        this.data.clear();
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    public int getNumberOfDirs() {
        return -1;
    }
}

