/*
 * Decompiled with CFR 0.152.
 */
package com.sittinglittleduck.DirBuster.gui;

import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.jgoodies.looks.plastic.theme.Silver;
import com.sittinglittleduck.DirBuster.Config;
import com.sittinglittleduck.DirBuster.ImageCreator;
import com.sittinglittleduck.DirBuster.Manager;
import com.sittinglittleduck.DirBuster.gui.JDialogAdvSetup;
import com.sittinglittleduck.DirBuster.gui.JDialogViewLicence;
import com.sittinglittleduck.DirBuster.gui.JPanelReport;
import com.sittinglittleduck.DirBuster.gui.JPanelRunning;
import com.sittinglittleduck.DirBuster.gui.JPanelSetup;
import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class StartGUI
extends JFrame {
    Manager manager = null;
    HelpSet hs;
    HelpBroker hb;
    public JPanelSetup jPanelSetup;
    public JPanelRunning jPanelRunning;
    public JPanelReport jPanelReport;
    public JCheckBoxMenuItem jCheckBoxMenuDebug;
    public JCheckBoxMenuItem jCheckBoxMenuFollowRedirets;
    public JCheckBoxMenuItem jCheckBoxMenuItemCaseInsensativeMode;
    public JCheckBoxMenuItem jCheckBoxMenuParseHTML;
    public JLabel jLabelCurrentWork;
    public JLabel jLabelStatus;
    public JMenu jMenuAbout1;
    public JMenuBar jMenuBar;
    public JMenu jMenuFile1;
    public JMenu jMenuHelp1;
    public JMenuItem jMenuItemAdvanced;
    public JMenuItem jMenuItemCheck;
    public JMenuItem jMenuItemExit;
    public JMenuItem jMenuItemFAQ;
    public JMenuItem jMenuItemHelp;
    public JMenuItem jMenuItemLicence;
    public JMenuItem jMenuItemNew;
    public JMenuItem jMenuItemReport;
    public JMenuItem jMenuItemVersion;
    public JMenuItem jMenuItemhome;
    public JMenu jMenuLookAndFeel;
    public JMenu jMenuOptions;
    public JPanel jPanelStatus;
    public JSeparator jSeparator1;
    public JSeparator jSeparator2;
    public JSeparator jSeparator3;

    public StartGUI() {
        try {
            System.out.println("Starting OWASP DirBuster 1.0-RC1");
            Options.setTabIconsEnabled((boolean)true);
            Options.setDefaultIconSize((Dimension)new Dimension(18, 18));
            PlasticXPLookAndFeel.setPlasticTheme((PlasticTheme)new Silver());
            UIManager.setLookAndFeel("com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
            this.initComponents();
            String os = System.getProperty("os.name");
            if (os.contains("Vista")) {
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                this.setBounds((screenSize.width - 771) / 2, (screenSize.height - 590) / 2, 771, 590);
            }
            this.setTitle("OWASP DirBuster 1.0-RC1 - Web Application Brute Forcing");
            this.jPanelSetup = new JPanelSetup(this);
            this.jPanelRunning = new JPanelRunning(this);
            this.jPanelReport = new JPanelReport(this);
            this.getContentPane().add((Component)this.jPanelSetup, "Center");
            this.setIconImage(ImageCreator.OWASP_IMAGE.getImage());
            this.manager = Manager.getInstance();
            this.manager.setGUI(this);
            this.jCheckBoxMenuFollowRedirets.setSelected(Config.followRedirects);
            this.jCheckBoxMenuDebug.setSelected(Config.debug);
            this.jCheckBoxMenuParseHTML.setSelected(Config.parseHTML);
            this.jCheckBoxMenuItemCaseInsensativeMode.setSelected(Config.caseInsensativeMode);
            this.jPanelSetup.jTextFieldFile.setText(this.manager.getDefaultList());
            this.jPanelSetup.jTextFieldFileExtention.setText(this.manager.getDefaultExts());
            this.jPanelSetup.jSliderThreads.setValue(this.manager.getDefaultNoThreads());
            this.jPanelSetup.jLabelThreadsDisplay.setText(this.manager.getDefaultNoThreads() + " Threads");
            this.loadHelp();
            this.checkForUpdate();
            this.createLookAndFeelMenus();
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(StartGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(StartGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(StartGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(StartGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void initComponents() {
        this.jPanelStatus = new JPanel();
        this.jLabelStatus = new JLabel();
        this.jLabelCurrentWork = new JLabel();
        this.jMenuBar = new JMenuBar();
        this.jMenuFile1 = new JMenu();
        this.jMenuItemNew = new JMenuItem();
        this.jMenuItemExit = new JMenuItem();
        this.jMenuOptions = new JMenu();
        this.jCheckBoxMenuFollowRedirets = new JCheckBoxMenuItem();
        this.jCheckBoxMenuDebug = new JCheckBoxMenuItem();
        this.jCheckBoxMenuItemCaseInsensativeMode = new JCheckBoxMenuItem();
        this.jCheckBoxMenuParseHTML = new JCheckBoxMenuItem();
        this.jSeparator3 = new JSeparator();
        this.jMenuLookAndFeel = new JMenu();
        this.jSeparator2 = new JSeparator();
        this.jMenuItemAdvanced = new JMenuItem();
        this.jMenuAbout1 = new JMenu();
        this.jMenuItemLicence = new JMenuItem();
        this.jMenuItemVersion = new JMenuItem();
        this.jMenuHelp1 = new JMenu();
        this.jMenuItemHelp = new JMenuItem();
        this.jMenuItemFAQ = new JMenuItem();
        this.jMenuItemhome = new JMenuItem();
        this.jMenuItemCheck = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jMenuItemReport = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setCursor(new Cursor(0));
        this.setFont(new Font("Arial", 0, 12));
        this.jPanelStatus.setLayout(new GridBagLayout());
        this.jLabelStatus.setText("Please complete the test details");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        this.jPanelStatus.add((Component)this.jLabelStatus, gridBagConstraints);
        this.jLabelCurrentWork.setHorizontalAlignment(11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 250;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 10);
        this.jPanelStatus.add((Component)this.jLabelCurrentWork, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanelStatus, "South");
        this.jMenuBar.setFont(new Font("Arial", 1, 12));
        this.jMenuFile1.setText("File");
        this.jMenuItemNew.setIcon(new ImageIcon(this.getClass().getResource("/com/sittinglittleduck/DirBuster/gui/icons/window-new.png")));
        this.jMenuItemNew.setText("New");
        this.jMenuItemNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StartGUI.this.jMenuItemNewActionPerformed(evt);
            }
        });
        this.jMenuFile1.add(this.jMenuItemNew);
        this.jMenuItemExit.setIcon(new ImageIcon(this.getClass().getResource("/com/sittinglittleduck/DirBuster/gui/icons/door_out.png")));
        this.jMenuItemExit.setText("Exit");
        this.jMenuItemExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StartGUI.this.jMenuItemExitActionPerformed(evt);
            }
        });
        this.jMenuFile1.add(this.jMenuItemExit);
        this.jMenuBar.add(this.jMenuFile1);
        this.jMenuOptions.setText("Options");
        this.jCheckBoxMenuFollowRedirets.setText("Follow Redirects");
        this.jCheckBoxMenuFollowRedirets.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StartGUI.this.jCheckBoxMenuFollowRediretsActionPerformed(evt);
            }
        });
        this.jMenuOptions.add(this.jCheckBoxMenuFollowRedirets);
        this.jCheckBoxMenuDebug.setText("Debug Mode");
        this.jCheckBoxMenuDebug.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StartGUI.this.jCheckBoxMenuDebugActionPerformed(evt);
            }
        });
        this.jMenuOptions.add(this.jCheckBoxMenuDebug);
        this.jCheckBoxMenuItemCaseInsensativeMode.setText("Case Insensative Mode");
        this.jCheckBoxMenuItemCaseInsensativeMode.setEnabled(false);
        this.jCheckBoxMenuItemCaseInsensativeMode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StartGUI.this.jCheckBoxMenuItemCaseInsensativeModeActionPerformed(evt);
            }
        });
        this.jMenuOptions.add(this.jCheckBoxMenuItemCaseInsensativeMode);
        this.jCheckBoxMenuParseHTML.setText("Parse HTML");
        this.jCheckBoxMenuParseHTML.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StartGUI.this.jCheckBoxMenuParseHTMLActionPerformed(evt);
            }
        });
        this.jMenuOptions.add(this.jCheckBoxMenuParseHTML);
        this.jMenuOptions.add(this.jSeparator3);
        this.jMenuLookAndFeel.setText("Look & Feel");
        this.jMenuOptions.add(this.jMenuLookAndFeel);
        this.jMenuOptions.add(this.jSeparator2);
        this.jMenuItemAdvanced.setIcon(new ImageIcon(this.getClass().getResource("/com/sittinglittleduck/DirBuster/gui/icons/preferences-system.png")));
        this.jMenuItemAdvanced.setText("Advanced Options");
        this.jMenuItemAdvanced.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StartGUI.this.jMenuItemAdvancedActionPerformed(evt);
            }
        });
        this.jMenuOptions.add(this.jMenuItemAdvanced);
        this.jMenuBar.add(this.jMenuOptions);
        this.jMenuAbout1.setText("About");
        this.jMenuItemLicence.setIcon(new ImageIcon(this.getClass().getResource("/com/sittinglittleduck/DirBuster/gui/icons/information.png")));
        this.jMenuItemLicence.setText("License");
        this.jMenuItemLicence.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StartGUI.this.jMenuItemLicenceActionPerformed(evt);
            }
        });
        this.jMenuAbout1.add(this.jMenuItemLicence);
        this.jMenuItemVersion.setIcon(new ImageIcon(this.getClass().getResource("/com/sittinglittleduck/DirBuster/gui/icons/information.png")));
        this.jMenuItemVersion.setText("Version");
        this.jMenuItemVersion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StartGUI.this.jMenuItemVersionActionPerformed(evt);
            }
        });
        this.jMenuAbout1.add(this.jMenuItemVersion);
        this.jMenuBar.add(this.jMenuAbout1);
        this.jMenuHelp1.setText("Help");
        this.jMenuItemHelp.setIcon(new ImageIcon(this.getClass().getResource("/com/sittinglittleduck/DirBuster/gui/icons/help.png")));
        this.jMenuItemHelp.setText("Help");
        this.jMenuItemHelp.setEnabled(false);
        this.jMenuHelp1.add(this.jMenuItemHelp);
        this.jMenuItemFAQ.setText("FAQ");
        this.jMenuItemFAQ.setEnabled(false);
        this.jMenuHelp1.add(this.jMenuItemFAQ);
        this.jMenuItemhome.setIcon(new ImageIcon(this.getClass().getResource("/com/sittinglittleduck/DirBuster/gui/icons/internet-web-browser.png")));
        this.jMenuItemhome.setText("Home Page");
        this.jMenuItemhome.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StartGUI.this.jMenuItemhomeActionPerformed(evt);
            }
        });
        this.jMenuHelp1.add(this.jMenuItemhome);
        this.jMenuItemCheck.setText("Check for updates");
        this.jMenuItemCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StartGUI.this.jMenuItemCheckActionPerformed(evt);
            }
        });
        this.jMenuHelp1.add(this.jMenuItemCheck);
        this.jMenuHelp1.add(this.jSeparator1);
        this.jMenuItemReport.setIcon(new ImageIcon(this.getClass().getResource("/com/sittinglittleduck/DirBuster/gui/icons/bug.png")));
        this.jMenuItemReport.setText("Report a bug");
        this.jMenuItemReport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StartGUI.this.jMenuItemReportActionPerformed(evt);
            }
        });
        this.jMenuHelp1.add(this.jMenuItemReport);
        this.jMenuBar.add(this.jMenuHelp1);
        this.setJMenuBar(this.jMenuBar);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 771) / 2, (screenSize.height - 547) / 2, 771, 547);
    }

    private void jCheckBoxMenuParseHTMLActionPerformed(ActionEvent evt) {
        Config.parseHTML = this.jCheckBoxMenuParseHTML.isSelected();
    }

    private void jMenuItemReportActionPerformed(ActionEvent evt) {
        try {
            BrowserLauncher launcher = new BrowserLauncher(null);
            launcher.openURLinBrowser("https://sourceforge.net/tracker/?func=add&group_id=199126&atid=968238");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jMenuItemLicenceActionPerformed(ActionEvent evt) {
        new JDialogViewLicence((Frame)this, true).setVisible(true);
    }

    private void jMenuItemAdvancedActionPerformed(ActionEvent evt) {
        new JDialogAdvSetup((Frame)this, true).setVisible(true);
    }

    private void jCheckBoxMenuDebugActionPerformed(ActionEvent evt) {
        Config.debug = this.jCheckBoxMenuDebug.isSelected();
    }

    private void jCheckBoxMenuFollowRediretsActionPerformed(ActionEvent evt) {
        Config.followRedirects = this.jCheckBoxMenuFollowRedirets.isSelected();
    }

    private void jMenuItemCheckActionPerformed(ActionEvent evt) {
        this.manager.checkForUpdates(true);
    }

    private void jMenuItemNewActionPerformed(ActionEvent evt) {
        int n = JOptionPane.showConfirmDialog(this, "Are you sure you wish to cancel the current test and start a new one?", "Are you sure?", 0);
        if (n == 0) {
            this.manager.youAreFinished();
            this.showSetup();
            this.jPanelRunning.resultsTableModel.clearData();
            this.jPanelRunning.errorTableModel.clearAllResults();
        }
    }

    private void jMenuItemVersionActionPerformed(ActionEvent evt) {
        String versionText = "DirBuster 1.0-RC1\n\n06/05/2008\nWritten by: James Fisher\nHelp supplied by: John Anderson (john@ev6.net)\n\nContact: DirBuster@sittinglittleduck.com\nHome: http://www.owasp.org/index.php/Category:OWASP_DirBuster_Project";
        JOptionPane.showMessageDialog(this, versionText, "About DirBuster-1.0-RC1", 1, ImageCreator.OWASP_IMAGE);
    }

    private void jMenuItemhomeActionPerformed(ActionEvent evt) {
        try {
            BrowserLauncher launcher = new BrowserLauncher(null);
            launcher.openURLinBrowser("http://www.owasp.org/index.php/Category:OWASP_DirBuster_Project");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jMenuItemExitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void jCheckBoxMenuItemCaseInsensativeModeActionPerformed(ActionEvent evt) {
        Config.caseInsensativeMode = this.jCheckBoxMenuItemCaseInsensativeMode.isSelected();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new StartGUI().setVisible(true);
            }
        });
    }

    public void showSetup() {
        this.getContentPane().remove(this.jPanelRunning);
        this.getContentPane().remove(this.jPanelReport);
        this.getContentPane().add((Component)this.jPanelSetup, "Center");
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void showRunning() {
        this.getContentPane().remove(this.jPanelSetup);
        this.getContentPane().remove(this.jPanelReport);
        this.getContentPane().add((Component)this.jPanelRunning, "Center");
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void showReporting() {
        this.getContentPane().remove(this.jPanelSetup);
        this.getContentPane().remove(this.jPanelRunning);
        this.getContentPane().add((Component)this.jPanelReport, "Center");
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void updateProgress(String current, String average, String total, int numberOfThreads, String timeLeft, String parseQueueLength) {
        this.jPanelRunning.setCurrentSpeed(current);
        this.jPanelRunning.setAverageSpeed(average);
        this.jPanelRunning.setTotalRequests(total);
        this.jPanelRunning.jLabelNumThreads.setText("Current number of running threads: " + numberOfThreads);
        this.jPanelRunning.jLabelTimeLeft.setText(timeLeft);
        this.jPanelRunning.jLabelParseQueueLength.setText("Parse Queue Size: " + parseQueueLength);
    }

    public void pause() {
        if (this.manager != null) {
            this.manager.pause();
        }
    }

    public void unPause() {
        if (this.manager != null) {
            this.manager.unPause();
        }
    }

    public void setStatus(String status) {
        this.jLabelStatus.setText(status);
    }

    public void startBruteForceFile(String dirToStartWith, String fileToRead, String protocol, String host, int port, String fileExtention, int threadsNumber, boolean doDirs, boolean doFiles, boolean recursive, boolean auto, boolean useBlankExt, Vector extToUse) {
        this.manager.setupManager(dirToStartWith, fileToRead, protocol, host, port, fileExtention, this, threadsNumber, doDirs, doFiles, recursive, useBlankExt, extToUse);
        this.jPanelRunning.resultsTableModel.setManager(this.manager);
        this.manager.setAuto(auto);
        this.manager.start();
    }

    public void startBruteForcePure(String dirToStartWith, String[] charSet, int minLen, int maxLen, String protocol, String host, int port, String fileExtention, int threadsNumber, boolean doDirs, boolean doFiles, boolean recursive, boolean auto, boolean useBlankExt, Vector extToUse) {
        this.manager.setupManager(dirToStartWith, charSet, minLen, maxLen, protocol, host, port, fileExtention, this, threadsNumber, doDirs, doFiles, recursive, useBlankExt, extToUse);
        this.jPanelRunning.resultsTableModel.setManager(this.manager);
        this.manager.setAuto(auto);
        this.manager.start();
    }

    public void startBruteForceFuzz(String[] charSet, int minLen, int maxLen, String protocol, String host, int port, int threadsNumber, boolean auto, String urlFuzzStart, String urlFuzzEnd) {
        this.manager.setUpManager(charSet, minLen, maxLen, protocol, host, port, this, threadsNumber, urlFuzzStart, urlFuzzEnd);
        this.jPanelRunning.resultsTableModel.setManager(this.manager);
        this.manager.setAuto(auto);
        this.manager.start();
    }

    public void startListBasedFuzz(String inputFile, String protocol, String host, int port, int threadNumber, String urlFuzzStart, String urlFuzzEnd, boolean auto) {
        this.manager.setUpManager(inputFile, protocol, host, port, this, threadNumber, urlFuzzStart, urlFuzzEnd);
        this.jPanelRunning.resultsTableModel.setManager(this.manager);
        this.manager.setAuto(auto);
        this.manager.start();
    }

    public void finished() {
        this.manager.youAreFinished();
    }

    public void enableReport() {
        this.jPanelRunning.enableReport();
    }

    private void loadHelp() {
        try {
            URL url = this.getClass().getResource("/com/sittinglittleduck/DirBuster/help/help.hs");
            ClassLoader loader = this.getClass().getClassLoader();
            this.hs = new HelpSet(loader, url);
            this.hs.setTitle("DirBuster Help Viewer");
            this.hb = this.hs.createHelpBroker("Main_Window");
            this.jMenuItemHelp.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(this.hb));
            this.hb.enableHelpKey((Component)this.getRootPane(), "item1", this.hs);
        }
        catch (HelpSetException ex) {
            Logger.getLogger(StartGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void checkForUpdate() {
        this.manager.checkForUpdates(false);
    }

    public void setURL(String URL2) {
        this.jPanelSetup.jTextFieldTarget.setText(URL2);
    }

    private void createLookAndFeelMenus() {
        Vector<UIManager.LookAndFeelInfo> lookAndFeels = new Vector<UIManager.LookAndFeelInfo>(10, 10);
        UIManager.LookAndFeelInfo[] installedFeels = UIManager.getInstalledLookAndFeels();
        lookAndFeels.addElement(new UIManager.LookAndFeelInfo(UIManager.getLookAndFeel().getName(), UIManager.getLookAndFeel().getClass().getName()));
        for (int i = 0; i < Math.min(installedFeels.length, 10); ++i) {
            lookAndFeels.addElement(installedFeels[i]);
        }
        ButtonGroup group = new ButtonGroup();
        for (int i = 0; i < lookAndFeels.size(); ++i) {
            JRadioButtonMenuItem rb = new JRadioButtonMenuItem(((UIManager.LookAndFeelInfo)lookAndFeels.elementAt(i)).getName());
            group.add(rb);
            this.jMenuLookAndFeel.add(rb);
            rb.setSelected(UIManager.getLookAndFeel().getName().equalsIgnoreCase(((UIManager.LookAndFeelInfo)lookAndFeels.elementAt(i)).getName()));
            rb.putClientProperty("Look and Feel Name", lookAndFeels.elementAt(i));
            rb.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent ie) {
                    JRadioButtonMenuItem rbi = (JRadioButtonMenuItem)ie.getSource();
                    if (rbi.isSelected()) {
                        final UIManager.LookAndFeelInfo info = (UIManager.LookAndFeelInfo)rbi.getClientProperty("Look and Feel Name");
                        if (info == null) {
                            System.out.println("info is null");
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                try {
                                    UIManager.setLookAndFeel(info.getClassName());
                                    SwingUtilities.updateComponentTreeUI(Manager.getInstance().gui.jMenuBar.getParent());
                                }
                                catch (ClassNotFoundException ex) {
                                    Logger.getLogger(StartGUI.class.getName()).log(Level.SEVERE, null, ex);
                                }
                                catch (InstantiationException ex) {
                                    Logger.getLogger(StartGUI.class.getName()).log(Level.SEVERE, null, ex);
                                }
                                catch (IllegalAccessException ex) {
                                    Logger.getLogger(StartGUI.class.getName()).log(Level.SEVERE, null, ex);
                                }
                                catch (UnsupportedLookAndFeelException ex) {
                                    Logger.getLogger(StartGUI.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            }
                        });
                    }
                }
            });
        }
    }
}

