/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.tools;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.AccessibleAnchorProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.AbstractConnectionCreationTool;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Event;

public class ConnectionCreationTool
extends AbstractConnectionCreationTool {
    public ConnectionCreationTool() {
        this.setUnloadWhenFinished(false);
    }

    public ConnectionCreationTool(CreationFactory factory) {
        this.setFactory(factory);
        this.setUnloadWhenFinished(false);
    }

    boolean acceptConnectionFinish(KeyEvent event) {
        return this.isInState(32) && event.character == '\r';
    }

    boolean acceptConnectionStart(KeyEvent event) {
        return this.isInState(1) && event.character == '\r';
    }

    @Override
    protected boolean handleButtonDown(int button) {
        if (button == 1 && this.stateTransition(64, 0x40000000)) {
            return this.handleCreateConnection();
        }
        super.handleButtonDown(button);
        if (this.isInState(64)) {
            this.handleDrag();
        }
        return true;
    }

    @Override
    protected boolean handleFocusLost() {
        if (this.isInState(96)) {
            this.eraseSourceFeedback();
            this.eraseTargetFeedback();
            this.setState(8);
            this.handleFinished();
        }
        return super.handleFocusLost();
    }

    @Override
    protected boolean handleKeyDown(KeyEvent event) {
        if (this.acceptArrowKey(event)) {
            int direction = this.getDirection(event);
            boolean consumed = false;
            if (direction != 0 && event.stateMask == 0) {
                consumed = this.navigateNextAnchor(direction);
            }
            if (!consumed) {
                event.stateMask |= 0x40000;
                event.stateMask &= 0xFFFDFFFF;
                if (this.getCurrentViewer().getKeyHandler().keyPressed(event)) {
                    this.navigateNextAnchor(0);
                    this.updateTargetRequest();
                    this.updateTargetUnderMouse();
                    Command command = this.getCommand();
                    if (command != null) {
                        this.setCurrentCommand(command);
                    }
                    return true;
                }
            }
        }
        if (event.character == '/' || event.character == '\\') {
            event.stateMask |= 0x40000;
            if (this.getCurrentViewer().getKeyHandler().keyPressed(event)) {
                this.navigateNextAnchor(0);
                return true;
            }
        }
        if (this.acceptConnectionStart(event)) {
            this.performConnectionStart();
            return true;
        }
        if (this.acceptConnectionFinish(event)) {
            this.performConnectionFinished();
            return true;
        }
        return super.handleKeyDown(event);
    }

    @Override
    public void mouseWheelScrolled(Event event, EditPartViewer viewer) {
        if (this.isInState(65)) {
            this.performViewerMouseWheel(event, viewer);
        }
    }

    boolean navigateNextAnchor(int direction) {
        EditPart focus = this.getCurrentViewer().getFocusEditPart();
        AccessibleAnchorProvider provider = (AccessibleAnchorProvider)focus.getAdapter(AccessibleAnchorProvider.class);
        if (provider == null) {
            return false;
        }
        List<Point> list = this.isInState(32) ? provider.getTargetAnchorLocations() : provider.getSourceAnchorLocations();
        Point start = this.getLocation();
        int distance = Integer.MAX_VALUE;
        Point next = null;
        for (Point p : list) {
            int d;
            if (p.equals((Object)start) || direction != 0 && start.getPosition(p) != direction || (d = p.getDistanceOrthogonal(start)) >= distance) continue;
            distance = d;
            next = p;
        }
        if (next != null) {
            this.placeMouseInViewer(next);
            return true;
        }
        return false;
    }

    private void performConnectionStart() {
        Command command = this.getCommand();
        if (command != null && command.canExecute()) {
            this.updateTargetUnderMouse();
            this.setConnectionSource(this.getTargetEditPart());
            this.getTargetRequest().setSourceEditPart(this.getTargetEditPart());
            this.setState(32);
            this.placeMouseInViewer(this.getLocation().getTranslated(6, 6));
        }
    }

    private void performConnectionFinished() {
        Command command = this.getCommand();
        if (command != null && command.canExecute()) {
            this.setState(1);
            this.placeMouseInViewer(this.getLocation().getTranslated(6, 6));
            this.eraseSourceFeedback();
            this.eraseTargetFeedback();
            this.setCurrentCommand(command);
            this.executeCurrentCommand();
        }
    }
}

