/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine.openai;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.AIMessage;
import org.jkiss.dbeaver.model.ai.AIMessageType;
import org.jkiss.dbeaver.model.ai.AIUsage;
import org.jkiss.dbeaver.model.ai.engine.AIEngineRequest;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponse;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponseConsumer;
import org.jkiss.dbeaver.model.ai.engine.AIFunctionCall;
import org.jkiss.dbeaver.model.ai.engine.AIModel;
import org.jkiss.dbeaver.model.ai.engine.BaseCompletionEngine;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIBaseProperties;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIClient;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIClientLegacy;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIModels;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.OAIMessage;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.OAIResponsesRequest;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.OAIResponsesResponse;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.OAITool;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.OAIToolParameter;
import org.jkiss.dbeaver.model.ai.internal.AIMessages;
import org.jkiss.dbeaver.model.ai.registry.AIFunctionDescriptor;
import org.jkiss.dbeaver.model.ai.utils.DisposableLazyValue;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class OpenAIEngine<PROPS extends OpenAIBaseProperties>
extends BaseCompletionEngine<PROPS> {
    protected final DisposableLazyValue<OpenAIClient, DBException> openAiService = new DisposableLazyValue<OpenAIClient, DBException>(){

        @NotNull
        protected OpenAIClient initialize() throws DBException {
            return OpenAIEngine.this.createClient();
        }

        @Override
        protected void onDispose(@NotNull OpenAIClient disposedValue) {
            disposedValue.close();
        }
    };

    public OpenAIEngine(@NotNull PROPS properties) {
        super(properties);
    }

    @Override
    @NotNull
    public List<AIModel> getModels(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((OpenAIClient)this.openAiService.getInstance()).getModels(monitor).stream().map(model -> OpenAIModels.KNOWN_MODELS.getOrDefault(model.id(), new AIModel(model.id(), null, OpenAIModels.detectModelFeatures(model.id())))).toList();
    }

    @Override
    @NotNull
    public AIEngineResponse requestCompletion(@NotNull DBRProgressMonitor monitor, @NotNull AIEngineRequest request) throws DBException {
        OAIResponsesResponse completionResult = this.complete(monitor, request);
        List<OAIMessage> messages = completionResult.output.stream().filter(msg -> !"reasoning".equals(msg.type)).toList();
        AIUsage usage = new AIUsage(completionResult.usage.inputTokens(), completionResult.usage.inputTokensDetails().cachedTokens(), completionResult.usage.outputTokens(), completionResult.usage.outputTokensDetails().reasoningTokens());
        if (messages.isEmpty()) {
            return new AIEngineResponse(AIMessageType.ASSISTANT, List.of(AIMessages.ai_empty_engine_response), usage);
        }
        OAIMessage message = messages.getFirst();
        if ("function_call".equals(message.type)) {
            AIFunctionCall fc = OpenAIClient.createFunctionCall(message);
            return new AIEngineResponse(fc, usage);
        }
        List<String> choices = messages.stream().map(OAIMessage::getFullText).toList();
        return new AIEngineResponse(AIMessageType.ASSISTANT, choices, usage);
    }

    @Override
    public void requestCompletionStream(@NotNull DBRProgressMonitor monitor, @NotNull AIEngineRequest request, @NotNull AIEngineResponseConsumer listener) throws DBException {
        OAIResponsesRequest oaiRequest = this.createOpenAiRequest(request);
        oaiRequest.stream = true;
        ((OpenAIClient)this.openAiService.getInstance()).createChatCompletionStream(monitor, oaiRequest, listener);
    }

    @Override
    public int getContextWindowSize(@NotNull DBRProgressMonitor monitor) throws DBException {
        Integer contextWindowSize = ((OpenAIBaseProperties)this.properties).getContextWindowSize();
        if (contextWindowSize != null) {
            return contextWindowSize;
        }
        throw new DBException("Context window size is not set for the model: " + this.model());
    }

    @Override
    public void close() throws DBException {
        this.openAiService.dispose();
    }

    @NotNull
    protected OAIResponsesResponse complete(@NotNull DBRProgressMonitor monitor, @NotNull AIEngineRequest request) throws DBException {
        OAIResponsesRequest oaiRequest = this.createOpenAiRequest(request);
        return ((OpenAIClient)this.openAiService.getInstance()).createChatCompletion(monitor, oaiRequest);
    }

    @NotNull
    private OAIResponsesRequest createOpenAiRequest(@NotNull AIEngineRequest request) throws DBException {
        OAIResponsesRequest oaiRequest = new OAIResponsesRequest();
        List<AIMessage> messages = request.getMessages();
        oaiRequest.input = OpenAIEngine.fromMessages(messages);
        oaiRequest.temperature = this.temperature();
        oaiRequest.store = false;
        oaiRequest.model = this.model();
        if (!CommonUtils.isEmpty(request.getFunctions())) {
            ArrayList<OAITool> tools = new ArrayList<OAITool>();
            for (AIFunctionDescriptor fd : request.getFunctions()) {
                OAITool tool = new OAITool();
                tool.type = "function";
                tool.name = fd.getId();
                tool.description = fd.getDescription();
                tool.parameters.type = "object";
                ArrayList<String> requiredFields = new ArrayList<String>();
                AIFunctionDescriptor.Parameter[] parameterArray = fd.getParameters();
                int n = parameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AIFunctionDescriptor.Parameter param = parameterArray[n2];
                    OAIToolParameter tp = new OAIToolParameter();
                    tp.type = param.getType();
                    tp.description = param.getDescription();
                    tp.enumItems = param.getValidValues();
                    requiredFields.add(param.getName());
                    tool.parameters.properties.put(param.getName(), tp);
                    ++n2;
                }
                tool.parameters.required = requiredFields.toArray(new String[0]);
                tools.add(tool);
            }
            oaiRequest.tools = tools;
        }
        return oaiRequest;
    }

    @NotNull
    private static List<OAIMessage> fromMessages(@NotNull List<AIMessage> messages) {
        return messages.stream().map(OAIMessage::new).toList();
    }

    @NotNull
    protected OpenAIClient createClient() throws DBException {
        String token = ((OpenAIBaseProperties)this.properties).getToken();
        if (token == null || token.isEmpty()) {
            throw new DBException("OpenAI API token is not set");
        }
        String baseUrl = ((OpenAIBaseProperties)this.properties).getBaseUrl();
        if (baseUrl == null || baseUrl.isEmpty()) {
            baseUrl = "https://api.openai.com/v1/";
        }
        if (((OpenAIBaseProperties)this.properties).isLegacyApi()) {
            return OpenAIClientLegacy.createClient(baseUrl, token);
        }
        return OpenAIClient.createClient(baseUrl, token);
    }

    @Nullable
    protected String model() throws DBException {
        return ((OpenAIBaseProperties)this.properties).getModel();
    }

    protected double temperature() throws DBException {
        return ((OpenAIBaseProperties)this.properties).getTemperature();
    }
}

