/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.ai.engine.openai;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.ai.internal.AIUIMessages;

public class ModelSelectorField {
    private static final Log log = Log.getLog(ModelSelectorField.class);
    @NotNull
    private final Combo combo;
    @NotNull
    private final ModelListProvider modelListProvider;
    private volatile String selectedModel;

    private ModelSelectorField(final @NotNull Combo combo, @NotNull ModelListProvider modelListProvider, final @NotNull Runnable onModelSelected) {
        this.combo = combo;
        this.combo.addModifyListener(e -> {
            String string = this.selectedModel = combo.getText();
        });
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelSelectorField.this.selectedModel = combo.getText();
                onModelSelected.run();
            }
        });
        this.modelListProvider = modelListProvider;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    public String getSelectedModel() {
        return this.selectedModel;
    }

    public void setSelectedModel(@Nullable String model) {
        if (model == null || model.isBlank()) {
            return;
        }
        String[] stringArray = this.combo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String o = stringArray[n2];
            if (o.equals(model)) {
                this.combo.setText(model);
                return;
            }
            ++n2;
        }
        this.combo.add(model);
        this.combo.select(this.combo.getItemCount() - 1);
        this.selectedModel = model;
    }

    public void refreshModelListSilently(final boolean refresh) {
        new AbstractJob("Refreshing model list silently"){

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    ModelSelectorField.this.refreshModelList(monitor, refresh);
                    return Status.OK_STATUS;
                }
                catch (DBException e) {
                    log.debug((Object)"Error reading model list", (Throwable)e);
                    return Status.CANCEL_STATUS;
                }
            }
        }.schedule();
    }

    public void refreshModelList(DBRProgressMonitor monitor, boolean refresh) throws DBException {
        HashSet<String> models = new HashSet<String>(this.modelListProvider.getModels(monitor, refresh));
        if (models.isEmpty()) {
            return;
        }
        UIUtils.syncExec(() -> {
            String selectedItem = this.combo.getText();
            models.add(selectedItem);
            List sortedModels = new ArrayList(models).stream().sorted(String::compareToIgnoreCase).toList();
            this.combo.setItems(sortedModels.toArray(new String[0]));
            this.combo.select(sortedModels.indexOf(selectedItem));
        });
    }

    public static class Builder {
        @NotNull
        private Composite parent;
        @NotNull
        private GridData gridData;
        @Nullable
        private SelectionListener selectionListener;
        @NotNull
        private ModelListProvider modelListSupplier;
        private String modelLabel = AIUIMessages.gpt_preference_page_combo_engine;

        public Builder withParent(@NotNull Composite parent) {
            this.parent = parent;
            return this;
        }

        public Builder withGridData(@NotNull GridData gridData) {
            this.gridData = gridData;
            return this;
        }

        public Builder withSelectionListener(@NotNull SelectionListener selectionListener) {
            this.selectionListener = selectionListener;
            return this;
        }

        public Builder withModelListSupplier(@NotNull ModelListProvider modelListProvider) {
            this.modelListSupplier = modelListProvider;
            return this;
        }

        public Builder withModelLabel(@NotNull String modelLabel) {
            this.modelLabel = modelLabel;
            return this;
        }

        public ModelSelectorField build() {
            Combo combo = UIUtils.createLabelCombo((Composite)this.parent, (String)this.modelLabel, (int)4);
            combo.setLayoutData((Object)this.gridData);
            final ModelSelectorField modelSelectorField = new ModelSelectorField(combo, this.modelListSupplier, () -> {
                if (this.selectionListener != null) {
                    Event event = new Event();
                    event.widget = combo;
                    event.type = 13;
                    this.selectionListener.widgetSelected(new SelectionEvent(event));
                }
            });
            UIUtils.createDialogButton((Composite)this.parent, (String)AIUIMessages.gpt_preference_page_refresh_models, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> new AbstractJob("Refreshing model list"){

                protected IStatus run(DBRProgressMonitor monitor) {
                    try {
                        modelSelectorField.refreshModelList(monitor, true);
                        return Status.OK_STATUS;
                    }
                    catch (DBException exception) {
                        DBWorkbench.getPlatformUI().showError("Error reading model list", null, (Throwable)exception);
                        return Status.CANCEL_STATUS;
                    }
                }
            }.schedule()));
            return modelSelectorField;
        }
    }

    public static interface ModelListProvider {
        public List<String> getModels(DBRProgressMonitor var1, boolean var2) throws DBException;
    }
}

