/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model.plan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNodeKind;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlanNode;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.utils.CommonUtils;

public class CubridPlanNode
extends AbstractExecutionPlanNode {
    private static final String SEPARATOR = ":";
    private static final String SPACE = " ";
    private static Map<String, String> classNode = new HashMap<String, String>();
    private static Map<String, String> terms = new HashMap<String, String>();
    private static List<String> segments;
    private static final List<String> parentNode;
    private static final List<String> parentExcept;
    private static final Pattern totalPattern;
    private static final Pattern termPattern;
    private static final Pattern subNodePattern;
    private static final Pattern segmentPattern;
    private String fullText;
    private String nodeName;
    private String totalValue;
    private String name;
    private String index;
    private String term;
    private String extra;
    private long cost;
    private long row;
    private CubridPlanNode parent;
    private List<CubridPlanNode> nested = new ArrayList<CubridPlanNode>();

    static {
        parentNode = List.of("subplan", "head", "outer", "inner", "Query plan");
        parentExcept = List.of("iscan", "sscan");
        totalPattern = Pattern.compile("\\d+\\/\\d+");
        termPattern = Pattern.compile("node\\[\\d\\]");
        subNodePattern = Pattern.compile("term\\[\\d\\]");
        segmentPattern = Pattern.compile("(inner|outer|class|cost|follow|head|subplan|index|filtr|sort|sargs|edge|Query plan|term\\[..|node\\[..):\\s*([^\\n\\r]*)");
    }

    public CubridPlanNode() {
        this.name = "Query";
    }

    public CubridPlanNode(@NotNull String queryPlan) {
        this.fullText = queryPlan;
        this.getSegments();
        this.parseObject();
    }

    private CubridPlanNode(CubridPlanNode parent, boolean normal, String param) {
        this.parent = parent;
        this.fullText = parent.fullText;
        if (normal) {
            this.parseObject();
        } else {
            String[] values = param.split(SEPARATOR);
            this.name = values[0];
            this.term = this.getTermValue(values[1].trim());
            this.extra = this.getExtraValue(values[1].trim());
        }
    }

    @Property(order=0, viewable=true)
    @NotNull
    public String getNodeType() {
        return this.getMethodTitle(this.name);
    }

    @Property(order=1, viewable=true)
    @NotNull
    public String getNodeName() {
        return this.nodeName;
    }

    @Property(order=2, viewable=true)
    @NotNull
    public String getIndex() {
        return this.index;
    }

    @Property(order=3, viewable=true)
    @NotNull
    public String getTerms() {
        return this.term;
    }

    @Property(order=4, viewable=true)
    public long getCost() {
        return this.cost;
    }

    public void setCost(long cost) {
        this.cost = cost;
    }

    @Property(order=5, viewable=true)
    public long getCardinality() {
        return this.row;
    }

    @Property(order=6, viewable=true)
    @NotNull
    public String getTotal() {
        return this.totalValue;
    }

    @Property(order=7, viewable=true)
    @NotNull
    public String getExtra() {
        return this.extra;
    }

    @Property(order=8, length=PropertyLength.MULTILINE)
    @NotNull
    public String getFullText() {
        return this.fullText;
    }

    @Nullable
    public CubridPlanNode getParent() {
        return this.parent;
    }

    @Nullable
    public Collection<CubridPlanNode> getNested() {
        return this.nested;
    }

    public DBCPlanNodeKind getNodeKind() {
        if ("sscan".equals(this.name)) {
            return DBCPlanNodeKind.TABLE_SCAN;
        }
        if ("iscan".equals(this.name)) {
            return DBCPlanNodeKind.INDEX_SCAN;
        }
        return super.getNodeKind();
    }

    public void setAllNestedNode(List<CubridPlanNode> nodes) {
        this.nested.addAll(nodes);
    }

    @Nullable
    private String getMethodTitle(@NotNull String method) {
        return switch (method) {
            case "iscan" -> "Index Scan";
            case "sscan" -> "Full Scan";
            case "temp(group by)" -> "Group by Temp";
            case "temp(order by)" -> "Order by Temp";
            case "nl-join (inner join)" -> "Nested Loop - Inner Join";
            case "nl-join (cross join)" -> "Nested Loop - Cross Join";
            case "idx-join (inner join)" -> "Index Join - Inner Join";
            case "m-join (inner join)" -> "Merged - Inner Join";
            case "temp" -> "Temp";
            case "follow" -> "Follow";
            case "filtr" -> "Filter";
            default -> method;
        };
    }

    private void addNested(boolean normal, String param) {
        this.parent = this;
        this.nested.add(new CubridPlanNode(this, normal, param));
    }

    void parseNode() {
        this.addNested(true, null);
        while (segments.size() > 0) {
            String key = segments.get(0).split(SEPARATOR)[0];
            if (parentNode.contains(key)) {
                this.addNested(true, null);
                continue;
            }
            this.parseObject();
            break;
        }
    }

    void parseObject() {
        while (segments.size() > 0) {
            String segment = segments.remove(0);
            String[] values = segment.split(SEPARATOR);
            String key = values[0].trim();
            String value = values[1].trim();
            switch (key) {
                case "index": {
                    String[] indexes = value.split(SPACE);
                    this.index = indexes[0];
                    this.extra = this.getExtraValue(indexes[0]);
                    if (indexes.length <= 1 || this.subNode(this, key, value)) break;
                    this.term = this.getTermValue(indexes[1]);
                    this.extra = this.getExtraValue(indexes[1]);
                    break;
                }
                case "class": {
                    this.setNameValue(value);
                    break;
                }
                case "sort": {
                    if (parentExcept.contains(this.name)) break;
                    this.extra = String.format("(sort %s)", value);
                }
            }
            if (parentNode.contains(key)) {
                this.name = value;
                if (parentExcept.contains(value)) continue;
                this.parseNode();
                break;
            }
            if ("sargs".equals(key)) {
                if (!this.subNode(this, key, value) && !this.name.equals("sscan")) {
                    this.addNested(false, segment);
                    continue;
                }
                this.term = this.getTermValue(value);
                this.extra = this.getExtraValue(value);
                continue;
            }
            if ("edge".equals(key)) {
                if (!this.subNode(this.parent, key, value) && this.parent.name.equals("follow")) {
                    this.parent.extra = this.getTermValue(value);
                    continue;
                }
                if (!this.parent.name.startsWith("nl-join")) {
                    this.parent.addNested(false, segment);
                    continue;
                }
                this.parent.term = this.getTermValue(value);
                this.parent.extra = this.getExtraValue(value);
                continue;
            }
            if ("filtr".equals(key)) {
                this.addNested(false, segment);
                continue;
            }
            if (!key.contains("cost")) continue;
            String[] costs = value.split(" card ");
            this.cost = Long.parseLong(costs[0]);
            this.row = Long.parseLong(costs[1]);
            break;
        }
    }

    private boolean subNode(CubridPlanNode node, String key, String value) {
        if (value.contains(" AND ")) {
            Matcher m = subNodePattern.matcher(value);
            int count = 1;
            while (m.find()) {
                node.addNested(false, String.format("%s %s:%s", key, count, m.group()));
                ++count;
            }
            return true;
        }
        return false;
    }

    @Nullable
    private String getTermValue(String value) {
        if (CommonUtils.isNotEmpty((String)value)) {
            if (value.contains("node[")) {
                Matcher m = termPattern.matcher(value);
                if (m.find()) {
                    return value.replace(m.group(), classNode.get(m.group()));
                }
            } else {
                String termValue = terms.get(value);
                if (CommonUtils.isNotEmpty((String)termValue)) {
                    return termValue.split(" \\(sel ")[0];
                }
            }
        }
        return null;
    }

    @Nullable
    private String getExtraValue(String value) {
        String extraValue = terms.get(value);
        if (CommonUtils.isNotEmpty((String)extraValue)) {
            return "(sel " + extraValue.split(" \\(sel ")[1];
        }
        return null;
    }

    private void setNameValue(String value) {
        String[] values = value.split(SPACE);
        String nameValue = classNode.get(values[values.length - 1]);
        if (CommonUtils.isNotEmpty((String)nameValue)) {
            String temName = nameValue.split("\\(")[0];
            LinkedHashSet<String> setName = new LinkedHashSet<String>(Arrays.asList(temName.split(SPACE)));
            this.nodeName = String.join((CharSequence)SPACE, setName);
            this.setTotalValue(nameValue);
        }
    }

    private void setTotalValue(String value) {
        Matcher m;
        if (CommonUtils.isNotEmpty((String)value) && (m = totalPattern.matcher(value)).find()) {
            this.totalValue = m.group(0);
        }
    }

    @NotNull
    private List<String> getSegments() {
        Matcher matcher = segmentPattern.matcher(this.fullText);
        segments = new ArrayList<String>();
        while (matcher.find()) {
            String[] values;
            String segment = matcher.group().trim();
            if (segment.startsWith("node")) {
                values = segment.split(SEPARATOR);
                classNode.put(values[0], values[1]);
                continue;
            }
            if (segment.startsWith("term")) {
                values = segment.split("]: ");
                terms.put(String.format("%s]", values[0]), values[1]);
                continue;
            }
            segments.add(segment);
        }
        this.name = segments.get(0).split(SEPARATOR)[1].trim();
        return segments;
    }
}

