// CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: https://codemirror.net/LICENSE

(function() {
  var mode = CodeMirror.getMode({indentUnit: 4}, "wast");
  function MT(name) {test.mode(name, mode, Array.prototype.slice.call(arguments, 1));}

  MT('number-test',
     '[number 0]',
     '[number 123]',
     '[number nan]',
     '[number inf]',
     '[number infinity]',
     '[number 0.1]',
     '[number 123.0]',
     '[number 12E+99]');

  MT('string-literals-test',
     '[string "foo"]',
     '[string "\\"foo\\""]',
     '[string "foo #\\"# bar"]');

  MT('atom-test',
     '[atom anyfunc]',
     '[atom i32]',
     '[atom i64]',
     '[atom f32]',
     '[atom f64]');

  MT('keyword-test',
     '[keyword br]',
     '[keyword if]',
     '[keyword loop]',
     '[keyword i32.add]',
     '[keyword local.get]');

  MT('control-instructions',
     '[keyword unreachable]',
     '[keyword nop]',
     '[keyword br] [variable-2 $label0]',
     '[keyword br_if] [variable-2 $label0]',
     '[keyword br_table] [variable-2 $label0] [variable-2 $label1] [variable-2 $label3]',
     '[keyword return]',
     '[keyword call] [variable-2 $func0]',
     '[keyword call_indirect] ([keyword param] [atom f32] [atom f64]) ([keyword result] [atom i32] [atom i64])',
     '[keyword return_call] [variable-2 $func0]',
     '[keyword return_call_indirect] ([keyword param] [atom f32] [atom f64]) ([keyword result] [atom i32] [atom i64])');

  MT('memory-instructions',
     '[keyword i32.load] [keyword offset]=[number 4] [keyword align]=[number 4]',
     '[keyword i32.load8_s] [keyword offset]=[number 4] [keyword align]=[number 4]',
     '[keyword i32.load8_u] [keyword offset]=[number 4] [keyword align]=[number 4]',
     '[keyword i32.load16_s] [keyword offset]=[number 4] [keyword align]=[number 4]',
     '[keyword i32.load16_u] [keyword offset]=[number 4] [keyword align]=[number 4]',
     '[keyword i32.store] [keyword offset]=[number 4] [keyword align]=[number 4]',
     '[keyword i32.store8] [keyword offset]=[number 4] [keyword align]=[number 4]',
     '[keyword i32.store16] [keyword offset]=[number 4] [keyword align]=[number 4]',
     '[keyword i64.store] [keyword offset]=[number 4] [keyword align]=[number 4]',
     '[keyword i64.load] [keyword offset]=[number 4] [keyword align]=[number 4]',
     '[keyword i64.load8_s] [keyword offset]=[number 4] [keyword align]=[number 4]',
     '[keyword i64.load8_u] [keyword offset]=[number 4] [keyword align]=[number 4]',
     '[keyword i64.load16_s] [keyword offset]=[number 4] [keyword align]=[number 4]',
     '[keyword i64.load16_u] [keyword offset]=[number 4] [keyword align]=[number 4]',
     '[keyword i64.load32_s] [keyword offset]=[number 4] [keyword align]=[number 4]',
     '[keyword i64.load32_u] [keyword offset]=[number 4] [keyword align]=[number 4]',
     '[keyword i64.store8] [keyword offset]=[number 4] [keyword align]=[number 4]',
     '[keyword i64.store16] [keyword offset]=[number 4] [keyword align]=[number 4]',
     '[keyword i64.store32] [keyword offset]=[number 4] [keyword align]=[number 4]',
     '[keyword f32.load] [keyword offset]=[number 4] [keyword align]=[number 4]',
     '[keyword f32.store] [keyword offset]=[number 4] [keyword align]=[number 4]',
     '[keyword f64.load] [keyword offset]=[number 4] [keyword align]=[number 4]',
     '[keyword f64.store] [keyword offset]=[number 4] [keyword align]=[number 4]');

  MT('atomic-memory-instructions',
     '[keyword atomic.notify] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i32.atomic.wait] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.wait] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i32.atomic.load] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i32.atomic.load8_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i32.atomic.load16_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i32.atomic.store] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i32.atomic.store8] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i32.atomic.store16] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.load] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.load8_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.load16_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.load32_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.store] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.store8] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.store16] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.store32] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i32.atomic.rmw.add] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i32.atomic.rmw8.add_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i32.atomic.rmw16.add_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.rmw.add] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.rmw8.add_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.rmw16.add_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.rmw32.add_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i32.atomic.rmw.sub] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i32.atomic.rmw8.sub_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i32.atomic.rmw16.sub_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.rmw.sub] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.rmw8.sub_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.rmw16.sub_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.rmw32.sub_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i32.atomic.rmw.and] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i32.atomic.rmw8.and_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i32.atomic.rmw16.and_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.rmw.and] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.rmw8.and_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.rmw16.and_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.rmw32.and_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i32.atomic.rmw.or] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i32.atomic.rmw8.or_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i32.atomic.rmw16.or_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.rmw.or] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.rmw8.or_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.rmw16.or_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.rmw32.or_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i32.atomic.rmw.xor] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i32.atomic.rmw8.xor_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i32.atomic.rmw16.xor_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.rmw.xor] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.rmw8.xor_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.rmw16.xor_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.rmw32.xor_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i32.atomic.rmw.xchg] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i32.atomic.rmw8.xchg_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i32.atomic.rmw16.xchg_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.rmw.xchg] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.rmw8.xchg_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.rmw16.xchg_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.rmw32.xchg_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i32.atomic.rmw.cmpxchg] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i32.atomic.rmw8.cmpxchg_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i32.atomic.rmw16.cmpxchg_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.rmw.cmpxchg] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.rmw8.cmpxchg_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.rmw16.cmpxchg_u] [keyword offset]=[number 32] [keyword align]=[number 4]',
     '[keyword i64.atomic.rmw32.cmpxchg_u] [keyword offset]=[number 32] [keyword align]=[number 4]');
})();
